/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.constants.BaseConstants;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.ExcelUtil;
import com.zkteco.zkbiosecurity.core.utils.FileType;
import com.zkteco.zkbiosecurity.core.utils.FileUtil;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ImgEncodeUtil;
import com.zkteco.zkbiosecurity.core.utils.LocaleMessageSourceUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.pers.remote.PersPersonRemote;
import com.zkteco.zkbiosecurity.pers.service.PersAttributeExtService;
import com.zkteco.zkbiosecurity.pers.service.PersAttributeService;
import com.zkteco.zkbiosecurity.pers.service.PersBioTemplateService;
import com.zkteco.zkbiosecurity.pers.service.PersCertificateService;
import com.zkteco.zkbiosecurity.pers.service.PersLeavePersonService;
import com.zkteco.zkbiosecurity.pers.service.PersParamsService;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.util.PersExportInfoUtil;
import com.zkteco.zkbiosecurity.pers.util.PersExportTemplateUtil;
import com.zkteco.zkbiosecurity.pers.util.PersExportUtil;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeExtItem;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeItem;
import com.zkteco.zkbiosecurity.pers.vo.PersAttributeRuleItem;
import com.zkteco.zkbiosecurity.pers.vo.PersCertificateItem;
import com.zkteco.zkbiosecurity.pers.vo.PersLeavePersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonExportItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonImportItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonPinItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFClientAnchor;
import org.apache.poi.hssf.usermodel.HSSFComment;
import org.apache.poi.hssf.usermodel.HSSFFont;
import org.apache.poi.hssf.usermodel.HSSFPatriarch;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.util.CellRangeAddress;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cglib.beans.BeanMap;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.util.CollectionUtils;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersPersonController
extends ExportController
implements PersPersonRemote {
    @Autowired
    private PersPersonService persPersonService;
    @Autowired
    private PersLeavePersonService persLeavePersonService;
    @Autowired
    private PersParamsService persParamsService;
    @Autowired
    private PersCertificateService persCertificateService;
    @Autowired
    private PersAttributeService persAttributeService;
    @Autowired
    private PersAttributeExtService persAttributeExtService;
    @Autowired
    private PersBioTemplateService persBioTemplateService;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private PersExportTemplateUtil persExportTemplateUtil;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private HttpServletRequest request;

    @RequiresPermissions(value={"pers:person"})
    public ModelAndView index() {
        return new ModelAndView("pers/person/persPerson");
    }

    @RequiresPermissions(value={"pers:person:edit", "pers:person:add"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id, @RequestParam(value="leaveId", required=false) String leaveId, @RequestParam(value="deptId", required=false) String deptId, @RequestParam(value="cardNo", required=false) String cardNo) {
        String bioTemplateJson = "";
        BeanMap attr = null;
        Map persParams = this.persParamsService.getPersParams();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            String thumbPath;
            PersPersonItem item = this.persPersonService.getItemById(id);
            if (Objects.isNull(item)) {
                throw new ZKBusinessException("common_prompt_exception_datanoexists");
            }
            String mobilePhone = item.getMobilePhone();
            if (!"zh_CN".equals(LocaleMessageSourceUtil.language) && StringUtils.isNotBlank((CharSequence)mobilePhone) && mobilePhone.split("-").length > 1) {
                item.setAreaCode(mobilePhone.split("-")[0]);
                item.setMobilePhone(mobilePhone.split("-")[1]);
            }
            if (StringUtils.isNotBlank((CharSequence)item.getPhotoPath()) && FileUtil.fileExists((String)(thumbPath = FileUtil.getThumbPath((String)item.getPhotoPath())))) {
                item.setThumbPhotoPath(thumbPath);
            }
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("certificate", (Object)this.persCertificateService.getItemByPersonId(id));
            PersAttributeExtItem extItem = this.persAttributeExtService.getItemByPersonId(id);
            if (Objects.nonNull(extItem)) {
                attr = BeanMap.create((Object)extItem);
            }
            bioTemplateJson = JSON.toJSONString((Object)this.persBioTemplateService.getItemMapByPersonId(id));
        } else if (StringUtils.isNotBlank((CharSequence)leaveId)) {
            PersLeavePersonItem leaveItem = this.persLeavePersonService.getItemById(leaveId);
            if (Objects.isNull(leaveItem)) {
                throw new ZKBusinessException("common_prompt_exception_datanoexists");
            }
            PersPersonItem item = new PersPersonItem();
            BeanUtils.copyProperties((Object)leaveItem, (Object)item, (String[])new String[]{"id"});
            this.request.setAttribute("item", (Object)item);
            this.request.setAttribute("attGroupId", (Object)leaveItem.getAttGroupId());
            this.request.setAttribute("isAttendance", (Object)leaveItem.getIsAttendance());
            this.request.setAttribute("leaveId", (Object)leaveId);
        } else if ("false".equals(persParams.get("pers.pinSupportLetter")) && "true".equals(persParams.get("pers.pinSupportIncrement"))) {
            this.request.setAttribute("defPin", (Object)this.persPersonService.getIncPoint());
        }
        List attributes = this.persAttributeService.getByCondition(new PersAttributeItem());
        for (PersAttributeItem item : attributes) {
            String attrName = I18nUtil.i18nCode((String)("pers_attr_" + item.getAttrName()), (Object[])new Object[0]);
            if (StringUtils.isNotBlank((CharSequence)attrName) && !attrName.contains("pers_attr_")) {
                item.setShowName(attrName);
            }
            if (!Objects.nonNull(attr)) continue;
            item.setVal(MapUtils.getString((Map)attr, (Object)("attrValue" + item.getFiledIndex()), (String)""));
        }
        this.request.setAttribute("attributes", (Object)attributes);
        this.request.setAttribute("persParams", (Object)persParams);
        this.request.setAttribute("treeDeptId", (Object)deptId);
        this.request.setAttribute("treeDeptName", (Object)this.request.getParameter("deptName"));
        this.request.setAttribute("cardNo", (Object)cardNo);
        this.request.setAttribute("bioTemplateJson", (Object)bioTemplateJson);
        if ("zh_CN".equals(LocaleMessageSourceUtil.language)) {
            return new ModelAndView("pers/person/editPersPersonZH");
        }
        this.request.setAttribute("showSMS", (Object)this.persPersonService.checkShowSMS());
        return new ModelAndView("pers/person/editPersPerson");
    }

    @RequiresPermissions(value={"pers:person:edit", "pers:person:add"})
    @LogRequest(module="pers_module", object="pers_person", opType="common_op_edit", requestParams={"pin", "name", "lastName"}, opContent="pers_person_pin")
    public ZKResultMsg save(PersPersonItem item, PersCertificateItem certificate, PersAttributeExtItem attributeExt, @RequestParam Map<String, String> extParams, @RequestParam(value="personPhoto", required=false) MultipartFile file) {
        String photoPath;
        if (StringUtils.isBlank((CharSequence)item.getId()) && !this.persPersonService.persLicenseCheck()) {
            throw ZKBusinessException.warnException((String)"common_license_maxCount", (Object[])new Object[0]);
        }
        ZKResultMsg res = new ZKResultMsg();
        certificate.setId(null);
        attributeExt.setId(null);
        if (Objects.nonNull(file) && !file.isEmpty()) {
            photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(item.getPin() + ".jpg"), (MultipartFile)file);
            item.setPhotoPath(photoPath);
        } else if (StringUtils.isNotBlank((CharSequence)extParams.get("personIdPhoto"))) {
            photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(item.getPin() + ".jpg"), (String)extParams.get("personIdPhoto"));
            item.setPhotoPath(photoPath);
        }
        if (StringUtils.isBlank((CharSequence)item.getId())) {
            item.setIsFrom("PERS_USER_MANUALLY_ADDED");
        }
        String sessionId = this.request.getSession().getId();
        extParams.put("sessionId", sessionId);
        this.persPersonService.saveItem(item, certificate, attributeExt, extParams);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:person:del"})
    @LogRequest(module="pers_module", object="pers_person", opType="common_op_del", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.persPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pers:person"})
    public DxGrid list(PersPersonItem condition) {
        condition.setPersonType(Short.valueOf((short)0));
        Pager pager = this.persPersonService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public String checkPwd(@RequestParam(value="personId") String personId, @RequestParam(value="personPwd") String personPwd) {
        List itemList;
        boolean persPersonflag;
        PersPersonItem item = new PersPersonItem(Boolean.valueOf(true));
        if (StringUtils.isNotBlank((CharSequence)personId)) {
            item.setNotInId(personId);
        }
        if (StringUtils.isNotBlank((CharSequence)personPwd)) {
            item.setPersonPwd(personPwd);
        }
        if (persPersonflag = CollectionUtils.isEmpty((Collection)(itemList = this.persPersonService.getByCondition(item)))) {
            persPersonflag = !this.persPersonService.checkForcePwd(personPwd);
        }
        return String.valueOf(persPersonflag);
    }

    public String isExist(@RequestParam(value="pin") String pin) {
        boolean isExist = true;
        if (!this.persPersonService.isExistPin(pin).booleanValue()) {
            PersLeavePersonItem leaveItem;
            String pinRetain = this.persParamsService.getValByName("pers.pinRetain");
            if (StringUtils.isBlank((CharSequence)this.request.getParameter("leavePersonId")) && "true".equals(pinRetain) && (leaveItem = this.persLeavePersonService.getItemByPin(pin)) != null) {
                isExist = false;
            }
        } else {
            isExist = false;
        }
        return String.valueOf(isExist);
    }

    public ZKResultMsg dataCount() {
        Map mapCount = this.persPersonService.dataCount();
        mapCount.put("cropFaceCount", String.valueOf(FileUtil.getCropFaceCount()));
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)mapCount));
    }

    public ModelAndView batch(@RequestParam(value="ids") String ids, @RequestParam(value="type") String type) {
        StringBuffer pinStrBuf = new StringBuffer();
        String[] idsArr = ids.split(",");
        for (int i = 0; i < idsArr.length; ++i) {
            PersPersonItem tempPerson = this.persPersonService.getItemById(idsArr[i]);
            if (i != idsArr.length - 1) {
                pinStrBuf.append(tempPerson.getPin() + ";");
                continue;
            }
            pinStrBuf.append(tempPerson.getPin());
        }
        this.request.setAttribute("selectedPerson", (Object)pinStrBuf.toString());
        this.request.setAttribute("ids", (Object)ids);
        return new ModelAndView("pers/person/" + type);
    }

    @RequiresPermissions(value={"pers:person:batchPositionChange"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_position_change", requestParams={"pins", "positionName", "changeReason"}, opContent="pers_person_pin")
    public ZKResultMsg batchPositionChange(@RequestParam(value="ids") String ids, @RequestParam(value="positionId") String positionId, @RequestParam(value="changeReason") String changeReason) {
        this.persPersonService.batchPositionChange(ids, positionId, changeReason);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"pers:person:deptChange"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_person_departmentChange", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg batchDeptChange(@RequestParam(value="ids") String ids, @RequestParam(value="deptId") String deptId, @RequestParam(value="changeReason") String changeReason, @RequestParam(value="flag") boolean flag) {
        this.persPersonService.batchDeptChange(ids, deptId, changeReason, flag);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String checkCertNumber(@RequestParam(value="certNumber") String certNumber, @RequestParam(value="personId", required=false) String personId, @RequestParam(value="certType") String certType) {
        boolean flag = true;
        if (StringUtils.isNotBlank((CharSequence)certNumber)) {
            flag = this.persCertificateService.isExistByCertNumberAndCertTypeAndPersonIdNe(certNumber, certType, personId);
        }
        return String.valueOf(flag);
    }

    public String checkMailParam() {
        return String.valueOf(this.persPersonService.checkMailParam());
    }

    public String checkEmailIsExist(String personId, String email) {
        PersPersonItem persPersonItem = new PersPersonItem();
        persPersonItem.setEmail(email);
        List byCondition = this.persPersonService.getByCondition(persPersonItem);
        for (PersPersonItem item : byCondition) {
            if (personId.equals(item.getId())) continue;
            return "false";
        }
        return "true";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"pers:person:import"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_import_personInfo", requestParams={}, opContent="pers_import_personInfo")
    public ZKResultMsg importExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List<PersPersonImportItem> itemList = PersExportUtil.excelImport(upload.getInputStream(), PersPersonImportItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.persPersonService.importPersonIno(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import Person Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    @RequiresPermissions(value={"pers:person:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String sortName = request.getParameter("sortName");
        String sortOrder = request.getParameter("sortOrder");
        PersPersonItem persPersonItem = new PersPersonItem();
        this.setConditionValue((BaseItem)persPersonItem);
        persPersonItem.setPersonType(Short.valueOf((short)0));
        if (StringUtils.isNotBlank((CharSequence)sortName) && StringUtils.isNotBlank((CharSequence)sortOrder)) {
            persPersonItem.setSortName(sortName);
            persPersonItem.setSortOrder(sortOrder);
        }
        String[] attrs = request.getParameterValues("attrs");
        String reportType = request.getParameter("reportType");
        this.persPersonService.buildCondition(request.getSession().getId(), persPersonItem);
        List itemList = this.persPersonService.getItemData(PersPersonItem.class, persPersonItem, this.getBeginIndex(), this.getEndIndex());
        List persPersonExportItemList = this.persPersonService.analyzeExportData(itemList);
        if (persPersonExportItemList == null) {
            throw new ZKBusinessException("common_report_dataSourceNull");
        }
        try {
            if ("XLS".equals(reportType)) {
                boolean isMSIE;
                String fileNamePrefix = "";
                if (request.getParameter("tableNameSearch") != null && !"".equals(request.getParameter("tableNameSearch"))) {
                    fileNamePrefix = request.getParameter("tableNameSearch");
                } else if (request.getParameter("tableNameParam") != null && !"".equals(request.getParameter("tableNameParam"))) {
                    fileNamePrefix = request.getParameter("tableNameParam");
                }
                Map<String, PersAttributeRuleItem> persAttributeRules = PersExportInfoUtil.getPersAttributeRule();
                HSSFWorkbook workbook = new HSSFWorkbook();
                HSSFSheet sheet = workbook.createSheet(fileNamePrefix);
                sheet.setDefaultColumnWidth(attrs.length);
                HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
                HSSFCellStyle style = workbook.createCellStyle();
                style.setAlignment((short)2);
                HSSFFont font = workbook.createFont();
                style.setVerticalAlignment((short)1);
                style.setAlignment((short)2);
                font.setFontHeightInPoints((short)14);
                style.setFont(font);
                HSSFRow row = sheet.createRow(0);
                HSSFCell cell = row.createCell(0);
                cell.setCellValue(fileNamePrefix);
                sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, attrs.length - 1));
                cell.setCellStyle(style);
                row.setHeightInPoints(20.0f);
                row.setHeight((short)540);
                row = sheet.createRow(1);
                row.setHeightInPoints(20.0f);
                row.setHeight((short)540);
                for (int i = 0; i < attrs.length; ++i) {
                    sheet.setColumnWidth(i, 5400);
                    cell = row.createCell(i);
                    String[] attr = attrs[i].split("-");
                    PersAttributeRuleItem persAttr = persAttributeRules.get(attr[1]);
                    if (persAttr == null) {
                        persAttr = new PersAttributeRuleItem(attr[0]);
                    }
                    cell.setCellValue(attr[0]);
                    cell.setCellStyle(style);
                    String commentStr = I18nUtil.i18nCode((String)"pers_export_templateComment", (Object[])new Object[]{attr[1], persAttr.getPrimaryKey(), persAttr.getUniqueKey(), persAttr.getEmpty()});
                    Map<String, String> commentMap = this.getPersAttributeComment();
                    String attrComment = commentMap.get(attr[1]);
                    if (StringUtils.isNotBlank((CharSequence)attrComment)) {
                        commentStr = commentStr + attrComment;
                    }
                    HSSFComment comment = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 1, 2, 4, 8));
                    comment.setString((RichTextString)new HSSFRichTextString(commentStr));
                    cell.setCellComment((Comment)comment);
                }
                for (PersPersonExportItem person : persPersonExportItemList) {
                    int lastRowNum = sheet.getLastRowNum();
                    row = sheet.createRow(lastRowNum + 1);
                    for (int i = 0; i < attrs.length; ++i) {
                        cell = row.createCell(i);
                        String param = attrs[i].split("-")[1];
                        String[] paramArray = param.split("\\.");
                        Object paramValue = null;
                        if (paramArray.length < 2) {
                            paramValue = PersExportInfoUtil.getFieldValue(person, param);
                        } else if (person.getAttributeExt() != null) {
                            paramValue = PersExportInfoUtil.getFieldValue(person.getAttributeExt(), paramArray[1]);
                        }
                        cell.setCellValue(paramValue != null ? paramValue.toString().replaceAll(",", "&") : "");
                        cell.setCellStyle(style);
                    }
                }
                response.setCharacterEncoding("UTF-8");
                String agent = request.getHeader("User-Agent");
                boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
                if (isMSIE) {
                    fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
                    fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
                } else {
                    fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
                }
                if (request.getHeader("User-Agent") != null && request.getHeader("User-Agent").indexOf("Edge") != -1) {
                    fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
                    fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
                    fileNamePrefix = fileNamePrefix.replace("%2520", " ");
                }
                response.setHeader("Content-Disposition", "attachment;filename=\"" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType.toLowerCase() + "\"");
                response.setContentType("application/vnd.ms-excel");
                ServletOutputStream outStream = response.getOutputStream();
                workbook.write((OutputStream)outStream);
                this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
                return;
            }
            JSONObject jsonColumn = new JSONObject(true);
            HashMap jsonCloumnMap = new HashMap();
            HashMap<String, String> jsonMap = new HashMap<String, String>();
            LinkedHashMap<String, String> attributeExtMap = new LinkedHashMap<String, String>();
            for (int i = 0; i < attrs.length; ++i) {
                String[] attr = attrs[i].split("-");
                String[] paramArray = attr[1].split("\\.");
                if (paramArray.length < 2) {
                    jsonColumn.put(attr[1], (Object)attr[0]);
                    continue;
                }
                jsonColumn.put(paramArray[0], (Object)attr[0]);
                attributeExtMap.put(attr[0], paramArray[1]);
            }
            jsonMap.put("jsonColumn", jsonColumn.toJSONString());
            jsonCloumnMap.put("jsonColumn", jsonMap);
            LinkedHashMap<String, String> attrMap = null;
            Object attrValue = null;
            for (PersPersonExportItem person : persPersonExportItemList) {
                attrMap = new LinkedHashMap<String, String>();
                if (!attributeExtMap.isEmpty() && person.getAttributeExt() != null) {
                    for (String key : attributeExtMap.keySet()) {
                        attrValue = PersExportInfoUtil.getFieldValue(person.getAttributeExt(), (String)attributeExtMap.get(key));
                        attrMap.put(key, attrValue != null ? attrValue.toString().replaceAll(",", "&") : "");
                    }
                }
                person.setAttrMap(attrMap);
            }
            this.excelExport(persPersonExportItemList, PersPersonExportItem.class, jsonCloumnMap);
        }
        catch (Exception e) {
            this.log.error("export error", (Throwable)e);
            throw new ZKBusinessException("common_report_exportFaild");
        }
    }

    @RequiresPermissions(value={"pers:person:exportTemplate"})
    public void exportTemplate(HttpServletRequest request, HttpServletResponse response) {
        try {
            boolean isMSIE;
            String[] attrs = request.getParameterValues("attrs");
            String reportType = request.getParameter("reportType");
            Map<String, PersAttributeRuleItem> persAttributeRules = PersExportInfoUtil.getPersAttributeRule();
            String fileNamePrefix = I18nUtil.i18nCode((String)"pers_export_templateFileName", (Object[])new Object[0]);
            HSSFWorkbook workbook = new HSSFWorkbook();
            HSSFSheet sheet = workbook.createSheet(fileNamePrefix);
            sheet.setDefaultColumnWidth(attrs.length);
            HSSFPatriarch patriarch = sheet.createDrawingPatriarch();
            HSSFCellStyle style = workbook.createCellStyle();
            style.setAlignment((short)2);
            HSSFFont font = workbook.createFont();
            style.setVerticalAlignment((short)1);
            style.setAlignment((short)2);
            font.setFontHeightInPoints((short)14);
            style.setFont(font);
            HSSFRow row = sheet.createRow(0);
            HSSFCell cell = row.createCell(0);
            cell.setCellValue(fileNamePrefix);
            sheet.addMergedRegion(new CellRangeAddress(0, 0, 0, attrs.length - 1));
            cell.setCellStyle(style);
            row.setHeightInPoints(20.0f);
            row.setHeight((short)540);
            row = sheet.createRow(1);
            row.setHeightInPoints(20.0f);
            row.setHeight((short)540);
            for (int i = 0; i < attrs.length; ++i) {
                sheet.setColumnWidth(i, 5400);
                cell = row.createCell(i);
                String[] attr = attrs[i].split("-");
                PersAttributeRuleItem persAttr = persAttributeRules.get(attr[1]);
                if (persAttr == null) {
                    persAttr = new PersAttributeRuleItem(attr[0]);
                }
                cell.setCellValue(attr[0]);
                cell.setCellStyle(style);
                String commentStr = I18nUtil.i18nCode((String)"pers_export_templateComment", (Object[])new Object[]{attr[1], persAttr.getPrimaryKey(), persAttr.getUniqueKey(), persAttr.getEmpty()});
                Map<String, String> commentMap = this.getPersAttributeComment();
                String attrComment = commentMap.get(attr[1]);
                if (StringUtils.isNotBlank((CharSequence)attrComment)) {
                    commentStr = commentStr + attrComment;
                }
                HSSFComment comment = patriarch.createCellComment((ClientAnchor)new HSSFClientAnchor(0, 0, 0, 0, 1, 2, 4, 8));
                comment.setString((RichTextString)new HSSFRichTextString(commentStr));
                cell.setCellComment((Comment)comment);
            }
            response.setCharacterEncoding("UTF-8");
            String agent = request.getHeader("User-Agent");
            boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
            if (isMSIE) {
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
                fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
            } else {
                fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
            }
            if (request.getHeader("User-Agent") != null && request.getHeader("User-Agent").indexOf("Edge") != -1) {
                fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
                fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
                fileNamePrefix = fileNamePrefix.replace("%2520", " ");
            }
            response.setHeader("Content-Disposition", "attachment;filename=\"" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + "." + reportType.toLowerCase() + "\"");
            response.setContentType("application/vnd.ms-excel");
            ServletOutputStream outStream = response.getOutputStream();
            workbook.write((OutputStream)outStream);
            this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + request.getSession().getId()), (Object)"end");
            return;
        }
        catch (Exception e) {
            this.log.error("export error", (Throwable)e);
            throw new ZKBusinessException("common_report_exportFaild");
        }
    }

    private Map<String, String> getPersAttributeComment() {
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        List certTypeList = this.baseDictionaryValueService.getDictionaryValues("certificateType");
        StringBuilder certName = new StringBuilder();
        for (BaseDictionaryValueItem certType : certTypeList) {
            certName.append(certType.getDictValue()).append(",");
        }
        map.put("pin", "\r\n" + I18nUtil.i18nCode((String)"pers_import_pinStartWithZero", (Object[])new Object[0]));
        map.put("certName", "\r\n" + I18nUtil.i18nCode((String)"pers_cert_type", (Object[])new Object[0]) + ":" + certName.substring(0, certName.length() - 1));
        map.put("birthday", "\r\n" + I18nUtil.i18nCode((String)"base_datetime_timeFormat", (Object[])new Object[0]) + ":yyyy-MM-dd");
        map.put("certNumber", "\r\n" + I18nUtil.i18nCode((String)"pers_export_certNumberComment", (Object[])new Object[0]));
        return map;
    }

    public String getDeptPins(String deptIds) {
        JSONObject jsonObject = new JSONObject();
        List<String> dptIds = Arrays.asList(deptIds.split(","));
        List persPersonItems = this.persPersonService.getPersPersonByDeptIds(dptIds);
        StringBuilder pins = new StringBuilder();
        StringBuilder persIds = new StringBuilder();
        int index = 1;
        for (PersPersonItem persPersonItem : persPersonItems) {
            if (index != persPersonItems.size()) {
                pins.append(persPersonItem.getPin() + ",");
                persIds.append(persPersonItem.getId() + ",");
            } else {
                pins.append(persPersonItem.getPin());
                persIds.append(persPersonItem.getId());
            }
            ++index;
        }
        jsonObject.put("pins", (Object)pins);
        jsonObject.put("persIds", (Object)persIds);
        return jsonObject.toJSONString();
    }

    @RequiresPermissions(value={"pers:person:resetSelfPwd"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_person_resetSelfPwd", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg resetSelfPwd(String ids) {
        this.persPersonService.resetSelfPwd(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    @RequiresPermissions(value={"pers:person:importPhoto"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_import_personPhoto", requestParams={"pin"}, opContent="pers_person_pin")
    public ZKResultMsg savePhoto(@RequestParam(value="pin") String pin, @RequestParam(value="photoQuality", defaultValue="false") Boolean photoQuality, @RequestParam(value="personPhoto") MultipartFile personPhoto) {
        if (this.persPersonService.isExistPin(pin).booleanValue()) {
            if (Objects.nonNull(personPhoto) && !personPhoto.isEmpty()) {
                if (personPhoto.getOriginalFilename().toLowerCase().matches(".*?(jpg|jpeg|png|bmp|gif)$")) {
                    String photoPath = FileUtil.saveFileToServer((String)"pers", (String)"user/avatar", (String)(pin + ".jpg"), (MultipartFile)personPhoto);
                    return I18nUtil.i18nMsg((ZKResultMsg)this.persPersonService.uploadUserPhoto(pin, photoPath));
                }
                return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"pers_cardTemplate_jpgFormat"));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"pers_cardTemplate_uploadFail"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"pers_person_pinError", (Object[])new Object[]{pin}));
    }

    @LogRequest(module="pers_module", object="pers_person", opType="pers_import_personPhoto", requestParams={}, opContent="pers_import_personPhoto")
    public ZKResultMsg saveLargePhoto(@RequestParam(value="uploadFile") MultipartFile uploadFile) {
        if (Objects.nonNull(uploadFile) && !uploadFile.isEmpty()) {
            String[] originalFilename = uploadFile.getOriginalFilename().replace("\\", "/").split("/");
            if (originalFilename.length > 0) {
                String filename = originalFilename[originalFilename.length - 1];
                String filePath = FileUtil.saveFileToServer((String)"pers", (String)"user/zipPhotos", (String)filename, (MultipartFile)uploadFile);
                String zipPath = this.persPersonService.unZipToFile(filePath, "/upload/pers/user/zipPhotos/");
                FileUtil.deleteFile((String)FileUtil.getLocalFullPath((String)filePath));
                return I18nUtil.i18nMsg((ZKResultMsg)this.persPersonService.handlerZipUserPhoto(zipPath));
            }
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"common_op_failed"));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.getFailMsg((String)"common_op_failed"));
    }

    @RequiresPermissions(value={"pers:person:exportPhoto"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_export_personPhoto", opContent="pers_export_personPhoto")
    public void exportPhoto() throws Exception {
        boolean isMSIE;
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"start");
        this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        PersPersonPinItem condition = new PersPersonPinItem();
        this.setConditionValue((BaseItem)condition);
        Map pinAndPhotoMap = this.persPersonService.getAllPersonPhotoByAuthUserFilter(this.request.getSession().getId(), condition);
        if (pinAndPhotoMap.isEmpty()) {
            throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
        }
        ArrayList files = new ArrayList();
        pinAndPhotoMap.forEach((pin, photoPath) -> {
            File file = new File(FileUtil.getLocalFullPath((String)photoPath));
            if (file.exists()) {
                files.add(file);
            }
        });
        if (files.isEmpty()) {
            throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
        }
        String reportType = "xlsx".toLowerCase();
        String jsonColumn = this.request.getParameter("jsonColumn");
        String fileName = this.request.getParameter("tableNameParam");
        String fileNamePrefix = I18nUtil.i18nCode((String)"pers_import_photoType", (Object[])new Object[0]);
        String tempFolder = fileName + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        String agent = this.request.getHeader("User-Agent");
        boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
        if (isMSIE) {
            fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
            fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
        } else {
            fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
        }
        if (this.request.getHeader("User-Agent") != null && this.request.getHeader("User-Agent").indexOf("Edge") != -1) {
            fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
            fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
            fileNamePrefix = fileNamePrefix.replace("%2520", " ");
        }
        String tempPath = (ClassUtil.getRootPath() + File.separator + FileUtil.systemFilePath + File.separator + "upload" + File.separator + "pers").replace("/", "\\") + "\\" + fileNamePrefix + "_" + new SimpleDateFormat("yyyyMMddHHmmss").format(new Date()) + ".zip";
        this.response = FileUtil.downLoadFiles((String)tempPath, (File[])files.toArray(new File[0]), (HttpServletRequest)this.request, (HttpServletResponse)this.response);
        this.response.flushBuffer();
        File zipTempFile = new File(tempPath);
        if (zipTempFile.exists()) {
            zipTempFile.delete();
        }
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
    }

    @RequiresPermissions(value={"pers:person:cardPrint"})
    public ModelAndView cardPrint(@RequestParam(value="ids") String ids) {
        List persPersonItemList = this.persPersonService.getItemsByIds(ids);
        this.request.setAttribute("persPersonItemList", (Object)persPersonItemList);
        return new ModelAndView("pers/cardPrintTemplate/opCardPrinting");
    }

    public ZKResultMsg getCountry(@RequestParam(value="countryKey") String countryKey) {
        return new ZKResultMsg((Object)this.persPersonService.getCountry(countryKey));
    }

    public String checkSMSModemParam() {
        return String.valueOf(this.persPersonService.checkSMSModemParam());
    }

    public ZKResultMsg validPersonPhoto(@RequestParam(value="personPhoto", required=false) MultipartFile file, @RequestParam(value="personIdPhoto", required=false) String personIdPhoto) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        String photoPath = "";
        String filePath = FileUtil.createUploadFileRootPath((String)"pers", (String)"user/avatar");
        String photoName = System.currentTimeMillis() + ".jpg";
        try {
            if (Objects.nonNull(file) && !file.isEmpty()) {
                InputStream inputStream = file.getInputStream();
                boolean jpgImage = ImgEncodeUtil.isSupportImageType((InputStream)inputStream, (FileType[])new FileType[]{FileType.JPEG, FileType.PNG});
                if (!jpgImage) {
                    zkResultMsg.setRet("fail");
                    zkResultMsg.setMsg(I18nUtil.i18nCode((String)"pers_face_validFailMsg", (Object[])new Object[0]) + I18nUtil.i18nCode((String)"pers_face_photoFormatError", (Object[])new Object[0]));
                    return zkResultMsg;
                }
                String fullPath = FileUtil.systemFilePath + '/' + filePath;
                File fileImg = new File(new File(fullPath), photoName);
                if (!fileImg.getParentFile().exists()) {
                    fileImg.getParentFile().mkdirs();
                }
                if (fileImg.exists()) {
                    fileImg.delete();
                }
                file.transferTo(new File(fileImg.getAbsolutePath()));
                photoPath = '/' + filePath + photoName;
            } else if (StringUtils.isNotBlank((CharSequence)personIdPhoto)) {
                FileUtil.saveFile((String)filePath, (String)photoName, (String)personIdPhoto, (boolean)false);
                photoPath = '/' + filePath + photoName;
            }
            if (StringUtils.isNotBlank((CharSequence)photoPath)) {
                zkResultMsg = this.persPersonService.validCropFace(photoPath);
                File tempFile = new File(FileUtil.getLocalFullPath((String)photoPath));
                if (tempFile.exists()) {
                    tempFile.delete();
                }
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return zkResultMsg;
    }

    public TreeItem verifyModeTree() {
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = new TreeItem();
        item.setId("1000");
        item.setText(I18nUtil.i18nCode((String)"pers_card", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.FP_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_regFinger", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.PALM_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_metacarpalVein", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.VEIN_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_regVein", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.FACE_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_infraredFaceTemplate", (Object[])new Object[0]));
        items.add(item);
        item = new TreeItem();
        item.setId(BaseConstants.BaseBioType.BIOPHOTO_BIO_TYPE.toString());
        item.setText(I18nUtil.i18nCode((String)"pers_person_visibleFaceTemplate", (Object[])new Object[0]));
        items.add(item);
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public ModelAndView getBioTemplateView(@RequestParam(value="ids") String ids) {
        List personList;
        List pinList;
        if (StringUtils.isNotBlank((CharSequence)ids) && (pinList = this.persPersonService.getPinsByIds(personList = StrUtil.strToList((String)ids))) != null && !pinList.isEmpty()) {
            this.request.setAttribute("personIds", (Object)ids);
            this.request.setAttribute("pins", (Object)String.join((CharSequence)",", pinList));
        }
        List personItemList = this.persPersonService.getItemsByIds(ids);
        return new ModelAndView("pers/person/opDeleteBioTemplate");
    }

    @RequiresPermissions(value={"pers:person:delBioTemplate"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_person_delBioTemplate", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg deleteBioTemplate(@RequestParam Map<String, String> params) {
        String personIds = params.get("personIds");
        String personPins = params.get("pins");
        if (StringUtils.isNotBlank((CharSequence)personPins)) {
            String fp = params.get("fp");
            String face = params.get("face");
            String fv = params.get("fv");
            String palm = params.get("palm");
            String vislight = params.get("vislight");
            ArrayList<Short> bioType = new ArrayList<Short>();
            if (StringUtils.isNotBlank((CharSequence)fp)) {
                bioType.add(Short.parseShort(fp));
            }
            if (StringUtils.isNotBlank((CharSequence)face)) {
                bioType.add(Short.parseShort(face));
            }
            if (StringUtils.isNotBlank((CharSequence)fv)) {
                bioType.add(Short.parseShort(fv));
            }
            if (StringUtils.isNotBlank((CharSequence)palm)) {
                bioType.add(Short.parseShort(palm));
            }
            if (StringUtils.isNotBlank((CharSequence)vislight)) {
                bioType.add(Short.parseShort(vislight));
            }
            if (!bioType.isEmpty()) {
                List personIdList = StrUtil.strToList((String)personIds);
                List personPinList = StrUtil.strToList((String)personPins);
                this.persBioTemplateService.deleteByPersonPinsAndBioTypes(personIdList, personPinList, bioType);
            }
        }
        return new ZKResultMsg();
    }

    public void exportLeavePersonTemplate(HttpServletRequest request, HttpServletResponse response) {
        JSONObject jsonObject = JSONObject.parseObject((String)request.getParameter("jsonColumn"), (Feature[])new Feature[]{Feature.OrderedField});
        HashMap<String, String> commentMap = new HashMap<String, String>();
        if (jsonObject == null) {
            jsonObject = new JSONObject(new LinkedHashMap());
            jsonObject.put("pin", (Object)I18nUtil.i18nCode((String)"pers_person_pin", (Object[])new Object[0]));
            jsonObject.put("name", (Object)I18nUtil.i18nCode((String)"pers_person_name", (Object[])new Object[0]));
            if (!"zh_CN".equals(LocaleMessageSourceUtil.language)) {
                jsonObject.put("lastName", (Object)I18nUtil.i18nCode((String)"pers_person_lastName", (Object[])new Object[0]));
            }
            jsonObject.put("deptName", (Object)I18nUtil.i18nCode((String)"pers_dept_deptName", (Object[])new Object[0]));
            jsonObject.put("leaveDate", (Object)I18nUtil.i18nCode((String)"pers_dimission_date", (Object[])new Object[0]));
            jsonObject.put("leaveTypeString", (Object)I18nUtil.i18nCode((String)"pers_dimission_type", (Object[])new Object[0]));
            jsonObject.put("leaveReason", (Object)I18nUtil.i18nCode((String)"pers_dimission_reason", (Object[])new Object[0]));
            commentMap.put("jsonColumn", jsonObject.toJSONString());
        }
        Iterator iterator = jsonObject.keySet().iterator();
        while (iterator.hasNext()) {
            String key;
            switch (key = (String)iterator.next()) {
                case "pin": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"common_jqMsg_required", (Object[])new Object[0]));
                    break;
                }
                case "leaveDate": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"pers_dimission_dateFormat", (Object[])new Object[0]));
                    break;
                }
                case "leaveTypeString": {
                    commentMap.put(key, I18nUtil.i18nCode((String)"pers_dimission_leaveType", (Object[])new Object[0]));
                }
            }
        }
        this.persExportTemplateUtil.templateExport(request, response, commentMap);
    }

    public ZKResultMsg getDeptIdByPersonId(@RequestParam(value="personId") String personId) {
        PersPersonItem item = this.persPersonService.getItemById(personId);
        ZKResultMsg result = new ZKResultMsg();
        if (item != null) {
            result.setData((Object)item.getDeptId());
        } else {
            result.setData(null);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ZKResultMsg importLeavePersonExcel(MultipartFile upload) throws IOException {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"pers_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            List itemList = ExcelUtil.excelImport((InputStream)upload.getInputStream(), PersLeavePersonItem.class);
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"pers_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.persLeavePersonService.importExcel(itemList));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import PersLeavePerson Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }
}

