/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.pers.remote.PersLeavePersonRemote;
import com.zkteco.zkbiosecurity.pers.service.PersLeavePersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersLeavePersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersLeavePersonController
extends ExportController
implements PersLeavePersonRemote {
    @Autowired
    private PersLeavePersonService persLeavePersonService;

    @RequiresPermissions(value={"pers:leavePerson"})
    public ModelAndView index() {
        return new ModelAndView("pers/leavePerson/persLeavePerson");
    }

    @RequiresPermissions(value={"pers:leavePerson:edit", "pers:person:leave"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id, @RequestParam(value="ids", required=false) String ids, @RequestParam(value="pins", required=false) String pins, @RequestParam(value="names", required=false) String names) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.persLeavePersonService.getItemById(id));
            this.request.setAttribute("pin", (Object)this.persLeavePersonService.getItemById(id).getPin());
            this.request.setAttribute("name", (Object)this.persLeavePersonService.getItemById(id).getName());
        }
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            this.request.setAttribute("ids", (Object)ids);
            this.request.setAttribute("pin", (Object)pins);
            this.request.setAttribute("name", (Object)names);
        }
        return new ModelAndView("pers/leavePerson/editPersLeavePerson");
    }

    @RequiresPermissions(value={"pers:leavePerson:edit", "pers:person:leave"})
    @LogRequest(module="pers_module", object="pers_person", opType="pers_leave", requestParams={"pin", "name"}, opContent="pers_person_pin")
    public ZKResultMsg save(PersLeavePersonItem item, @RequestParam(value="personIds", required=false) String personIds) {
        ZKResultMsg res = new ZKResultMsg();
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{item.getId()})) {
            this.persLeavePersonService.saveItem(item);
        } else {
            this.persLeavePersonService.batchLeave(item, personIds);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"pers:leavePerson"})
    public DxGrid list(PersLeavePersonItem condition) {
        Pager pager = this.persLeavePersonService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @LogRequest(module="pers_module", object="pers_leave", opType="common_op_del", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.persLeavePersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public void export(HttpServletRequest req, HttpServletResponse resp) {
        String exportType = this.request.getParameter("exportType");
        String recordStart = this.request.getParameter("recordstart");
        String recordCount = this.request.getParameter("recordcount");
        int beginIndex = 0;
        int endIndex = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : 0;
            int maxCount = Integer.valueOf(recordCount) > 30000 ? 30000 : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        PersLeavePersonItem persLeavePersonItem = new PersLeavePersonItem();
        this.setConditionValue((BaseItem)persLeavePersonItem);
        List list = this.persLeavePersonService.getItemData(PersLeavePersonItem.class, (BaseItem)persLeavePersonItem, beginIndex, endIndex);
        this.excelExport(list, PersLeavePersonItem.class);
    }
}

