/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.cache;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;
import net.sourceforge.jnlp.DownloadOptions;
import net.sourceforge.jnlp.OptionsDefinitions;
import net.sourceforge.jnlp.Version;
import net.sourceforge.jnlp.cache.CacheEntry;
import net.sourceforge.jnlp.cache.CacheUtil;
import net.sourceforge.jnlp.cache.Resource;
import net.sourceforge.jnlp.cache.ResourceTracker;
import net.sourceforge.jnlp.cache.ResourceUrlCreator;
import net.sourceforge.jnlp.cache.UpdatePolicy;
import net.sourceforge.jnlp.runtime.Boot;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.security.ConnectionFactory;
import net.sourceforge.jnlp.security.SecurityDialogs;
import net.sourceforge.jnlp.security.dialogs.InetSecurity511Panel;
import net.sourceforge.jnlp.util.HttpUtils;
import net.sourceforge.jnlp.util.UrlUtils;
import net.sourceforge.jnlp.util.logging.OutputController;

public class ResourceDownloader
implements Runnable {
    private final Resource resource;
    private final Object lock;

    public ResourceDownloader(Resource resource, Object lock) {
        this.resource = resource;
        this.lock = lock;
    }

    static int getUrlResponseCode(URL url, Map<String, String> requestProperties, ResourceTracker.RequestMethods requestMethod) throws IOException {
        return ResourceDownloader.getUrlResponseCodeWithRedirectonResult((URL)url, requestProperties, (ResourceTracker.RequestMethods)requestMethod).result;
    }

    static UrlRequestResult getUrlResponseCodeWithRedirectonResult(URL url, Map<String, String> requestProperties, ResourceTracker.RequestMethods requestMethod) throws IOException {
        UrlRequestResult result = new UrlRequestResult();
        URLConnection connection = ConnectionFactory.getConnectionFactory().openConnection(url);
        for (Map.Entry<String, String> property : requestProperties.entrySet()) {
            connection.addRequestProperty(property.getKey(), property.getValue());
        }
        if (connection instanceof HttpURLConnection) {
            HttpURLConnection httpConnection = (HttpURLConnection)connection;
            httpConnection.setRequestMethod(requestMethod.toString());
            int responseCode = httpConnection.getResponseCode();
            HttpUtils.consumeAndCloseConnectionSilently(httpConnection);
            result.result = responseCode;
        }
        Map<String, List<String>> header = connection.getHeaderFields();
        for (Map.Entry<String, List<String>> entry : header.entrySet()) {
            OutputController.getLogger().log("Key : " + entry.getKey() + " ,Value : " + entry.getValue());
        }
        String possibleRedirect = connection.getHeaderField("Location");
        if (possibleRedirect != null && possibleRedirect.trim().length() > 0) {
            result.URL = new URL(possibleRedirect);
        }
        ConnectionFactory.getConnectionFactory().disconnect(connection);
        result.lastModified = connection.getLastModified();
        result.length = connection.getContentLengthLong();
        return result;
    }

    @Override
    public void run() {
        if (this.resource.isSet(Resource.Status.PRECONNECT) && !this.resource.hasFlags(EnumSet.of(Resource.Status.ERROR, Resource.Status.CONNECTING, Resource.Status.CONNECTED))) {
            this.resource.changeStatus(EnumSet.noneOf(Resource.Status.class), EnumSet.of(Resource.Status.CONNECTING));
            this.resource.fireDownloadEvent();
            this.initializeResource();
        }
        if (this.resource.isSet(Resource.Status.PREDOWNLOAD) && !this.resource.hasFlags(EnumSet.of(Resource.Status.ERROR, Resource.Status.DOWNLOADING, Resource.Status.DOWNLOADED))) {
            this.resource.changeStatus(EnumSet.noneOf(Resource.Status.class), EnumSet.of(Resource.Status.DOWNLOADING));
            this.resource.fireDownloadEvent();
            this.downloadResource();
        }
    }

    private void initializeResource() {
        if (!JNLPRuntime.isOfflineForced() && this.resource.isConnectable()) {
            this.initializeOnlineResource();
        } else {
            this.initializeOfflineResource();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeOnlineResource() {
        try {
            UrlRequestResult finalLocation = this.findBestUrl(this.resource);
            if (finalLocation != null) {
                this.initializeFromURL(finalLocation);
            } else {
                this.initializeOfflineResource();
            }
        }
        catch (Exception e) {
            OutputController.getLogger().log(e);
            this.resource.changeStatus(EnumSet.noneOf(Resource.Status.class), EnumSet.of(Resource.Status.ERROR));
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.resource.fireDownloadEvent();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeFromURL(UrlRequestResult location) throws IOException {
        Object entry = new CacheEntry(this.resource.getLocation(), this.resource.getRequestVersion());
        ((CacheEntry)entry).lock();
        try {
            Object newEntry;
            boolean current;
            Long lm;
            this.resource.setDownloadLocation(location.URL);
            URLConnection connection = ConnectionFactory.getConnectionFactory().openConnection(location.URL);
            connection.addRequestProperty("Accept-Encoding", "pack200-gzip, gzip");
            File localFile = CacheUtil.getCacheFile(this.resource.getLocation(), this.resource.getDownloadVersion());
            Long size = location.length;
            if (size == null) {
                size = connection.getContentLengthLong();
            }
            if ((lm = location.lastModified) == null) {
                lm = connection.getLastModified();
            }
            boolean bl = current = CacheUtil.isCurrent(this.resource.getLocation(), this.resource.getRequestVersion(), lm) && this.resource.getUpdatePolicy() != UpdatePolicy.FORCE;
            if (!current && ((CacheEntry)entry).isCached()) {
                ((CacheEntry)entry).markForDelete();
                ((CacheEntry)entry).store();
                localFile = CacheUtil.makeNewCacheFile(this.resource.getLocation(), this.resource.getDownloadVersion());
                newEntry = new CacheEntry(this.resource.getLocation(), this.resource.getRequestVersion());
                ((CacheEntry)newEntry).lock();
                ((CacheEntry)entry).unlock();
                entry = newEntry;
            }
            newEntry = this.resource;
            synchronized (newEntry) {
                this.resource.setLocalFile(localFile);
                this.resource.setSize(size);
                this.resource.changeStatus(EnumSet.of(Resource.Status.PRECONNECT, Resource.Status.CONNECTING), EnumSet.of(Resource.Status.CONNECTED, Resource.Status.PREDOWNLOAD));
                if (current) {
                    this.resource.changeStatus(EnumSet.of(Resource.Status.PREDOWNLOAD, Resource.Status.DOWNLOADING), EnumSet.of(Resource.Status.DOWNLOADED));
                }
            }
            if (!current) {
                ((CacheEntry)entry).setRemoteContentLength(size);
                ((CacheEntry)entry).setLastModified(lm);
            }
            ((CacheEntry)entry).setLastUpdated(System.currentTimeMillis());
            try {
                String jnlpPath = Boot.getOptionParser().getMainArg();
                if (jnlpPath == null || jnlpPath.equals("")) {
                    jnlpPath = Boot.getOptionParser().getParam(OptionsDefinitions.OPTIONS.JNLP);
                    if (jnlpPath == null || jnlpPath.equals("")) {
                        jnlpPath = Boot.getOptionParser().getParam(OptionsDefinitions.OPTIONS.HTML);
                        if (jnlpPath == null || jnlpPath.equals("")) {
                            OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "Not-setting jnlp-path for missing main/jnlp/html argument");
                        } else {
                            ((CacheEntry)entry).setJnlpPath(jnlpPath);
                        }
                    } else {
                        ((CacheEntry)entry).setJnlpPath(jnlpPath);
                    }
                } else {
                    ((CacheEntry)entry).setJnlpPath(jnlpPath);
                }
            }
            catch (Exception ex) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, ex);
            }
            ((CacheEntry)entry).store();
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.resource.fireDownloadEvent();
            ConnectionFactory.getConnectionFactory().disconnect(connection);
        }
        finally {
            ((CacheEntry)entry).unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initializeOfflineResource() {
        CacheEntry entry = new CacheEntry(this.resource.getLocation(), this.resource.getRequestVersion());
        entry.lock();
        try {
            File localFile = CacheUtil.getCacheFile(this.resource.getLocation(), this.resource.getDownloadVersion());
            if (localFile != null && localFile.exists()) {
                long size = localFile.length();
                Resource resource = this.resource;
                synchronized (resource) {
                    this.resource.setLocalFile(localFile);
                    this.resource.setSize(size);
                    this.resource.changeStatus(EnumSet.of(Resource.Status.PREDOWNLOAD, Resource.Status.DOWNLOADING), EnumSet.of(Resource.Status.DOWNLOADED));
                }
            } else {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "You are trying to get resource " + this.resource.getLocation().toExternalForm() + " but it is not in cache and could not be downloaded. Attempting to continue, but you may expect failure");
                this.resource.changeStatus(EnumSet.noneOf(Resource.Status.class), EnumSet.of(Resource.Status.ERROR));
            }
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.resource.fireDownloadEvent();
        }
        finally {
            entry.unlock();
        }
    }

    protected UrlRequestResult findBestUrl(Resource resource) {
        DownloadOptions options = resource.getDownloadOptions();
        if (options == null) {
            options = new DownloadOptions(false, false);
        }
        List<URL> urls = new ResourceUrlCreator(resource, options).getUrls();
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Finding best URL for: " + resource.getLocation() + " : " + options.toString());
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "All possible urls for " + resource.toString() + " : " + urls);
        for (ResourceTracker.RequestMethods requestMethod : ResourceTracker.RequestMethods.getValidRequestMethods()) {
            for (int i = 0; i < urls.size(); ++i) {
                URL url = urls.get(i);
                try {
                    HashMap<String, String> requestProperties = new HashMap<String, String>();
                    requestProperties.put("Accept-Encoding", "pack200-gzip, gzip");
                    UrlRequestResult response = ResourceDownloader.getUrlResponseCodeWithRedirectonResult(url, requestProperties, requestMethod);
                    if (response.result == 511 && !InetSecurity511Panel.isSkip()) {
                        boolean result511 = SecurityDialogs.show511Dialogue(resource);
                        if (!result511) {
                            throw new RuntimeException("Terminated on users request after encauntering 'http 511 authentication'.");
                        }
                        --i;
                        continue;
                    }
                    if (response.shouldRedirect()) {
                        if (response.URL == null) {
                            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Although " + resource.toString() + " got redirect " + response.result + " code for " + (Object)((Object)requestMethod) + " request for " + url.toExternalForm() + " the target was null. Not following");
                            continue;
                        }
                        OutputController.getLogger().log(OutputController.Level.MESSAGE_DEBUG, "Resource " + resource.toString() + " got redirect " + response.result + " code for " + (Object)((Object)requestMethod) + " request for " + url.toExternalForm() + " adding " + response.URL.toExternalForm() + " to list of possible urls");
                        if (!JNLPRuntime.isAllowRedirect()) {
                            throw new RedirectionException("The resource " + url.toExternalForm() + " is being redirected (" + response.result + ") to " + response.URL.toExternalForm() + ". This is disabled by default. If you wont to allow it, run javaws with -allowredirect parameter.");
                        }
                        urls.add(response.URL);
                        continue;
                    }
                    if (response.isInvalid()) {
                        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "For " + resource.toString() + " the server returned " + response.result + " code for " + (Object)((Object)requestMethod) + " request for " + url.toExternalForm());
                        continue;
                    }
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "best url for " + resource.toString() + " is " + url.toString() + " by " + (Object)((Object)requestMethod));
                    if (response.URL == null) {
                        response.URL = url;
                    }
                    return response;
                }
                catch (IOException e) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "While processing " + url.toString() + " by " + (Object)((Object)requestMethod) + " for resource " + resource.toString() + " got " + e + ": ");
                    OutputController.getLogger().log(e);
                }
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadResource() {
        URLConnection connection = null;
        URL downloadFrom = this.resource.getDownloadLocation();
        URL downloadTo = this.resource.getLocation();
        try {
            connection = this.getDownloadConnection(downloadFrom);
            String contentEncoding = connection.getContentEncoding();
            OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Downloading " + downloadTo + " using " + downloadFrom + " (encoding : " + contentEncoding + ") ");
            boolean packgz = "pack200-gzip".equals(contentEncoding) || downloadFrom.getPath().endsWith(".pack.gz");
            boolean gzip = "gzip".equals(contentEncoding);
            if (packgz) {
                this.downloadPackGzFile(this.resource, connection, new URL(downloadFrom + ".pack.gz"), downloadTo);
            } else if (gzip) {
                this.downloadGZipFile(this.resource, connection, new URL(downloadFrom + ".gz"), downloadTo);
            } else {
                this.downloadFile(this.resource, connection, downloadTo);
            }
            this.resource.changeStatus(EnumSet.of(Resource.Status.DOWNLOADING), EnumSet.of(Resource.Status.DOWNLOADED));
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.resource.fireDownloadEvent();
        }
        catch (Exception ex) {
            OutputController.getLogger().log(ex);
            this.resource.changeStatus(EnumSet.noneOf(Resource.Status.class), EnumSet.of(Resource.Status.ERROR));
            Object object = this.lock;
            synchronized (object) {
                this.lock.notifyAll();
            }
            this.resource.fireDownloadEvent();
        }
        finally {
            if (connection != null) {
                ConnectionFactory.getConnectionFactory().disconnect(connection);
            }
        }
    }

    private URLConnection getDownloadConnection(URL location) throws IOException {
        URLConnection con = ConnectionFactory.getConnectionFactory().openConnection(location);
        con.addRequestProperty("Accept-Encoding", "pack200-gzip, gzip");
        con.connect();
        return con;
    }

    private void downloadPackGzFile(Resource resource, URLConnection connection, URL downloadFrom, URL downloadTo) throws IOException {
        this.downloadFile(resource, connection, downloadFrom);
        this.uncompressPackGz(downloadFrom, downloadTo, resource.getDownloadVersion());
        this.storeEntryFields(new CacheEntry(downloadTo, resource.getDownloadVersion()), connection.getContentLength(), connection.getLastModified());
    }

    private void downloadGZipFile(Resource resource, URLConnection connection, URL downloadFrom, URL downloadTo) throws IOException {
        this.downloadFile(resource, connection, downloadFrom);
        this.uncompressGzip(downloadFrom, downloadTo, resource.getDownloadVersion());
        this.storeEntryFields(new CacheEntry(downloadTo, resource.getDownloadVersion()), connection.getContentLength(), connection.getLastModified());
    }

    private void downloadFile(Resource resource, URLConnection connection, URL downloadLocation) throws IOException {
        CacheEntry downloadEntry = new CacheEntry(downloadLocation, resource.getDownloadVersion());
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Downloading file: " + downloadLocation + " into: " + downloadEntry.getCacheFile().getCanonicalPath());
        if (!downloadEntry.isCurrent(connection.getLastModified())) {
            try {
                this.writeDownloadToFile(resource, downloadLocation, new BufferedInputStream(connection.getInputStream()));
            }
            catch (IOException ex) {
                String IH = "Invalid Http response";
                if (ex.getMessage().equals(IH)) {
                    OutputController.getLogger().log(ex);
                    OutputController.getLogger().log(OutputController.Level.MESSAGE_ALL, "'" + IH + "' message detected. Attempting direct socket");
                    Object[] result = UrlUtils.loadUrlWithInvalidHeaderBytes(connection.getURL());
                    OutputController.getLogger().log("Header of: " + connection.getURL() + " (" + downloadLocation + ")");
                    String head = (String)result[0];
                    byte[] body = (byte[])result[1];
                    OutputController.getLogger().log(head);
                    OutputController.getLogger().log("Body is: " + body.length + " bytes long");
                    this.writeDownloadToFile(resource, downloadLocation, new ByteArrayInputStream(body));
                }
                throw ex;
            }
        } else {
            resource.setTransferred(CacheUtil.getCacheFile(downloadLocation, resource.getDownloadVersion()).length());
        }
        this.storeEntryFields(downloadEntry, connection.getContentLengthLong(), connection.getLastModified());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void storeEntryFields(CacheEntry entry, long contentLength, long lastModified) {
        entry.lock();
        try {
            entry.setRemoteContentLength(contentLength);
            entry.setLastModified(lastModified);
            entry.store();
        }
        finally {
            entry.unlock();
        }
    }

    private void writeDownloadToFile(Resource resource, URL downloadLocation, InputStream in) throws IOException {
        byte[] buf = new byte[1024];
        try (OutputStream out = CacheUtil.getOutputStream(downloadLocation, resource.getDownloadVersion());){
            int rlen;
            while (-1 != (rlen = in.read(buf))) {
                resource.incrementTransferred(rlen);
                out.write(buf, 0, rlen);
            }
            in.close();
        }
    }

    private void uncompressGzip(URL compressedLocation, URL uncompressedLocation, Version version) throws IOException {
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Extracting gzip: " + compressedLocation + " to " + uncompressedLocation);
        byte[] buf = new byte[1024];
        try (GZIPInputStream gzInputStream = new GZIPInputStream(new FileInputStream(CacheUtil.getCacheFile(compressedLocation, version)));){
            int rlen;
            BufferedInputStream inputStream = new BufferedInputStream(gzInputStream);
            BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(CacheUtil.getCacheFile(uncompressedLocation, version)));
            while (-1 != (rlen = ((InputStream)inputStream).read(buf))) {
                outputStream.write(buf, 0, rlen);
            }
            outputStream.close();
            ((InputStream)inputStream).close();
        }
    }

    private void uncompressPackGz(URL compressedLocation, URL uncompressedLocation, Version version) throws IOException {
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Extracting packgz: " + compressedLocation + " to " + uncompressedLocation);
        try (GZIPInputStream gzInputStream = new GZIPInputStream(new FileInputStream(CacheUtil.getCacheFile(compressedLocation, version)));){
            BufferedInputStream inputStream = new BufferedInputStream(gzInputStream);
            JarOutputStream outputStream = new JarOutputStream(new FileOutputStream(CacheUtil.getCacheFile(uncompressedLocation, version)));
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.unpack((InputStream)inputStream, outputStream);
            outputStream.close();
            ((InputStream)inputStream).close();
        }
    }

    private static class RedirectionException
    extends RuntimeException {
        public RedirectionException(String string) {
            super(string);
        }

        public RedirectionException(Throwable cause) {
            super(cause);
        }
    }

    static class UrlRequestResult {
        int result = 200;
        URL URL;
        Long lastModified;
        Long length;

        public UrlRequestResult() {
        }

        public UrlRequestResult(URL URL2) {
            this.URL = URL2;
        }

        URL getURL() {
            return this.URL;
        }

        public boolean shouldRedirect() {
            return this.result == 301 || this.result == 302 || this.result == 303 || this.result == 307 || this.result == 308;
        }

        public boolean isInvalid() {
            return this.result < 200 || this.result >= 300;
        }

        public String toString() {
            return "url: " + (this.URL == null ? "null" : this.URL.toExternalForm()) + "; " + "result:" + this.result + "; " + "lastModified: " + (this.lastModified == null ? "null" : this.lastModified.toString()) + "; " + "length: " + this.length == null ? "null" : this.length.toString() + "; ";
        }
    }
}

