/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.cloud.sdk.internal.mapping;

import com.zkteco.cloud.sdk.ApiException;
import com.zkteco.cloud.sdk.internal.mapping.ApiField;
import com.zkteco.cloud.sdk.internal.mapping.ApiListField;
import com.zkteco.cloud.sdk.internal.mapping.Reader;
import com.zkteco.cloud.sdk.internal.util.StringUtils;
import com.zkteco.cloud.sdk.resp.BaseResponse;
import java.beans.BeanInfo;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class Converters {
    public static boolean isCheckJsonType = false;
    private static final Object emptyCache = new Object();
    private static final Map<String, Set<String>> baseProps = new HashMap<String, Set<String>>();
    private static final Map<String, Object> fieldCache = new ConcurrentHashMap<String, Object>();
    private static final Map<String, Object> methodCache = new ConcurrentHashMap<String, Object>();

    private Converters() {
    }

    public static <T> T convert(Class<T> clazz, Reader reader) throws ApiException {
        T rsp = null;
        try {
            PropertyDescriptor[] pds;
            rsp = clazz.newInstance();
            BeanInfo beanInfo = Introspector.getBeanInfo(clazz);
            for (PropertyDescriptor pd : pds = beanInfo.getPropertyDescriptors()) {
                Object value;
                ApiListField jsonListField;
                Method method = Converters.getCacheMethod(clazz, pd);
                if (method == null) continue;
                String itemName = pd.getName();
                String parentName = null;
                Field field = null;
                Set<String> stopProps = baseProps.get(clazz.getSuperclass().getName());
                field = stopProps != null && stopProps.contains(itemName) ? Converters.getField(clazz.getSuperclass(), pd) : Converters.getField(clazz, pd);
                if (field == null) continue;
                ApiField jsonField = field.getAnnotation(ApiField.class);
                if (jsonField != null) {
                    itemName = jsonField.value();
                }
                if ((jsonListField = field.getAnnotation(ApiListField.class)) != null) {
                    parentName = jsonListField.value();
                }
                if (!reader.hasReturnField(itemName) && (parentName == null || !reader.hasReturnField(parentName))) continue;
                Class<?> typeClass = field.getType();
                if (String.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof String) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a String");
                    }
                    if (value != null) {
                        method.invoke(rsp, value.toString());
                        continue;
                    }
                    method.invoke(rsp, "");
                    continue;
                }
                if (Long.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Long) {
                        method.invoke(rsp, (Long)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a Number(Long)");
                    }
                    if (!StringUtils.isNumeric(value)) continue;
                    method.invoke(rsp, Long.valueOf(value.toString()));
                    continue;
                }
                if (Boolean.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Boolean) {
                        method.invoke(rsp, (Boolean)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a Boolean");
                    }
                    if (value == null) continue;
                    method.invoke(rsp, Boolean.valueOf(value.toString()));
                    continue;
                }
                if (Date.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (!(value instanceof String)) continue;
                    method.invoke(rsp, StringUtils.parseDateTime(value.toString()));
                    continue;
                }
                if (List.class.isAssignableFrom(typeClass)) {
                    Class subType;
                    List<?> listObjs;
                    ParameterizedType paramType;
                    Type[] genericTypes;
                    Type fieldType = field.getGenericType();
                    if (!(fieldType instanceof ParameterizedType) || (genericTypes = (paramType = (ParameterizedType)fieldType).getActualTypeArguments()) == null || genericTypes.length <= 0 || !(genericTypes[0] instanceof Class) || (listObjs = reader.getListObjects(parentName, itemName, subType = (Class)genericTypes[0])) == null) continue;
                    method.invoke(rsp, listObjs);
                    continue;
                }
                if (Integer.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Integer) {
                        method.invoke(rsp, (Integer)value);
                        continue;
                    }
                    if (isCheckJsonType && value != null) {
                        throw new ApiException(itemName + " is not a Number(Integer)");
                    }
                    if (!StringUtils.isNumeric(value)) continue;
                    method.invoke(rsp, Integer.valueOf(value.toString()));
                    continue;
                }
                if (Double.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Double) {
                        method.invoke(rsp, (Double)value);
                        continue;
                    }
                    if (!isCheckJsonType || value == null) continue;
                    throw new ApiException(itemName + " is not a Double");
                }
                if (Number.class.isAssignableFrom(typeClass)) {
                    value = reader.getPrimitiveObject(itemName);
                    if (value instanceof Number) {
                        method.invoke(rsp, (Number)value);
                        continue;
                    }
                    if (!isCheckJsonType || value == null) continue;
                    throw new ApiException(itemName + " is not a Number");
                }
                Object obj = reader.getObject(itemName, typeClass);
                if (obj == null) continue;
                method.invoke(rsp, obj);
            }
        }
        catch (Exception e) {
            throw new ApiException(e);
        }
        return rsp;
    }

    public static Field getField(Class<?> clazz, PropertyDescriptor pd) throws Exception {
        String key = clazz.getName() + "_" + pd.getName();
        Object field = fieldCache.get(key);
        if (field == null) {
            try {
                field = clazz.getDeclaredField(pd.getName());
            }
            catch (NoSuchFieldException e) {
                field = emptyCache;
            }
            fieldCache.put(key, field);
        }
        return field == emptyCache ? null : (Field)field;
    }

    private static Method getCacheMethod(Class<?> clazz, PropertyDescriptor pd) {
        String key = clazz.getName() + "_" + pd.getName();
        Object method = methodCache.get(key);
        if (method == null) {
            method = pd.getWriteMethod();
            if (method == null) {
                method = emptyCache;
            }
            methodCache.put(key, method);
        }
        return method == emptyCache ? null : (Method)method;
    }

    static {
        baseProps.put(BaseResponse.class.getName(), StringUtils.getClassProperties(BaseResponse.class, false));
    }
}

