/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.wx.controller;

import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersApiTokenRemote;
import com.zkteco.zkbiosecurity.pers.service.PersAppBioService;
import com.zkteco.zkbiosecurity.pers.service.wx.PersApiTokenService;
import com.zkteco.zkbiosecurity.pers.vo.wx.LoginTokenItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

@RestController
public class PersApiTokenController
extends BaseController
implements PersApiTokenRemote {
    @Autowired
    private PersApiTokenService persApiTokenService;
    @Autowired
    private PersAppBioService persAppBioService;

    public ZKResultMsg logOut(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return ZKResultMsg.failMsg();
        }
        try {
            this.persApiTokenService.logOut(token);
        }
        catch (ZKBusinessException e) {
            e.printStackTrace();
        }
        return new ZKResultMsg();
    }

    public ZKResultMsg getToken(@RequestBody LoginTokenItem loginTokenItem) {
        if (StringUtils.isBlank((CharSequence)loginTokenItem.getCode())) {
            return ZKResultMsg.failMsg();
        }
        ZKResultMsg resultMsg = this.persApiTokenService.getToken(loginTokenItem);
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }
}

