/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.wx.controller;

import java.util.Calendar;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class IdCardGenerator {
    public static final Map<String, Integer> areaCode = new HashMap<String, Integer>();

    public String generate() {
        StringBuilder generater = new StringBuilder();
        generater.append(this.randomAreaCode());
        generater.append(this.randomBirthday());
        generater.append(this.randomCode());
        generater.append(this.calcTrailingNumber(generater.toString().toCharArray()));
        return generater.toString();
    }

    public int randomAreaCode() {
        int index = (int)(Math.random() * (double)areaCode.size());
        Collection<Integer> values = areaCode.values();
        Iterator<Integer> it = values.iterator();
        int code = 0;
        for (int i = 0; i < index && it.hasNext(); ++i) {
            code = it.next();
        }
        return code;
    }

    public String randomBirthday() {
        Calendar birthday = Calendar.getInstance();
        birthday.set(1, (int)(Math.random() * 60.0) + 1950);
        birthday.set(2, (int)(Math.random() * 12.0));
        birthday.set(5, (int)(Math.random() * 31.0));
        StringBuilder builder = new StringBuilder();
        builder.append(birthday.get(1));
        long month = birthday.get(2) + 1;
        if (month < 10L) {
            builder.append("0");
        }
        builder.append(month);
        long date = birthday.get(5);
        if (date < 10L) {
            builder.append("0");
        }
        builder.append(date);
        return builder.toString();
    }

    public char calcTrailingNumber(char[] chars) {
        int i;
        if (chars.length < 17) {
            return ' ';
        }
        int[] c = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
        char[] r = new char[]{'1', '0', 'X', '9', '8', '7', '6', '5', '4', '3', '2'};
        int[] n = new int[17];
        int result = 0;
        for (i = 0; i < n.length; ++i) {
            n[i] = Integer.parseInt(chars[i] + "");
        }
        for (i = 0; i < n.length; ++i) {
            result += c[i] * n[i];
        }
        return r[result % 11];
    }

    public String randomCode() {
        int code = (int)(Math.random() * 1000.0);
        if (code < 10) {
            return "00" + code;
        }
        if (code < 100) {
            return "0" + code;
        }
        return "" + code;
    }

    /*
     * Opcode count of 21096 triggered aggressive code reduction.  Override with --aggressivesizethreshold.
     */
    static {
        areaCode.put("\u5317\u4eac\u5e02", 110000);
        areaCode.put("\u5e02\u8f96\u533a", 110100);
        areaCode.put("\u4e1c\u57ce\u533a", 110101);
        areaCode.put("\u897f\u57ce\u533a", 110102);
        areaCode.put("\u5d07\u6587\u533a", 110103);
        areaCode.put("\u5ba3\u6b66\u533a", 110104);
        areaCode.put("\u671d\u9633\u533a", 110105);
        areaCode.put("\u4e30\u53f0\u533a", 110106);
        areaCode.put("\u77f3\u666f\u5c71\u533a", 110107);
        areaCode.put("\u6d77\u6dc0\u533a", 110108);
        areaCode.put("\u95e8\u5934\u6c9f\u533a", 110109);
        areaCode.put("\u623f\u5c71\u533a", 110111);
        areaCode.put("\u901a\u5dde\u533a", 110112);
        areaCode.put("\u987a\u4e49\u533a", 110113);
        areaCode.put("\u660c\u5e73\u533a", 110114);
        areaCode.put("\u5927\u5174\u533a", 110115);
        areaCode.put("\u6000\u67d4\u533a", 110116);
        areaCode.put("\u5e73\u8c37\u533a", 110117);
        areaCode.put("\u53bf", 110200);
        areaCode.put("\u5bc6\u4e91\u53bf", 110228);
        areaCode.put("\u5ef6\u5e86\u53bf", 110229);
        areaCode.put("\u5929\u6d25\u5e02", 120000);
        areaCode.put("\u5e02\u8f96\u533a", 120100);
        areaCode.put("\u548c\u5e73\u533a", 120101);
        areaCode.put("\u6cb3\u4e1c\u533a", 120102);
        areaCode.put("\u6cb3\u897f\u533a", 120103);
        areaCode.put("\u5357\u5f00\u533a", 120104);
        areaCode.put("\u6cb3\u5317\u533a", 120105);
        areaCode.put("\u7ea2\u6865\u533a", 120106);
        areaCode.put("\u4e1c\u4e3d\u533a", 120110);
        areaCode.put("\u897f\u9752\u533a", 120111);
        areaCode.put("\u6d25\u5357\u533a", 120112);
        areaCode.put("\u5317\u8fb0\u533a", 120113);
        areaCode.put("\u6b66\u6e05\u533a", 120114);
        areaCode.put("\u5b9d\u577b\u533a", 120115);
        areaCode.put("\u53bf", 120200);
        areaCode.put("\u5b81\u6cb3\u53bf", 120221);
        areaCode.put("\u9759\u6d77\u53bf", 120223);
        areaCode.put("\u84df\u3000\u53bf", 120225);
        areaCode.put("\u6cb3\u5317\u7701", 130000);
        areaCode.put("\u77f3\u5bb6\u5e84\u5e02", 130100);
        areaCode.put("\u5e02\u8f96\u533a", 130101);
        areaCode.put("\u957f\u5b89\u533a", 130102);
        areaCode.put("\u6865\u4e1c\u533a", 130103);
        areaCode.put("\u6865\u897f\u533a", 130104);
        areaCode.put("\u65b0\u534e\u533a", 130105);
        areaCode.put("\u4e95\u9649\u77ff\u533a", 130107);
        areaCode.put("\u88d5\u534e\u533a", 130108);
        areaCode.put("\u4e95\u9649\u53bf", 130121);
        areaCode.put("\u6b63\u5b9a\u53bf", 130123);
        areaCode.put("\u683e\u57ce\u53bf", 130124);
        areaCode.put("\u884c\u5510\u53bf", 130125);
        areaCode.put("\u7075\u5bff\u53bf", 130126);
        areaCode.put("\u9ad8\u9091\u53bf", 130127);
        areaCode.put("\u6df1\u6cfd\u53bf", 130128);
        areaCode.put("\u8d5e\u7687\u53bf", 130129);
        areaCode.put("\u65e0\u6781\u53bf", 130130);
        areaCode.put("\u5e73\u5c71\u53bf", 130131);
        areaCode.put("\u5143\u6c0f\u53bf", 130132);
        areaCode.put("\u8d75\u3000\u53bf", 130133);
        areaCode.put("\u8f9b\u96c6\u5e02", 130181);
        areaCode.put("\u85c1\u57ce\u5e02", 130182);
        areaCode.put("\u664b\u5dde\u5e02", 130183);
        areaCode.put("\u65b0\u4e50\u5e02", 130184);
        areaCode.put("\u9e7f\u6cc9\u5e02", 130185);
        areaCode.put("\u5510\u5c71\u5e02", 130200);
        areaCode.put("\u5e02\u8f96\u533a", 130201);
        areaCode.put("\u8def\u5357\u533a", 130202);
        areaCode.put("\u8def\u5317\u533a", 130203);
        areaCode.put("\u53e4\u51b6\u533a", 130204);
        areaCode.put("\u5f00\u5e73\u533a", 130205);
        areaCode.put("\u4e30\u5357\u533a", 130207);
        areaCode.put("\u4e30\u6da6\u533a", 130208);
        areaCode.put("\u6ee6\u3000\u53bf", 130223);
        areaCode.put("\u6ee6\u5357\u53bf", 130224);
        areaCode.put("\u4e50\u4ead\u53bf", 130225);
        areaCode.put("\u8fc1\u897f\u53bf", 130227);
        areaCode.put("\u7389\u7530\u53bf", 130229);
        areaCode.put("\u5510\u6d77\u53bf", 130230);
        areaCode.put("\u9075\u5316\u5e02", 130281);
        areaCode.put("\u8fc1\u5b89\u5e02", 130283);
        areaCode.put("\u79e6\u7687\u5c9b\u5e02", 130300);
        areaCode.put("\u5e02\u8f96\u533a", 130301);
        areaCode.put("\u6d77\u6e2f\u533a", 130302);
        areaCode.put("\u5c71\u6d77\u5173\u533a", 130303);
        areaCode.put("\u5317\u6234\u6cb3\u533a", 130304);
        areaCode.put("\u9752\u9f99\u6ee1\u65cf\u81ea\u6cbb\u53bf", 130321);
        areaCode.put("\u660c\u9ece\u53bf", 130322);
        areaCode.put("\u629a\u5b81\u53bf", 130323);
        areaCode.put("\u5362\u9f99\u53bf", 130324);
        areaCode.put("\u90af\u90f8\u5e02", 130400);
        areaCode.put("\u5e02\u8f96\u533a", 130401);
        areaCode.put("\u90af\u5c71\u533a", 130402);
        areaCode.put("\u4e1b\u53f0\u533a", 130403);
        areaCode.put("\u590d\u5174\u533a", 130404);
        areaCode.put("\u5cf0\u5cf0\u77ff\u533a", 130406);
        areaCode.put("\u90af\u90f8\u53bf", 130421);
        areaCode.put("\u4e34\u6f33\u53bf", 130423);
        areaCode.put("\u6210\u5b89\u53bf", 130424);
        areaCode.put("\u5927\u540d\u53bf", 130425);
        areaCode.put("\u6d89\u3000\u53bf", 130426);
        areaCode.put("\u78c1\u3000\u53bf", 130427);
        areaCode.put("\u80a5\u4e61\u53bf", 130428);
        areaCode.put("\u6c38\u5e74\u53bf", 130429);
        areaCode.put("\u90b1\u3000\u53bf", 130430);
        areaCode.put("\u9e21\u6cfd\u53bf", 130431);
        areaCode.put("\u5e7f\u5e73\u53bf", 130432);
        areaCode.put("\u9986\u9676\u53bf", 130433);
        areaCode.put("\u9b4f\u3000\u53bf", 130434);
        areaCode.put("\u66f2\u5468\u53bf", 130435);
        areaCode.put("\u6b66\u5b89\u5e02", 130481);
        areaCode.put("\u90a2\u53f0\u5e02", 130500);
        areaCode.put("\u5e02\u8f96\u533a", 130501);
        areaCode.put("\u6865\u4e1c\u533a", 130502);
        areaCode.put("\u6865\u897f\u533a", 130503);
        areaCode.put("\u90a2\u53f0\u53bf", 130521);
        areaCode.put("\u4e34\u57ce\u53bf", 130522);
        areaCode.put("\u5185\u4e18\u53bf", 130523);
        areaCode.put("\u67cf\u4e61\u53bf", 130524);
        areaCode.put("\u9686\u5c27\u53bf", 130525);
        areaCode.put("\u4efb\u3000\u53bf", 130526);
        areaCode.put("\u5357\u548c\u53bf", 130527);
        areaCode.put("\u5b81\u664b\u53bf", 130528);
        areaCode.put("\u5de8\u9e7f\u53bf", 130529);
        areaCode.put("\u65b0\u6cb3\u53bf", 130530);
        areaCode.put("\u5e7f\u5b97\u53bf", 130531);
        areaCode.put("\u5e73\u4e61\u53bf", 130532);
        areaCode.put("\u5a01\u3000\u53bf", 130533);
        areaCode.put("\u6e05\u6cb3\u53bf", 130534);
        areaCode.put("\u4e34\u897f\u53bf", 130535);
        areaCode.put("\u5357\u5bab\u5e02", 130581);
        areaCode.put("\u6c99\u6cb3\u5e02", 130582);
        areaCode.put("\u4fdd\u5b9a\u5e02", 130600);
        areaCode.put("\u5e02\u8f96\u533a", 130601);
        areaCode.put("\u65b0\u5e02\u533a", 130602);
        areaCode.put("\u5317\u5e02\u533a", 130603);
        areaCode.put("\u5357\u5e02\u533a", 130604);
        areaCode.put("\u6ee1\u57ce\u53bf", 130621);
        areaCode.put("\u6e05\u82d1\u53bf", 130622);
        areaCode.put("\u6d9e\u6c34\u53bf", 130623);
        areaCode.put("\u961c\u5e73\u53bf", 130624);
        areaCode.put("\u5f90\u6c34\u53bf", 130625);
        areaCode.put("\u5b9a\u5174\u53bf", 130626);
        areaCode.put("\u5510\u3000\u53bf", 130627);
        areaCode.put("\u9ad8\u9633\u53bf", 130628);
        areaCode.put("\u5bb9\u57ce\u53bf", 130629);
        areaCode.put("\u6d9e\u6e90\u53bf", 130630);
        areaCode.put("\u671b\u90fd\u53bf", 130631);
        areaCode.put("\u5b89\u65b0\u53bf", 130632);
        areaCode.put("\u6613\u3000\u53bf", 130633);
        areaCode.put("\u66f2\u9633\u53bf", 130634);
        areaCode.put("\u8821\u3000\u53bf", 130635);
        areaCode.put("\u987a\u5e73\u53bf", 130636);
        areaCode.put("\u535a\u91ce\u53bf", 130637);
        areaCode.put("\u96c4\u3000\u53bf", 130638);
        areaCode.put("\u6dbf\u5dde\u5e02", 130681);
        areaCode.put("\u5b9a\u5dde\u5e02", 130682);
        areaCode.put("\u5b89\u56fd\u5e02", 130683);
        areaCode.put("\u9ad8\u7891\u5e97\u5e02", 130684);
        areaCode.put("\u5f20\u5bb6\u53e3\u5e02", 130700);
        areaCode.put("\u5e02\u8f96\u533a", 130701);
        areaCode.put("\u6865\u4e1c\u533a", 130702);
        areaCode.put("\u6865\u897f\u533a", 130703);
        areaCode.put("\u5ba3\u5316\u533a", 130705);
        areaCode.put("\u4e0b\u82b1\u56ed\u533a", 130706);
        areaCode.put("\u5ba3\u5316\u53bf", 130721);
        areaCode.put("\u5f20\u5317\u53bf", 130722);
        areaCode.put("\u5eb7\u4fdd\u53bf", 130723);
        areaCode.put("\u6cbd\u6e90\u53bf", 130724);
        areaCode.put("\u5c1a\u4e49\u53bf", 130725);
        areaCode.put("\u851a\u3000\u53bf", 130726);
        areaCode.put("\u9633\u539f\u53bf", 130727);
        areaCode.put("\u6000\u5b89\u53bf", 130728);
        areaCode.put("\u4e07\u5168\u53bf", 130729);
        areaCode.put("\u6000\u6765\u53bf", 130730);
        areaCode.put("\u6dbf\u9e7f\u53bf", 130731);
        areaCode.put("\u8d64\u57ce\u53bf", 130732);
        areaCode.put("\u5d07\u793c\u53bf", 130733);
        areaCode.put("\u627f\u5fb7\u5e02", 130800);
        areaCode.put("\u5e02\u8f96\u533a", 130801);
        areaCode.put("\u53cc\u6865\u533a", 130802);
        areaCode.put("\u53cc\u6ee6\u533a", 130803);
        areaCode.put("\u9e70\u624b\u8425\u5b50\u77ff\u533a", 130804);
        areaCode.put("\u627f\u5fb7\u53bf", 130821);
        areaCode.put("\u5174\u9686\u53bf", 130822);
        areaCode.put("\u5e73\u6cc9\u53bf", 130823);
        areaCode.put("\u6ee6\u5e73\u53bf", 130824);
        areaCode.put("\u9686\u5316\u53bf", 130825);
        areaCode.put("\u4e30\u5b81\u6ee1\u65cf\u81ea\u6cbb\u53bf", 130826);
        areaCode.put("\u5bbd\u57ce\u6ee1\u65cf\u81ea\u6cbb\u53bf", 130827);
        areaCode.put("\u56f4\u573a\u6ee1\u65cf\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 130828);
        areaCode.put("\u6ca7\u5dde\u5e02", 130900);
        areaCode.put("\u5e02\u8f96\u533a", 130901);
        areaCode.put("\u65b0\u534e\u533a", 130902);
        areaCode.put("\u8fd0\u6cb3\u533a", 130903);
        areaCode.put("\u6ca7\u3000\u53bf", 130921);
        areaCode.put("\u9752\u3000\u53bf", 130922);
        areaCode.put("\u4e1c\u5149\u53bf", 130923);
        areaCode.put("\u6d77\u5174\u53bf", 130924);
        areaCode.put("\u76d0\u5c71\u53bf", 130925);
        areaCode.put("\u8083\u5b81\u53bf", 130926);
        areaCode.put("\u5357\u76ae\u53bf", 130927);
        areaCode.put("\u5434\u6865\u53bf", 130928);
        areaCode.put("\u732e\u3000\u53bf", 130929);
        areaCode.put("\u5b5f\u6751\u56de\u65cf\u81ea\u6cbb\u53bf", 130930);
        areaCode.put("\u6cca\u5934\u5e02", 130981);
        areaCode.put("\u4efb\u4e18\u5e02", 130982);
        areaCode.put("\u9ec4\u9a85\u5e02", 130983);
        areaCode.put("\u6cb3\u95f4\u5e02", 130984);
        areaCode.put("\u5eca\u574a\u5e02", 131000);
        areaCode.put("\u5e02\u8f96\u533a", 131001);
        areaCode.put("\u5b89\u6b21\u533a", 131002);
        areaCode.put("\u5e7f\u9633\u533a", 131003);
        areaCode.put("\u56fa\u5b89\u53bf", 131022);
        areaCode.put("\u6c38\u6e05\u53bf", 131023);
        areaCode.put("\u9999\u6cb3\u53bf", 131024);
        areaCode.put("\u5927\u57ce\u53bf", 131025);
        areaCode.put("\u6587\u5b89\u53bf", 131026);
        areaCode.put("\u5927\u5382\u56de\u65cf\u81ea\u6cbb\u53bf", 131028);
        areaCode.put("\u9738\u5dde\u5e02", 131081);
        areaCode.put("\u4e09\u6cb3\u5e02", 131082);
        areaCode.put("\u8861\u6c34\u5e02", 131100);
        areaCode.put("\u5e02\u8f96\u533a", 131101);
        areaCode.put("\u6843\u57ce\u533a", 131102);
        areaCode.put("\u67a3\u5f3a\u53bf", 131121);
        areaCode.put("\u6b66\u9091\u53bf", 131122);
        areaCode.put("\u6b66\u5f3a\u53bf", 131123);
        areaCode.put("\u9976\u9633\u53bf", 131124);
        areaCode.put("\u5b89\u5e73\u53bf", 131125);
        areaCode.put("\u6545\u57ce\u53bf", 131126);
        areaCode.put("\u666f\u3000\u53bf", 131127);
        areaCode.put("\u961c\u57ce\u53bf", 131128);
        areaCode.put("\u5180\u5dde\u5e02", 131181);
        areaCode.put("\u6df1\u5dde\u5e02", 131182);
        areaCode.put("\u5c71\u897f\u7701", 140000);
        areaCode.put("\u592a\u539f\u5e02", 140100);
        areaCode.put("\u5e02\u8f96\u533a", 140101);
        areaCode.put("\u5c0f\u5e97\u533a", 140105);
        areaCode.put("\u8fce\u6cfd\u533a", 140106);
        areaCode.put("\u674f\u82b1\u5cad\u533a", 140107);
        areaCode.put("\u5c16\u8349\u576a\u533a", 140108);
        areaCode.put("\u4e07\u67cf\u6797\u533a", 140109);
        areaCode.put("\u664b\u6e90\u533a", 140110);
        areaCode.put("\u6e05\u5f90\u53bf", 140121);
        areaCode.put("\u9633\u66f2\u53bf", 140122);
        areaCode.put("\u5a04\u70e6\u53bf", 140123);
        areaCode.put("\u53e4\u4ea4\u5e02", 140181);
        areaCode.put("\u5927\u540c\u5e02", 140200);
        areaCode.put("\u5e02\u8f96\u533a", 140201);
        areaCode.put("\u57ce\u3000\u533a", 140202);
        areaCode.put("\u77ff\u3000\u533a", 140203);
        areaCode.put("\u5357\u90ca\u533a", 140211);
        areaCode.put("\u65b0\u8363\u533a", 140212);
        areaCode.put("\u9633\u9ad8\u53bf", 140221);
        areaCode.put("\u5929\u9547\u53bf", 140222);
        areaCode.put("\u5e7f\u7075\u53bf", 140223);
        areaCode.put("\u7075\u4e18\u53bf", 140224);
        areaCode.put("\u6d51\u6e90\u53bf", 140225);
        areaCode.put("\u5de6\u4e91\u53bf", 140226);
        areaCode.put("\u5927\u540c\u53bf", 140227);
        areaCode.put("\u9633\u6cc9\u5e02", 140300);
        areaCode.put("\u5e02\u8f96\u533a", 140301);
        areaCode.put("\u57ce\u3000\u533a", 140302);
        areaCode.put("\u77ff\u3000\u533a", 140303);
        areaCode.put("\u90ca\u3000\u533a", 140311);
        areaCode.put("\u5e73\u5b9a\u53bf", 140321);
        areaCode.put("\u76c2\u3000\u53bf", 140322);
        areaCode.put("\u957f\u6cbb\u5e02", 140400);
        areaCode.put("\u5e02\u8f96\u533a", 140401);
        areaCode.put("\u57ce\u3000\u533a", 140402);
        areaCode.put("\u90ca\u3000\u533a", 140411);
        areaCode.put("\u957f\u6cbb\u53bf", 140421);
        areaCode.put("\u8944\u57a3\u53bf", 140423);
        areaCode.put("\u5c6f\u7559\u53bf", 140424);
        areaCode.put("\u5e73\u987a\u53bf", 140425);
        areaCode.put("\u9ece\u57ce\u53bf", 140426);
        areaCode.put("\u58f6\u5173\u53bf", 140427);
        areaCode.put("\u957f\u5b50\u53bf", 140428);
        areaCode.put("\u6b66\u4e61\u53bf", 140429);
        areaCode.put("\u6c81\u3000\u53bf", 140430);
        areaCode.put("\u6c81\u6e90\u53bf", 140431);
        areaCode.put("\u6f5e\u57ce\u5e02", 140481);
        areaCode.put("\u664b\u57ce\u5e02", 140500);
        areaCode.put("\u5e02\u8f96\u533a", 140501);
        areaCode.put("\u57ce\u3000\u533a", 140502);
        areaCode.put("\u6c81\u6c34\u53bf", 140521);
        areaCode.put("\u9633\u57ce\u53bf", 140522);
        areaCode.put("\u9675\u5ddd\u53bf", 140524);
        areaCode.put("\u6cfd\u5dde\u53bf", 140525);
        areaCode.put("\u9ad8\u5e73\u5e02", 140581);
        areaCode.put("\u6714\u5dde\u5e02", 140600);
        areaCode.put("\u5e02\u8f96\u533a", 140601);
        areaCode.put("\u6714\u57ce\u533a", 140602);
        areaCode.put("\u5e73\u9c81\u533a", 140603);
        areaCode.put("\u5c71\u9634\u53bf", 140621);
        areaCode.put("\u5e94\u3000\u53bf", 140622);
        areaCode.put("\u53f3\u7389\u53bf", 140623);
        areaCode.put("\u6000\u4ec1\u53bf", 140624);
        areaCode.put("\u664b\u4e2d\u5e02", 140700);
        areaCode.put("\u5e02\u8f96\u533a", 140701);
        areaCode.put("\u6986\u6b21\u533a", 140702);
        areaCode.put("\u6986\u793e\u53bf", 140721);
        areaCode.put("\u5de6\u6743\u53bf", 140722);
        areaCode.put("\u548c\u987a\u53bf", 140723);
        areaCode.put("\u6614\u9633\u53bf", 140724);
        areaCode.put("\u5bff\u9633\u53bf", 140725);
        areaCode.put("\u592a\u8c37\u53bf", 140726);
        areaCode.put("\u7941\u3000\u53bf", 140727);
        areaCode.put("\u5e73\u9065\u53bf", 140728);
        areaCode.put("\u7075\u77f3\u53bf", 140729);
        areaCode.put("\u4ecb\u4f11\u5e02", 140781);
        areaCode.put("\u8fd0\u57ce\u5e02", 140800);
        areaCode.put("\u5e02\u8f96\u533a", 140801);
        areaCode.put("\u76d0\u6e56\u533a", 140802);
        areaCode.put("\u4e34\u7317\u53bf", 140821);
        areaCode.put("\u4e07\u8363\u53bf", 140822);
        areaCode.put("\u95fb\u559c\u53bf", 140823);
        areaCode.put("\u7a37\u5c71\u53bf", 140824);
        areaCode.put("\u65b0\u7edb\u53bf", 140825);
        areaCode.put("\u7edb\u3000\u53bf", 140826);
        areaCode.put("\u57a3\u66f2\u53bf", 140827);
        areaCode.put("\u590f\u3000\u53bf", 140828);
        areaCode.put("\u5e73\u9646\u53bf", 140829);
        areaCode.put("\u82ae\u57ce\u53bf", 140830);
        areaCode.put("\u6c38\u6d4e\u5e02", 140881);
        areaCode.put("\u6cb3\u6d25\u5e02", 140882);
        areaCode.put("\u5ffb\u5dde\u5e02", 140900);
        areaCode.put("\u5e02\u8f96\u533a", 140901);
        areaCode.put("\u5ffb\u5e9c\u533a", 140902);
        areaCode.put("\u5b9a\u8944\u53bf", 140921);
        areaCode.put("\u4e94\u53f0\u53bf", 140922);
        areaCode.put("\u4ee3\u3000\u53bf", 140923);
        areaCode.put("\u7e41\u5cd9\u53bf", 140924);
        areaCode.put("\u5b81\u6b66\u53bf", 140925);
        areaCode.put("\u9759\u4e50\u53bf", 140926);
        areaCode.put("\u795e\u6c60\u53bf", 140927);
        areaCode.put("\u4e94\u5be8\u53bf", 140928);
        areaCode.put("\u5ca2\u5c9a\u53bf", 140929);
        areaCode.put("\u6cb3\u66f2\u53bf", 140930);
        areaCode.put("\u4fdd\u5fb7\u53bf", 140931);
        areaCode.put("\u504f\u5173\u53bf", 140932);
        areaCode.put("\u539f\u5e73\u5e02", 140981);
        areaCode.put("\u4e34\u6c7e\u5e02", 141000);
        areaCode.put("\u5e02\u8f96\u533a", 141001);
        areaCode.put("\u5c27\u90fd\u533a", 141002);
        areaCode.put("\u66f2\u6c83\u53bf", 141021);
        areaCode.put("\u7ffc\u57ce\u53bf", 141022);
        areaCode.put("\u8944\u6c7e\u53bf", 141023);
        areaCode.put("\u6d2a\u6d1e\u53bf", 141024);
        areaCode.put("\u53e4\u3000\u53bf", 141025);
        areaCode.put("\u5b89\u6cfd\u53bf", 141026);
        areaCode.put("\u6d6e\u5c71\u53bf", 141027);
        areaCode.put("\u5409\u3000\u53bf", 141028);
        areaCode.put("\u4e61\u5b81\u53bf", 141029);
        areaCode.put("\u5927\u5b81\u53bf", 141030);
        areaCode.put("\u96b0\u3000\u53bf", 141031);
        areaCode.put("\u6c38\u548c\u53bf", 141032);
        areaCode.put("\u84b2\u3000\u53bf", 141033);
        areaCode.put("\u6c7e\u897f\u53bf", 141034);
        areaCode.put("\u4faf\u9a6c\u5e02", 141081);
        areaCode.put("\u970d\u5dde\u5e02", 141082);
        areaCode.put("\u5415\u6881\u5e02", 141100);
        areaCode.put("\u5e02\u8f96\u533a", 141101);
        areaCode.put("\u79bb\u77f3\u533a", 141102);
        areaCode.put("\u6587\u6c34\u53bf", 141121);
        areaCode.put("\u4ea4\u57ce\u53bf", 141122);
        areaCode.put("\u5174\u3000\u53bf", 141123);
        areaCode.put("\u4e34\u3000\u53bf", 141124);
        areaCode.put("\u67f3\u6797\u53bf", 141125);
        areaCode.put("\u77f3\u697c\u53bf", 141126);
        areaCode.put("\u5c9a\u3000\u53bf", 141127);
        areaCode.put("\u65b9\u5c71\u53bf", 141128);
        areaCode.put("\u4e2d\u9633\u53bf", 141129);
        areaCode.put("\u4ea4\u53e3\u53bf", 141130);
        areaCode.put("\u5b5d\u4e49\u5e02", 141181);
        areaCode.put("\u6c7e\u9633\u5e02", 141182);
        areaCode.put("\u5185\u8499\u53e4\u81ea\u6cbb\u533a", 150000);
        areaCode.put("\u547c\u548c\u6d69\u7279\u5e02", 150100);
        areaCode.put("\u5e02\u8f96\u533a", 150101);
        areaCode.put("\u65b0\u57ce\u533a", 150102);
        areaCode.put("\u56de\u6c11\u533a", 150103);
        areaCode.put("\u7389\u6cc9\u533a", 150104);
        areaCode.put("\u8d5b\u7f55\u533a", 150105);
        areaCode.put("\u571f\u9ed8\u7279\u5de6\u65d7", 150121);
        areaCode.put("\u6258\u514b\u6258\u53bf", 150122);
        areaCode.put("\u548c\u6797\u683c\u5c14\u53bf", 150123);
        areaCode.put("\u6e05\u6c34\u6cb3\u53bf", 150124);
        areaCode.put("\u6b66\u5ddd\u53bf", 150125);
        areaCode.put("\u5305\u5934\u5e02", 150200);
        areaCode.put("\u5e02\u8f96\u533a", 150201);
        areaCode.put("\u4e1c\u6cb3\u533a", 150202);
        areaCode.put("\u6606\u90fd\u4ed1\u533a", 150203);
        areaCode.put("\u9752\u5c71\u533a", 150204);
        areaCode.put("\u77f3\u62d0\u533a", 150205);
        areaCode.put("\u767d\u4e91\u9102\u535a\u77ff\u533a", 150206);
        areaCode.put("\u4e5d\u539f\u533a", 150207);
        areaCode.put("\u571f\u9ed8\u7279\u53f3\u65d7", 150221);
        areaCode.put("\u56fa\u9633\u53bf", 150222);
        areaCode.put("\u8fbe\u5c14\u7f55\u8302\u660e\u5b89\u8054\u5408\u65d7", 150223);
        areaCode.put("\u4e4c\u6d77\u5e02", 150300);
        areaCode.put("\u5e02\u8f96\u533a", 150301);
        areaCode.put("\u6d77\u52c3\u6e7e\u533a", 150302);
        areaCode.put("\u6d77\u5357\u533a", 150303);
        areaCode.put("\u4e4c\u8fbe\u533a", 150304);
        areaCode.put("\u8d64\u5cf0\u5e02", 150400);
        areaCode.put("\u5e02\u8f96\u533a", 150401);
        areaCode.put("\u7ea2\u5c71\u533a", 150402);
        areaCode.put("\u5143\u5b9d\u5c71\u533a", 150403);
        areaCode.put("\u677e\u5c71\u533a", 150404);
        areaCode.put("\u963f\u9c81\u79d1\u5c14\u6c81\u65d7", 150421);
        areaCode.put("\u5df4\u6797\u5de6\u65d7", 150422);
        areaCode.put("\u5df4\u6797\u53f3\u65d7", 150423);
        areaCode.put("\u6797\u897f\u53bf", 150424);
        areaCode.put("\u514b\u4ec0\u514b\u817e\u65d7", 150425);
        areaCode.put("\u7fc1\u725b\u7279\u65d7", 150426);
        areaCode.put("\u5580\u5587\u6c81\u65d7", 150428);
        areaCode.put("\u5b81\u57ce\u53bf", 150429);
        areaCode.put("\u6556\u6c49\u65d7", 150430);
        areaCode.put("\u901a\u8fbd\u5e02", 150500);
        areaCode.put("\u5e02\u8f96\u533a", 150501);
        areaCode.put("\u79d1\u5c14\u6c81\u533a", 150502);
        areaCode.put("\u79d1\u5c14\u6c81\u5de6\u7ffc\u4e2d\u65d7", 150521);
        areaCode.put("\u79d1\u5c14\u6c81\u5de6\u7ffc\u540e\u65d7", 150522);
        areaCode.put("\u5f00\u9c81\u53bf", 150523);
        areaCode.put("\u5e93\u4f26\u65d7", 150524);
        areaCode.put("\u5948\u66fc\u65d7", 150525);
        areaCode.put("\u624e\u9c81\u7279\u65d7", 150526);
        areaCode.put("\u970d\u6797\u90ed\u52d2\u5e02", 150581);
        areaCode.put("\u9102\u5c14\u591a\u65af\u5e02", 150600);
        areaCode.put("\u5e02\u8f96\u533a", 150601);
        areaCode.put("  \u4e1c\u80dc\u533a", 150602);
        areaCode.put("\u8fbe\u62c9\u7279\u65d7", 150621);
        areaCode.put("\u51c6\u683c\u5c14\u65d7", 150622);
        areaCode.put("\u9102\u6258\u514b\u524d\u65d7", 150623);
        areaCode.put("\u9102\u6258\u514b\u65d7", 150624);
        areaCode.put("\u676d\u9526\u65d7", 150625);
        areaCode.put("\u4e4c\u5ba1\u65d7", 150626);
        areaCode.put("\u4f0a\u91d1\u970d\u6d1b\u65d7", 150627);
        areaCode.put("\u547c\u4f26\u8d1d\u5c14\u5e02", 150700);
        areaCode.put("\u5e02\u8f96\u533a", 150701);
        areaCode.put("\u6d77\u62c9\u5c14\u533a", 150702);
        areaCode.put("\u963f\u8363\u65d7", 150721);
        areaCode.put("\u83ab\u529b\u8fbe\u74e6\u8fbe\u65a1\u5c14\u65cf\u81ea\u6cbb\u65d7", 150722);
        areaCode.put("\u9102\u4f26\u6625\u81ea\u6cbb\u65d7", 150723);
        areaCode.put("\u9102\u6e29\u514b\u65cf\u81ea\u6cbb\u65d7", 150724);
        areaCode.put("\u9648\u5df4\u5c14\u864e\u65d7", 150725);
        areaCode.put("\u65b0\u5df4\u5c14\u864e\u5de6\u65d7", 150726);
        areaCode.put("\u65b0\u5df4\u5c14\u864e\u53f3\u65d7", 150727);
        areaCode.put("\u6ee1\u6d32\u91cc\u5e02", 150781);
        areaCode.put("\u7259\u514b\u77f3\u5e02", 150782);
        areaCode.put("\u624e\u5170\u5c6f\u5e02", 150783);
        areaCode.put("\u989d\u5c14\u53e4\u7eb3\u5e02", 150784);
        areaCode.put("\u6839\u6cb3\u5e02", 150785);
        areaCode.put("\u5df4\u5f66\u6dd6\u5c14\u5e02", 150800);
        areaCode.put("\u5e02\u8f96\u533a", 150801);
        areaCode.put("\u4e34\u6cb3\u533a", 150802);
        areaCode.put("\u4e94\u539f\u53bf", 150821);
        areaCode.put("\u78f4\u53e3\u53bf", 150822);
        areaCode.put("\u4e4c\u62c9\u7279\u524d\u65d7", 150823);
        areaCode.put("\u4e4c\u62c9\u7279\u4e2d\u65d7", 150824);
        areaCode.put("\u4e4c\u62c9\u7279\u540e\u65d7", 150825);
        areaCode.put("\u676d\u9526\u540e\u65d7", 150826);
        areaCode.put("\u4e4c\u5170\u5bdf\u5e03\u5e02", 150900);
        areaCode.put("\u5e02\u8f96\u533a", 150901);
        areaCode.put("\u96c6\u5b81\u533a", 150902);
        areaCode.put("\u5353\u8d44\u53bf", 150921);
        areaCode.put("\u5316\u5fb7\u53bf", 150922);
        areaCode.put("\u5546\u90fd\u53bf", 150923);
        areaCode.put("\u5174\u548c\u53bf", 150924);
        areaCode.put("\u51c9\u57ce\u53bf", 150925);
        areaCode.put("\u5bdf\u54c8\u5c14\u53f3\u7ffc\u524d\u65d7", 150926);
        areaCode.put("\u5bdf\u54c8\u5c14\u53f3\u7ffc\u4e2d\u65d7", 150927);
        areaCode.put("\u5bdf\u54c8\u5c14\u53f3\u7ffc\u540e\u65d7", 150928);
        areaCode.put("\u56db\u5b50\u738b\u65d7", 150929);
        areaCode.put("\u4e30\u9547\u5e02", 150981);
        areaCode.put("\u5174\u5b89\u76df", 152200);
        areaCode.put("\u4e4c\u5170\u6d69\u7279\u5e02", 152201);
        areaCode.put("\u963f\u5c14\u5c71\u5e02", 152202);
        areaCode.put("\u79d1\u5c14\u6c81\u53f3\u7ffc\u524d\u65d7", 152221);
        areaCode.put("\u79d1\u5c14\u6c81\u53f3\u7ffc\u4e2d\u65d7", 152222);
        areaCode.put("\u624e\u8d49\u7279\u65d7", 152223);
        areaCode.put("\u7a81\u6cc9\u53bf", 152224);
        areaCode.put("\u9521\u6797\u90ed\u52d2\u76df", 152500);
        areaCode.put("\u4e8c\u8fde\u6d69\u7279\u5e02", 152501);
        areaCode.put("\u9521\u6797\u6d69\u7279\u5e02", 152502);
        areaCode.put("\u963f\u5df4\u560e\u65d7", 152522);
        areaCode.put("\u82cf\u5c3c\u7279\u5de6\u65d7", 152523);
        areaCode.put("\u82cf\u5c3c\u7279\u53f3\u65d7", 152524);
        areaCode.put("\u4e1c\u4e4c\u73e0\u7a46\u6c81\u65d7", 152525);
        areaCode.put("\u897f\u4e4c\u73e0\u7a46\u6c81\u65d7", 152526);
        areaCode.put("\u592a\u4ec6\u5bfa\u65d7", 152527);
        areaCode.put("\u9576\u9ec4\u65d7", 152528);
        areaCode.put("\u6b63\u9576\u767d\u65d7", 152529);
        areaCode.put("\u6b63\u84dd\u65d7", 152530);
        areaCode.put("\u591a\u4f26\u53bf", 152531);
        areaCode.put("\u963f\u62c9\u5584\u76df", 152900);
        areaCode.put("\u963f\u62c9\u5584\u5de6\u65d7", 152921);
        areaCode.put("\u963f\u62c9\u5584\u53f3\u65d7", 152922);
        areaCode.put("\u989d\u6d4e\u7eb3\u65d7", 152923);
        areaCode.put("\u8fbd\u5b81\u7701", 210000);
        areaCode.put("\u6c88\u9633\u5e02", 210100);
        areaCode.put("\u5e02\u8f96\u533a", 210101);
        areaCode.put("\u548c\u5e73\u533a", 210102);
        areaCode.put("\u6c88\u6cb3\u533a", 210103);
        areaCode.put("\u5927\u4e1c\u533a", 210104);
        areaCode.put("\u7687\u59d1\u533a", 210105);
        areaCode.put("\u94c1\u897f\u533a", 210106);
        areaCode.put("\u82cf\u5bb6\u5c6f\u533a", 210111);
        areaCode.put("\u4e1c\u9675\u533a", 210112);
        areaCode.put("\u6c88\u5317\u65b0\u533a", 210113);
        areaCode.put("\u4e8e\u6d2a\u533a", 210114);
        areaCode.put("\u8fbd\u4e2d\u53bf", 210122);
        areaCode.put("\u5eb7\u5e73\u53bf", 210123);
        areaCode.put("\u6cd5\u5e93\u53bf", 210124);
        areaCode.put("\u65b0\u6c11\u5e02", 210181);
        areaCode.put("\u5927\u8fde\u5e02", 210200);
        areaCode.put("\u5e02\u8f96\u533a", 210201);
        areaCode.put("\u4e2d\u5c71\u533a", 210202);
        areaCode.put("\u897f\u5c97\u533a", 210203);
        areaCode.put("\u6c99\u6cb3\u53e3\u533a", 210204);
        areaCode.put("\u7518\u4e95\u5b50\u533a", 210211);
        areaCode.put("\u65c5\u987a\u53e3\u533a", 210212);
        areaCode.put("\u91d1\u5dde\u533a", 210213);
        areaCode.put("\u957f\u6d77\u53bf", 210224);
        areaCode.put("\u74e6\u623f\u5e97\u5e02", 210281);
        areaCode.put("\u666e\u5170\u5e97\u5e02", 210282);
        areaCode.put("\u5e84\u6cb3\u5e02", 210283);
        areaCode.put("\u978d\u5c71\u5e02", 210300);
        areaCode.put("\u5e02\u8f96\u533a", 210301);
        areaCode.put("\u94c1\u4e1c\u533a", 210302);
        areaCode.put("\u94c1\u897f\u533a", 210303);
        areaCode.put("\u7acb\u5c71\u533a", 210304);
        areaCode.put("\u5343\u5c71\u533a", 210311);
        areaCode.put("\u53f0\u5b89\u53bf", 210321);
        areaCode.put("\u5cab\u5ca9\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210323);
        areaCode.put("\u6d77\u57ce\u5e02", 210381);
        areaCode.put("\u629a\u987a\u5e02", 210400);
        areaCode.put("\u5e02\u8f96\u533a", 210401);
        areaCode.put("\u65b0\u629a\u533a", 210402);
        areaCode.put("\u4e1c\u6d32\u533a", 210403);
        areaCode.put("\u671b\u82b1\u533a", 210404);
        areaCode.put("\u987a\u57ce\u533a", 210411);
        areaCode.put("\u629a\u987a\u53bf", 210421);
        areaCode.put("\u65b0\u5bbe\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210422);
        areaCode.put("\u6e05\u539f\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210423);
        areaCode.put("\u672c\u6eaa\u5e02", 210500);
        areaCode.put("\u5e02\u8f96\u533a", 210501);
        areaCode.put("\u5e73\u5c71\u533a", 210502);
        areaCode.put("\u6eaa\u6e56\u533a", 210503);
        areaCode.put("\u660e\u5c71\u533a", 210504);
        areaCode.put("\u5357\u82ac\u533a", 210505);
        areaCode.put("\u672c\u6eaa\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210521);
        areaCode.put("\u6853\u4ec1\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210522);
        areaCode.put("\u4e39\u4e1c\u5e02", 210600);
        areaCode.put("\u5e02\u8f96\u533a", 210601);
        areaCode.put("\u5143\u5b9d\u533a", 210602);
        areaCode.put("\u632f\u5174\u533a", 210603);
        areaCode.put("\u632f\u5b89\u533a", 210604);
        areaCode.put("\u5bbd\u7538\u6ee1\u65cf\u81ea\u6cbb\u53bf", 210624);
        areaCode.put("\u4e1c\u6e2f\u5e02", 210681);
        areaCode.put("\u51e4\u57ce\u5e02", 210682);
        areaCode.put("\u9526\u5dde\u5e02", 210700);
        areaCode.put("\u5e02\u8f96\u533a", 210701);
        areaCode.put("\u53e4\u5854\u533a", 210702);
        areaCode.put("\u51cc\u6cb3\u533a", 210703);
        areaCode.put("\u592a\u548c\u533a", 210711);
        areaCode.put("\u9ed1\u5c71\u53bf", 210726);
        areaCode.put("\u4e49\u3000\u53bf", 210727);
        areaCode.put("\u51cc\u6d77\u5e02", 210781);
        areaCode.put("\u5317\u9547\u5e02", 210782);
        areaCode.put("\u8425\u53e3\u5e02", 210800);
        areaCode.put("\u5e02\u8f96\u533a", 210801);
        areaCode.put("\u7ad9\u524d\u533a", 210802);
        areaCode.put("\u897f\u5e02\u533a", 210803);
        areaCode.put("\u9c85\u9c7c\u5708\u533a", 210804);
        areaCode.put("\u8001\u8fb9\u533a", 210811);
        areaCode.put("\u76d6\u5dde\u5e02", 210881);
        areaCode.put("\u5927\u77f3\u6865\u5e02", 210882);
        areaCode.put("\u961c\u65b0\u5e02", 210900);
        areaCode.put("\u5e02\u8f96\u533a", 210901);
        areaCode.put("\u6d77\u5dde\u533a", 210902);
        areaCode.put("\u65b0\u90b1\u533a", 210903);
        areaCode.put("\u592a\u5e73\u533a", 210904);
        areaCode.put("\u6e05\u6cb3\u95e8\u533a", 210905);
        areaCode.put("\u7ec6\u6cb3\u533a", 210911);
        areaCode.put("\u961c\u65b0\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 210921);
        areaCode.put("\u5f70\u6b66\u53bf", 210922);
        areaCode.put("\u8fbd\u9633\u5e02", 211000);
        areaCode.put("\u5e02\u8f96\u533a", 211001);
        areaCode.put("\u767d\u5854\u533a", 211002);
        areaCode.put("\u6587\u5723\u533a", 211003);
        areaCode.put("\u5b8f\u4f1f\u533a", 211004);
        areaCode.put("\u5f13\u957f\u5cad\u533a", 211005);
        areaCode.put("\u592a\u5b50\u6cb3\u533a", 211011);
        areaCode.put("\u8fbd\u9633\u53bf", 211021);
        areaCode.put("\u706f\u5854\u5e02", 211081);
        areaCode.put("\u76d8\u9526\u5e02", 211100);
        areaCode.put("\u5e02\u8f96\u533a", 211101);
        areaCode.put("\u53cc\u53f0\u5b50\u533a", 211102);
        areaCode.put("\u5174\u9686\u53f0\u533a", 211103);
        areaCode.put("\u5927\u6d3c\u53bf", 211121);
        areaCode.put("\u76d8\u5c71\u53bf", 211122);
        areaCode.put("\u94c1\u5cad\u5e02", 211200);
        areaCode.put("\u5e02\u8f96\u533a", 211201);
        areaCode.put("\u94f6\u5dde\u533a", 211202);
        areaCode.put("\u6e05\u6cb3\u533a", 211204);
        areaCode.put("\u94c1\u5cad\u53bf", 211221);
        areaCode.put("\u897f\u4e30\u53bf", 211223);
        areaCode.put("\u660c\u56fe\u53bf", 211224);
        areaCode.put("\u8c03\u5175\u5c71\u5e02", 211281);
        areaCode.put("\u5f00\u539f\u5e02", 211282);
        areaCode.put("\u671d\u9633\u5e02", 211300);
        areaCode.put("\u5e02\u8f96\u533a", 211301);
        areaCode.put("\u53cc\u5854\u533a", 211302);
        areaCode.put("\u9f99\u57ce\u533a", 211303);
        areaCode.put("\u671d\u9633\u53bf", 211321);
        areaCode.put("\u5efa\u5e73\u53bf", 211322);
        areaCode.put("\u5580\u5587\u6c81\u5de6\u7ffc\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 211324);
        areaCode.put("\u5317\u7968\u5e02", 211381);
        areaCode.put("\u51cc\u6e90\u5e02", 211382);
        areaCode.put("\u846b\u82a6\u5c9b\u5e02", 211400);
        areaCode.put("\u5e02\u8f96\u533a", 211401);
        areaCode.put("\u8fde\u5c71\u533a", 211402);
        areaCode.put("\u9f99\u6e2f\u533a", 211403);
        areaCode.put("\u5357\u7968\u533a", 211404);
        areaCode.put("\u7ee5\u4e2d\u53bf", 211421);
        areaCode.put("\u5efa\u660c\u53bf", 211422);
        areaCode.put("\u5174\u57ce\u5e02", 211481);
        areaCode.put("\u5409\u6797\u7701", 220000);
        areaCode.put("\u957f\u6625\u5e02", 220100);
        areaCode.put("\u5e02\u8f96\u533a", 220101);
        areaCode.put("\u5357\u5173\u533a", 220102);
        areaCode.put("\u5bbd\u57ce\u533a", 220103);
        areaCode.put("\u671d\u9633\u533a", 220104);
        areaCode.put("\u4e8c\u9053\u533a", 220105);
        areaCode.put("\u7eff\u56ed\u533a", 220106);
        areaCode.put("\u53cc\u9633\u533a", 220112);
        areaCode.put("\u519c\u5b89\u53bf", 220122);
        areaCode.put("\u4e5d\u53f0\u5e02", 220181);
        areaCode.put("\u6986\u6811\u5e02", 220182);
        areaCode.put("\u5fb7\u60e0\u5e02", 220183);
        areaCode.put("\u5409\u6797\u5e02", 220200);
        areaCode.put("\u5e02\u8f96\u533a", 220201);
        areaCode.put("\u660c\u9091\u533a", 220202);
        areaCode.put("\u9f99\u6f6d\u533a", 220203);
        areaCode.put("\u8239\u8425\u533a", 220204);
        areaCode.put("\u4e30\u6ee1\u533a", 220211);
        areaCode.put("\u6c38\u5409\u53bf", 220221);
        areaCode.put("\u86df\u6cb3\u5e02", 220281);
        areaCode.put("\u6866\u7538\u5e02", 220282);
        areaCode.put("\u8212\u5170\u5e02", 220283);
        areaCode.put("\u78d0\u77f3\u5e02", 220284);
        areaCode.put("\u56db\u5e73\u5e02", 220300);
        areaCode.put("\u5e02\u8f96\u533a", 220301);
        areaCode.put("\u94c1\u897f\u533a", 220302);
        areaCode.put("\u94c1\u4e1c\u533a", 220303);
        areaCode.put("\u68a8\u6811\u53bf", 220322);
        areaCode.put("\u4f0a\u901a\u6ee1\u65cf\u81ea\u6cbb\u53bf", 220323);
        areaCode.put("\u516c\u4e3b\u5cad\u5e02", 220381);
        areaCode.put("\u53cc\u8fbd\u5e02", 220382);
        areaCode.put("\u8fbd\u6e90\u5e02", 220400);
        areaCode.put("\u5e02\u8f96\u533a", 220401);
        areaCode.put("\u9f99\u5c71\u533a", 220402);
        areaCode.put("\u897f\u5b89\u533a", 220403);
        areaCode.put("\u4e1c\u4e30\u53bf", 220421);
        areaCode.put("\u4e1c\u8fbd\u53bf", 220422);
        areaCode.put("\u901a\u5316\u5e02", 220500);
        areaCode.put("\u5e02\u8f96\u533a", 220501);
        areaCode.put("\u4e1c\u660c\u533a", 220502);
        areaCode.put("\u4e8c\u9053\u6c5f\u533a", 220503);
        areaCode.put("\u901a\u5316\u53bf", 220521);
        areaCode.put("\u8f89\u5357\u53bf", 220523);
        areaCode.put("\u67f3\u6cb3\u53bf", 220524);
        areaCode.put("\u6885\u6cb3\u53e3\u5e02", 220581);
        areaCode.put("\u96c6\u5b89\u5e02", 220582);
        areaCode.put("\u767d\u5c71\u5e02", 220600);
        areaCode.put("\u5e02\u8f96\u533a", 220601);
        areaCode.put("\u516b\u9053\u6c5f\u533a", 220602);
        areaCode.put("  \u6c5f\u6e90\u533a", 220605);
        areaCode.put("\u629a\u677e\u53bf", 220621);
        areaCode.put("\u9756\u5b87\u53bf", 220622);
        areaCode.put("\u957f\u767d\u671d\u9c9c\u65cf\u81ea\u6cbb\u53bf", 220623);
        areaCode.put("\u4e34\u6c5f\u5e02", 220681);
        areaCode.put("\u677e\u539f\u5e02", 220700);
        areaCode.put("\u5e02\u8f96\u533a", 220701);
        areaCode.put("\u5b81\u6c5f\u533a", 220702);
        areaCode.put("\u524d\u90ed\u5c14\u7f57\u65af\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 220721);
        areaCode.put("\u957f\u5cad\u53bf", 220722);
        areaCode.put("\u4e7e\u5b89\u53bf", 220723);
        areaCode.put("\u6276\u4f59\u53bf", 220724);
        areaCode.put("\u767d\u57ce\u5e02", 220800);
        areaCode.put("\u5e02\u8f96\u533a", 220801);
        areaCode.put("\u6d2e\u5317\u533a", 220802);
        areaCode.put("\u9547\u8d49\u53bf", 220821);
        areaCode.put("\u901a\u6986\u53bf", 220822);
        areaCode.put("\u6d2e\u5357\u5e02", 220881);
        areaCode.put("\u5927\u5b89\u5e02", 220882);
        areaCode.put("\u5ef6\u8fb9\u671d\u9c9c\u65cf\u81ea\u6cbb\u5dde", 222400);
        areaCode.put("\u5ef6\u5409\u5e02", 222401);
        areaCode.put("\u56fe\u4eec\u5e02", 222402);
        areaCode.put("\u6566\u5316\u5e02", 222403);
        areaCode.put("\u73f2\u6625\u5e02", 222404);
        areaCode.put("\u9f99\u4e95\u5e02", 222405);
        areaCode.put("\u548c\u9f99\u5e02", 222406);
        areaCode.put("\u6c6a\u6e05\u53bf", 222424);
        areaCode.put("\u5b89\u56fe\u53bf", 222426);
        areaCode.put("\u9ed1\u9f99\u6c5f\u7701", 230000);
        areaCode.put("\u54c8\u5c14\u6ee8\u5e02", 230100);
        areaCode.put("\u5e02\u8f96\u533a", 230101);
        areaCode.put("\u9053\u91cc\u533a", 230102);
        areaCode.put("\u5357\u5c97\u533a", 230103);
        areaCode.put("\u9053\u5916\u533a", 230104);
        areaCode.put("\u5e73\u623f\u533a", 230108);
        areaCode.put("\u677e\u5317\u533a", 230109);
        areaCode.put("\u9999\u574a\u533a", 230110);
        areaCode.put("\u547c\u5170\u533a", 230111);
        areaCode.put("\u4f9d\u5170\u53bf", 230123);
        areaCode.put("\u65b9\u6b63\u53bf", 230124);
        areaCode.put("\u5bbe\u3000\u53bf", 230125);
        areaCode.put("\u5df4\u5f66\u53bf", 230126);
        areaCode.put("\u6728\u5170\u53bf", 230127);
        areaCode.put("\u901a\u6cb3\u53bf", 230128);
        areaCode.put("\u5ef6\u5bff\u53bf", 230129);
        areaCode.put("\u53cc\u57ce\u5e02", 230182);
        areaCode.put("\u5c1a\u5fd7\u5e02", 230183);
        areaCode.put("\u4e94\u5e38\u5e02", 230184);
        areaCode.put("\u9f50\u9f50\u54c8\u5c14\u5e02", 230200);
        areaCode.put("\u5e02\u8f96\u533a", 230201);
        areaCode.put("\u9f99\u6c99\u533a", 230202);
        areaCode.put("\u5efa\u534e\u533a", 230203);
        areaCode.put("\u94c1\u950b\u533a", 230204);
        areaCode.put("\u6602\u6602\u6eaa\u533a", 230205);
        areaCode.put("\u5bcc\u62c9\u5c14\u57fa\u533a", 230206);
        areaCode.put("\u78be\u5b50\u5c71\u533a", 230207);
        areaCode.put("\u6885\u91cc\u65af\u8fbe\u65a1\u5c14\u65cf\u533a", 230208);
        areaCode.put("\u9f99\u6c5f\u53bf", 230221);
        areaCode.put("\u4f9d\u5b89\u53bf", 230223);
        areaCode.put("\u6cf0\u6765\u53bf", 230224);
        areaCode.put("\u7518\u5357\u53bf", 230225);
        areaCode.put("\u5bcc\u88d5\u53bf", 230227);
        areaCode.put("\u514b\u5c71\u53bf", 230229);
        areaCode.put("\u514b\u4e1c\u53bf", 230230);
        areaCode.put("\u62dc\u6cc9\u53bf", 230231);
        areaCode.put("\u8bb7\u6cb3\u5e02", 230281);
        areaCode.put("\u9e21\u897f\u5e02", 230300);
        areaCode.put("\u5e02\u8f96\u533a", 230301);
        areaCode.put("\u9e21\u51a0\u533a", 230302);
        areaCode.put("\u6052\u5c71\u533a", 230303);
        areaCode.put("\u6ef4\u9053\u533a", 230304);
        areaCode.put("\u68a8\u6811\u533a", 230305);
        areaCode.put("\u57ce\u5b50\u6cb3\u533a", 230306);
        areaCode.put("\u9ebb\u5c71\u533a", 230307);
        areaCode.put("\u9e21\u4e1c\u53bf", 230321);
        areaCode.put("\u864e\u6797\u5e02", 230381);
        areaCode.put("\u5bc6\u5c71\u5e02", 230382);
        areaCode.put("\u9e64\u5c97\u5e02", 230400);
        areaCode.put("\u5e02\u8f96\u533a", 230401);
        areaCode.put("\u5411\u9633\u533a", 230402);
        areaCode.put("\u5de5\u519c\u533a", 230403);
        areaCode.put("\u5357\u5c71\u533a", 230404);
        areaCode.put("\u5174\u5b89\u533a", 230405);
        areaCode.put("\u4e1c\u5c71\u533a", 230406);
        areaCode.put("\u5174\u5c71\u533a", 230407);
        areaCode.put("\u841d\u5317\u53bf", 230421);
        areaCode.put("\u7ee5\u6ee8\u53bf", 230422);
        areaCode.put("\u53cc\u9e2d\u5c71\u5e02", 230500);
        areaCode.put("\u5e02\u8f96\u533a", 230501);
        areaCode.put("\u5c16\u5c71\u533a", 230502);
        areaCode.put("\u5cad\u4e1c\u533a", 230503);
        areaCode.put("\u56db\u65b9\u53f0\u533a", 230505);
        areaCode.put("\u5b9d\u5c71\u533a", 230506);
        areaCode.put("\u96c6\u8d24\u53bf", 230521);
        areaCode.put("\u53cb\u8c0a\u53bf", 230522);
        areaCode.put("\u5b9d\u6e05\u53bf", 230523);
        areaCode.put("\u9976\u6cb3\u53bf", 230524);
        areaCode.put("\u5927\u5e86\u5e02", 230600);
        areaCode.put("\u5e02\u8f96\u533a", 230601);
        areaCode.put("\u8428\u5c14\u56fe\u533a", 230602);
        areaCode.put("\u9f99\u51e4\u533a", 230603);
        areaCode.put("\u8ba9\u80e1\u8def\u533a", 230604);
        areaCode.put("\u7ea2\u5c97\u533a", 230605);
        areaCode.put("\u5927\u540c\u533a", 230606);
        areaCode.put("\u8087\u5dde\u53bf", 230621);
        areaCode.put("\u8087\u6e90\u53bf", 230622);
        areaCode.put("\u6797\u7538\u53bf", 230623);
        areaCode.put("\u675c\u5c14\u4f2f\u7279\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 230624);
        areaCode.put("\u4f0a\u6625\u5e02", 230700);
        areaCode.put("\u5e02\u8f96\u533a", 230701);
        areaCode.put("\u4f0a\u6625\u533a", 230702);
        areaCode.put("\u5357\u5c94\u533a", 230703);
        areaCode.put("\u53cb\u597d\u533a", 230704);
        areaCode.put("\u897f\u6797\u533a", 230705);
        areaCode.put("\u7fe0\u5ce6\u533a", 230706);
        areaCode.put("\u65b0\u9752\u533a", 230707);
        areaCode.put("\u7f8e\u6eaa\u533a", 230708);
        areaCode.put("\u91d1\u5c71\u5c6f\u533a", 230709);
        areaCode.put("\u4e94\u8425\u533a", 230710);
        areaCode.put("\u4e4c\u9a6c\u6cb3\u533a", 230711);
        areaCode.put("\u6c64\u65fa\u6cb3\u533a", 230712);
        areaCode.put("\u5e26\u5cad\u533a", 230713);
        areaCode.put("\u4e4c\u4f0a\u5cad\u533a", 230714);
        areaCode.put("\u7ea2\u661f\u533a", 230715);
        areaCode.put("\u4e0a\u7518\u5cad\u533a", 230716);
        areaCode.put("\u5609\u836b\u53bf", 230722);
        areaCode.put("\u94c1\u529b\u5e02", 230781);
        areaCode.put("\u4f73\u6728\u65af\u5e02", 230800);
        areaCode.put("\u5e02\u8f96\u533a", 230801);
        areaCode.put("\u5411\u9633\u533a", 230803);
        areaCode.put("\u524d\u8fdb\u533a", 230804);
        areaCode.put("\u4e1c\u98ce\u533a", 230805);
        areaCode.put("\u90ca\u3000\u533a", 230811);
        areaCode.put("\u6866\u5357\u53bf", 230822);
        areaCode.put("\u6866\u5ddd\u53bf", 230826);
        areaCode.put("\u6c64\u539f\u53bf", 230828);
        areaCode.put("\u629a\u8fdc\u53bf", 230833);
        areaCode.put("\u540c\u6c5f\u5e02", 230881);
        areaCode.put("\u5bcc\u9526\u5e02", 230882);
        areaCode.put("\u4e03\u53f0\u6cb3\u5e02", 230900);
        areaCode.put("\u5e02\u8f96\u533a", 230901);
        areaCode.put("\u65b0\u5174\u533a", 230902);
        areaCode.put("\u6843\u5c71\u533a", 230903);
        areaCode.put("\u8304\u5b50\u6cb3\u533a", 230904);
        areaCode.put("\u52c3\u5229\u53bf", 230921);
        areaCode.put("\u7261\u4e39\u6c5f\u5e02", 231000);
        areaCode.put("\u5e02\u8f96\u533a", 231001);
        areaCode.put("\u4e1c\u5b89\u533a", 231002);
        areaCode.put("\u9633\u660e\u533a", 231003);
        areaCode.put("\u7231\u6c11\u533a", 231004);
        areaCode.put("\u897f\u5b89\u533a", 231005);
        areaCode.put("\u4e1c\u5b81\u53bf", 231024);
        areaCode.put("\u6797\u53e3\u53bf", 231025);
        areaCode.put("\u7ee5\u82ac\u6cb3\u5e02", 231081);
        areaCode.put("\u6d77\u6797\u5e02", 231083);
        areaCode.put("\u5b81\u5b89\u5e02", 231084);
        areaCode.put("\u7a46\u68f1\u5e02", 231085);
        areaCode.put("\u9ed1\u6cb3\u5e02", 231100);
        areaCode.put("\u5e02\u8f96\u533a", 231101);
        areaCode.put("\u7231\u8f89\u533a", 231102);
        areaCode.put("\u5ae9\u6c5f\u53bf", 231121);
        areaCode.put("\u900a\u514b\u53bf", 231123);
        areaCode.put("\u5b59\u5434\u53bf", 231124);
        areaCode.put("\u5317\u5b89\u5e02", 231181);
        areaCode.put("\u4e94\u5927\u8fde\u6c60\u5e02", 231182);
        areaCode.put("\u7ee5\u5316\u5e02", 231200);
        areaCode.put("\u5e02\u8f96\u533a", 231201);
        areaCode.put("\u5317\u6797\u533a", 231202);
        areaCode.put("\u671b\u594e\u53bf", 231221);
        areaCode.put("\u5170\u897f\u53bf", 231222);
        areaCode.put("\u9752\u5188\u53bf", 231223);
        areaCode.put("\u5e86\u5b89\u53bf", 231224);
        areaCode.put("\u660e\u6c34\u53bf", 231225);
        areaCode.put("\u7ee5\u68f1\u53bf", 231226);
        areaCode.put("\u5b89\u8fbe\u5e02", 231281);
        areaCode.put("\u8087\u4e1c\u5e02", 231282);
        areaCode.put("\u6d77\u4f26\u5e02", 231283);
        areaCode.put("\u5927\u5174\u5b89\u5cad\u5730\u533a", 232700);
        areaCode.put("\u547c\u739b\u53bf", 232721);
        areaCode.put("\u5854\u6cb3\u53bf", 232722);
        areaCode.put("\u6f20\u6cb3\u53bf", 232723);
        areaCode.put("\u4e0a\u6d77\u5e02", 310000);
        areaCode.put("\u5e02\u8f96\u533a", 310100);
        areaCode.put("\u9ec4\u6d66\u533a", 310101);
        areaCode.put("\u5362\u6e7e\u533a", 310103);
        areaCode.put("\u5f90\u6c47\u533a", 310104);
        areaCode.put("\u957f\u5b81\u533a", 310105);
        areaCode.put("\u9759\u5b89\u533a", 310106);
        areaCode.put("\u666e\u9640\u533a", 310107);
        areaCode.put("\u95f8\u5317\u533a", 310108);
        areaCode.put("\u8679\u53e3\u533a", 310109);
        areaCode.put("\u6768\u6d66\u533a", 310110);
        areaCode.put("\u95f5\u884c\u533a", 310112);
        areaCode.put("\u5b9d\u5c71\u533a", 310113);
        areaCode.put("\u5609\u5b9a\u533a", 310114);
        areaCode.put("\u6d66\u4e1c\u65b0\u533a (*)", 310115);
        areaCode.put("\u91d1\u5c71\u533a", 310116);
        areaCode.put("\u677e\u6c5f\u533a", 310117);
        areaCode.put("\u9752\u6d66\u533a", 310118);
        areaCode.put("\u5949\u8d24\u533a", 310120);
        areaCode.put("\u53bf", 310200);
        areaCode.put("\u5d07\u660e\u53bf", 310230);
        areaCode.put("\u6c5f\u82cf\u7701", 320000);
        areaCode.put("\u5357\u4eac\u5e02", 320100);
        areaCode.put("\u5e02\u8f96\u533a", 320101);
        areaCode.put("\u7384\u6b66\u533a", 320102);
        areaCode.put("\u767d\u4e0b\u533a", 320103);
        areaCode.put("\u79e6\u6dee\u533a", 320104);
        areaCode.put("\u5efa\u90ba\u533a", 320105);
        areaCode.put("\u9f13\u697c\u533a", 320106);
        areaCode.put("\u4e0b\u5173\u533a", 320107);
        areaCode.put("\u6d66\u53e3\u533a", 320111);
        areaCode.put("\u6816\u971e\u533a", 320113);
        areaCode.put("\u96e8\u82b1\u53f0\u533a", 320114);
        areaCode.put("\u6c5f\u5b81\u533a", 320115);
        areaCode.put("\u516d\u5408\u533a", 320116);
        areaCode.put("\u6ea7\u6c34\u53bf", 320124);
        areaCode.put("\u9ad8\u6df3\u53bf", 320125);
        areaCode.put("\u65e0\u9521\u5e02", 320200);
        areaCode.put("\u5e02\u8f96\u533a", 320201);
        areaCode.put("\u5d07\u5b89\u533a", 320202);
        areaCode.put("\u5357\u957f\u533a", 320203);
        areaCode.put("\u5317\u5858\u533a", 320204);
        areaCode.put("\u9521\u5c71\u533a", 320205);
        areaCode.put("\u60e0\u5c71\u533a", 320206);
        areaCode.put("\u6ee8\u6e56\u533a", 320211);
        areaCode.put("\u6c5f\u9634\u5e02", 320281);
        areaCode.put("\u5b9c\u5174\u5e02", 320282);
        areaCode.put("\u5f90\u5dde\u5e02", 320300);
        areaCode.put("\u5e02\u8f96\u533a", 320301);
        areaCode.put("\u9f13\u697c\u533a", 320302);
        areaCode.put("\u4e91\u9f99\u533a", 320303);
        areaCode.put("\u4e5d\u91cc\u533a", 320304);
        areaCode.put("\u8d3e\u6c6a\u533a", 320305);
        areaCode.put("\u6cc9\u5c71\u533a", 320311);
        areaCode.put("\u4e30\u3000\u53bf", 320321);
        areaCode.put("\u6c9b\u3000\u53bf", 320322);
        areaCode.put("\u94dc\u5c71\u53bf", 320323);
        areaCode.put("\u7762\u5b81\u53bf", 320324);
        areaCode.put("\u65b0\u6c82\u5e02", 320381);
        areaCode.put("\u90b3\u5dde\u5e02", 320382);
        areaCode.put("\u5e38\u5dde\u5e02", 320400);
        areaCode.put("\u5e02\u8f96\u533a", 320401);
        areaCode.put("\u5929\u5b81\u533a", 320402);
        areaCode.put("\u949f\u697c\u533a", 320404);
        areaCode.put("\u621a\u5885\u5830\u533a", 320405);
        areaCode.put("\u65b0\u5317\u533a", 320411);
        areaCode.put("\u6b66\u8fdb\u533a", 320412);
        areaCode.put("\u6ea7\u9633\u5e02", 320481);
        areaCode.put("\u91d1\u575b\u5e02", 320482);
        areaCode.put("\u82cf\u5dde\u5e02", 320500);
        areaCode.put("\u5e02\u8f96\u533a", 320501);
        areaCode.put("\u6ca7\u6d6a\u533a", 320502);
        areaCode.put("\u5e73\u6c5f\u533a", 320503);
        areaCode.put("\u91d1\u960a\u533a", 320504);
        areaCode.put("\u864e\u4e18\u533a", 320505);
        areaCode.put("\u5434\u4e2d\u533a", 320506);
        areaCode.put("\u76f8\u57ce\u533a", 320507);
        areaCode.put("\u5e38\u719f\u5e02", 320581);
        areaCode.put("\u5f20\u5bb6\u6e2f\u5e02", 320582);
        areaCode.put("\u6606\u5c71\u5e02", 320583);
        areaCode.put("\u5434\u6c5f\u5e02", 320584);
        areaCode.put("\u592a\u4ed3\u5e02", 320585);
        areaCode.put("\u5357\u901a\u5e02", 320600);
        areaCode.put("\u5e02\u8f96\u533a", 320601);
        areaCode.put("\u5d07\u5ddd\u533a", 320602);
        areaCode.put("\u6e2f\u95f8\u533a", 320611);
        areaCode.put("\u6d77\u5b89\u53bf", 320621);
        areaCode.put("\u5982\u4e1c\u53bf", 320623);
        areaCode.put("\u542f\u4e1c\u5e02", 320681);
        areaCode.put("\u5982\u768b\u5e02", 320682);
        areaCode.put("\u6d77\u95e8\u5e02", 320684);
        areaCode.put("\u8fde\u4e91\u6e2f\u5e02", 320700);
        areaCode.put("\u5e02\u8f96\u533a", 320701);
        areaCode.put("\u8fde\u4e91\u533a", 320703);
        areaCode.put("\u65b0\u6d66\u533a", 320705);
        areaCode.put("\u6d77\u5dde\u533a", 320706);
        areaCode.put("\u8d63\u6986\u53bf", 320721);
        areaCode.put("\u4e1c\u6d77\u53bf", 320722);
        areaCode.put("\u704c\u4e91\u53bf", 320723);
        areaCode.put("\u704c\u5357\u53bf", 320724);
        areaCode.put("\u6dee\u5b89\u5e02", 320800);
        areaCode.put("\u5e02\u8f96\u533a", 320801);
        areaCode.put("\u6e05\u6cb3\u533a", 320802);
        areaCode.put("\u695a\u5dde\u533a", 320803);
        areaCode.put("\u6dee\u9634\u533a", 320804);
        areaCode.put("\u6e05\u6d66\u533a", 320811);
        areaCode.put("\u6d9f\u6c34\u53bf", 320826);
        areaCode.put("\u6d2a\u6cfd\u53bf", 320829);
        areaCode.put("\u76f1\u7719\u53bf", 320830);
        areaCode.put("\u91d1\u6e56\u53bf", 320831);
        areaCode.put("\u76d0\u57ce\u5e02", 320900);
        areaCode.put("\u5e02\u8f96\u533a", 320901);
        areaCode.put("\u4ead\u6e56\u533a", 320902);
        areaCode.put("\u76d0\u90fd\u533a", 320903);
        areaCode.put("\u54cd\u6c34\u53bf", 320921);
        areaCode.put("\u6ee8\u6d77\u53bf", 320922);
        areaCode.put("\u961c\u5b81\u53bf", 320923);
        areaCode.put("\u5c04\u9633\u53bf", 320924);
        areaCode.put("\u5efa\u6e56\u53bf", 320925);
        areaCode.put("\u4e1c\u53f0\u5e02", 320981);
        areaCode.put("\u5927\u4e30\u5e02", 320982);
        areaCode.put("\u626c\u5dde\u5e02", 321000);
        areaCode.put("\u5e02\u8f96\u533a", 321001);
        areaCode.put("\u5e7f\u9675\u533a", 321002);
        areaCode.put("\u9097\u6c5f\u533a", 321003);
        areaCode.put("\u7ef4\u626c\u533a", 321011);
        areaCode.put("\u5b9d\u5e94\u53bf", 321023);
        areaCode.put("\u4eea\u5f81\u5e02", 321081);
        areaCode.put("\u9ad8\u90ae\u5e02", 321084);
        areaCode.put("\u6c5f\u90fd\u5e02", 321088);
        areaCode.put("\u9547\u6c5f\u5e02", 321100);
        areaCode.put("\u5e02\u8f96\u533a", 321101);
        areaCode.put("\u4eac\u53e3\u533a", 321102);
        areaCode.put("\u6da6\u5dde\u533a", 321111);
        areaCode.put("\u4e39\u5f92\u533a", 321112);
        areaCode.put("\u4e39\u9633\u5e02", 321181);
        areaCode.put("\u626c\u4e2d\u5e02", 321182);
        areaCode.put("\u53e5\u5bb9\u5e02", 321183);
        areaCode.put("\u6cf0\u5dde\u5e02", 321200);
        areaCode.put("\u5e02\u8f96\u533a", 321201);
        areaCode.put("\u6d77\u9675\u533a", 321202);
        areaCode.put("\u9ad8\u6e2f\u533a", 321203);
        areaCode.put("\u5174\u5316\u5e02", 321281);
        areaCode.put("\u9756\u6c5f\u5e02", 321282);
        areaCode.put("\u6cf0\u5174\u5e02", 321283);
        areaCode.put("\u59dc\u5830\u5e02", 321284);
        areaCode.put("\u5bbf\u8fc1\u5e02", 321300);
        areaCode.put("\u5e02\u8f96\u533a", 321301);
        areaCode.put("\u5bbf\u57ce\u533a", 321302);
        areaCode.put("\u5bbf\u8c6b\u533a", 321311);
        areaCode.put("\u6cad\u9633\u53bf", 321322);
        areaCode.put("\u6cd7\u9633\u53bf", 321323);
        areaCode.put("\u6cd7\u6d2a\u53bf", 321324);
        areaCode.put("\u6d59\u6c5f\u7701", 330000);
        areaCode.put("\u676d\u5dde\u5e02", 330100);
        areaCode.put("\u5e02\u8f96\u533a", 330101);
        areaCode.put("\u4e0a\u57ce\u533a", 330102);
        areaCode.put("\u4e0b\u57ce\u533a", 330103);
        areaCode.put("\u6c5f\u5e72\u533a", 330104);
        areaCode.put("\u62f1\u5885\u533a", 330105);
        areaCode.put("\u897f\u6e56\u533a", 330106);
        areaCode.put("\u6ee8\u6c5f\u533a", 330108);
        areaCode.put("\u8427\u5c71\u533a", 330109);
        areaCode.put("\u4f59\u676d\u533a", 330110);
        areaCode.put("\u6850\u5e90\u53bf", 330122);
        areaCode.put("\u6df3\u5b89\u53bf", 330127);
        areaCode.put("\u5efa\u5fb7\u5e02", 330182);
        areaCode.put("\u5bcc\u9633\u5e02", 330183);
        areaCode.put("\u4e34\u5b89\u5e02", 330185);
        areaCode.put("\u5b81\u6ce2\u5e02", 330200);
        areaCode.put("\u5e02\u8f96\u533a", 330201);
        areaCode.put("\u6d77\u66d9\u533a", 330203);
        areaCode.put("\u6c5f\u4e1c\u533a", 330204);
        areaCode.put("\u6c5f\u5317\u533a", 330205);
        areaCode.put("\u5317\u4ed1\u533a", 330206);
        areaCode.put("\u9547\u6d77\u533a", 330211);
        areaCode.put("\u911e\u5dde\u533a", 330212);
        areaCode.put("\u8c61\u5c71\u53bf", 330225);
        areaCode.put("\u5b81\u6d77\u53bf", 330226);
        areaCode.put("\u4f59\u59da\u5e02", 330281);
        areaCode.put("\u6148\u6eaa\u5e02", 330282);
        areaCode.put("\u5949\u5316\u5e02", 330283);
        areaCode.put("\u6e29\u5dde\u5e02", 330300);
        areaCode.put("\u5e02\u8f96\u533a", 330301);
        areaCode.put("\u9e7f\u57ce\u533a", 330302);
        areaCode.put("\u9f99\u6e7e\u533a", 330303);
        areaCode.put("\u74ef\u6d77\u533a", 330304);
        areaCode.put("\u6d1e\u5934\u53bf", 330322);
        areaCode.put("\u6c38\u5609\u53bf", 330324);
        areaCode.put("\u5e73\u9633\u53bf", 330326);
        areaCode.put("\u82cd\u5357\u53bf", 330327);
        areaCode.put("\u6587\u6210\u53bf", 330328);
        areaCode.put("\u6cf0\u987a\u53bf", 330329);
        areaCode.put("\u745e\u5b89\u5e02", 330381);
        areaCode.put("\u4e50\u6e05\u5e02", 330382);
        areaCode.put("\u5609\u5174\u5e02", 330400);
        areaCode.put("\u5e02\u8f96\u533a", 330401);
        areaCode.put("\u5357\u6e56\u533a", 330402);
        areaCode.put("\u79c0\u6d32\u533a", 330411);
        areaCode.put("\u5609\u5584\u53bf", 330421);
        areaCode.put("\u6d77\u76d0\u53bf", 330424);
        areaCode.put("\u6d77\u5b81\u5e02", 330481);
        areaCode.put("\u5e73\u6e56\u5e02", 330482);
        areaCode.put("\u6850\u4e61\u5e02", 330483);
        areaCode.put("\u6e56\u5dde\u5e02", 330500);
        areaCode.put("\u5e02\u8f96\u533a", 330501);
        areaCode.put("\u5434\u5174\u533a", 330502);
        areaCode.put("\u5357\u6d54\u533a", 330503);
        areaCode.put("\u5fb7\u6e05\u53bf", 330521);
        areaCode.put("\u957f\u5174\u53bf", 330522);
        areaCode.put("\u5b89\u5409\u53bf", 330523);
        areaCode.put("\u7ecd\u5174\u5e02", 330600);
        areaCode.put("\u5e02\u8f96\u533a", 330601);
        areaCode.put("\u8d8a\u57ce\u533a", 330602);
        areaCode.put("\u7ecd\u5174\u53bf", 330621);
        areaCode.put("\u65b0\u660c\u53bf", 330624);
        areaCode.put("\u8bf8\u66a8\u5e02", 330681);
        areaCode.put("\u4e0a\u865e\u5e02", 330682);
        areaCode.put("\u5d4a\u5dde\u5e02", 330683);
        areaCode.put("\u91d1\u534e\u5e02", 330700);
        areaCode.put("\u5e02\u8f96\u533a", 330701);
        areaCode.put("\u5a7a\u57ce\u533a", 330702);
        areaCode.put("\u91d1\u4e1c\u533a", 330703);
        areaCode.put("\u6b66\u4e49\u53bf", 330723);
        areaCode.put("\u6d66\u6c5f\u53bf", 330726);
        areaCode.put("\u78d0\u5b89\u53bf", 330727);
        areaCode.put("\u5170\u6eaa\u5e02", 330781);
        areaCode.put("\u4e49\u4e4c\u5e02", 330782);
        areaCode.put("\u4e1c\u9633\u5e02", 330783);
        areaCode.put("\u6c38\u5eb7\u5e02", 330784);
        areaCode.put("\u8862\u5dde\u5e02", 330800);
        areaCode.put("\u5e02\u8f96\u533a", 330801);
        areaCode.put("\u67ef\u57ce\u533a", 330802);
        areaCode.put("\u8862\u6c5f\u533a", 330803);
        areaCode.put("\u5e38\u5c71\u53bf", 330822);
        areaCode.put("\u5f00\u5316\u53bf", 330824);
        areaCode.put("\u9f99\u6e38\u53bf", 330825);
        areaCode.put("\u6c5f\u5c71\u5e02", 330881);
        areaCode.put("\u821f\u5c71\u5e02", 330900);
        areaCode.put("\u5e02\u8f96\u533a", 330901);
        areaCode.put("\u5b9a\u6d77\u533a", 330902);
        areaCode.put("\u666e\u9640\u533a", 330903);
        areaCode.put("\u5cb1\u5c71\u53bf", 330921);
        areaCode.put("\u5d4a\u6cd7\u53bf", 330922);
        areaCode.put("\u53f0\u5dde\u5e02", 331000);
        areaCode.put("\u5e02\u8f96\u533a", 331001);
        areaCode.put("\u6912\u6c5f\u533a", 331002);
        areaCode.put("\u9ec4\u5ca9\u533a", 331003);
        areaCode.put("\u8def\u6865\u533a", 331004);
        areaCode.put("\u7389\u73af\u53bf", 331021);
        areaCode.put("\u4e09\u95e8\u53bf", 331022);
        areaCode.put("\u5929\u53f0\u53bf", 331023);
        areaCode.put("\u4ed9\u5c45\u53bf", 331024);
        areaCode.put("\u6e29\u5cad\u5e02", 331081);
        areaCode.put("\u4e34\u6d77\u5e02", 331082);
        areaCode.put("\u4e3d\u6c34\u5e02", 331100);
        areaCode.put("\u5e02\u8f96\u533a", 331101);
        areaCode.put("\u83b2\u90fd\u533a", 331102);
        areaCode.put("\u9752\u7530\u53bf", 331121);
        areaCode.put("\u7f19\u4e91\u53bf", 331122);
        areaCode.put("\u9042\u660c\u53bf", 331123);
        areaCode.put("\u677e\u9633\u53bf", 331124);
        areaCode.put("\u4e91\u548c\u53bf", 331125);
        areaCode.put("\u5e86\u5143\u53bf", 331126);
        areaCode.put("\u666f\u5b81\u7572\u65cf\u81ea\u6cbb\u53bf", 331127);
        areaCode.put("\u9f99\u6cc9\u5e02", 331181);
        areaCode.put("\u5b89\u5fbd\u7701", 340000);
        areaCode.put("\u5408\u80a5\u5e02", 340100);
        areaCode.put("\u5e02\u8f96\u533a", 340101);
        areaCode.put("\u7476\u6d77\u533a", 340102);
        areaCode.put("\u5e90\u9633\u533a", 340103);
        areaCode.put("\u8700\u5c71\u533a", 340104);
        areaCode.put("\u5305\u6cb3\u533a", 340111);
        areaCode.put("\u957f\u4e30\u53bf", 340121);
        areaCode.put("\u80a5\u4e1c\u53bf", 340122);
        areaCode.put("\u80a5\u897f\u53bf", 340123);
        areaCode.put("\u829c\u6e56\u5e02", 340200);
        areaCode.put("\u5e02\u8f96\u533a", 340201);
        areaCode.put("\u955c\u6e56\u533a", 340202);
        areaCode.put("\u5f0b\u6c5f\u533a", 340203);
        areaCode.put("\u9e20\u6c5f\u533a", 340207);
        areaCode.put("\u4e09\u5c71\u533a", 340208);
        areaCode.put("\u829c\u6e56\u53bf", 340221);
        areaCode.put("\u7e41\u660c\u53bf", 340222);
        areaCode.put("\u5357\u9675\u53bf", 340223);
        areaCode.put("\u868c\u57e0\u5e02", 340300);
        areaCode.put("\u5e02\u8f96\u533a", 340301);
        areaCode.put("\u9f99\u5b50\u6e56\u533a", 340302);
        areaCode.put("\u868c\u5c71\u533a", 340303);
        areaCode.put("\u79b9\u4f1a\u533a", 340304);
        areaCode.put("\u6dee\u4e0a\u533a", 340311);
        areaCode.put("\u6000\u8fdc\u53bf", 340321);
        areaCode.put("\u4e94\u6cb3\u53bf", 340322);
        areaCode.put("\u56fa\u9547\u53bf", 340323);
        areaCode.put("\u6dee\u5357\u5e02", 340400);
        areaCode.put("\u5e02\u8f96\u533a", 340401);
        areaCode.put("\u5927\u901a\u533a", 340402);
        areaCode.put("\u7530\u5bb6\u5eb5\u533a", 340403);
        areaCode.put("\u8c22\u5bb6\u96c6\u533a", 340404);
        areaCode.put("\u516b\u516c\u5c71\u533a", 340405);
        areaCode.put("\u6f58\u96c6\u533a", 340406);
        areaCode.put("\u51e4\u53f0\u53bf", 340421);
        areaCode.put("\u9a6c\u978d\u5c71\u5e02", 340500);
        areaCode.put("\u5e02\u8f96\u533a", 340501);
        areaCode.put("\u91d1\u5bb6\u5e84\u533a", 340502);
        areaCode.put("\u82b1\u5c71\u533a", 340503);
        areaCode.put("\u96e8\u5c71\u533a", 340504);
        areaCode.put("\u5f53\u6d82\u53bf", 340521);
        areaCode.put("\u6dee\u5317\u5e02", 340600);
        areaCode.put("\u5e02\u8f96\u533a", 340601);
        areaCode.put("\u675c\u96c6\u533a", 340602);
        areaCode.put("\u76f8\u5c71\u533a", 340603);
        areaCode.put("\u70c8\u5c71\u533a", 340604);
        areaCode.put("\u6fc9\u6eaa\u53bf", 340621);
        areaCode.put("\u94dc\u9675\u5e02", 340700);
        areaCode.put("\u5e02\u8f96\u533a", 340701);
        areaCode.put("\u94dc\u5b98\u5c71\u533a", 340702);
        areaCode.put("\u72ee\u5b50\u5c71\u533a", 340703);
        areaCode.put("\u90ca\u3000\u533a", 340711);
        areaCode.put("\u94dc\u9675\u53bf", 340721);
        areaCode.put("\u5b89\u5e86\u5e02", 340800);
        areaCode.put("\u5e02\u8f96\u533a", 340801);
        areaCode.put("\u8fce\u6c5f\u533a", 340802);
        areaCode.put("\u5927\u89c2\u533a", 340803);
        areaCode.put("\u5b9c\u79c0\u533a", 340811);
        areaCode.put("\u6000\u5b81\u53bf", 340822);
        areaCode.put("\u679e\u9633\u53bf", 340823);
        areaCode.put("\u6f5c\u5c71\u53bf", 340824);
        areaCode.put("\u592a\u6e56\u53bf", 340825);
        areaCode.put("\u5bbf\u677e\u53bf", 340826);
        areaCode.put("\u671b\u6c5f\u53bf", 340827);
        areaCode.put("\u5cb3\u897f\u53bf", 340828);
        areaCode.put("\u6850\u57ce\u5e02", 340881);
        areaCode.put("\u9ec4\u5c71\u5e02", 341000);
        areaCode.put("\u5e02\u8f96\u533a", 341001);
        areaCode.put("\u5c6f\u6eaa\u533a", 341002);
        areaCode.put("\u9ec4\u5c71\u533a", 341003);
        areaCode.put("\u5fbd\u5dde\u533a", 341004);
        areaCode.put("\u6b59\u3000\u53bf", 341021);
        areaCode.put("\u4f11\u5b81\u53bf", 341022);
        areaCode.put("\u9edf\u3000\u53bf", 341023);
        areaCode.put("\u7941\u95e8\u53bf", 341024);
        areaCode.put("\u6ec1\u5dde\u5e02", 341100);
        areaCode.put("\u5e02\u8f96\u533a", 341101);
        areaCode.put("\u7405\u740a\u533a", 341102);
        areaCode.put("\u5357\u8c2f\u533a", 341103);
        areaCode.put("\u6765\u5b89\u53bf", 341122);
        areaCode.put("\u5168\u6912\u53bf", 341124);
        areaCode.put("\u5b9a\u8fdc\u53bf", 341125);
        areaCode.put("\u51e4\u9633\u53bf", 341126);
        areaCode.put("\u5929\u957f\u5e02", 341181);
        areaCode.put("\u660e\u5149\u5e02", 341182);
        areaCode.put("\u961c\u9633\u5e02", 341200);
        areaCode.put("\u5e02\u8f96\u533a", 341201);
        areaCode.put("\u988d\u5dde\u533a", 341202);
        areaCode.put("\u988d\u4e1c\u533a", 341203);
        areaCode.put("\u988d\u6cc9\u533a", 341204);
        areaCode.put("\u4e34\u6cc9\u53bf", 341221);
        areaCode.put("\u592a\u548c\u53bf", 341222);
        areaCode.put("\u961c\u5357\u53bf", 341225);
        areaCode.put("\u988d\u4e0a\u53bf", 341226);
        areaCode.put("\u754c\u9996\u5e02", 341282);
        areaCode.put("\u5bbf\u5dde\u5e02", 341300);
        areaCode.put("\u5e02\u8f96\u533a", 341301);
        areaCode.put("\u57c7\u6865\u533a", 341302);
        areaCode.put("\u7800\u5c71\u53bf", 341321);
        areaCode.put("\u8427\u3000\u53bf", 341322);
        areaCode.put("\u7075\u74a7\u53bf", 341323);
        areaCode.put("\u6cd7\u3000\u53bf", 341324);
        areaCode.put("\u5de2\u6e56\u5e02", 341400);
        areaCode.put("\u5e02\u8f96\u533a", 341401);
        areaCode.put("\u5c45\u5de2\u533a", 341402);
        areaCode.put("\u5e90\u6c5f\u53bf", 341421);
        areaCode.put("\u65e0\u4e3a\u53bf", 341422);
        areaCode.put("\u542b\u5c71\u53bf", 341423);
        areaCode.put("\u548c\u3000\u53bf", 341424);
        areaCode.put("\u516d\u5b89\u5e02", 341500);
        areaCode.put("\u5e02\u8f96\u533a", 341501);
        areaCode.put("\u91d1\u5b89\u533a", 341502);
        areaCode.put("\u88d5\u5b89\u533a", 341503);
        areaCode.put("\u5bff\u3000\u53bf", 341521);
        areaCode.put("\u970d\u90b1\u53bf", 341522);
        areaCode.put("\u8212\u57ce\u53bf", 341523);
        areaCode.put("\u91d1\u5be8\u53bf", 341524);
        areaCode.put("\u970d\u5c71\u53bf", 341525);
        areaCode.put("\u4eb3\u5dde\u5e02", 341600);
        areaCode.put("\u5e02\u8f96\u533a", 341601);
        areaCode.put("\u8c2f\u57ce\u533a", 341602);
        areaCode.put("\u6da1\u9633\u53bf", 341621);
        areaCode.put("\u8499\u57ce\u53bf", 341622);
        areaCode.put("\u5229\u8f9b\u53bf", 341623);
        areaCode.put("\u6c60\u5dde\u5e02", 341700);
        areaCode.put("\u5e02\u8f96\u533a", 341701);
        areaCode.put("\u8d35\u6c60\u533a", 341702);
        areaCode.put("\u4e1c\u81f3\u53bf", 341721);
        areaCode.put("\u77f3\u53f0\u53bf", 341722);
        areaCode.put("\u9752\u9633\u53bf", 341723);
        areaCode.put("\u5ba3\u57ce\u5e02", 341800);
        areaCode.put("\u5e02\u8f96\u533a", 341801);
        areaCode.put("\u5ba3\u5dde\u533a", 341802);
        areaCode.put("\u90ce\u6eaa\u53bf", 341821);
        areaCode.put("\u5e7f\u5fb7\u53bf", 341822);
        areaCode.put("\u6cfe\u3000\u53bf", 341823);
        areaCode.put("\u7ee9\u6eaa\u53bf", 341824);
        areaCode.put("\u65cc\u5fb7\u53bf", 341825);
        areaCode.put("\u5b81\u56fd\u5e02", 341881);
        areaCode.put("\u798f\u5efa\u7701", 350000);
        areaCode.put("\u798f\u5dde\u5e02", 350100);
        areaCode.put("\u5e02\u8f96\u533a", 350101);
        areaCode.put("\u9f13\u697c\u533a", 350102);
        areaCode.put("\u53f0\u6c5f\u533a", 350103);
        areaCode.put("\u4ed3\u5c71\u533a", 350104);
        areaCode.put("\u9a6c\u5c3e\u533a", 350105);
        areaCode.put("\u664b\u5b89\u533a", 350111);
        areaCode.put("\u95fd\u4faf\u53bf", 350121);
        areaCode.put("\u8fde\u6c5f\u53bf", 350122);
        areaCode.put("\u7f57\u6e90\u53bf", 350123);
        areaCode.put("\u95fd\u6e05\u53bf", 350124);
        areaCode.put("\u6c38\u6cf0\u53bf", 350125);
        areaCode.put("\u5e73\u6f6d\u53bf", 350128);
        areaCode.put("\u798f\u6e05\u5e02", 350181);
        areaCode.put("\u957f\u4e50\u5e02", 350182);
        areaCode.put("\u53a6\u95e8\u5e02", 350200);
        areaCode.put("\u5e02\u8f96\u533a", 350201);
        areaCode.put("\u601d\u660e\u533a", 350203);
        areaCode.put("\u6d77\u6ca7\u533a", 350205);
        areaCode.put("\u6e56\u91cc\u533a", 350206);
        areaCode.put("\u96c6\u7f8e\u533a", 350211);
        areaCode.put("\u540c\u5b89\u533a", 350212);
        areaCode.put("\u7fd4\u5b89\u533a", 350213);
        areaCode.put("\u8386\u7530\u5e02", 350300);
        areaCode.put("\u5e02\u8f96\u533a", 350301);
        areaCode.put("\u57ce\u53a2\u533a", 350302);
        areaCode.put("\u6db5\u6c5f\u533a", 350303);
        areaCode.put("\u8354\u57ce\u533a", 350304);
        areaCode.put("\u79c0\u5c7f\u533a", 350305);
        areaCode.put("\u4ed9\u6e38\u53bf", 350322);
        areaCode.put("\u4e09\u660e\u5e02", 350400);
        areaCode.put("\u5e02\u8f96\u533a", 350401);
        areaCode.put("\u6885\u5217\u533a", 350402);
        areaCode.put("\u4e09\u5143\u533a", 350403);
        areaCode.put("\u660e\u6eaa\u53bf", 350421);
        areaCode.put("\u6e05\u6d41\u53bf", 350423);
        areaCode.put("\u5b81\u5316\u53bf", 350424);
        areaCode.put("\u5927\u7530\u53bf", 350425);
        areaCode.put("\u5c24\u6eaa\u53bf", 350426);
        areaCode.put("\u6c99\u3000\u53bf", 350427);
        areaCode.put("\u5c06\u4e50\u53bf", 350428);
        areaCode.put("\u6cf0\u5b81\u53bf", 350429);
        areaCode.put("\u5efa\u5b81\u53bf", 350430);
        areaCode.put("\u6c38\u5b89\u5e02", 350481);
        areaCode.put("\u6cc9\u5dde\u5e02", 350500);
        areaCode.put("\u5e02\u8f96\u533a", 350501);
        areaCode.put("\u9ca4\u57ce\u533a", 350502);
        areaCode.put("\u4e30\u6cfd\u533a", 350503);
        areaCode.put("\u6d1b\u6c5f\u533a", 350504);
        areaCode.put("\u6cc9\u6e2f\u533a", 350505);
        areaCode.put("\u60e0\u5b89\u53bf", 350521);
        areaCode.put("\u5b89\u6eaa\u53bf", 350524);
        areaCode.put("\u6c38\u6625\u53bf", 350525);
        areaCode.put("\u5fb7\u5316\u53bf", 350526);
        areaCode.put("\u91d1\u95e8\u53bf", 350527);
        areaCode.put("\u77f3\u72ee\u5e02", 350581);
        areaCode.put("\u664b\u6c5f\u5e02", 350582);
        areaCode.put("\u5357\u5b89\u5e02", 350583);
        areaCode.put("\u6f33\u5dde\u5e02", 350600);
        areaCode.put("\u5e02\u8f96\u533a", 350601);
        areaCode.put("\u8297\u57ce\u533a", 350602);
        areaCode.put("\u9f99\u6587\u533a", 350603);
        areaCode.put("\u4e91\u9704\u53bf", 350622);
        areaCode.put("\u6f33\u6d66\u53bf", 350623);
        areaCode.put("\u8bcf\u5b89\u53bf", 350624);
        areaCode.put("\u957f\u6cf0\u53bf", 350625);
        areaCode.put("\u4e1c\u5c71\u53bf", 350626);
        areaCode.put("\u5357\u9756\u53bf", 350627);
        areaCode.put("\u5e73\u548c\u53bf", 350628);
        areaCode.put("\u534e\u5b89\u53bf", 350629);
        areaCode.put("\u9f99\u6d77\u5e02", 350681);
        areaCode.put("\u5357\u5e73\u5e02", 350700);
        areaCode.put("\u5e02\u8f96\u533a", 350701);
        areaCode.put("\u5ef6\u5e73\u533a", 350702);
        areaCode.put("\u987a\u660c\u53bf", 350721);
        areaCode.put("\u6d66\u57ce\u53bf", 350722);
        areaCode.put("\u5149\u6cfd\u53bf", 350723);
        areaCode.put("\u677e\u6eaa\u53bf", 350724);
        areaCode.put("\u653f\u548c\u53bf", 350725);
        areaCode.put("\u90b5\u6b66\u5e02", 350781);
        areaCode.put("\u6b66\u5937\u5c71\u5e02", 350782);
        areaCode.put("\u5efa\u74ef\u5e02", 350783);
        areaCode.put("\u5efa\u9633\u5e02", 350784);
        areaCode.put("\u9f99\u5ca9\u5e02", 350800);
        areaCode.put("\u5e02\u8f96\u533a", 350801);
        areaCode.put("\u65b0\u7f57\u533a", 350802);
        areaCode.put("\u957f\u6c40\u53bf", 350821);
        areaCode.put("\u6c38\u5b9a\u53bf", 350822);
        areaCode.put("\u4e0a\u676d\u53bf", 350823);
        areaCode.put("\u6b66\u5e73\u53bf", 350824);
        areaCode.put("\u8fde\u57ce\u53bf", 350825);
        areaCode.put("\u6f33\u5e73\u5e02", 350881);
        areaCode.put("\u5b81\u5fb7\u5e02", 350900);
        areaCode.put("\u5e02\u8f96\u533a", 350901);
        areaCode.put("\u8549\u57ce\u533a", 350902);
        areaCode.put("\u971e\u6d66\u53bf", 350921);
        areaCode.put("\u53e4\u7530\u53bf", 350922);
        areaCode.put("\u5c4f\u5357\u53bf", 350923);
        areaCode.put("\u5bff\u5b81\u53bf", 350924);
        areaCode.put("\u5468\u5b81\u53bf", 350925);
        areaCode.put("\u67d8\u8363\u53bf", 350926);
        areaCode.put("\u798f\u5b89\u5e02", 350981);
        areaCode.put("\u798f\u9f0e\u5e02", 350982);
        areaCode.put("\u6c5f\u897f\u7701", 360000);
        areaCode.put("\u5357\u660c\u5e02", 360100);
        areaCode.put("\u5e02\u8f96\u533a", 360101);
        areaCode.put("\u4e1c\u6e56\u533a", 360102);
        areaCode.put("\u897f\u6e56\u533a", 360103);
        areaCode.put("\u9752\u4e91\u8c31\u533a", 360104);
        areaCode.put("\u6e7e\u91cc\u533a", 360105);
        areaCode.put("\u9752\u5c71\u6e56\u533a", 360111);
        areaCode.put("\u5357\u660c\u53bf", 360121);
        areaCode.put("\u65b0\u5efa\u53bf", 360122);
        areaCode.put("\u5b89\u4e49\u53bf", 360123);
        areaCode.put("\u8fdb\u8d24\u53bf", 360124);
        areaCode.put("\u666f\u5fb7\u9547\u5e02", 360200);
        areaCode.put("\u5e02\u8f96\u533a", 360201);
        areaCode.put("\u660c\u6c5f\u533a", 360202);
        areaCode.put("\u73e0\u5c71\u533a", 360203);
        areaCode.put("\u6d6e\u6881\u53bf", 360222);
        areaCode.put("\u4e50\u5e73\u5e02", 360281);
        areaCode.put("\u840d\u4e61\u5e02", 360300);
        areaCode.put("\u5e02\u8f96\u533a", 360301);
        areaCode.put("\u5b89\u6e90\u533a", 360302);
        areaCode.put("\u6e58\u4e1c\u533a", 360313);
        areaCode.put("\u83b2\u82b1\u53bf", 360321);
        areaCode.put("\u4e0a\u6817\u53bf", 360322);
        areaCode.put("\u82a6\u6eaa\u53bf", 360323);
        areaCode.put("\u4e5d\u6c5f\u5e02", 360400);
        areaCode.put("\u5e02\u8f96\u533a", 360401);
        areaCode.put("\u5e90\u5c71\u533a", 360402);
        areaCode.put("\u6d54\u9633\u533a", 360403);
        areaCode.put("\u4e5d\u6c5f\u53bf", 360421);
        areaCode.put("\u6b66\u5b81\u53bf", 360423);
        areaCode.put("\u4fee\u6c34\u53bf", 360424);
        areaCode.put("\u6c38\u4fee\u53bf", 360425);
        areaCode.put("\u5fb7\u5b89\u53bf", 360426);
        areaCode.put("\u661f\u5b50\u53bf", 360427);
        areaCode.put("\u90fd\u660c\u53bf", 360428);
        areaCode.put("\u6e56\u53e3\u53bf", 360429);
        areaCode.put("\u5f6d\u6cfd\u53bf", 360430);
        areaCode.put("\u745e\u660c\u5e02", 360481);
        areaCode.put("\u65b0\u4f59\u5e02", 360500);
        areaCode.put("\u5e02\u8f96\u533a", 360501);
        areaCode.put("\u6e1d\u6c34\u533a", 360502);
        areaCode.put("\u5206\u5b9c\u53bf", 360521);
        areaCode.put("\u9e70\u6f6d\u5e02", 360600);
        areaCode.put("\u5e02\u8f96\u533a", 360601);
        areaCode.put("\u6708\u6e56\u533a", 360602);
        areaCode.put("\u4f59\u6c5f\u53bf", 360622);
        areaCode.put("\u8d35\u6eaa\u5e02", 360681);
        areaCode.put("\u8d63\u5dde\u5e02", 360700);
        areaCode.put("\u5e02\u8f96\u533a", 360701);
        areaCode.put("\u7ae0\u8d21\u533a", 360702);
        areaCode.put("\u8d63\u3000\u53bf", 360721);
        areaCode.put("\u4fe1\u4e30\u53bf", 360722);
        areaCode.put("\u5927\u4f59\u53bf", 360723);
        areaCode.put("\u4e0a\u72b9\u53bf", 360724);
        areaCode.put("\u5d07\u4e49\u53bf", 360725);
        areaCode.put("\u5b89\u8fdc\u53bf", 360726);
        areaCode.put("\u9f99\u5357\u53bf", 360727);
        areaCode.put("\u5b9a\u5357\u53bf", 360728);
        areaCode.put("\u5168\u5357\u53bf", 360729);
        areaCode.put("\u5b81\u90fd\u53bf", 360730);
        areaCode.put("\u4e8e\u90fd\u53bf", 360731);
        areaCode.put("\u5174\u56fd\u53bf", 360732);
        areaCode.put("\u4f1a\u660c\u53bf", 360733);
        areaCode.put("\u5bfb\u4e4c\u53bf", 360734);
        areaCode.put("\u77f3\u57ce\u53bf", 360735);
        areaCode.put("\u745e\u91d1\u5e02", 360781);
        areaCode.put("\u5357\u5eb7\u5e02", 360782);
        areaCode.put("\u5409\u5b89\u5e02", 360800);
        areaCode.put("\u5e02\u8f96\u533a", 360801);
        areaCode.put("\u5409\u5dde\u533a", 360802);
        areaCode.put("\u9752\u539f\u533a", 360803);
        areaCode.put("\u5409\u5b89\u53bf", 360821);
        areaCode.put("\u5409\u6c34\u53bf", 360822);
        areaCode.put("\u5ce1\u6c5f\u53bf", 360823);
        areaCode.put("\u65b0\u5e72\u53bf", 360824);
        areaCode.put("\u6c38\u4e30\u53bf", 360825);
        areaCode.put("\u6cf0\u548c\u53bf", 360826);
        areaCode.put("\u9042\u5ddd\u53bf", 360827);
        areaCode.put("\u4e07\u5b89\u53bf", 360828);
        areaCode.put("\u5b89\u798f\u53bf", 360829);
        areaCode.put("\u6c38\u65b0\u53bf", 360830);
        areaCode.put("\u4e95\u5188\u5c71\u5e02", 360881);
        areaCode.put("\u5b9c\u6625\u5e02", 360900);
        areaCode.put("\u5e02\u8f96\u533a", 360901);
        areaCode.put("\u8881\u5dde\u533a", 360902);
        areaCode.put("\u5949\u65b0\u53bf", 360921);
        areaCode.put("\u4e07\u8f7d\u53bf", 360922);
        areaCode.put("\u4e0a\u9ad8\u53bf", 360923);
        areaCode.put("\u5b9c\u4e30\u53bf", 360924);
        areaCode.put("\u9756\u5b89\u53bf", 360925);
        areaCode.put("\u94dc\u9f13\u53bf", 360926);
        areaCode.put("\u4e30\u57ce\u5e02", 360981);
        areaCode.put("\u6a1f\u6811\u5e02", 360982);
        areaCode.put("\u9ad8\u5b89\u5e02", 360983);
        areaCode.put("\u629a\u5dde\u5e02", 361000);
        areaCode.put("\u5e02\u8f96\u533a", 361001);
        areaCode.put("\u4e34\u5ddd\u533a", 361002);
        areaCode.put("\u5357\u57ce\u53bf", 361021);
        areaCode.put("\u9ece\u5ddd\u53bf", 361022);
        areaCode.put("\u5357\u4e30\u53bf", 361023);
        areaCode.put("\u5d07\u4ec1\u53bf", 361024);
        areaCode.put("\u4e50\u5b89\u53bf", 361025);
        areaCode.put("\u5b9c\u9ec4\u53bf", 361026);
        areaCode.put("\u91d1\u6eaa\u53bf", 361027);
        areaCode.put("\u8d44\u6eaa\u53bf", 361028);
        areaCode.put("\u4e1c\u4e61\u53bf", 361029);
        areaCode.put("\u5e7f\u660c\u53bf", 361030);
        areaCode.put("\u4e0a\u9976\u5e02", 361100);
        areaCode.put("\u5e02\u8f96\u533a", 361101);
        areaCode.put("\u4fe1\u5dde\u533a", 361102);
        areaCode.put("\u4e0a\u9976\u53bf", 361121);
        areaCode.put("\u5e7f\u4e30\u53bf", 361122);
        areaCode.put("\u7389\u5c71\u53bf", 361123);
        areaCode.put("\u94c5\u5c71\u53bf", 361124);
        areaCode.put("\u6a2a\u5cf0\u53bf", 361125);
        areaCode.put("\u5f0b\u9633\u53bf", 361126);
        areaCode.put("\u4f59\u5e72\u53bf", 361127);
        areaCode.put("\u9131\u9633\u53bf", 361128);
        areaCode.put("\u4e07\u5e74\u53bf", 361129);
        areaCode.put("\u5a7a\u6e90\u53bf", 361130);
        areaCode.put("\u5fb7\u5174\u5e02", 361181);
        areaCode.put("\u5c71\u4e1c\u7701", 370000);
        areaCode.put("\u6d4e\u5357\u5e02", 370100);
        areaCode.put("\u5e02\u8f96\u533a", 370101);
        areaCode.put("\u5386\u4e0b\u533a", 370102);
        areaCode.put("\u5e02\u4e2d\u533a", 370103);
        areaCode.put("\u69d0\u836b\u533a", 370104);
        areaCode.put("\u5929\u6865\u533a", 370105);
        areaCode.put("\u5386\u57ce\u533a", 370112);
        areaCode.put("\u957f\u6e05\u533a", 370113);
        areaCode.put("\u5e73\u9634\u53bf", 370124);
        areaCode.put("\u6d4e\u9633\u53bf", 370125);
        areaCode.put("\u5546\u6cb3\u53bf", 370126);
        areaCode.put("\u7ae0\u4e18\u5e02", 370181);
        areaCode.put("\u9752\u5c9b\u5e02", 370200);
        areaCode.put("\u5e02\u8f96\u533a", 370201);
        areaCode.put("\u5e02\u5357\u533a", 370202);
        areaCode.put("\u5e02\u5317\u533a", 370203);
        areaCode.put("\u56db\u65b9\u533a", 370205);
        areaCode.put("\u9ec4\u5c9b\u533a", 370211);
        areaCode.put("\u5d02\u5c71\u533a", 370212);
        areaCode.put("\u674e\u6ca7\u533a", 370213);
        areaCode.put("\u57ce\u9633\u533a", 370214);
        areaCode.put("\u80f6\u5dde\u5e02", 370281);
        areaCode.put("\u5373\u58a8\u5e02", 370282);
        areaCode.put("\u5e73\u5ea6\u5e02", 370283);
        areaCode.put("\u80f6\u5357\u5e02", 370284);
        areaCode.put("\u83b1\u897f\u5e02", 370285);
        areaCode.put("\u6dc4\u535a\u5e02", 370300);
        areaCode.put("\u5e02\u8f96\u533a", 370301);
        areaCode.put("\u6dc4\u5ddd\u533a", 370302);
        areaCode.put("\u5f20\u5e97\u533a", 370303);
        areaCode.put("\u535a\u5c71\u533a", 370304);
        areaCode.put("\u4e34\u6dc4\u533a", 370305);
        areaCode.put("\u5468\u6751\u533a", 370306);
        areaCode.put("\u6853\u53f0\u53bf", 370321);
        areaCode.put("\u9ad8\u9752\u53bf", 370322);
        areaCode.put("\u6c82\u6e90\u53bf", 370323);
        areaCode.put("\u67a3\u5e84\u5e02", 370400);
        areaCode.put("\u5e02\u8f96\u533a", 370401);
        areaCode.put("\u5e02\u4e2d\u533a", 370402);
        areaCode.put("\u859b\u57ce\u533a", 370403);
        areaCode.put("\u5cc4\u57ce\u533a", 370404);
        areaCode.put("\u53f0\u513f\u5e84\u533a", 370405);
        areaCode.put("\u5c71\u4ead\u533a", 370406);
        areaCode.put("\u6ed5\u5dde\u5e02", 370481);
        areaCode.put("\u4e1c\u8425\u5e02", 370500);
        areaCode.put("\u5e02\u8f96\u533a", 370501);
        areaCode.put("\u4e1c\u8425\u533a", 370502);
        areaCode.put("\u6cb3\u53e3\u533a", 370503);
        areaCode.put("\u57a6\u5229\u53bf", 370521);
        areaCode.put("\u5229\u6d25\u53bf", 370522);
        areaCode.put("\u5e7f\u9976\u53bf", 370523);
        areaCode.put("\u70df\u53f0\u5e02", 370600);
        areaCode.put("\u5e02\u8f96\u533a", 370601);
        areaCode.put("\u829d\u7f58\u533a", 370602);
        areaCode.put("\u798f\u5c71\u533a", 370611);
        areaCode.put("\u725f\u5e73\u533a", 370612);
        areaCode.put("\u83b1\u5c71\u533a", 370613);
        areaCode.put("\u957f\u5c9b\u53bf", 370634);
        areaCode.put("\u9f99\u53e3\u5e02", 370681);
        areaCode.put("\u83b1\u9633\u5e02", 370682);
        areaCode.put("\u83b1\u5dde\u5e02", 370683);
        areaCode.put("\u84ec\u83b1\u5e02", 370684);
        areaCode.put("\u62db\u8fdc\u5e02", 370685);
        areaCode.put("\u6816\u971e\u5e02", 370686);
        areaCode.put("\u6d77\u9633\u5e02", 370687);
        areaCode.put("\u6f4d\u574a\u5e02", 370700);
        areaCode.put("\u5e02\u8f96\u533a", 370701);
        areaCode.put("\u6f4d\u57ce\u533a", 370702);
        areaCode.put("\u5bd2\u4ead\u533a", 370703);
        areaCode.put("\u574a\u5b50\u533a", 370704);
        areaCode.put("\u594e\u6587\u533a", 370705);
        areaCode.put("\u4e34\u6710\u53bf", 370724);
        areaCode.put("\u660c\u4e50\u53bf", 370725);
        areaCode.put("\u9752\u5dde\u5e02", 370781);
        areaCode.put("\u8bf8\u57ce\u5e02", 370782);
        areaCode.put("\u5bff\u5149\u5e02", 370783);
        areaCode.put("\u5b89\u4e18\u5e02", 370784);
        areaCode.put("\u9ad8\u5bc6\u5e02", 370785);
        areaCode.put("\u660c\u9091\u5e02", 370786);
        areaCode.put("\u6d4e\u5b81\u5e02", 370800);
        areaCode.put("\u5e02\u8f96\u533a", 370801);
        areaCode.put("\u5e02\u4e2d\u533a", 370802);
        areaCode.put("\u4efb\u57ce\u533a", 370811);
        areaCode.put("\u5fae\u5c71\u53bf", 370826);
        areaCode.put("\u9c7c\u53f0\u53bf", 370827);
        areaCode.put("\u91d1\u4e61\u53bf", 370828);
        areaCode.put("\u5609\u7965\u53bf", 370829);
        areaCode.put("\u6c76\u4e0a\u53bf", 370830);
        areaCode.put("\u6cd7\u6c34\u53bf", 370831);
        areaCode.put("\u6881\u5c71\u53bf", 370832);
        areaCode.put("\u66f2\u961c\u5e02", 370881);
        areaCode.put("\u5156\u5dde\u5e02", 370882);
        areaCode.put("\u90b9\u57ce\u5e02", 370883);
        areaCode.put("\u6cf0\u5b89\u5e02", 370900);
        areaCode.put("\u5e02\u8f96\u533a", 370901);
        areaCode.put("\u6cf0\u5c71\u533a", 370902);
        areaCode.put("\u5cb1\u5cb3\u533a", 370911);
        areaCode.put("\u5b81\u9633\u53bf", 370921);
        areaCode.put("\u4e1c\u5e73\u53bf", 370923);
        areaCode.put("\u65b0\u6cf0\u5e02", 370982);
        areaCode.put("\u80a5\u57ce\u5e02", 370983);
        areaCode.put("\u5a01\u6d77\u5e02", 371000);
        areaCode.put("\u5e02\u8f96\u533a", 371001);
        areaCode.put("\u73af\u7fe0\u533a", 371002);
        areaCode.put("\u6587\u767b\u5e02", 371081);
        areaCode.put("\u8363\u6210\u5e02", 371082);
        areaCode.put("\u4e73\u5c71\u5e02", 371083);
        areaCode.put("\u65e5\u7167\u5e02", 371100);
        areaCode.put("\u5e02\u8f96\u533a", 371101);
        areaCode.put("\u4e1c\u6e2f\u533a", 371102);
        areaCode.put("\u5c9a\u5c71\u533a", 371103);
        areaCode.put("\u4e94\u83b2\u53bf", 371121);
        areaCode.put("\u8392\u3000\u53bf", 371122);
        areaCode.put("\u83b1\u829c\u5e02", 371200);
        areaCode.put("\u5e02\u8f96\u533a", 371201);
        areaCode.put("\u83b1\u57ce\u533a", 371202);
        areaCode.put("\u94a2\u57ce\u533a", 371203);
        areaCode.put("\u4e34\u6c82\u5e02", 371300);
        areaCode.put("\u5e02\u8f96\u533a", 371301);
        areaCode.put("\u5170\u5c71\u533a", 371302);
        areaCode.put("\u7f57\u5e84\u533a", 371311);
        areaCode.put("\u6cb3\u4e1c\u533a", 371312);
        areaCode.put("\u6c82\u5357\u53bf", 371321);
        areaCode.put("\u90ef\u57ce\u53bf", 371322);
        areaCode.put("\u6c82\u6c34\u53bf", 371323);
        areaCode.put("\u82cd\u5c71\u53bf", 371324);
        areaCode.put("\u8d39\u3000\u53bf", 371325);
        areaCode.put("\u5e73\u9091\u53bf", 371326);
        areaCode.put("\u8392\u5357\u53bf", 371327);
        areaCode.put("\u8499\u9634\u53bf", 371328);
        areaCode.put("\u4e34\u6cad\u53bf", 371329);
        areaCode.put("\u5fb7\u5dde\u5e02", 371400);
        areaCode.put("\u5e02\u8f96\u533a", 371401);
        areaCode.put("\u5fb7\u57ce\u533a", 371402);
        areaCode.put("\u9675\u3000\u53bf", 371421);
        areaCode.put("\u5b81\u6d25\u53bf", 371422);
        areaCode.put("\u5e86\u4e91\u53bf", 371423);
        areaCode.put("\u4e34\u9091\u53bf", 371424);
        areaCode.put("\u9f50\u6cb3\u53bf", 371425);
        areaCode.put("\u5e73\u539f\u53bf", 371426);
        areaCode.put("\u590f\u6d25\u53bf", 371427);
        areaCode.put("\u6b66\u57ce\u53bf", 371428);
        areaCode.put("\u4e50\u9675\u5e02", 371481);
        areaCode.put("\u79b9\u57ce\u5e02", 371482);
        areaCode.put("\u804a\u57ce\u5e02", 371500);
        areaCode.put("\u5e02\u8f96\u533a", 371501);
        areaCode.put("\u4e1c\u660c\u5e9c\u533a", 371502);
        areaCode.put("\u9633\u8c37\u53bf", 371521);
        areaCode.put("\u8398\u3000\u53bf", 371522);
        areaCode.put("\u830c\u5e73\u53bf", 371523);
        areaCode.put("\u4e1c\u963f\u53bf", 371524);
        areaCode.put("\u51a0\u3000\u53bf", 371525);
        areaCode.put("\u9ad8\u5510\u53bf", 371526);
        areaCode.put("\u4e34\u6e05\u5e02", 371581);
        areaCode.put("\u6ee8\u5dde\u5e02", 371600);
        areaCode.put("\u5e02\u8f96\u533a", 371601);
        areaCode.put("\u6ee8\u57ce\u533a", 371602);
        areaCode.put("\u60e0\u6c11\u53bf", 371621);
        areaCode.put("\u9633\u4fe1\u53bf", 371622);
        areaCode.put("\u65e0\u68e3\u53bf", 371623);
        areaCode.put("\u6cbe\u5316\u53bf", 371624);
        areaCode.put("\u535a\u5174\u53bf", 371625);
        areaCode.put("\u90b9\u5e73\u53bf", 371626);
        areaCode.put("\u83cf\u6cfd\u5e02", 371700);
        areaCode.put("\u5e02\u8f96\u533a", 371701);
        areaCode.put("\u7261\u4e39\u533a", 371702);
        areaCode.put("\u66f9\u3000\u53bf", 371721);
        areaCode.put("\u5355\u3000\u53bf", 371722);
        areaCode.put("\u6210\u6b66\u53bf", 371723);
        areaCode.put("\u5de8\u91ce\u53bf", 371724);
        areaCode.put("\u90d3\u57ce\u53bf", 371725);
        areaCode.put("\u9104\u57ce\u53bf", 371726);
        areaCode.put("\u5b9a\u9676\u53bf", 371727);
        areaCode.put("\u4e1c\u660e\u53bf", 371728);
        areaCode.put("\u6cb3\u5357\u7701", 410000);
        areaCode.put("\u90d1\u5dde\u5e02", 410100);
        areaCode.put("\u5e02\u8f96\u533a", 410101);
        areaCode.put("\u4e2d\u539f\u533a", 410102);
        areaCode.put("\u4e8c\u4e03\u533a", 410103);
        areaCode.put("\u7ba1\u57ce\u56de\u65cf\u533a", 410104);
        areaCode.put("\u91d1\u6c34\u533a", 410105);
        areaCode.put("\u4e0a\u8857\u533a", 410106);
        areaCode.put("\u60e0\u6d4e\u533a", 410108);
        areaCode.put("\u4e2d\u725f\u53bf", 410122);
        areaCode.put("\u5de9\u4e49\u5e02", 410181);
        areaCode.put("\u8365\u9633\u5e02", 410182);
        areaCode.put("\u65b0\u5bc6\u5e02", 410183);
        areaCode.put("\u65b0\u90d1\u5e02", 410184);
        areaCode.put("\u767b\u5c01\u5e02", 410185);
        areaCode.put("\u5f00\u5c01\u5e02", 410200);
        areaCode.put("\u5e02\u8f96\u533a", 410201);
        areaCode.put("\u9f99\u4ead\u533a", 410202);
        areaCode.put("\u987a\u6cb3\u56de\u65cf\u533a", 410203);
        areaCode.put("\u9f13\u697c\u533a", 410204);
        areaCode.put("\u79b9\u738b\u53f0\u533a", 410205);
        areaCode.put("\u91d1\u660e\u533a", 410211);
        areaCode.put("\u675e\u3000\u53bf", 410221);
        areaCode.put("\u901a\u8bb8\u53bf", 410222);
        areaCode.put("\u5c09\u6c0f\u53bf", 410223);
        areaCode.put("\u5f00\u5c01\u53bf", 410224);
        areaCode.put("\u5170\u8003\u53bf", 410225);
        areaCode.put("\u6d1b\u9633\u5e02", 410300);
        areaCode.put("\u5e02\u8f96\u533a", 410301);
        areaCode.put("\u8001\u57ce\u533a", 410302);
        areaCode.put("\u897f\u5de5\u533a", 410303);
        areaCode.put("\u700d\u6cb3\u56de\u65cf\u533a", 410304);
        areaCode.put("\u6da7\u897f\u533a", 410305);
        areaCode.put("\u5409\u5229\u533a", 410306);
        areaCode.put("\u6d1b\u9f99\u533a", 410311);
        areaCode.put("\u5b5f\u6d25\u53bf", 410322);
        areaCode.put("\u65b0\u5b89\u53bf", 410323);
        areaCode.put("\u683e\u5ddd\u53bf", 410324);
        areaCode.put("\u5d69\u3000\u53bf", 410325);
        areaCode.put("\u6c5d\u9633\u53bf", 410326);
        areaCode.put("\u5b9c\u9633\u53bf", 410327);
        areaCode.put("\u6d1b\u5b81\u53bf", 410328);
        areaCode.put("\u4f0a\u5ddd\u53bf", 410329);
        areaCode.put("\u5043\u5e08\u5e02", 410381);
        areaCode.put("\u5e73\u9876\u5c71\u5e02", 410400);
        areaCode.put("\u5e02\u8f96\u533a", 410401);
        areaCode.put("\u65b0\u534e\u533a", 410402);
        areaCode.put("\u536b\u4e1c\u533a", 410403);
        areaCode.put("\u77f3\u9f99\u533a", 410404);
        areaCode.put("\u6e5b\u6cb3\u533a", 410411);
        areaCode.put("\u5b9d\u4e30\u53bf", 410421);
        areaCode.put("\u53f6\u3000\u53bf", 410422);
        areaCode.put("\u9c81\u5c71\u53bf", 410423);
        areaCode.put("\u90cf\u3000\u53bf", 410425);
        areaCode.put("\u821e\u94a2\u5e02", 410481);
        areaCode.put("\u6c5d\u5dde\u5e02", 410482);
        areaCode.put("\u5b89\u9633\u5e02", 410500);
        areaCode.put("\u5e02\u8f96\u533a", 410501);
        areaCode.put("\u6587\u5cf0\u533a", 410502);
        areaCode.put("\u5317\u5173\u533a", 410503);
        areaCode.put("\u6bb7\u90fd\u533a", 410505);
        areaCode.put("\u9f99\u5b89\u533a", 410506);
        areaCode.put("\u5b89\u9633\u53bf", 410522);
        areaCode.put("\u6c64\u9634\u53bf", 410523);
        areaCode.put("\u6ed1\u3000\u53bf", 410526);
        areaCode.put("\u5185\u9ec4\u53bf", 410527);
        areaCode.put("\u6797\u5dde\u5e02", 410581);
        areaCode.put("\u9e64\u58c1\u5e02", 410600);
        areaCode.put("\u5e02\u8f96\u533a", 410601);
        areaCode.put("\u9e64\u5c71\u533a", 410602);
        areaCode.put("\u5c71\u57ce\u533a", 410603);
        areaCode.put("\u6dc7\u6ee8\u533a", 410611);
        areaCode.put("\u6d5a\u3000\u53bf", 410621);
        areaCode.put("\u6dc7\u3000\u53bf", 410622);
        areaCode.put("\u65b0\u4e61\u5e02", 410700);
        areaCode.put("\u5e02\u8f96\u533a", 410701);
        areaCode.put("\u7ea2\u65d7\u533a", 410702);
        areaCode.put("\u536b\u6ee8\u533a", 410703);
        areaCode.put("\u51e4\u6cc9\u533a", 410704);
        areaCode.put("\u7267\u91ce\u533a", 410711);
        areaCode.put("\u65b0\u4e61\u53bf", 410721);
        areaCode.put("\u83b7\u5609\u53bf", 410724);
        areaCode.put("\u539f\u9633\u53bf", 410725);
        areaCode.put("\u5ef6\u6d25\u53bf", 410726);
        areaCode.put("\u5c01\u4e18\u53bf", 410727);
        areaCode.put("\u957f\u57a3\u53bf", 410728);
        areaCode.put("\u536b\u8f89\u5e02", 410781);
        areaCode.put("\u8f89\u53bf\u5e02", 410782);
        areaCode.put("\u7126\u4f5c\u5e02", 410800);
        areaCode.put("\u5e02\u8f96\u533a", 410801);
        areaCode.put("\u89e3\u653e\u533a", 410802);
        areaCode.put("\u4e2d\u7ad9\u533a", 410803);
        areaCode.put("\u9a6c\u6751\u533a", 410804);
        areaCode.put("\u5c71\u9633\u533a", 410811);
        areaCode.put("\u4fee\u6b66\u53bf", 410821);
        areaCode.put("\u535a\u7231\u53bf", 410822);
        areaCode.put("\u6b66\u965f\u53bf", 410823);
        areaCode.put("\u6e29\u3000\u53bf", 410825);
        areaCode.put("\u6c81\u9633\u5e02", 410882);
        areaCode.put("\u5b5f\u5dde\u5e02", 410883);
        areaCode.put("\u6fee\u9633\u5e02", 410900);
        areaCode.put("\u5e02\u8f96\u533a", 410901);
        areaCode.put("\u534e\u9f99\u533a", 410902);
        areaCode.put("\u6e05\u4e30\u53bf", 410922);
        areaCode.put("\u5357\u4e50\u53bf", 410923);
        areaCode.put("\u8303\u3000\u53bf", 410926);
        areaCode.put("\u53f0\u524d\u53bf", 410927);
        areaCode.put("\u6fee\u9633\u53bf", 410928);
        areaCode.put("\u8bb8\u660c\u5e02", 411000);
        areaCode.put("\u5e02\u8f96\u533a", 411001);
        areaCode.put("\u9b4f\u90fd\u533a", 411002);
        areaCode.put("\u8bb8\u660c\u53bf", 411023);
        areaCode.put("\u9122\u9675\u53bf", 411024);
        areaCode.put("\u8944\u57ce\u53bf", 411025);
        areaCode.put("\u79b9\u5dde\u5e02", 411081);
        areaCode.put("\u957f\u845b\u5e02", 411082);
        areaCode.put("\u6f2f\u6cb3\u5e02", 411100);
        areaCode.put("\u5e02\u8f96\u533a", 411101);
        areaCode.put("\u6e90\u6c47\u533a", 411102);
        areaCode.put("\u90fe\u57ce\u533a", 411103);
        areaCode.put("\u53ec\u9675\u533a", 411104);
        areaCode.put("\u821e\u9633\u53bf", 411121);
        areaCode.put("\u4e34\u988d\u53bf", 411122);
        areaCode.put("\u4e09\u95e8\u5ce1\u5e02", 411200);
        areaCode.put("\u5e02\u8f96\u533a", 411201);
        areaCode.put("\u6e56\u6ee8\u533a", 411202);
        areaCode.put("\u6e11\u6c60\u53bf", 411221);
        areaCode.put("\u9655\u3000\u53bf", 411222);
        areaCode.put("\u5362\u6c0f\u53bf", 411224);
        areaCode.put("\u4e49\u9a6c\u5e02", 411281);
        areaCode.put("\u7075\u5b9d\u5e02", 411282);
        areaCode.put("\u5357\u9633\u5e02", 411300);
        areaCode.put("\u5e02\u8f96\u533a", 411301);
        areaCode.put("\u5b9b\u57ce\u533a", 411302);
        areaCode.put("\u5367\u9f99\u533a", 411303);
        areaCode.put("\u5357\u53ec\u53bf", 411321);
        areaCode.put("\u65b9\u57ce\u53bf", 411322);
        areaCode.put("\u897f\u5ce1\u53bf", 411323);
        areaCode.put("\u9547\u5e73\u53bf", 411324);
        areaCode.put("\u5185\u4e61\u53bf", 411325);
        areaCode.put("\u6dc5\u5ddd\u53bf", 411326);
        areaCode.put("\u793e\u65d7\u53bf", 411327);
        areaCode.put("\u5510\u6cb3\u53bf", 411328);
        areaCode.put("\u65b0\u91ce\u53bf", 411329);
        areaCode.put("\u6850\u67cf\u53bf", 411330);
        areaCode.put("\u9093\u5dde\u5e02", 411381);
        areaCode.put("\u5546\u4e18\u5e02", 411400);
        areaCode.put("\u5e02\u8f96\u533a", 411401);
        areaCode.put("\u6881\u56ed\u533a", 411402);
        areaCode.put("\u7762\u9633\u533a", 411403);
        areaCode.put("\u6c11\u6743\u53bf", 411421);
        areaCode.put("\u7762\u3000\u53bf", 411422);
        areaCode.put("\u5b81\u9675\u53bf", 411423);
        areaCode.put("\u67d8\u57ce\u53bf", 411424);
        areaCode.put("\u865e\u57ce\u53bf", 411425);
        areaCode.put("\u590f\u9091\u53bf", 411426);
        areaCode.put("\u6c38\u57ce\u5e02", 411481);
        areaCode.put("\u4fe1\u9633\u5e02", 411500);
        areaCode.put("\u5e02\u8f96\u533a", 411501);
        areaCode.put("\u6d49\u6cb3\u533a", 411502);
        areaCode.put("\u5e73\u6865\u533a", 411503);
        areaCode.put("\u7f57\u5c71\u53bf", 411521);
        areaCode.put("\u5149\u5c71\u53bf", 411522);
        areaCode.put("\u65b0\u3000\u53bf", 411523);
        areaCode.put("\u5546\u57ce\u53bf", 411524);
        areaCode.put("\u56fa\u59cb\u53bf", 411525);
        areaCode.put("\u6f62\u5ddd\u53bf", 411526);
        areaCode.put("\u6dee\u6ee8\u53bf", 411527);
        areaCode.put("\u606f\u3000\u53bf", 411528);
        areaCode.put("\u5468\u53e3\u5e02", 411600);
        areaCode.put("\u5e02\u8f96\u533a", 411601);
        areaCode.put("\u5ddd\u6c47\u533a", 411602);
        areaCode.put("\u6276\u6c9f\u53bf", 411621);
        areaCode.put("\u897f\u534e\u53bf", 411622);
        areaCode.put("\u5546\u6c34\u53bf", 411623);
        areaCode.put("\u6c88\u4e18\u53bf", 411624);
        areaCode.put("\u90f8\u57ce\u53bf", 411625);
        areaCode.put("\u6dee\u9633\u53bf", 411626);
        areaCode.put("\u592a\u5eb7\u53bf", 411627);
        areaCode.put("\u9e7f\u9091\u53bf", 411628);
        areaCode.put("\u9879\u57ce\u5e02", 411681);
        areaCode.put("\u9a7b\u9a6c\u5e97\u5e02", 411700);
        areaCode.put("\u5e02\u8f96\u533a", 411701);
        areaCode.put("\u9a7f\u57ce\u533a", 411702);
        areaCode.put("\u897f\u5e73\u53bf", 411721);
        areaCode.put("\u4e0a\u8521\u53bf", 411722);
        areaCode.put("\u5e73\u8206\u53bf", 411723);
        areaCode.put("\u6b63\u9633\u53bf", 411724);
        areaCode.put("\u786e\u5c71\u53bf", 411725);
        areaCode.put("\u6ccc\u9633\u53bf", 411726);
        areaCode.put("\u6c5d\u5357\u53bf", 411727);
        areaCode.put("\u9042\u5e73\u53bf", 411728);
        areaCode.put("\u65b0\u8521\u53bf", 411729);
        areaCode.put("\u6d4e\u6e90\u5e02", 419001);
        areaCode.put("\u6e56\u5317\u7701", 420000);
        areaCode.put("\u6b66\u6c49\u5e02", 420100);
        areaCode.put("\u5e02\u8f96\u533a", 420101);
        areaCode.put("\u6c5f\u5cb8\u533a", 420102);
        areaCode.put("\u6c5f\u6c49\u533a", 420103);
        areaCode.put("\u785a\u53e3\u533a", 420104);
        areaCode.put("\u6c49\u9633\u533a", 420105);
        areaCode.put("\u6b66\u660c\u533a", 420106);
        areaCode.put("\u9752\u5c71\u533a", 420107);
        areaCode.put("\u6d2a\u5c71\u533a", 420111);
        areaCode.put("\u4e1c\u897f\u6e56\u533a", 420112);
        areaCode.put("\u6c49\u5357\u533a", 420113);
        areaCode.put("\u8521\u7538\u533a", 420114);
        areaCode.put("\u6c5f\u590f\u533a", 420115);
        areaCode.put("\u9ec4\u9642\u533a", 420116);
        areaCode.put("\u65b0\u6d32\u533a", 420117);
        areaCode.put("\u9ec4\u77f3\u5e02", 420200);
        areaCode.put("\u5e02\u8f96\u533a", 420201);
        areaCode.put("\u9ec4\u77f3\u6e2f\u533a", 420202);
        areaCode.put("\u897f\u585e\u5c71\u533a", 420203);
        areaCode.put("\u4e0b\u9646\u533a", 420204);
        areaCode.put("\u94c1\u5c71\u533a", 420205);
        areaCode.put("\u9633\u65b0\u53bf", 420222);
        areaCode.put("\u5927\u51b6\u5e02", 420281);
        areaCode.put("\u5341\u5830\u5e02", 420300);
        areaCode.put("\u5e02\u8f96\u533a", 420301);
        areaCode.put("\u8305\u7bad\u533a", 420302);
        areaCode.put("\u5f20\u6e7e\u533a", 420303);
        areaCode.put("\u90e7\u3000\u53bf", 420321);
        areaCode.put("\u90e7\u897f\u53bf", 420322);
        areaCode.put("\u7af9\u5c71\u53bf", 420323);
        areaCode.put("\u7af9\u6eaa\u53bf", 420324);
        areaCode.put("\u623f\u3000\u53bf", 420325);
        areaCode.put("\u4e39\u6c5f\u53e3\u5e02", 420381);
        areaCode.put("\u5b9c\u660c\u5e02", 420500);
        areaCode.put("\u5e02\u8f96\u533a", 420501);
        areaCode.put("\u897f\u9675\u533a", 420502);
        areaCode.put("\u4f0d\u5bb6\u5c97\u533a", 420503);
        areaCode.put("\u70b9\u519b\u533a", 420504);
        areaCode.put("\u7307\u4ead\u533a", 420505);
        areaCode.put("\u5937\u9675\u533a", 420506);
        areaCode.put("\u8fdc\u5b89\u53bf", 420525);
        areaCode.put("\u5174\u5c71\u53bf", 420526);
        areaCode.put("\u79ed\u5f52\u53bf", 420527);
        areaCode.put("\u957f\u9633\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 420528);
        areaCode.put("\u4e94\u5cf0\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 420529);
        areaCode.put("\u5b9c\u90fd\u5e02", 420581);
        areaCode.put("\u5f53\u9633\u5e02", 420582);
        areaCode.put("\u679d\u6c5f\u5e02", 420583);
        areaCode.put("\u8944\u6a0a\u5e02", 420600);
        areaCode.put("\u5e02\u8f96\u533a", 420601);
        areaCode.put("\u8944\u57ce\u533a", 420602);
        areaCode.put("\u6a0a\u57ce\u533a", 420606);
        areaCode.put("\u8944\u9633\u533a", 420607);
        areaCode.put("\u5357\u6f33\u53bf", 420624);
        areaCode.put("\u8c37\u57ce\u53bf", 420625);
        areaCode.put("\u4fdd\u5eb7\u53bf", 420626);
        areaCode.put("\u8001\u6cb3\u53e3\u5e02", 420682);
        areaCode.put("\u67a3\u9633\u5e02", 420683);
        areaCode.put("\u5b9c\u57ce\u5e02", 420684);
        areaCode.put("\u9102\u5dde\u5e02", 420700);
        areaCode.put("\u5e02\u8f96\u533a", 420701);
        areaCode.put("\u6881\u5b50\u6e56\u533a", 420702);
        areaCode.put("\u534e\u5bb9\u533a", 420703);
        areaCode.put("\u9102\u57ce\u533a", 420704);
        areaCode.put("\u8346\u95e8\u5e02", 420800);
        areaCode.put("\u5e02\u8f96\u533a", 420801);
        areaCode.put("\u4e1c\u5b9d\u533a", 420802);
        areaCode.put("\u6387\u5200\u533a", 420804);
        areaCode.put("\u4eac\u5c71\u53bf", 420821);
        areaCode.put("\u6c99\u6d0b\u53bf", 420822);
        areaCode.put("\u949f\u7965\u5e02", 420881);
        areaCode.put("\u5b5d\u611f\u5e02", 420900);
        areaCode.put("\u5e02\u8f96\u533a", 420901);
        areaCode.put("\u5b5d\u5357\u533a", 420902);
        areaCode.put("\u5b5d\u660c\u53bf", 420921);
        areaCode.put("\u5927\u609f\u53bf", 420922);
        areaCode.put("\u4e91\u68a6\u53bf", 420923);
        areaCode.put("\u5e94\u57ce\u5e02", 420981);
        areaCode.put("\u5b89\u9646\u5e02", 420982);
        areaCode.put("\u6c49\u5ddd\u5e02", 420984);
        areaCode.put("\u8346\u5dde\u5e02", 421000);
        areaCode.put("\u5e02\u8f96\u533a", 421001);
        areaCode.put("\u6c99\u5e02\u533a", 421002);
        areaCode.put("\u8346\u5dde\u533a", 421003);
        areaCode.put("\u516c\u5b89\u53bf", 421022);
        areaCode.put("\u76d1\u5229\u53bf", 421023);
        areaCode.put("\u6c5f\u9675\u53bf", 421024);
        areaCode.put("\u77f3\u9996\u5e02", 421081);
        areaCode.put("\u6d2a\u6e56\u5e02", 421083);
        areaCode.put("\u677e\u6ecb\u5e02", 421087);
        areaCode.put("\u9ec4\u5188\u5e02", 421100);
        areaCode.put("\u5e02\u8f96\u533a", 421101);
        areaCode.put("\u9ec4\u5dde\u533a", 421102);
        areaCode.put("\u56e2\u98ce\u53bf", 421121);
        areaCode.put("\u7ea2\u5b89\u53bf", 421122);
        areaCode.put("\u7f57\u7530\u53bf", 421123);
        areaCode.put("\u82f1\u5c71\u53bf", 421124);
        areaCode.put("\u6d60\u6c34\u53bf", 421125);
        areaCode.put("\u8572\u6625\u53bf", 421126);
        areaCode.put("\u9ec4\u6885\u53bf", 421127);
        areaCode.put("\u9ebb\u57ce\u5e02", 421181);
        areaCode.put("\u6b66\u7a74\u5e02", 421182);
        areaCode.put("\u54b8\u5b81\u5e02", 421200);
        areaCode.put("\u5e02\u8f96\u533a", 421201);
        areaCode.put("\u54b8\u5b89\u533a", 421202);
        areaCode.put("\u5609\u9c7c\u53bf", 421221);
        areaCode.put("\u901a\u57ce\u53bf", 421222);
        areaCode.put("\u5d07\u9633\u53bf", 421223);
        areaCode.put("\u901a\u5c71\u53bf", 421224);
        areaCode.put("\u8d64\u58c1\u5e02", 421281);
        areaCode.put("\u968f\u5dde\u5e02", 421300);
        areaCode.put("\u5e02\u8f96\u533a", 421301);
        areaCode.put("\u66fe\u90fd\u533a (*)", 421303);
        areaCode.put("\u5e7f\u6c34\u5e02", 421381);
        areaCode.put("\u6069\u65bd\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 422800);
        areaCode.put("\u6069\u65bd\u5e02", 422801);
        areaCode.put("\u5229\u5ddd\u5e02", 422802);
        areaCode.put("\u5efa\u59cb\u53bf", 422822);
        areaCode.put("\u5df4\u4e1c\u53bf", 422823);
        areaCode.put("\u5ba3\u6069\u53bf", 422825);
        areaCode.put("\u54b8\u4e30\u53bf", 422826);
        areaCode.put("\u6765\u51e4\u53bf", 422827);
        areaCode.put("\u9e64\u5cf0\u53bf", 422828);
        areaCode.put("\u7701\u76f4\u8f96\u53bf\u7ea7\u884c\u653f\u533a\u5212", 429000);
        areaCode.put("\u4ed9\u6843\u5e02", 429004);
        areaCode.put("\u6f5c\u6c5f\u5e02", 429005);
        areaCode.put("\u5929\u95e8\u5e02", 429006);
        areaCode.put("\u795e\u519c\u67b6\u6797\u533a", 429021);
        areaCode.put("\u6e56\u5357\u7701", 430000);
        areaCode.put("\u957f\u6c99\u5e02", 430100);
        areaCode.put("\u5e02\u8f96\u533a", 430101);
        areaCode.put("\u8299\u84c9\u533a", 430102);
        areaCode.put("\u5929\u5fc3\u533a", 430103);
        areaCode.put("\u5cb3\u9e93\u533a", 430104);
        areaCode.put("\u5f00\u798f\u533a", 430105);
        areaCode.put("\u96e8\u82b1\u533a", 430111);
        areaCode.put("\u957f\u6c99\u53bf", 430121);
        areaCode.put("\u671b\u57ce\u53bf", 430122);
        areaCode.put("\u5b81\u4e61\u53bf", 430124);
        areaCode.put("\u6d4f\u9633\u5e02", 430181);
        areaCode.put("\u682a\u6d32\u5e02", 430200);
        areaCode.put("\u5e02\u8f96\u533a", 430201);
        areaCode.put("\u8377\u5858\u533a", 430202);
        areaCode.put("\u82a6\u6dde\u533a", 430203);
        areaCode.put("\u77f3\u5cf0\u533a", 430204);
        areaCode.put("\u5929\u5143\u533a", 430211);
        areaCode.put("\u682a\u6d32\u53bf", 430221);
        areaCode.put("\u6538\u3000\u53bf", 430223);
        areaCode.put("\u8336\u9675\u53bf", 430224);
        areaCode.put("\u708e\u9675\u53bf", 430225);
        areaCode.put("\u91b4\u9675\u5e02", 430281);
        areaCode.put("\u6e58\u6f6d\u5e02", 430300);
        areaCode.put("\u5e02\u8f96\u533a", 430301);
        areaCode.put("\u96e8\u6e56\u533a", 430302);
        areaCode.put("\u5cb3\u5858\u533a", 430304);
        areaCode.put("\u6e58\u6f6d\u53bf", 430321);
        areaCode.put("\u6e58\u4e61\u5e02", 430381);
        areaCode.put("\u97f6\u5c71\u5e02", 430382);
        areaCode.put("\u8861\u9633\u5e02", 430400);
        areaCode.put("\u5e02\u8f96\u533a", 430401);
        areaCode.put("\u73e0\u6656\u533a", 430405);
        areaCode.put("\u96c1\u5cf0\u533a", 430406);
        areaCode.put("\u77f3\u9f13\u533a", 430407);
        areaCode.put("\u84b8\u6e58\u533a", 430408);
        areaCode.put("\u5357\u5cb3\u533a", 430412);
        areaCode.put("\u8861\u9633\u53bf", 430421);
        areaCode.put("\u8861\u5357\u53bf", 430422);
        areaCode.put("\u8861\u5c71\u53bf", 430423);
        areaCode.put("\u8861\u4e1c\u53bf", 430424);
        areaCode.put("\u7941\u4e1c\u53bf", 430426);
        areaCode.put("\u8012\u9633\u5e02", 430481);
        areaCode.put("\u5e38\u5b81\u5e02", 430482);
        areaCode.put("\u90b5\u9633\u5e02", 430500);
        areaCode.put("\u5e02\u8f96\u533a", 430501);
        areaCode.put("\u53cc\u6e05\u533a", 430502);
        areaCode.put("\u5927\u7965\u533a", 430503);
        areaCode.put("\u5317\u5854\u533a", 430511);
        areaCode.put("\u90b5\u4e1c\u53bf", 430521);
        areaCode.put("\u65b0\u90b5\u53bf", 430522);
        areaCode.put("\u90b5\u9633\u53bf", 430523);
        areaCode.put("\u9686\u56de\u53bf", 430524);
        areaCode.put("\u6d1e\u53e3\u53bf", 430525);
        areaCode.put("\u7ee5\u5b81\u53bf", 430527);
        areaCode.put("\u65b0\u5b81\u53bf", 430528);
        areaCode.put("\u57ce\u6b65\u82d7\u65cf\u81ea\u6cbb\u53bf", 430529);
        areaCode.put("\u6b66\u5188\u5e02", 430581);
        areaCode.put("\u5cb3\u9633\u5e02", 430600);
        areaCode.put("\u5e02\u8f96\u533a", 430601);
        areaCode.put("\u5cb3\u9633\u697c\u533a", 430602);
        areaCode.put("\u4e91\u6eaa\u533a", 430603);
        areaCode.put("\u541b\u5c71\u533a", 430611);
        areaCode.put("\u5cb3\u9633\u53bf", 430621);
        areaCode.put("\u534e\u5bb9\u53bf", 430623);
        areaCode.put("\u6e58\u9634\u53bf", 430624);
        areaCode.put("\u5e73\u6c5f\u53bf", 430626);
        areaCode.put("\u6c68\u7f57\u5e02", 430681);
        areaCode.put("\u4e34\u6e58\u5e02", 430682);
        areaCode.put("\u5e38\u5fb7\u5e02", 430700);
        areaCode.put("\u5e02\u8f96\u533a", 430701);
        areaCode.put("\u6b66\u9675\u533a", 430702);
        areaCode.put("\u9f0e\u57ce\u533a", 430703);
        areaCode.put("\u5b89\u4e61\u53bf", 430721);
        areaCode.put("\u6c49\u5bff\u53bf", 430722);
        areaCode.put("\u6fa7\u3000\u53bf", 430723);
        areaCode.put("\u4e34\u6fa7\u53bf", 430724);
        areaCode.put("\u6843\u6e90\u53bf", 430725);
        areaCode.put("\u77f3\u95e8\u53bf", 430726);
        areaCode.put("\u6d25\u5e02\u5e02", 430781);
        areaCode.put("\u5f20\u5bb6\u754c\u5e02", 430800);
        areaCode.put("\u5e02\u8f96\u533a", 430801);
        areaCode.put("\u6c38\u5b9a\u533a", 430802);
        areaCode.put("\u6b66\u9675\u6e90\u533a", 430811);
        areaCode.put("\u6148\u5229\u53bf", 430821);
        areaCode.put("\u6851\u690d\u53bf", 430822);
        areaCode.put("\u76ca\u9633\u5e02", 430900);
        areaCode.put("\u5e02\u8f96\u533a", 430901);
        areaCode.put("\u8d44\u9633\u533a", 430902);
        areaCode.put("\u8d6b\u5c71\u533a", 430903);
        areaCode.put("\u5357\u3000\u53bf", 430921);
        areaCode.put("\u6843\u6c5f\u53bf", 430922);
        areaCode.put("\u5b89\u5316\u53bf", 430923);
        areaCode.put("\u6c85\u6c5f\u5e02", 430981);
        areaCode.put("\u90f4\u5dde\u5e02", 431000);
        areaCode.put("\u5e02\u8f96\u533a", 431001);
        areaCode.put("\u5317\u6e56\u533a", 431002);
        areaCode.put("\u82cf\u4ed9\u533a", 431003);
        areaCode.put("\u6842\u9633\u53bf", 431021);
        areaCode.put("\u5b9c\u7ae0\u53bf", 431022);
        areaCode.put("\u6c38\u5174\u53bf", 431023);
        areaCode.put("\u5609\u79be\u53bf", 431024);
        areaCode.put("\u4e34\u6b66\u53bf", 431025);
        areaCode.put("\u6c5d\u57ce\u53bf", 431026);
        areaCode.put("\u6842\u4e1c\u53bf", 431027);
        areaCode.put("\u5b89\u4ec1\u53bf", 431028);
        areaCode.put("\u8d44\u5174\u5e02", 431081);
        areaCode.put("\u6c38\u5dde\u5e02", 431100);
        areaCode.put("\u5e02\u8f96\u533a", 431101);
        areaCode.put("\u96f6\u9675\u533a", 431102);
        areaCode.put("\u51b7\u6c34\u6ee9\u533a", 431103);
        areaCode.put("\u7941\u9633\u53bf", 431121);
        areaCode.put("\u4e1c\u5b89\u53bf", 431122);
        areaCode.put("\u53cc\u724c\u53bf", 431123);
        areaCode.put("\u9053\u3000\u53bf", 431124);
        areaCode.put("\u6c5f\u6c38\u53bf", 431125);
        areaCode.put("\u5b81\u8fdc\u53bf", 431126);
        areaCode.put("\u84dd\u5c71\u53bf", 431127);
        areaCode.put("\u65b0\u7530\u53bf", 431128);
        areaCode.put("\u6c5f\u534e\u7476\u65cf\u81ea\u6cbb\u53bf", 431129);
        areaCode.put("\u6000\u5316\u5e02", 431200);
        areaCode.put("\u5e02\u8f96\u533a", 431201);
        areaCode.put("\u9e64\u57ce\u533a", 431202);
        areaCode.put("\u4e2d\u65b9\u53bf", 431221);
        areaCode.put("\u6c85\u9675\u53bf", 431222);
        areaCode.put("\u8fb0\u6eaa\u53bf", 431223);
        areaCode.put("\u6e86\u6d66\u53bf", 431224);
        areaCode.put("\u4f1a\u540c\u53bf", 431225);
        areaCode.put("\u9ebb\u9633\u82d7\u65cf\u81ea\u6cbb\u53bf", 431226);
        areaCode.put("\u65b0\u6643\u4f97\u65cf\u81ea\u6cbb\u53bf", 431227);
        areaCode.put("\u82b7\u6c5f\u4f97\u65cf\u81ea\u6cbb\u53bf", 431228);
        areaCode.put("\u9756\u5dde\u82d7\u65cf\u4f97\u65cf\u81ea\u6cbb\u53bf", 431229);
        areaCode.put("\u901a\u9053\u4f97\u65cf\u81ea\u6cbb\u53bf", 431230);
        areaCode.put("\u6d2a\u6c5f\u5e02", 431281);
        areaCode.put("\u5a04\u5e95\u5e02", 431300);
        areaCode.put("\u5e02\u8f96\u533a", 431301);
        areaCode.put("\u5a04\u661f\u533a", 431302);
        areaCode.put("\u53cc\u5cf0\u53bf", 431321);
        areaCode.put("\u65b0\u5316\u53bf", 431322);
        areaCode.put("\u51b7\u6c34\u6c5f\u5e02", 431381);
        areaCode.put("\u6d9f\u6e90\u5e02", 431382);
        areaCode.put("\u6e58\u897f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 433100);
        areaCode.put("\u5409\u9996\u5e02", 433101);
        areaCode.put("\u6cf8\u6eaa\u53bf", 433122);
        areaCode.put("\u51e4\u51f0\u53bf", 433123);
        areaCode.put("\u82b1\u57a3\u53bf", 433124);
        areaCode.put("\u4fdd\u9756\u53bf", 433125);
        areaCode.put("\u53e4\u4e08\u53bf", 433126);
        areaCode.put("\u6c38\u987a\u53bf", 433127);
        areaCode.put("\u9f99\u5c71\u53bf", 433130);
        areaCode.put("\u5e7f\u4e1c\u7701", 440000);
        areaCode.put("\u5e7f\u5dde\u5e02", 440100);
        areaCode.put("\u5e02\u8f96\u533a", 440101);
        areaCode.put("\u8354\u6e7e\u533a", 440103);
        areaCode.put("\u8d8a\u79c0\u533a", 440104);
        areaCode.put("\u6d77\u73e0\u533a", 440105);
        areaCode.put("\u5929\u6cb3\u533a", 440106);
        areaCode.put("\u767d\u4e91\u533a", 440111);
        areaCode.put("\u9ec4\u57d4\u533a", 440112);
        areaCode.put("\u756a\u79ba\u533a", 440113);
        areaCode.put("\u82b1\u90fd\u533a", 440114);
        areaCode.put("\u5357\u6c99\u533a", 440115);
        areaCode.put("\u841d\u5c97\u533a", 440116);
        areaCode.put("\u589e\u57ce\u5e02", 440183);
        areaCode.put("\u4ece\u5316\u5e02", 440184);
        areaCode.put("\u97f6\u5173\u5e02", 440200);
        areaCode.put("\u5e02\u8f96\u533a", 440201);
        areaCode.put("\u6b66\u6c5f\u533a", 440203);
        areaCode.put("\u6d48\u6c5f\u533a", 440204);
        areaCode.put("\u66f2\u6c5f\u533a", 440205);
        areaCode.put("\u59cb\u5174\u53bf", 440222);
        areaCode.put("\u4ec1\u5316\u53bf", 440224);
        areaCode.put("\u7fc1\u6e90\u53bf", 440229);
        areaCode.put("\u4e73\u6e90\u7476\u65cf\u81ea\u6cbb\u53bf", 440232);
        areaCode.put("\u65b0\u4e30\u53bf", 440233);
        areaCode.put("\u4e50\u660c\u5e02", 440281);
        areaCode.put("\u5357\u96c4\u5e02", 440282);
        areaCode.put("\u6df1\u5733\u5e02", 440300);
        areaCode.put("\u5e02\u8f96\u533a", 440301);
        areaCode.put("\u7f57\u6e56\u533a", 440303);
        areaCode.put("\u798f\u7530\u533a", 440304);
        areaCode.put("\u5357\u5c71\u533a", 440305);
        areaCode.put("\u5b9d\u5b89\u533a", 440306);
        areaCode.put("\u9f99\u5c97\u533a", 440307);
        areaCode.put("\u76d0\u7530\u533a", 440308);
        areaCode.put("\u73e0\u6d77\u5e02", 440400);
        areaCode.put("\u5e02\u8f96\u533a", 440401);
        areaCode.put("\u9999\u6d32\u533a", 440402);
        areaCode.put("\u6597\u95e8\u533a", 440403);
        areaCode.put("\u91d1\u6e7e\u533a", 440404);
        areaCode.put("\u6c55\u5934\u5e02", 440500);
        areaCode.put("\u5e02\u8f96\u533a", 440501);
        areaCode.put("\u9f99\u6e56\u533a", 440507);
        areaCode.put("\u91d1\u5e73\u533a", 440511);
        areaCode.put("\u6fe0\u6c5f\u533a", 440512);
        areaCode.put("\u6f6e\u9633\u533a", 440513);
        areaCode.put("\u6f6e\u5357\u533a", 440514);
        areaCode.put("\u6f84\u6d77\u533a", 440515);
        areaCode.put("\u5357\u6fb3\u53bf", 440523);
        areaCode.put("\u4f5b\u5c71\u5e02", 440600);
        areaCode.put("\u5e02\u8f96\u533a", 440601);
        areaCode.put("\u7985\u57ce\u533a", 440604);
        areaCode.put("\u5357\u6d77\u533a", 440605);
        areaCode.put("\u987a\u5fb7\u533a", 440606);
        areaCode.put("\u4e09\u6c34\u533a", 440607);
        areaCode.put("\u9ad8\u660e\u533a", 440608);
        areaCode.put("\u6c5f\u95e8\u5e02", 440700);
        areaCode.put("\u5e02\u8f96\u533a", 440701);
        areaCode.put("\u84ec\u6c5f\u533a", 440703);
        areaCode.put("\u6c5f\u6d77\u533a", 440704);
        areaCode.put("\u65b0\u4f1a\u533a", 440705);
        areaCode.put("\u53f0\u5c71\u5e02", 440781);
        areaCode.put("\u5f00\u5e73\u5e02", 440783);
        areaCode.put("\u9e64\u5c71\u5e02", 440784);
        areaCode.put("\u6069\u5e73\u5e02", 440785);
        areaCode.put("\u6e5b\u6c5f\u5e02", 440800);
        areaCode.put("\u5e02\u8f96\u533a", 440801);
        areaCode.put("\u8d64\u574e\u533a", 440802);
        areaCode.put("\u971e\u5c71\u533a", 440803);
        areaCode.put("\u5761\u5934\u533a", 440804);
        areaCode.put("\u9ebb\u7ae0\u533a", 440811);
        areaCode.put("\u9042\u6eaa\u53bf", 440823);
        areaCode.put("\u5f90\u95fb\u53bf", 440825);
        areaCode.put("\u5ec9\u6c5f\u5e02", 440881);
        areaCode.put("\u96f7\u5dde\u5e02", 440882);
        areaCode.put("\u5434\u5ddd\u5e02", 440883);
        areaCode.put("\u8302\u540d\u5e02", 440900);
        areaCode.put("\u5e02\u8f96\u533a", 440901);
        areaCode.put("\u8302\u5357\u533a", 440902);
        areaCode.put("\u8302\u6e2f\u533a", 440903);
        areaCode.put("\u7535\u767d\u53bf", 440923);
        areaCode.put("\u9ad8\u5dde\u5e02", 440981);
        areaCode.put("\u5316\u5dde\u5e02", 440982);
        areaCode.put("\u4fe1\u5b9c\u5e02", 440983);
        areaCode.put("\u8087\u5e86\u5e02", 441200);
        areaCode.put("\u5e02\u8f96\u533a", 441201);
        areaCode.put("\u7aef\u5dde\u533a", 441202);
        areaCode.put("\u9f0e\u6e56\u533a", 441203);
        areaCode.put("\u5e7f\u5b81\u53bf", 441223);
        areaCode.put("\u6000\u96c6\u53bf", 441224);
        areaCode.put("\u5c01\u5f00\u53bf", 441225);
        areaCode.put("\u5fb7\u5e86\u53bf", 441226);
        areaCode.put("\u9ad8\u8981\u5e02", 441283);
        areaCode.put("\u56db\u4f1a\u5e02", 441284);
        areaCode.put("\u60e0\u5dde\u5e02", 441300);
        areaCode.put("\u5e02\u8f96\u533a", 441301);
        areaCode.put("\u60e0\u57ce\u533a", 441302);
        areaCode.put("\u60e0\u9633\u533a", 441303);
        areaCode.put("\u535a\u7f57\u53bf", 441322);
        areaCode.put("\u60e0\u4e1c\u53bf", 441323);
        areaCode.put("\u9f99\u95e8\u53bf", 441324);
        areaCode.put("\u6885\u5dde\u5e02", 441400);
        areaCode.put("\u5e02\u8f96\u533a", 441401);
        areaCode.put("\u6885\u6c5f\u533a", 441402);
        areaCode.put("\u6885\u3000\u53bf", 441421);
        areaCode.put("\u5927\u57d4\u53bf", 441422);
        areaCode.put("\u4e30\u987a\u53bf", 441423);
        areaCode.put("\u4e94\u534e\u53bf", 441424);
        areaCode.put("\u5e73\u8fdc\u53bf", 441426);
        areaCode.put("\u8549\u5cad\u53bf", 441427);
        areaCode.put("\u5174\u5b81\u5e02", 441481);
        areaCode.put("\u6c55\u5c3e\u5e02", 441500);
        areaCode.put("\u5e02\u8f96\u533a", 441501);
        areaCode.put("\u57ce\u3000\u533a", 441502);
        areaCode.put("\u6d77\u4e30\u53bf", 441521);
        areaCode.put("\u9646\u6cb3\u53bf", 441523);
        areaCode.put("\u9646\u4e30\u5e02", 441581);
        areaCode.put("\u6cb3\u6e90\u5e02", 441600);
        areaCode.put("\u5e02\u8f96\u533a", 441601);
        areaCode.put("\u6e90\u57ce\u533a", 441602);
        areaCode.put("\u7d2b\u91d1\u53bf", 441621);
        areaCode.put("\u9f99\u5ddd\u53bf", 441622);
        areaCode.put("\u8fde\u5e73\u53bf", 441623);
        areaCode.put("\u548c\u5e73\u53bf", 441624);
        areaCode.put("\u4e1c\u6e90\u53bf", 441625);
        areaCode.put("\u9633\u6c5f\u5e02", 441700);
        areaCode.put("\u5e02\u8f96\u533a", 441701);
        areaCode.put("\u6c5f\u57ce\u533a", 441702);
        areaCode.put("\u9633\u897f\u53bf", 441721);
        areaCode.put("\u9633\u4e1c\u53bf", 441723);
        areaCode.put("\u9633\u6625\u5e02", 441781);
        areaCode.put("\u6e05\u8fdc\u5e02", 441800);
        areaCode.put("\u5e02\u8f96\u533a", 441801);
        areaCode.put("\u6e05\u57ce\u533a", 441802);
        areaCode.put("\u4f5b\u5188\u53bf", 441821);
        areaCode.put("\u9633\u5c71\u53bf", 441823);
        areaCode.put("\u8fde\u5c71\u58ee\u65cf\u7476\u65cf\u81ea\u6cbb\u53bf", 441825);
        areaCode.put("\u8fde\u5357\u7476\u65cf\u81ea\u6cbb\u53bf", 441826);
        areaCode.put("\u6e05\u65b0\u53bf", 441827);
        areaCode.put("\u82f1\u5fb7\u5e02", 441881);
        areaCode.put("\u8fde\u5dde\u5e02", 441882);
        areaCode.put("\u4e1c\u839e\u5e02", 441900);
        areaCode.put("\u4e2d\u5c71\u5e02", 442000);
        areaCode.put("\u6f6e\u5dde\u5e02", 445100);
        areaCode.put("\u5e02\u8f96\u533a", 445101);
        areaCode.put("\u6e58\u6865\u533a", 445102);
        areaCode.put("\u6f6e\u5b89\u53bf", 445121);
        areaCode.put("\u9976\u5e73\u53bf", 445122);
        areaCode.put("\u63ed\u9633\u5e02", 445200);
        areaCode.put("\u5e02\u8f96\u533a", 445201);
        areaCode.put("\u6995\u57ce\u533a", 445202);
        areaCode.put("\u63ed\u4e1c\u53bf", 445221);
        areaCode.put("\u63ed\u897f\u53bf", 445222);
        areaCode.put("\u60e0\u6765\u53bf", 445224);
        areaCode.put("\u666e\u5b81\u5e02", 445281);
        areaCode.put("\u4e91\u6d6e\u5e02", 445300);
        areaCode.put("\u5e02\u8f96\u533a", 445301);
        areaCode.put("\u4e91\u57ce\u533a", 445302);
        areaCode.put("\u65b0\u5174\u53bf", 445321);
        areaCode.put("\u90c1\u5357\u53bf", 445322);
        areaCode.put("\u4e91\u5b89\u53bf", 445323);
        areaCode.put("\u7f57\u5b9a\u5e02", 445381);
        areaCode.put("\u5e7f\u897f\u58ee\u65cf\u81ea\u6cbb\u533a", 450000);
        areaCode.put("\u5357\u5b81\u5e02", 450100);
        areaCode.put("\u5e02\u8f96\u533a", 450101);
        areaCode.put("\u5174\u5b81\u533a", 450102);
        areaCode.put("\u9752\u79c0\u533a", 450103);
        areaCode.put("\u6c5f\u5357\u533a", 450105);
        areaCode.put("\u897f\u4e61\u5858\u533a", 450107);
        areaCode.put("\u826f\u5e86\u533a", 450108);
        areaCode.put("\u9095\u5b81\u533a", 450109);
        areaCode.put("\u6b66\u9e23\u53bf", 450122);
        areaCode.put("\u9686\u5b89\u53bf", 450123);
        areaCode.put("\u9a6c\u5c71\u53bf", 450124);
        areaCode.put("\u4e0a\u6797\u53bf", 450125);
        areaCode.put("\u5bbe\u9633\u53bf", 450126);
        areaCode.put("\u6a2a\u3000\u53bf", 450127);
        areaCode.put("\u67f3\u5dde\u5e02", 450200);
        areaCode.put("\u5e02\u8f96\u533a", 450201);
        areaCode.put("\u57ce\u4e2d\u533a", 450202);
        areaCode.put("\u9c7c\u5cf0\u533a", 450203);
        areaCode.put("\u67f3\u5357\u533a", 450204);
        areaCode.put("\u67f3\u5317\u533a", 450205);
        areaCode.put("\u67f3\u6c5f\u53bf", 450221);
        areaCode.put("\u67f3\u57ce\u53bf", 450222);
        areaCode.put("\u9e7f\u5be8\u53bf", 450223);
        areaCode.put("\u878d\u5b89\u53bf", 450224);
        areaCode.put("\u878d\u6c34\u82d7\u65cf\u81ea\u6cbb\u53bf", 450225);
        areaCode.put("\u4e09\u6c5f\u4f97\u65cf\u81ea\u6cbb\u53bf", 450226);
        areaCode.put("\u6842\u6797\u5e02", 450300);
        areaCode.put("\u5e02\u8f96\u533a", 450301);
        areaCode.put("\u79c0\u5cf0\u533a", 450302);
        areaCode.put("\u53e0\u5f69\u533a", 450303);
        areaCode.put("\u8c61\u5c71\u533a", 450304);
        areaCode.put("\u4e03\u661f\u533a", 450305);
        areaCode.put("\u96c1\u5c71\u533a", 450311);
        areaCode.put("\u9633\u6714\u53bf", 450321);
        areaCode.put("\u4e34\u6842\u53bf", 450322);
        areaCode.put("\u7075\u5ddd\u53bf", 450323);
        areaCode.put("\u5168\u5dde\u53bf", 450324);
        areaCode.put("\u5174\u5b89\u53bf", 450325);
        areaCode.put("\u6c38\u798f\u53bf", 450326);
        areaCode.put("\u704c\u9633\u53bf", 450327);
        areaCode.put("\u9f99\u80dc\u5404\u65cf\u81ea\u6cbb\u53bf", 450328);
        areaCode.put("\u8d44\u6e90\u53bf", 450329);
        areaCode.put("\u5e73\u4e50\u53bf", 450330);
        areaCode.put("\u8354\u84b2\u53bf", 450331);
        areaCode.put("\u606d\u57ce\u7476\u65cf\u81ea\u6cbb\u53bf", 450332);
        areaCode.put("\u68a7\u5dde\u5e02", 450400);
        areaCode.put("\u5e02\u8f96\u533a", 450401);
        areaCode.put("\u4e07\u79c0\u533a", 450403);
        areaCode.put("\u8776\u5c71\u533a", 450404);
        areaCode.put("\u957f\u6d32\u533a", 450405);
        areaCode.put("\u82cd\u68a7\u53bf", 450421);
        areaCode.put("\u85e4\u3000\u53bf", 450422);
        areaCode.put("\u8499\u5c71\u53bf", 450423);
        areaCode.put("\u5c91\u6eaa\u5e02", 450481);
        areaCode.put("\u5317\u6d77\u5e02", 450500);
        areaCode.put("\u5e02\u8f96\u533a", 450501);
        areaCode.put("\u6d77\u57ce\u533a", 450502);
        areaCode.put("\u94f6\u6d77\u533a", 450503);
        areaCode.put("\u94c1\u5c71\u6e2f\u533a", 450512);
        areaCode.put("\u5408\u6d66\u53bf", 450521);
        areaCode.put("\u9632\u57ce\u6e2f\u5e02", 450600);
        areaCode.put("\u5e02\u8f96\u533a", 450601);
        areaCode.put("\u6e2f\u53e3\u533a", 450602);
        areaCode.put("\u9632\u57ce\u533a", 450603);
        areaCode.put("\u4e0a\u601d\u53bf", 450621);
        areaCode.put("\u4e1c\u5174\u5e02", 450681);
        areaCode.put("\u94a6\u5dde\u5e02", 450700);
        areaCode.put("\u5e02\u8f96\u533a", 450701);
        areaCode.put("\u94a6\u5357\u533a", 450702);
        areaCode.put("\u94a6\u5317\u533a", 450703);
        areaCode.put("\u7075\u5c71\u53bf", 450721);
        areaCode.put("\u6d66\u5317\u53bf", 450722);
        areaCode.put("\u8d35\u6e2f\u5e02", 450800);
        areaCode.put("\u5e02\u8f96\u533a", 450801);
        areaCode.put("\u6e2f\u5317\u533a", 450802);
        areaCode.put("\u6e2f\u5357\u533a", 450803);
        areaCode.put("\u8983\u5858\u533a", 450804);
        areaCode.put("\u5e73\u5357\u53bf", 450821);
        areaCode.put("\u6842\u5e73\u5e02", 450881);
        areaCode.put("\u7389\u6797\u5e02", 450900);
        areaCode.put("\u5e02\u8f96\u533a", 450901);
        areaCode.put("\u7389\u5dde\u533a", 450902);
        areaCode.put("\u5bb9\u3000\u53bf", 450921);
        areaCode.put("\u9646\u5ddd\u53bf", 450922);
        areaCode.put("\u535a\u767d\u53bf", 450923);
        areaCode.put("\u5174\u4e1a\u53bf", 450924);
        areaCode.put("\u5317\u6d41\u5e02", 450981);
        areaCode.put("\u767e\u8272\u5e02", 451000);
        areaCode.put("\u5e02\u8f96\u533a", 451001);
        areaCode.put("\u53f3\u6c5f\u533a", 451002);
        areaCode.put("\u7530\u9633\u53bf", 451021);
        areaCode.put("\u7530\u4e1c\u53bf", 451022);
        areaCode.put("\u5e73\u679c\u53bf", 451023);
        areaCode.put("\u5fb7\u4fdd\u53bf", 451024);
        areaCode.put("\u9756\u897f\u53bf", 451025);
        areaCode.put("\u90a3\u5761\u53bf", 451026);
        areaCode.put("\u51cc\u4e91\u53bf", 451027);
        areaCode.put("\u4e50\u4e1a\u53bf", 451028);
        areaCode.put("\u7530\u6797\u53bf", 451029);
        areaCode.put("\u897f\u6797\u53bf", 451030);
        areaCode.put("\u9686\u6797\u5404\u65cf\u81ea\u6cbb\u53bf", 451031);
        areaCode.put("\u8d3a\u5dde\u5e02", 451100);
        areaCode.put("\u5e02\u8f96\u533a", 451101);
        areaCode.put("\u516b\u6b65\u533a", 451102);
        areaCode.put("\u662d\u5e73\u53bf", 451121);
        areaCode.put("\u949f\u5c71\u53bf", 451122);
        areaCode.put("\u5bcc\u5ddd\u7476\u65cf\u81ea\u6cbb\u53bf", 451123);
        areaCode.put("\u6cb3\u6c60\u5e02", 451200);
        areaCode.put("\u5e02\u8f96\u533a", 451201);
        areaCode.put("\u91d1\u57ce\u6c5f\u533a", 451202);
        areaCode.put("\u5357\u4e39\u53bf", 451221);
        areaCode.put("\u5929\u5ce8\u53bf", 451222);
        areaCode.put("\u51e4\u5c71\u53bf", 451223);
        areaCode.put("\u4e1c\u5170\u53bf", 451224);
        areaCode.put("\u7f57\u57ce\u4eeb\u4f6c\u65cf\u81ea\u6cbb\u53bf", 451225);
        areaCode.put("\u73af\u6c5f\u6bdb\u5357\u65cf\u81ea\u6cbb\u53bf", 451226);
        areaCode.put("\u5df4\u9a6c\u7476\u65cf\u81ea\u6cbb\u53bf", 451227);
        areaCode.put("\u90fd\u5b89\u7476\u65cf\u81ea\u6cbb\u53bf", 451228);
        areaCode.put("\u5927\u5316\u7476\u65cf\u81ea\u6cbb\u53bf", 451229);
        areaCode.put("\u5b9c\u5dde\u5e02", 451281);
        areaCode.put("\u6765\u5bbe\u5e02", 451300);
        areaCode.put("\u5e02\u8f96\u533a", 451301);
        areaCode.put("\u5174\u5bbe\u533a", 451302);
        areaCode.put("\u5ffb\u57ce\u53bf", 451321);
        areaCode.put("\u8c61\u5dde\u53bf", 451322);
        areaCode.put("\u6b66\u5ba3\u53bf", 451323);
        areaCode.put("\u91d1\u79c0\u7476\u65cf\u81ea\u6cbb\u53bf", 451324);
        areaCode.put("\u5408\u5c71\u5e02", 451381);
        areaCode.put("\u5d07\u5de6\u5e02", 451400);
        areaCode.put("\u5e02\u8f96\u533a", 451401);
        areaCode.put("\u6c5f\u6d32\u533a", 451402);
        areaCode.put("\u6276\u7ee5\u53bf", 451421);
        areaCode.put("\u5b81\u660e\u53bf", 451422);
        areaCode.put("\u9f99\u5dde\u53bf", 451423);
        areaCode.put("\u5927\u65b0\u53bf", 451424);
        areaCode.put("\u5929\u7b49\u53bf", 451425);
        areaCode.put("\u51ed\u7965\u5e02", 451481);
        areaCode.put("\u6d77\u5357\u7701", 460000);
        areaCode.put("\u6d77\u53e3\u5e02", 460100);
        areaCode.put("\u5e02\u8f96\u533a", 460101);
        areaCode.put("\u79c0\u82f1\u533a", 460105);
        areaCode.put("\u9f99\u534e\u533a", 460106);
        areaCode.put("\u743c\u5c71\u533a", 460107);
        areaCode.put("\u7f8e\u5170\u533a", 460108);
        areaCode.put("\u4e09\u4e9a\u5e02", 460200);
        areaCode.put("\u5e02\u8f96\u533a", 460201);
        areaCode.put("\u7701\u76f4\u8f96\u53bf\u7ea7\u884c\u653f\u533a\u5212", 469000);
        areaCode.put("\u4e94\u6307\u5c71\u5e02", 469001);
        areaCode.put("\u743c\u6d77\u5e02", 469002);
        areaCode.put("\u510b\u5dde\u5e02", 469003);
        areaCode.put("\u6587\u660c\u5e02", 469005);
        areaCode.put("\u4e07\u5b81\u5e02", 469006);
        areaCode.put("\u4e1c\u65b9\u5e02", 469007);
        areaCode.put("\u5b9a\u5b89\u53bf", 469021);
        areaCode.put("\u5c6f\u660c\u53bf", 469022);
        areaCode.put("\u6f84\u8fc8\u53bf", 469023);
        areaCode.put("\u4e34\u9ad8\u53bf", 469024);
        areaCode.put("\u767d\u6c99\u9ece\u65cf\u81ea\u6cbb\u53bf", 469025);
        areaCode.put("\u660c\u6c5f\u9ece\u65cf\u81ea\u6cbb\u53bf", 469026);
        areaCode.put("\u4e50\u4e1c\u9ece\u65cf\u81ea\u6cbb\u53bf", 469027);
        areaCode.put("\u9675\u6c34\u9ece\u65cf\u81ea\u6cbb\u53bf", 469028);
        areaCode.put("\u4fdd\u4ead\u9ece\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 469029);
        areaCode.put("\u743c\u4e2d\u9ece\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 469030);
        areaCode.put("\u897f\u6c99\u7fa4\u5c9b", 469031);
        areaCode.put("\u5357\u6c99\u7fa4\u5c9b", 469032);
        areaCode.put("\u4e2d\u6c99\u7fa4\u5c9b\u7684\u5c9b\u7901\u53ca\u5176\u6d77\u57df", 469033);
        areaCode.put("\u91cd\u5e86\u5e02", 500000);
        areaCode.put("\u5e02\u8f96\u533a", 500100);
        areaCode.put("\u4e07\u5dde\u533a", 500101);
        areaCode.put("\u6daa\u9675\u533a", 500102);
        areaCode.put("\u6e1d\u4e2d\u533a", 500103);
        areaCode.put("\u5927\u6e21\u53e3\u533a", 500104);
        areaCode.put("\u6c5f\u5317\u533a", 500105);
        areaCode.put("\u6c99\u576a\u575d\u533a", 500106);
        areaCode.put("\u4e5d\u9f99\u5761\u533a", 500107);
        areaCode.put("\u5357\u5cb8\u533a", 500108);
        areaCode.put("\u5317\u789a\u533a", 500109);
        areaCode.put("\u4e07\u76db\u533a", 500110);
        areaCode.put("\u53cc\u6865\u533a", 500111);
        areaCode.put("\u6e1d\u5317\u533a", 500112);
        areaCode.put("\u5df4\u5357\u533a", 500113);
        areaCode.put("\u9ed4\u6c5f\u533a", 500114);
        areaCode.put("\u957f\u5bff\u533a", 500115);
        areaCode.put("\u6c5f\u6d25\u533a", 500116);
        areaCode.put("\u5408\u5ddd\u533a", 500117);
        areaCode.put("\u6c38\u5ddd\u533a", 500118);
        areaCode.put("\u5357\u5ddd\u533a", 500119);
        areaCode.put("\u53bf", 500200);
        areaCode.put("\u7da6\u6c5f\u53bf", 500222);
        areaCode.put("\u6f7c\u5357\u53bf", 500223);
        areaCode.put("\u94dc\u6881\u53bf", 500224);
        areaCode.put("\u5927\u8db3\u53bf", 500225);
        areaCode.put("\u8363\u660c\u53bf", 500226);
        areaCode.put("\u74a7\u5c71\u53bf", 500227);
        areaCode.put("\u6881\u5e73\u53bf", 500228);
        areaCode.put("\u57ce\u53e3\u53bf", 500229);
        areaCode.put("\u4e30\u90fd\u53bf", 500230);
        areaCode.put("\u57ab\u6c5f\u53bf", 500231);
        areaCode.put("\u6b66\u9686\u53bf", 500232);
        areaCode.put("\u5fe0\u3000\u53bf", 500233);
        areaCode.put("\u5f00\u3000\u53bf", 500234);
        areaCode.put("\u4e91\u9633\u53bf", 500235);
        areaCode.put("\u5949\u8282\u53bf", 500236);
        areaCode.put("\u5deb\u5c71\u53bf", 500237);
        areaCode.put("\u5deb\u6eaa\u53bf", 500238);
        areaCode.put("\u77f3\u67f1\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 500240);
        areaCode.put("\u79c0\u5c71\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 500241);
        areaCode.put("\u9149\u9633\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 500242);
        areaCode.put("\u5f6d\u6c34\u82d7\u65cf\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 500243);
        areaCode.put("\u56db\u5ddd\u7701", 510000);
        areaCode.put("\u6210\u90fd\u5e02", 510100);
        areaCode.put("\u5e02\u8f96\u533a", 510101);
        areaCode.put("\u9526\u6c5f\u533a", 510104);
        areaCode.put("\u9752\u7f8a\u533a", 510105);
        areaCode.put("\u91d1\u725b\u533a", 510106);
        areaCode.put("\u6b66\u4faf\u533a", 510107);
        areaCode.put("\u6210\u534e\u533a", 510108);
        areaCode.put("\u9f99\u6cc9\u9a7f\u533a", 510112);
        areaCode.put("\u9752\u767d\u6c5f\u533a", 510113);
        areaCode.put("\u65b0\u90fd\u533a", 510114);
        areaCode.put("\u6e29\u6c5f\u533a", 510115);
        areaCode.put("\u91d1\u5802\u53bf", 510121);
        areaCode.put("\u53cc\u6d41\u53bf", 510122);
        areaCode.put("\u90eb\u3000\u53bf", 510124);
        areaCode.put("\u5927\u9091\u53bf", 510129);
        areaCode.put("\u84b2\u6c5f\u53bf", 510131);
        areaCode.put("\u65b0\u6d25\u53bf", 510132);
        areaCode.put("\u90fd\u6c5f\u5830\u5e02", 510181);
        areaCode.put("\u5f6d\u5dde\u5e02", 510182);
        areaCode.put("\u909b\u5d03\u5e02", 510183);
        areaCode.put("\u5d07\u5dde\u5e02", 510184);
        areaCode.put("\u81ea\u8d21\u5e02", 510300);
        areaCode.put("\u5e02\u8f96\u533a", 510301);
        areaCode.put("\u81ea\u6d41\u4e95\u533a", 510302);
        areaCode.put("\u8d21\u4e95\u533a", 510303);
        areaCode.put("\u5927\u5b89\u533a", 510304);
        areaCode.put("\u6cbf\u6ee9\u533a", 510311);
        areaCode.put("\u8363\u3000\u53bf", 510321);
        areaCode.put("\u5bcc\u987a\u53bf", 510322);
        areaCode.put("\u6500\u679d\u82b1\u5e02", 510400);
        areaCode.put("\u5e02\u8f96\u533a", 510401);
        areaCode.put("\u4e1c\u3000\u533a", 510402);
        areaCode.put("\u897f\u3000\u533a", 510403);
        areaCode.put("\u4ec1\u548c\u533a", 510411);
        areaCode.put("\u7c73\u6613\u53bf", 510421);
        areaCode.put("\u76d0\u8fb9\u53bf", 510422);
        areaCode.put("\u6cf8\u5dde\u5e02", 510500);
        areaCode.put("\u5e02\u8f96\u533a", 510501);
        areaCode.put("\u6c5f\u9633\u533a", 510502);
        areaCode.put("\u7eb3\u6eaa\u533a", 510503);
        areaCode.put("\u9f99\u9a6c\u6f6d\u533a", 510504);
        areaCode.put("\u6cf8\u3000\u53bf", 510521);
        areaCode.put("\u5408\u6c5f\u53bf", 510522);
        areaCode.put("\u53d9\u6c38\u53bf", 510524);
        areaCode.put("\u53e4\u853a\u53bf", 510525);
        areaCode.put("\u5fb7\u9633\u5e02", 510600);
        areaCode.put("\u5e02\u8f96\u533a", 510601);
        areaCode.put("\u65cc\u9633\u533a", 510603);
        areaCode.put("\u4e2d\u6c5f\u53bf", 510623);
        areaCode.put("\u7f57\u6c5f\u53bf", 510626);
        areaCode.put("\u5e7f\u6c49\u5e02", 510681);
        areaCode.put("\u4ec0\u90a1\u5e02", 510682);
        areaCode.put("\u7ef5\u7af9\u5e02", 510683);
        areaCode.put("\u7ef5\u9633\u5e02", 510700);
        areaCode.put("\u5e02\u8f96\u533a", 510701);
        areaCode.put("\u6daa\u57ce\u533a", 510703);
        areaCode.put("\u6e38\u4ed9\u533a", 510704);
        areaCode.put("\u4e09\u53f0\u53bf", 510722);
        areaCode.put("\u76d0\u4ead\u53bf", 510723);
        areaCode.put("\u5b89\u3000\u53bf", 510724);
        areaCode.put("\u6893\u6f7c\u53bf", 510725);
        areaCode.put("\u5317\u5ddd\u7f8c\u65cf\u81ea\u6cbb\u53bf", 510726);
        areaCode.put("\u5e73\u6b66\u53bf", 510727);
        areaCode.put("\u6c5f\u6cb9\u5e02", 510781);
        areaCode.put("\u5e7f\u5143\u5e02", 510800);
        areaCode.put("\u5e02\u8f96\u533a", 510801);
        areaCode.put("\u5229\u5dde\u533a", 510802);
        areaCode.put("\u5143\u575d\u533a", 510811);
        areaCode.put("\u671d\u5929\u533a", 510812);
        areaCode.put("\u65fa\u82cd\u53bf", 510821);
        areaCode.put("\u9752\u5ddd\u53bf", 510822);
        areaCode.put("\u5251\u9601\u53bf", 510823);
        areaCode.put("\u82cd\u6eaa\u53bf", 510824);
        areaCode.put("\u9042\u5b81\u5e02", 510900);
        areaCode.put("\u5e02\u8f96\u533a", 510901);
        areaCode.put("\u8239\u5c71\u533a", 510903);
        areaCode.put("\u5b89\u5c45\u533a", 510904);
        areaCode.put("\u84ec\u6eaa\u53bf", 510921);
        areaCode.put("\u5c04\u6d2a\u53bf", 510922);
        areaCode.put("\u5927\u82f1\u53bf", 510923);
        areaCode.put("\u5185\u6c5f\u5e02", 511000);
        areaCode.put("\u5e02\u8f96\u533a", 511001);
        areaCode.put("\u5e02\u4e2d\u533a", 511002);
        areaCode.put("\u4e1c\u5174\u533a", 511011);
        areaCode.put("\u5a01\u8fdc\u53bf", 511024);
        areaCode.put("\u8d44\u4e2d\u53bf", 511025);
        areaCode.put("\u9686\u660c\u53bf", 511028);
        areaCode.put("\u4e50\u5c71\u5e02", 511100);
        areaCode.put("\u5e02\u8f96\u533a", 511101);
        areaCode.put("\u5e02\u4e2d\u533a", 511102);
        areaCode.put("\u6c99\u6e7e\u533a", 511111);
        areaCode.put("\u4e94\u901a\u6865\u533a", 511112);
        areaCode.put("\u91d1\u53e3\u6cb3\u533a", 511113);
        areaCode.put("\u728d\u4e3a\u53bf", 511123);
        areaCode.put("\u4e95\u7814\u53bf", 511124);
        areaCode.put("\u5939\u6c5f\u53bf", 511126);
        areaCode.put("\u6c90\u5ddd\u53bf", 511129);
        areaCode.put("\u5ce8\u8fb9\u5f5d\u65cf\u81ea\u6cbb\u53bf", 511132);
        areaCode.put("\u9a6c\u8fb9\u5f5d\u65cf\u81ea\u6cbb\u53bf", 511133);
        areaCode.put("\u5ce8\u7709\u5c71\u5e02", 511181);
        areaCode.put("\u5357\u5145\u5e02", 511300);
        areaCode.put("\u5e02\u8f96\u533a", 511301);
        areaCode.put("\u987a\u5e86\u533a", 511302);
        areaCode.put("\u9ad8\u576a\u533a", 511303);
        areaCode.put("\u5609\u9675\u533a", 511304);
        areaCode.put("\u5357\u90e8\u53bf", 511321);
        areaCode.put("\u8425\u5c71\u53bf", 511322);
        areaCode.put("\u84ec\u5b89\u53bf", 511323);
        areaCode.put("\u4eea\u9647\u53bf", 511324);
        areaCode.put("\u897f\u5145\u53bf", 511325);
        areaCode.put("\u9606\u4e2d\u5e02", 511381);
        areaCode.put("\u7709\u5c71\u5e02", 511400);
        areaCode.put("\u5e02\u8f96\u533a", 511401);
        areaCode.put("\u4e1c\u5761\u533a", 511402);
        areaCode.put("\u4ec1\u5bff\u53bf", 511421);
        areaCode.put("\u5f6d\u5c71\u53bf", 511422);
        areaCode.put("\u6d2a\u96c5\u53bf", 511423);
        areaCode.put("\u4e39\u68f1\u53bf", 511424);
        areaCode.put("\u9752\u795e\u53bf", 511425);
        areaCode.put("\u5b9c\u5bbe\u5e02", 511500);
        areaCode.put("\u5e02\u8f96\u533a", 511501);
        areaCode.put("\u7fe0\u5c4f\u533a", 511502);
        areaCode.put("\u5b9c\u5bbe\u53bf", 511521);
        areaCode.put("\u5357\u6eaa\u53bf", 511522);
        areaCode.put("\u6c5f\u5b89\u53bf", 511523);
        areaCode.put("\u957f\u5b81\u53bf", 511524);
        areaCode.put("\u9ad8\u3000\u53bf", 511525);
        areaCode.put("\u73d9\u3000\u53bf", 511526);
        areaCode.put("\u7b60\u8fde\u53bf", 511527);
        areaCode.put("\u5174\u6587\u53bf", 511528);
        areaCode.put("\u5c4f\u5c71\u53bf", 511529);
        areaCode.put("\u5e7f\u5b89\u5e02", 511600);
        areaCode.put("\u5e02\u8f96\u533a", 511601);
        areaCode.put("\u5e7f\u5b89\u533a", 511602);
        areaCode.put("\u5cb3\u6c60\u53bf", 511621);
        areaCode.put("\u6b66\u80dc\u53bf", 511622);
        areaCode.put("\u90bb\u6c34\u53bf", 511623);
        areaCode.put("\u534e\u84e5\u5e02", 511681);
        areaCode.put("\u8fbe\u5dde\u5e02", 511700);
        areaCode.put("\u5e02\u8f96\u533a", 511701);
        areaCode.put("\u901a\u5ddd\u533a", 511702);
        areaCode.put("\u8fbe\u3000\u53bf", 511721);
        areaCode.put("\u5ba3\u6c49\u53bf", 511722);
        areaCode.put("\u5f00\u6c5f\u53bf", 511723);
        areaCode.put("\u5927\u7af9\u53bf", 511724);
        areaCode.put("\u6e20\u3000\u53bf", 511725);
        areaCode.put("\u4e07\u6e90\u5e02", 511781);
        areaCode.put("\u96c5\u5b89\u5e02", 511800);
        areaCode.put("\u5e02\u8f96\u533a", 511801);
        areaCode.put("\u96e8\u57ce\u533a", 511802);
        areaCode.put("\u540d\u5c71\u53bf", 511821);
        areaCode.put("\u8365\u7ecf\u53bf", 511822);
        areaCode.put("\u6c49\u6e90\u53bf", 511823);
        areaCode.put("\u77f3\u68c9\u53bf", 511824);
        areaCode.put("\u5929\u5168\u53bf", 511825);
        areaCode.put("\u82a6\u5c71\u53bf", 511826);
        areaCode.put("\u5b9d\u5174\u53bf", 511827);
        areaCode.put("\u5df4\u4e2d\u5e02", 511900);
        areaCode.put("\u5e02\u8f96\u533a", 511901);
        areaCode.put("\u5df4\u5dde\u533a", 511902);
        areaCode.put("\u901a\u6c5f\u53bf", 511921);
        areaCode.put("\u5357\u6c5f\u53bf", 511922);
        areaCode.put("\u5e73\u660c\u53bf", 511923);
        areaCode.put("\u8d44\u9633\u5e02", 512000);
        areaCode.put("\u5e02\u8f96\u533a", 512001);
        areaCode.put("\u96c1\u6c5f\u533a", 512002);
        areaCode.put("\u5b89\u5cb3\u53bf", 512021);
        areaCode.put("\u4e50\u81f3\u53bf", 512022);
        areaCode.put("\u7b80\u9633\u5e02", 512081);
        areaCode.put("\u963f\u575d\u85cf\u65cf\u7f8c\u65cf\u81ea\u6cbb\u5dde", 513200);
        areaCode.put("\u6c76\u5ddd\u53bf", 513221);
        areaCode.put("\u7406\u3000\u53bf", 513222);
        areaCode.put("\u8302\u3000\u53bf", 513223);
        areaCode.put("\u677e\u6f58\u53bf", 513224);
        areaCode.put("\u4e5d\u5be8\u6c9f\u53bf", 513225);
        areaCode.put("\u91d1\u5ddd\u53bf", 513226);
        areaCode.put("\u5c0f\u91d1\u53bf", 513227);
        areaCode.put("\u9ed1\u6c34\u53bf", 513228);
        areaCode.put("\u9a6c\u5c14\u5eb7\u53bf", 513229);
        areaCode.put("\u58e4\u5858\u53bf", 513230);
        areaCode.put("\u963f\u575d\u53bf", 513231);
        areaCode.put("\u82e5\u5c14\u76d6\u53bf", 513232);
        areaCode.put("\u7ea2\u539f\u53bf", 513233);
        areaCode.put("\u7518\u5b5c\u85cf\u65cf\u81ea\u6cbb\u5dde", 513300);
        areaCode.put("\u5eb7\u5b9a\u53bf", 513321);
        areaCode.put("\u6cf8\u5b9a\u53bf", 513322);
        areaCode.put("\u4e39\u5df4\u53bf", 513323);
        areaCode.put("\u4e5d\u9f99\u53bf", 513324);
        areaCode.put("\u96c5\u6c5f\u53bf", 513325);
        areaCode.put("\u9053\u5b5a\u53bf", 513326);
        areaCode.put("\u7089\u970d\u53bf", 513327);
        areaCode.put("\u7518\u5b5c\u53bf", 513328);
        areaCode.put("\u65b0\u9f99\u53bf", 513329);
        areaCode.put("\u5fb7\u683c\u53bf", 513330);
        areaCode.put("\u767d\u7389\u53bf", 513331);
        areaCode.put("\u77f3\u6e20\u53bf", 513332);
        areaCode.put("\u8272\u8fbe\u53bf", 513333);
        areaCode.put("\u7406\u5858\u53bf", 513334);
        areaCode.put("\u5df4\u5858\u53bf", 513335);
        areaCode.put("\u4e61\u57ce\u53bf", 513336);
        areaCode.put("\u7a3b\u57ce\u53bf", 513337);
        areaCode.put("\u5f97\u8363\u53bf", 513338);
        areaCode.put("\u51c9\u5c71\u5f5d\u65cf\u81ea\u6cbb\u5dde", 513400);
        areaCode.put("\u897f\u660c\u5e02", 513401);
        areaCode.put("\u6728\u91cc\u85cf\u65cf\u81ea\u6cbb\u53bf", 513422);
        areaCode.put("\u76d0\u6e90\u53bf", 513423);
        areaCode.put("\u5fb7\u660c\u53bf", 513424);
        areaCode.put("\u4f1a\u7406\u53bf", 513425);
        areaCode.put("\u4f1a\u4e1c\u53bf", 513426);
        areaCode.put("\u5b81\u5357\u53bf", 513427);
        areaCode.put("\u666e\u683c\u53bf", 513428);
        areaCode.put("\u5e03\u62d6\u53bf", 513429);
        areaCode.put("\u91d1\u9633\u53bf", 513430);
        areaCode.put("\u662d\u89c9\u53bf", 513431);
        areaCode.put("\u559c\u5fb7\u53bf", 513432);
        areaCode.put("\u5195\u5b81\u53bf", 513433);
        areaCode.put("\u8d8a\u897f\u53bf", 513434);
        areaCode.put("\u7518\u6d1b\u53bf", 513435);
        areaCode.put("\u7f8e\u59d1\u53bf", 513436);
        areaCode.put("\u96f7\u6ce2\u53bf", 513437);
        areaCode.put("\u8d35\u5dde\u7701", 520000);
        areaCode.put("\u8d35\u9633\u5e02", 520100);
        areaCode.put("\u5e02\u8f96\u533a", 520101);
        areaCode.put("\u5357\u660e\u533a", 520102);
        areaCode.put("\u4e91\u5ca9\u533a", 520103);
        areaCode.put("\u82b1\u6eaa\u533a", 520111);
        areaCode.put("\u4e4c\u5f53\u533a", 520112);
        areaCode.put("\u767d\u4e91\u533a", 520113);
        areaCode.put("\u5c0f\u6cb3\u533a", 520114);
        areaCode.put("\u5f00\u9633\u53bf", 520121);
        areaCode.put("\u606f\u70fd\u53bf", 520122);
        areaCode.put("\u4fee\u6587\u53bf", 520123);
        areaCode.put("\u6e05\u9547\u5e02", 520181);
        areaCode.put("\u516d\u76d8\u6c34\u5e02", 520200);
        areaCode.put("\u949f\u5c71\u533a", 520201);
        areaCode.put("\u516d\u679d\u7279\u533a", 520203);
        areaCode.put("\u6c34\u57ce\u53bf", 520221);
        areaCode.put("\u76d8\u3000\u53bf", 520222);
        areaCode.put("\u9075\u4e49\u5e02", 520300);
        areaCode.put("\u5e02\u8f96\u533a", 520301);
        areaCode.put("\u7ea2\u82b1\u5c97\u533a", 520302);
        areaCode.put("\u6c47\u5ddd\u533a", 520303);
        areaCode.put("\u9075\u4e49\u53bf", 520321);
        areaCode.put("\u6850\u6893\u53bf", 520322);
        areaCode.put("\u7ee5\u9633\u53bf", 520323);
        areaCode.put("\u6b63\u5b89\u53bf", 520324);
        areaCode.put("\u9053\u771f\u4ee1\u4f6c\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 520325);
        areaCode.put("\u52a1\u5ddd\u4ee1\u4f6c\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 520326);
        areaCode.put("\u51e4\u5188\u53bf", 520327);
        areaCode.put("\u6e44\u6f6d\u53bf", 520328);
        areaCode.put("\u4f59\u5e86\u53bf", 520329);
        areaCode.put("\u4e60\u6c34\u53bf", 520330);
        areaCode.put("\u8d64\u6c34\u5e02", 520381);
        areaCode.put("\u4ec1\u6000\u5e02", 520382);
        areaCode.put("\u5b89\u987a\u5e02", 520400);
        areaCode.put("\u5e02\u8f96\u533a", 520401);
        areaCode.put("\u897f\u79c0\u533a", 520402);
        areaCode.put("\u5e73\u575d\u53bf", 520421);
        areaCode.put("\u666e\u5b9a\u53bf", 520422);
        areaCode.put("\u9547\u5b81\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 520423);
        areaCode.put("\u5173\u5cad\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 520424);
        areaCode.put("\u7d2b\u4e91\u82d7\u65cf\u5e03\u4f9d\u65cf\u81ea\u6cbb\u53bf", 520425);
        areaCode.put("\u94dc\u4ec1\u5730\u533a", 522200);
        areaCode.put("\u94dc\u4ec1\u5e02", 522201);
        areaCode.put("\u6c5f\u53e3\u53bf", 522222);
        areaCode.put("\u7389\u5c4f\u4f97\u65cf\u81ea\u6cbb\u53bf", 522223);
        areaCode.put("\u77f3\u9621\u53bf", 522224);
        areaCode.put("\u601d\u5357\u53bf", 522225);
        areaCode.put("\u5370\u6c5f\u571f\u5bb6\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 522226);
        areaCode.put("\u5fb7\u6c5f\u53bf", 522227);
        areaCode.put("\u6cbf\u6cb3\u571f\u5bb6\u65cf\u81ea\u6cbb\u53bf", 522228);
        areaCode.put("\u677e\u6843\u82d7\u65cf\u81ea\u6cbb\u53bf", 522229);
        areaCode.put("\u4e07\u5c71\u7279\u533a", 522230);
        areaCode.put("\u9ed4\u897f\u5357\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 522300);
        areaCode.put("\u5174\u4e49\u5e02", 522301);
        areaCode.put("\u5174\u4ec1\u53bf", 522322);
        areaCode.put("\u666e\u5b89\u53bf", 522323);
        areaCode.put("\u6674\u9686\u53bf", 522324);
        areaCode.put("\u8d1e\u4e30\u53bf", 522325);
        areaCode.put("\u671b\u8c1f\u53bf", 522326);
        areaCode.put("\u518c\u4ea8\u53bf", 522327);
        areaCode.put("\u5b89\u9f99\u53bf", 522328);
        areaCode.put("\u6bd5\u8282\u5730\u533a", 522400);
        areaCode.put("\u6bd5\u8282\u5e02", 522401);
        areaCode.put("\u5927\u65b9\u53bf", 522422);
        areaCode.put("\u9ed4\u897f\u53bf", 522423);
        areaCode.put("\u91d1\u6c99\u53bf", 522424);
        areaCode.put("\u7ec7\u91d1\u53bf", 522425);
        areaCode.put("\u7eb3\u96cd\u53bf", 522426);
        areaCode.put("\u5a01\u5b81\u5f5d\u65cf\u56de\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 522427);
        areaCode.put("\u8d6b\u7ae0\u53bf", 522428);
        areaCode.put("\u9ed4\u4e1c\u5357\u82d7\u65cf\u4f97\u65cf\u81ea\u6cbb\u5dde", 522600);
        areaCode.put("\u51ef\u91cc\u5e02", 522601);
        areaCode.put("\u9ec4\u5e73\u53bf", 522622);
        areaCode.put("\u65bd\u79c9\u53bf", 522623);
        areaCode.put("\u4e09\u7a57\u53bf", 522624);
        areaCode.put("\u9547\u8fdc\u53bf", 522625);
        areaCode.put("\u5c91\u5de9\u53bf", 522626);
        areaCode.put("\u5929\u67f1\u53bf", 522627);
        areaCode.put("\u9526\u5c4f\u53bf", 522628);
        areaCode.put("\u5251\u6cb3\u53bf", 522629);
        areaCode.put("\u53f0\u6c5f\u53bf", 522630);
        areaCode.put("\u9ece\u5e73\u53bf", 522631);
        areaCode.put("\u6995\u6c5f\u53bf", 522632);
        areaCode.put("\u4ece\u6c5f\u53bf", 522633);
        areaCode.put("\u96f7\u5c71\u53bf", 522634);
        areaCode.put("\u9ebb\u6c5f\u53bf", 522635);
        areaCode.put("\u4e39\u5be8\u53bf", 522636);
        areaCode.put("\u9ed4\u5357\u5e03\u4f9d\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 522700);
        areaCode.put("\u90fd\u5300\u5e02", 522701);
        areaCode.put("\u798f\u6cc9\u5e02", 522702);
        areaCode.put("\u8354\u6ce2\u53bf", 522722);
        areaCode.put("\u8d35\u5b9a\u53bf", 522723);
        areaCode.put("\u74ee\u5b89\u53bf", 522725);
        areaCode.put("\u72ec\u5c71\u53bf", 522726);
        areaCode.put("\u5e73\u5858\u53bf", 522727);
        areaCode.put("\u7f57\u7538\u53bf", 522728);
        areaCode.put("\u957f\u987a\u53bf", 522729);
        areaCode.put("\u9f99\u91cc\u53bf", 522730);
        areaCode.put("\u60e0\u6c34\u53bf", 522731);
        areaCode.put("\u4e09\u90fd\u6c34\u65cf\u81ea\u6cbb\u53bf", 522732);
        areaCode.put("\u4e91\u5357\u7701", 530000);
        areaCode.put("\u6606\u660e\u5e02", 530100);
        areaCode.put("\u5e02\u8f96\u533a", 530101);
        areaCode.put("\u4e94\u534e\u533a", 530102);
        areaCode.put("\u76d8\u9f99\u533a", 530103);
        areaCode.put("\u5b98\u6e21\u533a", 530111);
        areaCode.put("\u897f\u5c71\u533a", 530112);
        areaCode.put("\u4e1c\u5ddd\u533a", 530113);
        areaCode.put("\u5448\u8d21\u53bf", 530121);
        areaCode.put("\u664b\u5b81\u53bf", 530122);
        areaCode.put("\u5bcc\u6c11\u53bf", 530124);
        areaCode.put("\u5b9c\u826f\u53bf", 530125);
        areaCode.put("\u77f3\u6797\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530126);
        areaCode.put("\u5d69\u660e\u53bf", 530127);
        areaCode.put("\u7984\u529d\u5f5d\u65cf\u82d7\u65cf\u81ea\u6cbb\u53bf", 530128);
        areaCode.put("\u5bfb\u7538\u56de\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530129);
        areaCode.put("\u5b89\u5b81\u5e02", 530181);
        areaCode.put("\u66f2\u9756\u5e02", 530300);
        areaCode.put("\u5e02\u8f96\u533a", 530301);
        areaCode.put("\u9e92\u9e9f\u533a", 530302);
        areaCode.put("\u9a6c\u9f99\u53bf", 530321);
        areaCode.put("\u9646\u826f\u53bf", 530322);
        areaCode.put("\u5e08\u5b97\u53bf", 530323);
        areaCode.put("\u7f57\u5e73\u53bf", 530324);
        areaCode.put("\u5bcc\u6e90\u53bf", 530325);
        areaCode.put("\u4f1a\u6cfd\u53bf", 530326);
        areaCode.put("\u6cbe\u76ca\u53bf", 530328);
        areaCode.put("\u5ba3\u5a01\u5e02", 530381);
        areaCode.put("\u7389\u6eaa\u5e02", 530400);
        areaCode.put("\u5e02\u8f96\u533a", 530401);
        areaCode.put("\u7ea2\u5854\u533a", 530402);
        areaCode.put("\u6c5f\u5ddd\u53bf", 530421);
        areaCode.put("\u6f84\u6c5f\u53bf", 530422);
        areaCode.put("\u901a\u6d77\u53bf", 530423);
        areaCode.put("\u534e\u5b81\u53bf", 530424);
        areaCode.put("\u6613\u95e8\u53bf", 530425);
        areaCode.put("\u5ce8\u5c71\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530426);
        areaCode.put("\u65b0\u5e73\u5f5d\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf", 530427);
        areaCode.put("\u5143\u6c5f\u54c8\u5c3c\u65cf\u5f5d\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf", 530428);
        areaCode.put("\u4fdd\u5c71\u5e02", 530500);
        areaCode.put("\u5e02\u8f96\u533a", 530501);
        areaCode.put("\u9686\u9633\u533a", 530502);
        areaCode.put("\u65bd\u7538\u53bf", 530521);
        areaCode.put("\u817e\u51b2\u53bf", 530522);
        areaCode.put("\u9f99\u9675\u53bf", 530523);
        areaCode.put("\u660c\u5b81\u53bf", 530524);
        areaCode.put("\u662d\u901a\u5e02", 530600);
        areaCode.put("\u5e02\u8f96\u533a", 530601);
        areaCode.put("\u662d\u9633\u533a", 530602);
        areaCode.put("\u9c81\u7538\u53bf", 530621);
        areaCode.put("\u5de7\u5bb6\u53bf", 530622);
        areaCode.put("\u76d0\u6d25\u53bf", 530623);
        areaCode.put("\u5927\u5173\u53bf", 530624);
        areaCode.put("\u6c38\u5584\u53bf", 530625);
        areaCode.put("\u7ee5\u6c5f\u53bf", 530626);
        areaCode.put("\u9547\u96c4\u53bf", 530627);
        areaCode.put("\u5f5d\u826f\u53bf", 530628);
        areaCode.put("\u5a01\u4fe1\u53bf", 530629);
        areaCode.put("\u6c34\u5bcc\u53bf", 530630);
        areaCode.put("\u4e3d\u6c5f\u5e02", 530700);
        areaCode.put("\u5e02\u8f96\u533a", 530701);
        areaCode.put("\u53e4\u57ce\u533a", 530702);
        areaCode.put("\u7389\u9f99\u7eb3\u897f\u65cf\u81ea\u6cbb\u53bf", 530721);
        areaCode.put("\u6c38\u80dc\u53bf", 530722);
        areaCode.put("\u534e\u576a\u53bf", 530723);
        areaCode.put("\u5b81\u8497\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530724);
        areaCode.put("\u666e\u6d31\u5e02", 530800);
        areaCode.put("\u5e02\u8f96\u533a", 530801);
        areaCode.put("\u601d\u8305\u533a", 530802);
        areaCode.put("\u5b81\u6d31\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530821);
        areaCode.put("\u58a8\u6c5f\u54c8\u5c3c\u65cf\u81ea\u6cbb\u53bf", 530822);
        areaCode.put("\u666f\u4e1c\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530823);
        areaCode.put("\u666f\u8c37\u50a3\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530824);
        areaCode.put("\u9547\u6c85\u5f5d\u65cf\u54c8\u5c3c\u65cf\u62c9\u795c\u65cf\u81ea\u6cbb\u53bf", 530825);
        areaCode.put("\u6c5f\u57ce\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u53bf", 530826);
        areaCode.put("\u5b5f\u8fde\u50a3\u65cf\u62c9\u795c\u65cf\u4f64\u65cf\u81ea\u6cbb\u53bf", 530827);
        areaCode.put("\u6f9c\u6ca7\u62c9\u795c\u65cf\u81ea\u6cbb\u53bf", 530828);
        areaCode.put("\u897f\u76df\u4f64\u65cf\u81ea\u6cbb\u53bf", 530829);
        areaCode.put("\u4e34\u6ca7\u5e02", 530900);
        areaCode.put("\u5e02\u8f96\u533a", 530901);
        areaCode.put("\u4e34\u7fd4\u533a", 530902);
        areaCode.put("\u51e4\u5e86\u53bf", 530921);
        areaCode.put("\u4e91\u3000\u53bf", 530922);
        areaCode.put("\u6c38\u5fb7\u53bf", 530923);
        areaCode.put("\u9547\u5eb7\u53bf", 530924);
        areaCode.put("\u53cc\u6c5f\u62c9\u795c\u65cf\u4f64\u65cf\u5e03\u6717\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf", 530925);
        areaCode.put("\u803f\u9a6c\u50a3\u65cf\u4f64\u65cf\u81ea\u6cbb\u53bf", 530926);
        areaCode.put("\u6ca7\u6e90\u4f64\u65cf\u81ea\u6cbb\u53bf", 530927);
        areaCode.put("\u695a\u96c4\u5f5d\u65cf\u81ea\u6cbb\u5dde", 532300);
        areaCode.put("\u695a\u96c4\u5e02", 532301);
        areaCode.put("\u53cc\u67cf\u53bf", 532322);
        areaCode.put("\u725f\u5b9a\u53bf", 532323);
        areaCode.put("\u5357\u534e\u53bf", 532324);
        areaCode.put("\u59da\u5b89\u53bf", 532325);
        areaCode.put("\u5927\u59da\u53bf", 532326);
        areaCode.put("\u6c38\u4ec1\u53bf", 532327);
        areaCode.put("\u5143\u8c0b\u53bf", 532328);
        areaCode.put("\u6b66\u5b9a\u53bf", 532329);
        areaCode.put("\u7984\u4e30\u53bf", 532331);
        areaCode.put("\u7ea2\u6cb3\u54c8\u5c3c\u65cf\u5f5d\u65cf\u81ea\u6cbb\u5dde", 532500);
        areaCode.put("\u4e2a\u65e7\u5e02", 532501);
        areaCode.put("\u5f00\u8fdc\u5e02", 532502);
        areaCode.put("\u8499\u81ea\u53bf", 532522);
        areaCode.put("\u5c4f\u8fb9\u82d7\u65cf\u81ea\u6cbb\u53bf", 532523);
        areaCode.put("\u5efa\u6c34\u53bf", 532524);
        areaCode.put("\u77f3\u5c4f\u53bf", 532525);
        areaCode.put("\u5f25\u52d2\u53bf", 532526);
        areaCode.put("\u6cf8\u897f\u53bf", 532527);
        areaCode.put("\u5143\u9633\u53bf", 532528);
        areaCode.put("\u7ea2\u6cb3\u53bf", 532529);
        areaCode.put("\u91d1\u5e73\u82d7\u65cf\u7476\u65cf\u50a3\u65cf\u81ea\u6cbb\u53bf", 532530);
        areaCode.put("\u7eff\u6625\u53bf", 532531);
        areaCode.put("\u6cb3\u53e3\u7476\u65cf\u81ea\u6cbb\u53bf", 532532);
        areaCode.put("\u6587\u5c71\u58ee\u65cf\u82d7\u65cf\u81ea\u6cbb\u5dde", 532600);
        areaCode.put("\u6587\u5c71\u53bf", 532621);
        areaCode.put("\u781a\u5c71\u53bf", 532622);
        areaCode.put("\u897f\u7574\u53bf", 532623);
        areaCode.put("\u9ebb\u6817\u5761\u53bf", 532624);
        areaCode.put("\u9a6c\u5173\u53bf", 532625);
        areaCode.put("\u4e18\u5317\u53bf", 532626);
        areaCode.put("\u5e7f\u5357\u53bf", 532627);
        areaCode.put("\u5bcc\u5b81\u53bf", 532628);
        areaCode.put("\u897f\u53cc\u7248\u7eb3\u50a3\u65cf\u81ea\u6cbb\u5dde", 532800);
        areaCode.put("\u666f\u6d2a\u5e02", 532801);
        areaCode.put("\u52d0\u6d77\u53bf", 532822);
        areaCode.put("\u52d0\u814a\u53bf", 532823);
        areaCode.put("\u5927\u7406\u767d\u65cf\u81ea\u6cbb\u5dde", 532900);
        areaCode.put("\u5927\u7406\u5e02", 532901);
        areaCode.put("\u6f3e\u6fde\u5f5d\u65cf\u81ea\u6cbb\u53bf", 532922);
        areaCode.put("\u7965\u4e91\u53bf", 532923);
        areaCode.put("\u5bbe\u5ddd\u53bf", 532924);
        areaCode.put("\u5f25\u6e21\u53bf", 532925);
        areaCode.put("\u5357\u6da7\u5f5d\u65cf\u81ea\u6cbb\u53bf", 532926);
        areaCode.put("\u5dcd\u5c71\u5f5d\u65cf\u56de\u65cf\u81ea\u6cbb\u53bf", 532927);
        areaCode.put("\u6c38\u5e73\u53bf", 532928);
        areaCode.put("\u4e91\u9f99\u53bf", 532929);
        areaCode.put("\u6d31\u6e90\u53bf", 532930);
        areaCode.put("\u5251\u5ddd\u53bf", 532931);
        areaCode.put("\u9e64\u5e86\u53bf", 532932);
        areaCode.put("\u5fb7\u5b8f\u50a3\u65cf\u666f\u9887\u65cf\u81ea\u6cbb\u5dde", 533100);
        areaCode.put("\u745e\u4e3d\u5e02", 533102);
        areaCode.put("\u6f5e\u897f\u5e02", 533103);
        areaCode.put("\u6881\u6cb3\u53bf", 533122);
        areaCode.put("\u76c8\u6c5f\u53bf", 533123);
        areaCode.put("\u9647\u5ddd\u53bf", 533124);
        areaCode.put("\u6012\u6c5f\u5088\u50f3\u65cf\u81ea\u6cbb\u5dde", 533300);
        areaCode.put("\u6cf8\u6c34\u53bf", 533321);
        areaCode.put("\u798f\u8d21\u53bf", 533323);
        areaCode.put("\u8d21\u5c71\u72ec\u9f99\u65cf\u6012\u65cf\u81ea\u6cbb\u53bf", 533324);
        areaCode.put("\u5170\u576a\u767d\u65cf\u666e\u7c73\u65cf\u81ea\u6cbb\u53bf", 533325);
        areaCode.put("\u8fea\u5e86\u85cf\u65cf\u81ea\u6cbb\u5dde", 533400);
        areaCode.put("\u9999\u683c\u91cc\u62c9\u53bf", 533421);
        areaCode.put("\u5fb7\u94a6\u53bf", 533422);
        areaCode.put("\u7ef4\u897f\u5088\u50f3\u65cf\u81ea\u6cbb\u53bf", 533423);
        areaCode.put("\u897f\u85cf\u81ea\u6cbb\u533a", 540000);
        areaCode.put("\u62c9\u8428\u5e02", 540100);
        areaCode.put("\u5e02\u8f96\u533a", 540101);
        areaCode.put("\u57ce\u5173\u533a", 540102);
        areaCode.put("\u6797\u5468\u53bf", 540121);
        areaCode.put("\u5f53\u96c4\u53bf", 540122);
        areaCode.put("\u5c3c\u6728\u53bf", 540123);
        areaCode.put("\u66f2\u6c34\u53bf", 540124);
        areaCode.put("\u5806\u9f99\u5fb7\u5e86\u53bf", 540125);
        areaCode.put("\u8fbe\u5b5c\u53bf", 540126);
        areaCode.put("\u58a8\u7af9\u5de5\u5361\u53bf", 540127);
        areaCode.put("\u660c\u90fd\u5730\u533a", 542100);
        areaCode.put("\u660c\u90fd\u53bf", 542121);
        areaCode.put("\u6c5f\u8fbe\u53bf", 542122);
        areaCode.put("\u8d21\u89c9\u53bf", 542123);
        areaCode.put("\u7c7b\u4e4c\u9f50\u53bf", 542124);
        areaCode.put("\u4e01\u9752\u53bf", 542125);
        areaCode.put("\u5bdf\u96c5\u53bf", 542126);
        areaCode.put("\u516b\u5bbf\u53bf", 542127);
        areaCode.put("\u5de6\u8d21\u53bf", 542128);
        areaCode.put("\u8292\u5eb7\u53bf", 542129);
        areaCode.put("\u6d1b\u9686\u53bf", 542132);
        areaCode.put("\u8fb9\u575d\u53bf", 542133);
        areaCode.put("\u5c71\u5357\u5730\u533a", 542200);
        areaCode.put("\u4e43\u4e1c\u53bf", 542221);
        areaCode.put("\u624e\u56ca\u53bf", 542222);
        areaCode.put("\u8d21\u560e\u53bf", 542223);
        areaCode.put("\u6851\u65e5\u53bf", 542224);
        areaCode.put("\u743c\u7ed3\u53bf", 542225);
        areaCode.put("\u66f2\u677e\u53bf", 542226);
        areaCode.put("\u63aa\u7f8e\u53bf", 542227);
        areaCode.put("\u6d1b\u624e\u53bf", 542228);
        areaCode.put("\u52a0\u67e5\u53bf", 542229);
        areaCode.put("\u9686\u5b50\u53bf", 542231);
        areaCode.put("\u9519\u90a3\u53bf", 542232);
        areaCode.put("\u6d6a\u5361\u5b50\u53bf", 542233);
        areaCode.put("\u65e5\u5580\u5219\u5730\u533a", 542300);
        areaCode.put("\u65e5\u5580\u5219\u5e02", 542301);
        areaCode.put("\u5357\u6728\u6797\u53bf", 542322);
        areaCode.put("\u6c5f\u5b5c\u53bf", 542323);
        areaCode.put("\u5b9a\u65e5\u53bf", 542324);
        areaCode.put("\u8428\u8fe6\u53bf", 542325);
        areaCode.put("\u62c9\u5b5c\u53bf", 542326);
        areaCode.put("\u6602\u4ec1\u53bf", 542327);
        areaCode.put("\u8c22\u901a\u95e8\u53bf", 542328);
        areaCode.put("\u767d\u6717\u53bf", 542329);
        areaCode.put("\u4ec1\u5e03\u53bf", 542330);
        areaCode.put("\u5eb7\u9a6c\u53bf", 542331);
        areaCode.put("\u5b9a\u7ed3\u53bf", 542332);
        areaCode.put("\u4ef2\u5df4\u53bf", 542333);
        areaCode.put("\u4e9a\u4e1c\u53bf", 542334);
        areaCode.put("\u5409\u9686\u53bf", 542335);
        areaCode.put("\u8042\u62c9\u6728\u53bf", 542336);
        areaCode.put("\u8428\u560e\u53bf", 542337);
        areaCode.put("\u5c97\u5df4\u53bf", 542338);
        areaCode.put("\u90a3\u66f2\u5730\u533a", 542400);
        areaCode.put("\u90a3\u66f2\u53bf", 542421);
        areaCode.put("\u5609\u9ece\u53bf", 542422);
        areaCode.put("\u6bd4\u5982\u53bf", 542423);
        areaCode.put("\u8042\u8363\u53bf", 542424);
        areaCode.put("\u5b89\u591a\u53bf", 542425);
        areaCode.put("\u7533\u624e\u53bf", 542426);
        areaCode.put("\u7d22\u3000\u53bf", 542427);
        areaCode.put("\u73ed\u6208\u53bf", 542428);
        areaCode.put("\u5df4\u9752\u53bf", 542429);
        areaCode.put("\u5c3c\u739b\u53bf", 542430);
        areaCode.put("\u963f\u91cc\u5730\u533a", 542500);
        areaCode.put("\u666e\u5170\u53bf", 542521);
        areaCode.put("\u672d\u8fbe\u53bf", 542522);
        areaCode.put("\u5676\u5c14\u53bf", 542523);
        areaCode.put("\u65e5\u571f\u53bf", 542524);
        areaCode.put("\u9769\u5409\u53bf", 542525);
        areaCode.put("\u6539\u5219\u53bf", 542526);
        areaCode.put("\u63aa\u52e4\u53bf", 542527);
        areaCode.put("\u6797\u829d\u5730\u533a", 542600);
        areaCode.put("\u6797\u829d\u53bf", 542621);
        areaCode.put("\u5de5\u5e03\u6c5f\u8fbe\u53bf", 542622);
        areaCode.put("\u7c73\u6797\u53bf", 542623);
        areaCode.put("\u58a8\u8131\u53bf", 542624);
        areaCode.put("\u6ce2\u5bc6\u53bf", 542625);
        areaCode.put("\u5bdf\u9685\u53bf", 542626);
        areaCode.put("\u6717\u3000\u53bf", 542627);
        areaCode.put("\u9655\u897f\u7701", 610000);
        areaCode.put("\u897f\u5b89\u5e02", 610100);
        areaCode.put("\u5e02\u8f96\u533a", 610101);
        areaCode.put("\u65b0\u57ce\u533a", 610102);
        areaCode.put("\u7891\u6797\u533a", 610103);
        areaCode.put("\u83b2\u6e56\u533a", 610104);
        areaCode.put("\u705e\u6865\u533a", 610111);
        areaCode.put("\u672a\u592e\u533a", 610112);
        areaCode.put("\u96c1\u5854\u533a", 610113);
        areaCode.put("\u960e\u826f\u533a", 610114);
        areaCode.put("\u4e34\u6f7c\u533a", 610115);
        areaCode.put("\u957f\u5b89\u533a", 610116);
        areaCode.put("\u84dd\u7530\u53bf", 610122);
        areaCode.put("\u5468\u81f3\u53bf", 610124);
        areaCode.put("\u6237\u3000\u53bf", 610125);
        areaCode.put("\u9ad8\u9675\u53bf", 610126);
        areaCode.put("\u94dc\u5ddd\u5e02", 610200);
        areaCode.put("\u5e02\u8f96\u533a", 610201);
        areaCode.put("\u738b\u76ca\u533a", 610202);
        areaCode.put("\u5370\u53f0\u533a", 610203);
        areaCode.put("\u8000\u5dde\u533a", 610204);
        areaCode.put("\u5b9c\u541b\u53bf", 610222);
        areaCode.put("\u5b9d\u9e21\u5e02", 610300);
        areaCode.put("\u5e02\u8f96\u533a", 610301);
        areaCode.put("\u6e2d\u6ee8\u533a", 610302);
        areaCode.put("\u91d1\u53f0\u533a", 610303);
        areaCode.put("\u9648\u4ed3\u533a", 610304);
        areaCode.put("\u51e4\u7fd4\u53bf", 610322);
        areaCode.put("\u5c90\u5c71\u53bf", 610323);
        areaCode.put("\u6276\u98ce\u53bf", 610324);
        areaCode.put("\u7709\u3000\u53bf", 610326);
        areaCode.put("\u9647\u3000\u53bf", 610327);
        areaCode.put("\u5343\u9633\u53bf", 610328);
        areaCode.put("\u9e9f\u6e38\u53bf", 610329);
        areaCode.put("\u51e4\u3000\u53bf", 610330);
        areaCode.put("\u592a\u767d\u53bf", 610331);
        areaCode.put("\u54b8\u9633\u5e02", 610400);
        areaCode.put("\u5e02\u8f96\u533a", 610401);
        areaCode.put("\u79e6\u90fd\u533a", 610402);
        areaCode.put("\u6768\u9675\u533a", 610403);
        areaCode.put("\u6e2d\u57ce\u533a", 610404);
        areaCode.put("\u4e09\u539f\u53bf", 610422);
        areaCode.put("\u6cfe\u9633\u53bf", 610423);
        areaCode.put("\u4e7e\u3000\u53bf", 610424);
        areaCode.put("\u793c\u6cc9\u53bf", 610425);
        areaCode.put("\u6c38\u5bff\u53bf", 610426);
        areaCode.put("\u5f6c\u3000\u53bf", 610427);
        areaCode.put("\u957f\u6b66\u53bf", 610428);
        areaCode.put("\u65ec\u9091\u53bf", 610429);
        areaCode.put("\u6df3\u5316\u53bf", 610430);
        areaCode.put("\u6b66\u529f\u53bf", 610431);
        areaCode.put("\u5174\u5e73\u5e02", 610481);
        areaCode.put("\u6e2d\u5357\u5e02", 610500);
        areaCode.put("\u5e02\u8f96\u533a", 610501);
        areaCode.put("\u4e34\u6e2d\u533a", 610502);
        areaCode.put("\u534e\u3000\u53bf", 610521);
        areaCode.put("\u6f7c\u5173\u53bf", 610522);
        areaCode.put("\u5927\u8354\u53bf", 610523);
        areaCode.put("\u5408\u9633\u53bf", 610524);
        areaCode.put("\u6f84\u57ce\u53bf", 610525);
        areaCode.put("\u84b2\u57ce\u53bf", 610526);
        areaCode.put("\u767d\u6c34\u53bf", 610527);
        areaCode.put("\u5bcc\u5e73\u53bf", 610528);
        areaCode.put("\u97e9\u57ce\u5e02", 610581);
        areaCode.put("\u534e\u9634\u5e02", 610582);
        areaCode.put("\u5ef6\u5b89\u5e02", 610600);
        areaCode.put("\u5e02\u8f96\u533a", 610601);
        areaCode.put("\u5b9d\u5854\u533a", 610602);
        areaCode.put("\u5ef6\u957f\u53bf", 610621);
        areaCode.put("\u5ef6\u5ddd\u53bf", 610622);
        areaCode.put("\u5b50\u957f\u53bf", 610623);
        areaCode.put("\u5b89\u585e\u53bf", 610624);
        areaCode.put("\u5fd7\u4e39\u53bf", 610625);
        areaCode.put("\u5434\u8d77\u53bf", 610626);
        areaCode.put("\u7518\u6cc9\u53bf", 610627);
        areaCode.put("\u5bcc\u3000\u53bf", 610628);
        areaCode.put("\u6d1b\u5ddd\u53bf", 610629);
        areaCode.put("\u5b9c\u5ddd\u53bf", 610630);
        areaCode.put("\u9ec4\u9f99\u53bf", 610631);
        areaCode.put("\u9ec4\u9675\u53bf", 610632);
        areaCode.put("\u6c49\u4e2d\u5e02", 610700);
        areaCode.put("\u5e02\u8f96\u533a", 610701);
        areaCode.put("\u6c49\u53f0\u533a", 610702);
        areaCode.put("\u5357\u90d1\u53bf", 610721);
        areaCode.put("\u57ce\u56fa\u53bf", 610722);
        areaCode.put("\u6d0b\u3000\u53bf", 610723);
        areaCode.put("\u897f\u4e61\u53bf", 610724);
        areaCode.put("\u52c9\u3000\u53bf", 610725);
        areaCode.put("\u5b81\u5f3a\u53bf", 610726);
        areaCode.put("\u7565\u9633\u53bf", 610727);
        areaCode.put("\u9547\u5df4\u53bf", 610728);
        areaCode.put("\u7559\u575d\u53bf", 610729);
        areaCode.put("\u4f5b\u576a\u53bf", 610730);
        areaCode.put("\u6986\u6797\u5e02", 610800);
        areaCode.put("\u5e02\u8f96\u533a", 610801);
        areaCode.put("\u6986\u9633\u533a", 610802);
        areaCode.put("\u795e\u6728\u53bf", 610821);
        areaCode.put("\u5e9c\u8c37\u53bf", 610822);
        areaCode.put("\u6a2a\u5c71\u53bf", 610823);
        areaCode.put("\u9756\u8fb9\u53bf", 610824);
        areaCode.put("\u5b9a\u8fb9\u53bf", 610825);
        areaCode.put("\u7ee5\u5fb7\u53bf", 610826);
        areaCode.put("\u7c73\u8102\u53bf", 610827);
        areaCode.put("\u4f73\u3000\u53bf", 610828);
        areaCode.put("\u5434\u5821\u53bf", 610829);
        areaCode.put("\u6e05\u6da7\u53bf", 610830);
        areaCode.put("\u5b50\u6d32\u53bf", 610831);
        areaCode.put("\u5b89\u5eb7\u5e02", 610900);
        areaCode.put("\u5e02\u8f96\u533a", 610901);
        areaCode.put("\u6c49\u6ee8\u533a", 610902);
        areaCode.put("\u6c49\u9634\u53bf", 610921);
        areaCode.put("\u77f3\u6cc9\u53bf", 610922);
        areaCode.put("\u5b81\u9655\u53bf", 610923);
        areaCode.put("\u7d2b\u9633\u53bf", 610924);
        areaCode.put("\u5c9a\u768b\u53bf", 610925);
        areaCode.put("\u5e73\u5229\u53bf", 610926);
        areaCode.put("\u9547\u576a\u53bf", 610927);
        areaCode.put("\u65ec\u9633\u53bf", 610928);
        areaCode.put("\u767d\u6cb3\u53bf", 610929);
        areaCode.put("\u5546\u6d1b\u5e02", 611000);
        areaCode.put("\u5e02\u8f96\u533a", 611001);
        areaCode.put("\u5546\u5dde\u533a", 611002);
        areaCode.put("\u6d1b\u5357\u53bf", 611021);
        areaCode.put("\u4e39\u51e4\u53bf", 611022);
        areaCode.put("\u5546\u5357\u53bf", 611023);
        areaCode.put("\u5c71\u9633\u53bf", 611024);
        areaCode.put("\u9547\u5b89\u53bf", 611025);
        areaCode.put("\u67de\u6c34\u53bf", 611026);
        areaCode.put("\u7518\u8083\u7701", 620000);
        areaCode.put("\u5170\u5dde\u5e02", 620100);
        areaCode.put("\u5e02\u8f96\u533a", 620101);
        areaCode.put("\u57ce\u5173\u533a", 620102);
        areaCode.put("\u4e03\u91cc\u6cb3\u533a", 620103);
        areaCode.put("\u897f\u56fa\u533a", 620104);
        areaCode.put("\u5b89\u5b81\u533a", 620105);
        areaCode.put("\u7ea2\u53e4\u533a", 620111);
        areaCode.put("\u6c38\u767b\u53bf", 620121);
        areaCode.put("\u768b\u5170\u53bf", 620122);
        areaCode.put("\u6986\u4e2d\u53bf", 620123);
        areaCode.put("\u5609\u5cea\u5173\u5e02", 620200);
        areaCode.put("\u5e02\u8f96\u533a", 620201);
        areaCode.put("\u91d1\u660c\u5e02", 620300);
        areaCode.put("\u5e02\u8f96\u533a", 620301);
        areaCode.put("\u91d1\u5ddd\u533a", 620302);
        areaCode.put("\u6c38\u660c\u53bf", 620321);
        areaCode.put("\u767d\u94f6\u5e02", 620400);
        areaCode.put("\u5e02\u8f96\u533a", 620401);
        areaCode.put("\u767d\u94f6\u533a", 620402);
        areaCode.put("\u5e73\u5ddd\u533a", 620403);
        areaCode.put("\u9756\u8fdc\u53bf", 620421);
        areaCode.put("\u4f1a\u5b81\u53bf", 620422);
        areaCode.put("\u666f\u6cf0\u53bf", 620423);
        areaCode.put("\u5929\u6c34\u5e02", 620500);
        areaCode.put("\u5e02\u8f96\u533a", 620501);
        areaCode.put("\u79e6\u5dde\u533a", 620502);
        areaCode.put("\u9ea6\u79ef\u533a", 620503);
        areaCode.put("\u6e05\u6c34\u53bf", 620521);
        areaCode.put("\u79e6\u5b89\u53bf", 620522);
        areaCode.put("\u7518\u8c37\u53bf", 620523);
        areaCode.put("\u6b66\u5c71\u53bf", 620524);
        areaCode.put("\u5f20\u5bb6\u5ddd\u56de\u65cf\u81ea\u6cbb\u53bf", 620525);
        areaCode.put("\u6b66\u5a01\u5e02", 620600);
        areaCode.put("\u5e02\u8f96\u533a", 620601);
        areaCode.put("\u51c9\u5dde\u533a", 620602);
        areaCode.put("\u6c11\u52e4\u53bf", 620621);
        areaCode.put("\u53e4\u6d6a\u53bf", 620622);
        areaCode.put("\u5929\u795d\u85cf\u65cf\u81ea\u6cbb\u53bf", 620623);
        areaCode.put("\u5f20\u6396\u5e02", 620700);
        areaCode.put("\u5e02\u8f96\u533a", 620701);
        areaCode.put("\u7518\u5dde\u533a", 620702);
        areaCode.put("\u8083\u5357\u88d5\u56fa\u65cf\u81ea\u6cbb\u53bf", 620721);
        areaCode.put("\u6c11\u4e50\u53bf", 620722);
        areaCode.put("\u4e34\u6cfd\u53bf", 620723);
        areaCode.put("\u9ad8\u53f0\u53bf", 620724);
        areaCode.put("\u5c71\u4e39\u53bf", 620725);
        areaCode.put("\u5e73\u51c9\u5e02", 620800);
        areaCode.put("\u5e02\u8f96\u533a", 620801);
        areaCode.put("\u5d06\u5cd2\u533a", 620802);
        areaCode.put("\u6cfe\u5ddd\u53bf", 620821);
        areaCode.put("\u7075\u53f0\u53bf", 620822);
        areaCode.put("\u5d07\u4fe1\u53bf", 620823);
        areaCode.put("\u534e\u4ead\u53bf", 620824);
        areaCode.put("\u5e84\u6d6a\u53bf", 620825);
        areaCode.put("\u9759\u5b81\u53bf", 620826);
        areaCode.put("\u9152\u6cc9\u5e02", 620900);
        areaCode.put("\u5e02\u8f96\u533a", 620901);
        areaCode.put("\u8083\u5dde\u533a", 620902);
        areaCode.put("\u91d1\u5854\u53bf", 620921);
        areaCode.put("\u74dc\u5dde\u53bf", 620922);
        areaCode.put("\u8083\u5317\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 620923);
        areaCode.put("\u963f\u514b\u585e\u54c8\u8428\u514b\u65cf\u81ea\u6cbb\u53bf", 620924);
        areaCode.put("\u7389\u95e8\u5e02", 620981);
        areaCode.put("\u6566\u714c\u5e02", 620982);
        areaCode.put("\u5e86\u9633\u5e02", 621000);
        areaCode.put("\u5e02\u8f96\u533a", 621001);
        areaCode.put("\u897f\u5cf0\u533a", 621002);
        areaCode.put("\u5e86\u57ce\u53bf", 621021);
        areaCode.put("\u73af\u3000\u53bf", 621022);
        areaCode.put("\u534e\u6c60\u53bf", 621023);
        areaCode.put("\u5408\u6c34\u53bf", 621024);
        areaCode.put("\u6b63\u5b81\u53bf", 621025);
        areaCode.put("\u5b81\u3000\u53bf", 621026);
        areaCode.put("\u9547\u539f\u53bf", 621027);
        areaCode.put("\u5b9a\u897f\u5e02", 621100);
        areaCode.put("\u5e02\u8f96\u533a", 621101);
        areaCode.put("\u5b89\u5b9a\u533a", 621102);
        areaCode.put("\u901a\u6e2d\u53bf", 621121);
        areaCode.put("\u9647\u897f\u53bf", 621122);
        areaCode.put("\u6e2d\u6e90\u53bf", 621123);
        areaCode.put("\u4e34\u6d2e\u53bf", 621124);
        areaCode.put("\u6f33\u3000\u53bf", 621125);
        areaCode.put("\u5cb7\u3000\u53bf", 621126);
        areaCode.put("\u9647\u5357\u5e02", 621200);
        areaCode.put("\u5e02\u8f96\u533a", 621201);
        areaCode.put("\u6b66\u90fd\u533a", 621202);
        areaCode.put("\u6210\u3000\u53bf", 621221);
        areaCode.put("\u6587\u3000\u53bf", 621222);
        areaCode.put("\u5b95\u660c\u53bf", 621223);
        areaCode.put("\u5eb7\u3000\u53bf", 621224);
        areaCode.put("\u897f\u548c\u53bf", 621225);
        areaCode.put("\u793c\u3000\u53bf", 621226);
        areaCode.put("\u5fbd\u3000\u53bf", 621227);
        areaCode.put("\u4e24\u5f53\u53bf", 621228);
        areaCode.put("\u4e34\u590f\u56de\u65cf\u81ea\u6cbb\u5dde", 622900);
        areaCode.put("\u4e34\u590f\u5e02", 622901);
        areaCode.put("\u4e34\u590f\u53bf", 622921);
        areaCode.put("\u5eb7\u4e50\u53bf", 622922);
        areaCode.put("\u6c38\u9756\u53bf", 622923);
        areaCode.put("\u5e7f\u6cb3\u53bf", 622924);
        areaCode.put("\u548c\u653f\u53bf", 622925);
        areaCode.put("\u4e1c\u4e61\u65cf\u81ea\u6cbb\u53bf", 622926);
        areaCode.put("\u79ef\u77f3\u5c71\u4fdd\u5b89\u65cf\u4e1c\u4e61\u65cf\u6492\u62c9\u65cf\u81ea\u6cbb\u53bf", 622927);
        areaCode.put("\u7518\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", 623000);
        areaCode.put("\u5408\u4f5c\u5e02", 623001);
        areaCode.put("\u4e34\u6f6d\u53bf", 623021);
        areaCode.put("\u5353\u5c3c\u53bf", 623022);
        areaCode.put("\u821f\u66f2\u53bf", 623023);
        areaCode.put("\u8fed\u90e8\u53bf", 623024);
        areaCode.put("\u739b\u66f2\u53bf", 623025);
        areaCode.put("\u788c\u66f2\u53bf", 623026);
        areaCode.put("\u590f\u6cb3\u53bf", 623027);
        areaCode.put("\u9752\u6d77\u7701", 630000);
        areaCode.put("\u897f\u5b81\u5e02", 630100);
        areaCode.put("\u5e02\u8f96\u533a", 630101);
        areaCode.put("\u57ce\u4e1c\u533a", 630102);
        areaCode.put("\u57ce\u4e2d\u533a", 630103);
        areaCode.put("\u57ce\u897f\u533a", 630104);
        areaCode.put("\u57ce\u5317\u533a", 630105);
        areaCode.put("\u5927\u901a\u56de\u65cf\u571f\u65cf\u81ea\u6cbb\u53bf", 630121);
        areaCode.put("\u6e5f\u4e2d\u53bf", 630122);
        areaCode.put("\u6e5f\u6e90\u53bf", 630123);
        areaCode.put("\u6d77\u4e1c\u5730\u533a", 632100);
        areaCode.put("\u5e73\u5b89\u53bf", 632121);
        areaCode.put("\u6c11\u548c\u56de\u65cf\u571f\u65cf\u81ea\u6cbb\u53bf", 632122);
        areaCode.put("\u4e50\u90fd\u53bf", 632123);
        areaCode.put("\u4e92\u52a9\u571f\u65cf\u81ea\u6cbb\u53bf", 632126);
        areaCode.put("\u5316\u9686\u56de\u65cf\u81ea\u6cbb\u53bf", 632127);
        areaCode.put("\u5faa\u5316\u6492\u62c9\u65cf\u81ea\u6cbb\u53bf", 632128);
        areaCode.put("\u6d77\u5317\u85cf\u65cf\u81ea\u6cbb\u5dde", 632200);
        areaCode.put("\u95e8\u6e90\u56de\u65cf\u81ea\u6cbb\u53bf", 632221);
        areaCode.put("\u7941\u8fde\u53bf", 632222);
        areaCode.put("\u6d77\u664f\u53bf", 632223);
        areaCode.put("\u521a\u5bdf\u53bf", 632224);
        areaCode.put("\u9ec4\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", 632300);
        areaCode.put("\u540c\u4ec1\u53bf", 632321);
        areaCode.put("\u5c16\u624e\u53bf", 632322);
        areaCode.put("\u6cfd\u5e93\u53bf", 632323);
        areaCode.put("\u6cb3\u5357\u8499\u53e4\u65cf\u81ea\u6cbb\u53bf", 632324);
        areaCode.put("\u6d77\u5357\u85cf\u65cf\u81ea\u6cbb\u5dde", 632500);
        areaCode.put("\u5171\u548c\u53bf", 632521);
        areaCode.put("\u540c\u5fb7\u53bf", 632522);
        areaCode.put("\u8d35\u5fb7\u53bf", 632523);
        areaCode.put("\u5174\u6d77\u53bf", 632524);
        areaCode.put("\u8d35\u5357\u53bf", 632525);
        areaCode.put("\u679c\u6d1b\u85cf\u65cf\u81ea\u6cbb\u5dde", 632600);
        areaCode.put("\u739b\u6c81\u53bf", 632621);
        areaCode.put("\u73ed\u739b\u53bf", 632622);
        areaCode.put("\u7518\u5fb7\u53bf", 632623);
        areaCode.put("\u8fbe\u65e5\u53bf", 632624);
        areaCode.put("\u4e45\u6cbb\u53bf", 632625);
        areaCode.put("\u739b\u591a\u53bf", 632626);
        areaCode.put("\u7389\u6811\u85cf\u65cf\u81ea\u6cbb\u5dde", 632700);
        areaCode.put("\u7389\u6811\u53bf", 632721);
        areaCode.put("\u6742\u591a\u53bf", 632722);
        areaCode.put("\u79f0\u591a\u53bf", 632723);
        areaCode.put("\u6cbb\u591a\u53bf", 632724);
        areaCode.put("\u56ca\u8c26\u53bf", 632725);
        areaCode.put("\u66f2\u9ebb\u83b1\u53bf", 632726);
        areaCode.put("\u6d77\u897f\u8499\u53e4\u65cf\u85cf\u65cf\u81ea\u6cbb\u5dde", 632800);
        areaCode.put("\u683c\u5c14\u6728\u5e02", 632801);
        areaCode.put("\u5fb7\u4ee4\u54c8\u5e02", 632802);
        areaCode.put("\u4e4c\u5170\u53bf", 632821);
        areaCode.put("\u90fd\u5170\u53bf", 632822);
        areaCode.put("\u5929\u5cfb\u53bf", 632823);
        areaCode.put("\u5b81\u590f\u56de\u65cf\u81ea\u6cbb\u533a", 640000);
        areaCode.put("\u94f6\u5ddd\u5e02", 640100);
        areaCode.put("\u5e02\u8f96\u533a", 640101);
        areaCode.put("\u5174\u5e86\u533a", 640104);
        areaCode.put("\u897f\u590f\u533a", 640105);
        areaCode.put("\u91d1\u51e4\u533a", 640106);
        areaCode.put("\u6c38\u5b81\u53bf", 640121);
        areaCode.put("\u8d3a\u5170\u53bf", 640122);
        areaCode.put("\u7075\u6b66\u5e02", 640181);
        areaCode.put("\u77f3\u5634\u5c71\u5e02", 640200);
        areaCode.put("\u5e02\u8f96\u533a", 640201);
        areaCode.put("\u5927\u6b66\u53e3\u533a", 640202);
        areaCode.put("\u60e0\u519c\u533a", 640205);
        areaCode.put("\u5e73\u7f57\u53bf", 640221);
        areaCode.put("\u5434\u5fe0\u5e02", 640300);
        areaCode.put("\u5e02\u8f96\u533a", 640301);
        areaCode.put("\u5229\u901a\u533a", 640302);
        areaCode.put("\u7ea2\u5bfa\u5821\u533a (*)", 640303);
        areaCode.put("\u76d0\u6c60\u53bf", 640323);
        areaCode.put("\u540c\u5fc3\u53bf", 640324);
        areaCode.put("\u9752\u94dc\u5ce1\u5e02", 640381);
        areaCode.put("\u56fa\u539f\u5e02", 640400);
        areaCode.put("\u5e02\u8f96\u533a", 640401);
        areaCode.put("\u539f\u5dde\u533a", 640402);
        areaCode.put("\u897f\u5409\u53bf", 640422);
        areaCode.put("\u9686\u5fb7\u53bf", 640423);
        areaCode.put("\u6cfe\u6e90\u53bf", 640424);
        areaCode.put("\u5f6d\u9633\u53bf", 640425);
        areaCode.put("\u4e2d\u536b\u5e02", 640500);
        areaCode.put("\u5e02\u8f96\u533a", 640501);
        areaCode.put("\u6c99\u5761\u5934\u533a", 640502);
        areaCode.put("\u4e2d\u5b81\u53bf", 640521);
        areaCode.put("\u6d77\u539f\u53bf", 640522);
        areaCode.put("\u65b0\u7586\u7ef4\u543e\u5c14\u81ea\u6cbb\u533a", 650000);
        areaCode.put("\u4e4c\u9c81\u6728\u9f50\u5e02", 650100);
        areaCode.put("\u5e02\u8f96\u533a", 650101);
        areaCode.put("\u5929\u5c71\u533a", 650102);
        areaCode.put("\u6c99\u4f9d\u5df4\u514b\u533a", 650103);
        areaCode.put("\u65b0\u5e02\u533a", 650104);
        areaCode.put("\u6c34\u78e8\u6c9f\u533a", 650105);
        areaCode.put("\u5934\u5c6f\u6cb3\u533a", 650106);
        areaCode.put("\u8fbe\u5742\u57ce\u533a", 650107);
        areaCode.put("\u7c73\u4e1c\u533a", 650109);
        areaCode.put("\u4e4c\u9c81\u6728\u9f50\u53bf", 650121);
        areaCode.put("\u514b\u62c9\u739b\u4f9d\u5e02", 650200);
        areaCode.put("\u5e02\u8f96\u533a", 650201);
        areaCode.put("\u72ec\u5c71\u5b50\u533a", 650202);
        areaCode.put("\u514b\u62c9\u739b\u4f9d\u533a", 650203);
        areaCode.put("\u767d\u78b1\u6ee9\u533a", 650204);
        areaCode.put("\u4e4c\u5c14\u79be\u533a", 650205);
        areaCode.put("\u5410\u9c81\u756a\u5730\u533a", 652100);
        areaCode.put("\u5410\u9c81\u756a\u5e02", 652101);
        areaCode.put("\u912f\u5584\u53bf", 652122);
        areaCode.put("\u6258\u514b\u900a\u53bf", 652123);
        areaCode.put("\u54c8\u5bc6\u5730\u533a", 652200);
        areaCode.put("\u54c8\u5bc6\u5e02", 652201);
        areaCode.put("\u5df4\u91cc\u5764\u54c8\u8428\u514b\u81ea\u6cbb\u53bf", 652222);
        areaCode.put("\u4f0a\u543e\u53bf", 652223);
        areaCode.put("\u660c\u5409\u56de\u65cf\u81ea\u6cbb\u5dde", 652300);
        areaCode.put("\u660c\u5409\u5e02", 652301);
        areaCode.put("\u961c\u5eb7\u5e02", 652302);
        areaCode.put("\u547c\u56fe\u58c1\u53bf", 652323);
        areaCode.put("\u739b\u7eb3\u65af\u53bf", 652324);
        areaCode.put("\u5947\u53f0\u53bf", 652325);
        areaCode.put("\u5409\u6728\u8428\u5c14\u53bf", 652327);
        areaCode.put("\u6728\u5792\u54c8\u8428\u514b\u81ea\u6cbb\u53bf", 652328);
        areaCode.put("\u535a\u5c14\u5854\u62c9\u8499\u53e4\u81ea\u6cbb\u5dde", 652700);
        areaCode.put("\u535a\u4e50\u5e02", 652701);
        areaCode.put("\u7cbe\u6cb3\u53bf", 652722);
        areaCode.put("\u6e29\u6cc9\u53bf", 652723);
        areaCode.put("\u5df4\u97f3\u90ed\u695e\u8499\u53e4\u81ea\u6cbb\u5dde", 652800);
        areaCode.put("\u5e93\u5c14\u52d2\u5e02", 652801);
        areaCode.put("\u8f6e\u53f0\u53bf", 652822);
        areaCode.put("\u5c09\u7281\u53bf", 652823);
        areaCode.put("\u82e5\u7f8c\u53bf", 652824);
        areaCode.put("\u4e14\u672b\u53bf", 652825);
        areaCode.put("\u7109\u8006\u56de\u65cf\u81ea\u6cbb\u53bf", 652826);
        areaCode.put("\u548c\u9759\u53bf", 652827);
        areaCode.put("\u548c\u7855\u53bf", 652828);
        areaCode.put("\u535a\u6e56\u53bf", 652829);
        areaCode.put("\u963f\u514b\u82cf\u5730\u533a", 652900);
        areaCode.put("\u963f\u514b\u82cf\u5e02", 652901);
        areaCode.put("\u6e29\u5bbf\u53bf", 652922);
        areaCode.put("\u5e93\u8f66\u53bf", 652923);
        areaCode.put("\u6c99\u96c5\u53bf", 652924);
        areaCode.put("\u65b0\u548c\u53bf", 652925);
        areaCode.put("\u62dc\u57ce\u53bf", 652926);
        areaCode.put("\u4e4c\u4ec0\u53bf", 652927);
        areaCode.put("\u963f\u74e6\u63d0\u53bf", 652928);
        areaCode.put("\u67ef\u576a\u53bf", 652929);
        areaCode.put("\u514b\u5b5c\u52d2\u82cf\u67ef\u5c14\u514b\u5b5c\u81ea\u6cbb\u5dde", 653000);
        areaCode.put("\u963f\u56fe\u4ec0\u5e02", 653001);
        areaCode.put("\u963f\u514b\u9676\u53bf", 653022);
        areaCode.put("\u963f\u5408\u5947\u53bf", 653023);
        areaCode.put("\u4e4c\u6070\u53bf", 653024);
        areaCode.put("\u5580\u4ec0\u5730\u533a", 653100);
        areaCode.put("\u5580\u4ec0\u5e02", 653101);
        areaCode.put("\u758f\u9644\u53bf", 653121);
        areaCode.put("\u758f\u52d2\u53bf", 653122);
        areaCode.put("\u82f1\u5409\u6c99\u53bf", 653123);
        areaCode.put("\u6cfd\u666e\u53bf", 653124);
        areaCode.put("\u838e\u8f66\u53bf", 653125);
        areaCode.put("\u53f6\u57ce\u53bf", 653126);
        areaCode.put("\u9ea6\u76d6\u63d0\u53bf", 653127);
        areaCode.put("\u5cb3\u666e\u6e56\u53bf", 653128);
        areaCode.put("\u4f3d\u5e08\u53bf", 653129);
        areaCode.put("\u5df4\u695a\u53bf", 653130);
        areaCode.put("\u5854\u4ec0\u5e93\u5c14\u5e72\u5854\u5409\u514b\u81ea\u6cbb\u53bf", 653131);
        areaCode.put("\u548c\u7530\u5730\u533a", 653200);
        areaCode.put("\u548c\u7530\u5e02", 653201);
        areaCode.put("\u548c\u7530\u53bf", 653221);
        areaCode.put("\u58a8\u7389\u53bf", 653222);
        areaCode.put("\u76ae\u5c71\u53bf", 653223);
        areaCode.put("\u6d1b\u6d66\u53bf", 653224);
        areaCode.put("\u7b56\u52d2\u53bf", 653225);
        areaCode.put("\u4e8e\u7530\u53bf", 653226);
        areaCode.put("\u6c11\u4e30\u53bf", 653227);
        areaCode.put("\u4f0a\u7281\u54c8\u8428\u514b\u81ea\u6cbb\u5dde", 654000);
        areaCode.put("\u4f0a\u5b81\u5e02", 654002);
        areaCode.put("\u594e\u5c6f\u5e02", 654003);
        areaCode.put("\u4f0a\u5b81\u53bf", 654021);
        areaCode.put("\u5bdf\u5e03\u67e5\u5c14\u9521\u4f2f\u81ea\u6cbb\u53bf", 654022);
        areaCode.put("\u970d\u57ce\u53bf", 654023);
        areaCode.put("\u5de9\u7559\u53bf", 654024);
        areaCode.put("\u65b0\u6e90\u53bf", 654025);
        areaCode.put("\u662d\u82cf\u53bf", 654026);
        areaCode.put("\u7279\u514b\u65af\u53bf", 654027);
        areaCode.put("\u5c3c\u52d2\u514b\u53bf", 654028);
        areaCode.put("\u5854\u57ce\u5730\u533a", 654200);
        areaCode.put("\u5854\u57ce\u5e02", 654201);
        areaCode.put("\u4e4c\u82cf\u5e02", 654202);
        areaCode.put("\u989d\u654f\u53bf", 654221);
        areaCode.put("\u6c99\u6e7e\u53bf", 654223);
        areaCode.put("\u6258\u91cc\u53bf", 654224);
        areaCode.put("\u88d5\u6c11\u53bf", 654225);
        areaCode.put("\u548c\u5e03\u514b\u8d5b\u5c14\u8499\u53e4\u81ea\u6cbb\u53bf", 654226);
        areaCode.put("\u963f\u52d2\u6cf0\u5730\u533a", 654300);
        areaCode.put("\u963f\u52d2\u6cf0\u5e02", 654301);
        areaCode.put("\u5e03\u5c14\u6d25\u53bf", 654321);
        areaCode.put("\u5bcc\u8574\u53bf", 654322);
        areaCode.put("\u798f\u6d77\u53bf", 654323);
        areaCode.put("\u54c8\u5df4\u6cb3\u53bf", 654324);
        areaCode.put("\u9752\u6cb3\u53bf", 654325);
        areaCode.put("\u5409\u6728\u4e43\u53bf", 654326);
        areaCode.put("\u81ea\u6cbb\u533a\u76f4\u8f96\u53bf\u7ea7\u884c\u653f\u533a\u5212", 659000);
        areaCode.put("\u77f3\u6cb3\u5b50\u5e02", 659001);
        areaCode.put("\u963f\u62c9\u5c14\u5e02", 659002);
        areaCode.put("\u56fe\u6728\u8212\u514b\u5e02", 659003);
        areaCode.put("\u4e94\u5bb6\u6e20\u5e02", 659004);
        areaCode.put("\u53f0\u6e7e\u7701", 710000);
        areaCode.put("\u9999\u6e2f\u7279\u522b\u884c\u653f\u533a", 810000);
        areaCode.put("\u6fb3\u95e8\u7279\u522b\u884c\u653f\u533a", 820000);
    }
}

