/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersTempPersonRemote;
import com.zkteco.zkbiosecurity.pers.service.PersPersonService;
import com.zkteco.zkbiosecurity.pers.service.PersTempPersonService;
import com.zkteco.zkbiosecurity.pers.vo.PersPersonItem;
import com.zkteco.zkbiosecurity.pers.vo.PersTempPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersTempPersonController
extends BaseController
implements PersTempPersonRemote {
    @Autowired
    private PersTempPersonService persTempPersonService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private PersPersonService persPersonService;

    @RequiresPermissions(value={"pers:tempPerson"})
    public ModelAndView index() {
        this.request.setAttribute("isAudit", (Object)this.baseSysParamService.getValByName("pers.tempPerson.audit"));
        return new ModelAndView("pers/tempPerson/persTempPerson");
    }

    @RequiresPermissions(value={"pers:tempPerson:audit"})
    @LogRequest(module="pers_module", object="pers_tempPerson", opType="pers_tempPerson_audit", requestParams={"pin"}, opContent="pers_person_pin")
    public ZKResultMsg audit(PersTempPersonItem item) {
        ZKResultMsg resultMsg = this.persTempPersonService.audit(item);
        if (!"ok".equals(resultMsg.getRet())) {
            resultMsg.setMsg(resultMsg.getMsg() + I18nUtil.i18nCode((String)"pers_app_pinExist", (Object[])new Object[0]));
        }
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequiresPermissions(value={"pers:tempPerson:view"})
    public ModelAndView view(@RequestParam(value="id", required=false) String id) {
        PersTempPersonItem item = this.persTempPersonService.getItemById(id);
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("pers/tempPerson/editPersTempPerson");
    }

    @RequiresPermissions(value={"pers:tempPerson:refresh"})
    public DxGrid list(PersTempPersonItem codition) {
        Pager pager = this.persTempPersonService.loadPagerByAuthUserFilter(this.request.getSession().getId(), codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"pers:tempPerson:del"})
    @LogRequest(module="pers_module", object="pers_tempPerson", opType="common_op_del", requestParams={"pins"}, opContent="pers_person_pin")
    public ZKResultMsg delete(String ids) {
        ZKResultMsg retMsg = new ZKResultMsg();
        this.persTempPersonService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }

    @RequiresPermissions(value={"pers:tempPerson:audit"})
    public ModelAndView auditView(@RequestParam(value="id", required=false) String id) {
        PersTempPersonItem item = this.persTempPersonService.getItemById(id);
        this.request.setAttribute("item", (Object)item);
        this.request.setAttribute("editPage", (Object)"true");
        PersPersonItem person = this.persPersonService.getItemByPin(item.getPin());
        if (person != null) {
            return new ModelAndView("pers/tempPerson/auditUpdateTempPerson");
        }
        return new ModelAndView("pers/tempPerson/auditPersTempPerson");
    }

    public ZKResultMsg getTempPersonById(String id) {
        ZKResultMsg retMsg = new ZKResultMsg();
        retMsg.setData((Object)this.persTempPersonService.getItemById(id));
        return I18nUtil.i18nMsg((ZKResultMsg)retMsg);
    }
}

