/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pers.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.pers.remote.PersIssueCardRemote;
import com.zkteco.zkbiosecurity.pers.service.PersIssueCardService;
import com.zkteco.zkbiosecurity.pers.vo.PersCardItem;
import com.zkteco.zkbiosecurity.pers.vo.PersIssueCardItem;
import com.zkteco.zkbiosecurity.pers.vo.PersNoCardPersonItem;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class PersIssueCardController
extends BaseController
implements PersIssueCardRemote {
    @Autowired
    private PersIssueCardService persIssueCardService;

    @RequiresPermissions(value={"pers:issueCard"})
    public ModelAndView index() {
        return new ModelAndView("pers/issueCard/persIssueCard");
    }

    @RequiresPermissions(value={"pers:issueCard"})
    public DxGrid list(PersIssueCardItem condition) {
        Pager pager = this.persIssueCardService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"pers:person"})
    public DxGrid noCardPerson(PersNoCardPersonItem condition) {
        Pager pager = null;
        if ("noSelected".equals(condition.getType())) {
            pager = this.persIssueCardService.findNoCardPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else if ("selected".equals(condition.getType())) {
            pager = new Pager(this.getPageNo(), this.getPageSize());
            pager.setData(new ArrayList());
        }
        return GridUtil.convert(pager, condition.getClass());
    }

    @LogRequest(module="pers_module", object="pers_card", opType="pers_batchIssCard_entity", requestParams={"cardListJson"}, opContent="pers_person_pin")
    @RequiresPermissions(value={"pers:card:batchIssueCard"})
    public ZKResultMsg batch(@RequestParam(value="cardListJson") String cardListJson) {
        List cardPersonItems = (List)JSON.parseObject((String)cardListJson, (TypeReference)new TypeReference<List<PersCardItem>>(){}, (Feature[])new Feature[0]);
        this.persIssueCardService.batchIssueCard(cardPersonItems);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }
}

