/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.util;

import java.awt.Image;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Calendar;
import java.util.regex.Pattern;
import javax.imageio.ImageIO;
import sun.misc.BASE64Decoder;

public class ValidatorsUtils {
    private static final String REGEX_SIMPLE_CHINESE = "^[\u4e00-\u9fa5]+$";
    private static final String REGEX_ALPHANUMERIC = "[a-zA-Z0-9]+";
    private static final String REGEX_NUMERIC = "(\\+|-){0,1}(\\d+)([.]?)(\\d*)";
    private static final String REGEX_ID_CARD = "(\\d{14}|\\d{17})(\\d|x|X)";
    private static final String REGEX_EMAIL = ".+@.+\\.[a-z]+";
    private static final String REGEX_PHONE = "^(1[1-9])\\d{9}$";
    private static final String REGEX_NUMBER = "[0-9]*";
    private static final int[] factorArr = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2, 1};
    private static final String[] parityBit = new String[]{"1", "0", "X", "9", "8", "7", "6", "5", "4", "3", "2"};
    private static final String[] UNCHAR = new String[]{"&", "<", ">", "`", "~", "!", "@", "#", "$", "%", "^", "*", "?", "/", "|", "\\", ":", ";", "=", "\"", "'", ","};
    private static final int PHOTO_MAX_SIZE_BYTE = 0xA00000;

    public static boolean isAlphanumeric(String str) {
        return ValidatorsUtils.isRegexMatch(str, REGEX_ALPHANUMERIC);
    }

    public static boolean isDate(String str) {
        if (ValidatorsUtils.isEmpty(str) || str.length() > 10) {
            return false;
        }
        String[] items = str.split("-");
        if (items.length != 3) {
            return false;
        }
        if (!ValidatorsUtils.isNumber(items[0], 1900, 9999) || !ValidatorsUtils.isNumber(items[1], 1, 12)) {
            return false;
        }
        int year = Integer.parseInt(items[0]);
        int month = Integer.parseInt(items[1]);
        return ValidatorsUtils.isNumber(items[2], 1, ValidatorsUtils.getLastDayOfMonth(year, month));
    }

    public static boolean isMonth(String str) {
        if (ValidatorsUtils.isEmpty(str) || str.length() > 7) {
            return false;
        }
        String[] items = str.split("-");
        if (items.length != 2) {
            return false;
        }
        return ValidatorsUtils.isNumber(items[0], 1900, 9999) && ValidatorsUtils.isNumber(items[1], 1, 12);
    }

    public static int getLastDayOfMonth(int year, int month) {
        Calendar cal = Calendar.getInstance();
        cal.set(1, year);
        cal.set(2, month - 1);
        int lastDay = cal.getActualMaximum(5);
        return lastDay;
    }

    public static boolean isDateTime(String str) {
        if (ValidatorsUtils.isEmpty(str) || str.length() > 20) {
            return false;
        }
        String[] items = str.split(" ");
        if (items.length != 2) {
            return false;
        }
        return ValidatorsUtils.isDate(items[0]) && ValidatorsUtils.isTime(items[1]);
    }

    public static boolean isEmail(String str) {
        return ValidatorsUtils.isRegexMatch(str, REGEX_EMAIL);
    }

    public static boolean isEmpty(Object[] args) {
        return args == null || args.length == 0 || args.length == 1 && args[0] == null;
    }

    public static boolean isEmpty(String str) {
        return str == null || str.trim().length() == 0;
    }

    public static boolean isNumber(String str) {
        if (ValidatorsUtils.isEmpty(str)) {
            return false;
        }
        for (int i = 0; i < str.length(); ++i) {
            if (str.charAt(i) <= '9' && str.charAt(i) >= '0') continue;
            return false;
        }
        return true;
    }

    public static boolean isNumber(String str, int min, int max) {
        if (!ValidatorsUtils.isNumber(str)) {
            return false;
        }
        int number = Integer.parseInt(str);
        return number >= min && number <= max;
    }

    public static boolean isNumeric(String str) {
        return ValidatorsUtils.isRegexMatch(str, REGEX_NUMERIC);
    }

    public static boolean isNumeric(String str, int fractionNum) {
        if (ValidatorsUtils.isEmpty(str)) {
            return false;
        }
        String regex = "(\\+|-){0,1}(\\d+)([.]?)(\\d{0," + fractionNum + "})";
        return Pattern.matches(regex, str);
    }

    public static boolean isPostcode(String str) {
        if (ValidatorsUtils.isEmpty(str)) {
            return false;
        }
        return str.length() == 6 && ValidatorsUtils.isNumber(str);
    }

    public static boolean isString(String str, int minLength, int maxLength) {
        if (str == null) {
            return false;
        }
        if (minLength < 0) {
            return str.length() <= maxLength;
        }
        if (maxLength < 0) {
            return str.length() >= minLength;
        }
        return str.length() >= minLength && str.length() <= maxLength;
    }

    public static boolean isTime(String str) {
        if (ValidatorsUtils.isEmpty(str) || str.length() > 8) {
            return false;
        }
        String[] items = str.split(":");
        if (items.length != 2 && items.length != 3) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i].length() == 2 || items[i].length() == 1) continue;
            return false;
        }
        return ValidatorsUtils.isNumber(items[0], 0, 23) && ValidatorsUtils.isNumber(items[1], 0, 59) && (items.length != 3 || ValidatorsUtils.isNumber(items[2], 0, 59));
    }

    public static boolean isTimeLimit(String str) {
        if (ValidatorsUtils.isEmpty(str) || str.length() > 8) {
            return false;
        }
        String[] items = str.split(":");
        if (items.length != 2) {
            return false;
        }
        for (int i = 0; i < items.length; ++i) {
            if (items[i].length() == 2 || items[i].length() == 1) continue;
            return false;
        }
        return ValidatorsUtils.isNumber(items[0], 0, 23) && ValidatorsUtils.isNumber(items[1], 0, 59) && (items.length != 3 || ValidatorsUtils.isNumber(items[2], 0, 59));
    }

    public static boolean isSimpleChinese(String str) {
        return ValidatorsUtils.isRegexMatch(str, REGEX_SIMPLE_CHINESE);
    }

    public static boolean isRegexMatch(String str, String regex) {
        return str != null && str.matches(regex);
    }

    public static boolean isMobilePhone(String str) {
        return ValidatorsUtils.isRegexMatch(str, REGEX_PHONE);
    }

    public static boolean checkCertType(String certNum) {
        String[] varArray = new String[20];
        int lngProduct = 0;
        int intStrLen = certNum.length();
        if (intStrLen != 18) {
            return false;
        }
        for (int i = 0; i < intStrLen; ++i) {
            varArray[i] = String.valueOf(certNum.charAt(i));
            if (i != 17 && (Integer.parseInt(varArray[i]) < 0 || Integer.parseInt(varArray[i]) > 9)) {
                return false;
            }
            if (i >= 17) continue;
            varArray[i] = String.valueOf(Integer.parseInt(varArray[i]) * factorArr[i]);
        }
        if (intStrLen == 18) {
            String date = certNum.substring(6, 14);
            if (!ValidatorsUtils.isData(date)) {
                return false;
            }
            for (int i = 0; i < 17; ++i) {
                lngProduct += Integer.parseInt(varArray[i]);
            }
            String intCheckDigit = parityBit[lngProduct % 11];
            return String.valueOf(varArray[17]).equals(intCheckDigit);
        }
        return false;
    }

    public static boolean isData(String data) {
        String regex = "[0-9]{6}";
        Boolean result = Pattern.compile(regex).matcher(data).find();
        if (!result.booleanValue()) {
            return false;
        }
        int year = Integer.parseInt(data.substring(0, 4));
        int month = Integer.parseInt(data.substring(4, 6));
        int day = Integer.parseInt(data.substring(6, 8));
        int[] iaMonthDays = new int[]{31, 28, 31, 30, 31, 30, 31, 31, 30, 31, 30, 31};
        if (year < 1700 || year > 2500) {
            return false;
        }
        if (year % 4 == 0 && year % 100 != 0 || year % 400 == 0) {
            iaMonthDays[1] = 29;
        }
        if (month < 1 || month > 12) {
            return false;
        }
        return day >= 1 && day <= iaMonthDays[month - 1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isImage(String imgBase64) {
        boolean isImage = false;
        Image bi = null;
        try {
            bi = ImageIO.read(new ByteArrayInputStream(new BASE64Decoder().decodeBuffer(imgBase64)));
            if (bi != null) {
                isImage = true;
            }
        }
        catch (IOException e) {
            isImage = false;
        }
        finally {
            if (bi != null) {
                bi.flush();
                bi = null;
            }
        }
        return isImage;
    }

    public static Integer imageSize(String image) {
        Integer equalIndex = image.indexOf("=");
        if (image.indexOf("=") > 0) {
            image = image.substring(0, equalIndex);
        }
        Integer strLength = image.length();
        Integer size = strLength - strLength / 8 * 2;
        return size;
    }

    public static boolean isOverSize(String image) {
        return ValidatorsUtils.imageSize(image) > 0xA00000;
    }

    public static boolean isNumberStr(String str) {
        return ValidatorsUtils.isRegexMatch(str, REGEX_NUMBER);
    }

    public static boolean isSpecialChar(String str) {
        str = str.trim();
        for (String charStr : UNCHAR) {
            if (str.indexOf(charStr) < 0) continue;
            return true;
        }
        return false;
    }
}

