/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttParamRemote;
import com.zkteco.zkbiosecurity.att.service.AttParamService;
import com.zkteco.zkbiosecurity.att.service.AttTimingService;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttParamController
extends BaseController
implements AttParamRemote {
    @Autowired
    private AttParamService attParamService;
    @Autowired
    private AttTimingService attTimingService;

    @RequiresPermissions(value={"att:param"})
    public ModelAndView index() {
        Map attParams = this.attParamService.getAttParams();
        this.request.setAttribute("attParams", (Object)attParams);
        return new ModelAndView("att/param/attParam");
    }

    @RequiresPermissions(value={"att:param:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_param", opType="common_op_edit", opContent="att_rule_baseRuleSet")
    public ZKResultMsg save(@RequestParam Map<String, String> params) {
        Map attParams = this.attParamService.getAttParams();
        String timingUnitOld = (String)attParams.get("att.timing.unit");
        String timingUnitNew = params.get("att.timing.unit");
        String timingFreqOld = (String)attParams.get("att.timing.frequency");
        String timingFreqNew = params.get("att.timing.frequency");
        if (!timingUnitOld.equals(timingUnitNew) || !timingFreqOld.equals(timingFreqNew)) {
            this.attTimingService.startCirculationCalculate(timingUnitNew, timingFreqNew);
        }
        this.attParamService.saveItem(params);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

