/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttBreakTimeRemote;
import com.zkteco.zkbiosecurity.att.service.AttBreakTimeService;
import com.zkteco.zkbiosecurity.att.vo.AttBreakTimeItem;
import com.zkteco.zkbiosecurity.att.vo.AttBreakTimeSelectItem;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Objects;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttBreakTimeController
extends BaseController
implements AttBreakTimeRemote {
    @Autowired
    private AttBreakTimeService attBreakTimeService;

    public ModelAndView index() {
        return new ModelAndView("att/breakTime/attBreakTime");
    }

    @RequiresPermissions(value={"att:breakTime:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attBreakTimeService.getItemById(id));
            this.request.setAttribute("isExistFkData", (Object)this.attBreakTimeService.isExistFkData(id));
        }
        return new ModelAndView("att/breakTime/editAttBreakTime");
    }

    @RequiresPermissions(value={"att:breakTime:edit"})
    public ZKResultMsg save(AttBreakTimeItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attBreakTimeService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:breakTime:refresh"})
    public DxGrid list(AttBreakTimeItem condition) {
        Pager pager = this.attBreakTimeService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:breakTime:del"})
    public ZKResultMsg delete(String ids) {
        if (this.attBreakTimeService.isExistFkData(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_common_relationDataCanNotDel", (Object[])new Object[0]));
        }
        this.attBreakTimeService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public DxGrid selectList(AttBreakTimeSelectItem condition) {
        Pager pager = null;
        if ("noSelected".equals(condition.getType())) {
            pager = this.attBreakTimeService.selectList(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else {
            pager = new Pager(this.getPageNo(), this.getPageSize());
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public String validName(String name) {
        boolean existsByName = !this.attBreakTimeService.existsByName(name);
        return String.valueOf(existsByName);
    }

    public ZKResultMsg isExistBreakTime(String id, String startTime, String endTime) {
        AttBreakTimeItem item = this.attBreakTimeService.getItemByStartTimeAndEndTime(startTime, endTime);
        boolean isExist = false;
        if (Objects.nonNull(item) && !item.getId().equals(id)) {
            isExist = true;
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg((Object)isExist));
    }
}

