/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisPrintParamRemote;
import com.zkteco.zkbiosecurity.vis.service.VisPlaceService;
import com.zkteco.zkbiosecurity.vis.service.VisPrintParamService;
import com.zkteco.zkbiosecurity.vis.vo.VisPrintParamItem;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisPrintParamController
extends BaseController
implements VisPrintParamRemote {
    @Autowired
    private VisPrintParamService visPrintParamService;
    @Autowired
    private VisPlaceService visPlaceService;

    @RequiresPermissions(value={"vis:printParam"})
    public ModelAndView index() {
        return new ModelAndView("vis/printParam/visPrintParam");
    }

    @RequiresPermissions(value={"vis:printParam:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visPrintParamService.getItemById(id));
        }
        return new ModelAndView("vis/printParam/editVisPrintParam");
    }

    @RequiresPermissions(value={"vis:printParam:edit"})
    public ZKResultMsg save(VisPrintParamItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visPrintParamService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:printParam:refresh"})
    public DxGrid list(VisPrintParamItem condition) {
        Pager pager = this.visPrintParamService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:printParam:del"})
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visPrintParamService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg getPrintParams(@RequestParam(value="placeId", required=false) String placeId) {
        Map printParamMap = this.visPrintParamService.getPrintParams(placeId);
        return new ZKResultMsg((Object)printParamMap);
    }
}

