/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisLinkageRemote;
import com.zkteco.zkbiosecurity.vis.service.VisLinkageService;
import com.zkteco.zkbiosecurity.vis.vo.VisLinkageItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisLinkageController
extends BaseController
implements VisLinkageRemote {
    @Autowired
    private VisLinkageService visLinkageService;

    @RequiresPermissions(value={"vis:linkage"})
    public ModelAndView index() {
        return new ModelAndView("vis/linkage/visLinkage");
    }

    @RequiresPermissions(value={"vis:linkage:refresh"})
    public DxGrid list(VisLinkageItem condition) {
        Pager pager = this.visLinkageService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:linkage:edit", "vis:linkage:add"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visLinkageService.getItemById(id));
        }
        return new ModelAndView("vis/linkage/editVisLinkage");
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_linkage", opType="common_op_edit", requestParams={"name"}, opContent="vis_leftMenu_linkage")
    @RequiresPermissions(value={"vis:linkage:edit", "vis:linkage:add"})
    public ZKResultMsg save(VisLinkageItem item) {
        this.visLinkageService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String validName(String name) {
        VisLinkageItem item = this.visLinkageService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    @RequiresPermissions(value={"vis:linkage:del"})
    @LogRequest(module="system_module", object="vis_leftMenu_linkage", opType="common_op_del", requestParams={"names"}, opContent="vis_leftMenu_linkage")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visLinkageService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_linkage", opType="common_disable", requestParams={"names"}, opContent="vis_leftMenu_linkage")
    @RequiresPermissions(value={"vis:linkage:disableLinkage"})
    public ZKResultMsg disableLinkage(String ids) {
        this.ableLinkage(ids, false);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @LogRequest(module="vis_module", object="vis_leftMenu_linkage", opType="common_enable", requestParams={"names"}, opContent="vis_leftMenu_linkage")
    @RequiresPermissions(value={"vis:linkage:enableLinkage"})
    public ZKResultMsg enableLinkage(String ids) {
        this.ableLinkage(ids, true);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    private void ableLinkage(String ids, boolean enabled) {
        if (StringUtils.isNotEmpty((CharSequence)ids)) {
            String[] idArray;
            for (String id : idArray = StringUtils.split((String)ids, (String)",")) {
                VisLinkageItem item = new VisLinkageItem();
                item.setId(id);
                item.setEnabled(Boolean.valueOf(enabled));
                this.visLinkageService.saveVisLinkageItem(item);
            }
        }
    }
}

