/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisAttributeValueRemote;
import com.zkteco.zkbiosecurity.vis.service.VisAttributeValueService;
import com.zkteco.zkbiosecurity.vis.vo.VisAttributeValueItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class VisAttributeValueController
extends BaseController
implements VisAttributeValueRemote {
    @Autowired
    private VisAttributeValueService visAttributeValueService;

    @RequiresPermissions(value={"vis:attributeValue"})
    public ModelAndView index() {
        return new ModelAndView("vis/attributeValue/visAttributeValue");
    }

    @RequiresPermissions(value={"vis:attributeValue:edit"})
    public ModelAndView edit(@RequestParam(value="id", required=false) String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.visAttributeValueService.getItemById(id));
        }
        return new ModelAndView("vis/attributeValue/editVisAttributeValue");
    }

    @RequiresPermissions(value={"vis:attributeValue:edit"})
    public ZKResultMsg save(VisAttributeValueItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.visAttributeValueService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"vis:attributeValue:refresh"})
    public DxGrid list(VisAttributeValueItem condition) {
        Pager pager = this.visAttributeValueService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:attributeValue:del"})
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visAttributeValueService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public ZKResultMsg checkUsed() {
        ZKResultMsg msg = new ZKResultMsg();
        String attrIds = this.request.getParameter("ids");
        if (StringUtils.isNotBlank((CharSequence)attrIds)) {
            msg = this.visAttributeValueService.checkUsed(attrIds);
        }
        return msg;
    }
}

