/*
 * Decompiled with CFR 0.152.
 */
package sun.net.spi;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.SocketAddress;
import java.net.URI;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import sun.misc.REException;
import sun.misc.RegexpPool;
import sun.net.NetProperties;
import sun.net.SocksProxy;
import sun.security.action.LoadLibraryAction;

public class DefaultProxySelector
extends ProxySelector {
    static final String[][] props = new String[][]{{"http", "http.proxy", "proxy", "socksProxy"}, {"https", "https.proxy", "proxy", "socksProxy"}, {"ftp", "ftp.proxy", "ftpProxy", "proxy", "socksProxy"}, {"gopher", "gopherProxy", "socksProxy"}, {"socket", "socksProxy"}};
    private static final String SOCKS_PROXY_VERSION = "socksProxyVersion";
    private static boolean hasSystemProxies = false;

    @Override
    public List<Proxy> select(URI uRI) {
        Object object;
        if (uRI == null) {
            throw new IllegalArgumentException("URI can't be null.");
        }
        String string = uRI.getScheme();
        Object object2 = uRI.getHost();
        if (object2 == null && (object = uRI.getAuthority()) != null) {
            int n = ((String)object).indexOf(64);
            if (n >= 0) {
                object = ((String)object).substring(n + 1);
            }
            if ((n = ((String)object).lastIndexOf(58)) >= 0) {
                object = ((String)object).substring(0, n);
            }
            object2 = object;
        }
        if (string == null || object2 == null) {
            throw new IllegalArgumentException("protocol = " + string + " host = " + (String)object2);
        }
        object = new ArrayList(1);
        NonProxyInfo nonProxyInfo = null;
        if ("http".equalsIgnoreCase(string)) {
            nonProxyInfo = NonProxyInfo.httpNonProxyInfo;
        } else if ("https".equalsIgnoreCase(string)) {
            nonProxyInfo = NonProxyInfo.httpNonProxyInfo;
        } else if ("ftp".equalsIgnoreCase(string)) {
            nonProxyInfo = NonProxyInfo.ftpNonProxyInfo;
        }
        final String string2 = string;
        final NonProxyInfo nonProxyInfo2 = nonProxyInfo;
        final String string3 = ((String)object2).toLowerCase();
        Proxy proxy = AccessController.doPrivileged(new PrivilegedAction<Proxy>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Proxy run() {
                String string = null;
                int n = 0;
                String string22 = null;
                InetSocketAddress inetSocketAddress = null;
                for (int i = 0; i < props.length; ++i) {
                    int n2;
                    if (!props[i][0].equalsIgnoreCase(string2)) continue;
                    for (n2 = 1; n2 < props[i].length && ((string = NetProperties.get(props[i][n2] + "Host")) == null || string.length() == 0); ++n2) {
                    }
                    if (string == null || string.length() == 0) {
                        String string32;
                        Proxy proxy;
                        if (hasSystemProxies && (proxy = DefaultProxySelector.this.getSystemProxy(string32 = string2.equalsIgnoreCase("socket") ? "socks" : string2, string3)) != null) {
                            return proxy;
                        }
                        return Proxy.NO_PROXY;
                    }
                    if (nonProxyInfo2 != null) {
                        string22 = NetProperties.get(nonProxyInfo2.property);
                        NonProxyInfo nonProxyInfo = nonProxyInfo2;
                        synchronized (nonProxyInfo) {
                            if (string22 == null) {
                                if (nonProxyInfo2.defaultVal != null) {
                                    string22 = nonProxyInfo2.defaultVal;
                                } else {
                                    nonProxyInfo2.hostsSource = null;
                                    nonProxyInfo2.hostsPool = null;
                                }
                            } else if (string22.length() != 0) {
                                string22 = string22 + "|localhost|127.*|[::1]|0.0.0.0|[::0]";
                            }
                            if (string22 != null && !string22.equals(nonProxyInfo2.hostsSource)) {
                                RegexpPool regexpPool = new RegexpPool();
                                StringTokenizer stringTokenizer = new StringTokenizer(string22, "|", false);
                                try {
                                    while (stringTokenizer.hasMoreTokens()) {
                                        regexpPool.add(stringTokenizer.nextToken().toLowerCase(), (Object)Boolean.TRUE);
                                    }
                                }
                                catch (REException rEException) {
                                    // empty catch block
                                }
                                nonProxyInfo2.hostsPool = regexpPool;
                                nonProxyInfo2.hostsSource = string22;
                            }
                            if (nonProxyInfo2.hostsPool != null && nonProxyInfo2.hostsPool.match(string3) != null) {
                                return Proxy.NO_PROXY;
                            }
                        }
                    }
                    if ((n = NetProperties.getInteger(props[i][n2] + "Port", 0).intValue()) == 0 && n2 < props[i].length - 1) {
                        for (int j = 1; j < props[i].length - 1; ++j) {
                            if (j == n2 || n != 0) continue;
                            n = NetProperties.getInteger(props[i][j] + "Port", 0);
                        }
                    }
                    if (n == 0) {
                        n = n2 == props[i].length - 1 ? DefaultProxySelector.this.defaultPort("socket") : DefaultProxySelector.this.defaultPort(string2);
                    }
                    inetSocketAddress = InetSocketAddress.createUnresolved(string, n);
                    if (n2 == props[i].length - 1) {
                        int n3 = NetProperties.getInteger(DefaultProxySelector.SOCKS_PROXY_VERSION, 5);
                        return SocksProxy.create(inetSocketAddress, n3);
                    }
                    return new Proxy(Proxy.Type.HTTP, inetSocketAddress);
                }
                return Proxy.NO_PROXY;
            }
        });
        object.add(proxy);
        return object;
    }

    @Override
    public void connectFailed(URI uRI, SocketAddress socketAddress, IOException iOException) {
        if (uRI == null || socketAddress == null || iOException == null) {
            throw new IllegalArgumentException("Arguments can't be null.");
        }
    }

    private int defaultPort(String string) {
        if ("http".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("https".equalsIgnoreCase(string)) {
            return 443;
        }
        if ("ftp".equalsIgnoreCase(string)) {
            return 80;
        }
        if ("socket".equalsIgnoreCase(string)) {
            return 1080;
        }
        if ("gopher".equalsIgnoreCase(string)) {
            return 80;
        }
        return -1;
    }

    private static native boolean init();

    private synchronized native Proxy getSystemProxy(String var1, String var2);

    static {
        Boolean bl = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

            @Override
            public Boolean run() {
                return NetProperties.getBoolean("java.net.useSystemProxies");
            }
        });
        if (bl != null && bl.booleanValue()) {
            AccessController.doPrivileged(new LoadLibraryAction("net"));
            hasSystemProxies = DefaultProxySelector.init();
        }
    }

    static class NonProxyInfo {
        static final String defStringVal = "localhost|127.*|[::1]|0.0.0.0|[::0]";
        String hostsSource;
        Pattern pattern;
        final String property;
        final String defaultVal;
        static NonProxyInfo ftpNonProxyInfo = new NonProxyInfo("ftp.nonProxyHosts", null, null, "localhost|127.*|[::1]|0.0.0.0|[::0]");
        static NonProxyInfo httpNonProxyInfo = new NonProxyInfo("http.nonProxyHosts", null, null, "localhost|127.*|[::1]|0.0.0.0|[::0]");
        static NonProxyInfo socksNonProxyInfo = new NonProxyInfo("socksNonProxyHosts", null, null, "localhost|127.*|[::1]|0.0.0.0|[::0]");

        NonProxyInfo(String p, String s, Pattern pattern, String d) {
            this.property = p;
            this.hostsSource = s;
            this.pattern = pattern;
            this.defaultVal = d;
        }
    }
}

