/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.auth.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.auth.remote.AuthSecurityParamsRemote;
import com.zkteco.zkbiosecurity.auth.service.AuthSecurityParamsService;
import com.zkteco.zkbiosecurity.auth.service.AuthUserService;
import com.zkteco.zkbiosecurity.auth.vo.AuthUserItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.StrUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.servlet.ModelAndView;

@RestController
public class AuthSecurityParamsController
extends BaseController
implements AuthSecurityParamsRemote {
    @Autowired
    private AuthSecurityParamsService authsecurityParamsService;
    @Autowired
    private AuthUserService authUserService;
    private static final String SEC_KEY = "0123456789ABCDEF";

    @RequiresPermissions(value={"auth:securityParams"})
    public ModelAndView index() {
        return new ModelAndView("system/securityParams/securityParams");
    }

    @LogRequest(module="system_module", object="system_leftMenu_authSecurityParams", opType="common_op_edit", requestParams={""}, opContent="app_vis_set")
    public ZKResultMsg saveParams(@RequestParam Map<String, String> valMap) {
        ZKResultMsg res = new ZKResultMsg();
        HashMap<String, String> saveMap = new HashMap<String, String>();
        saveMap.put("verificationCodeOpen", valMap.get("verificationCodeOpen"));
        saveMap.put("passwordStrengthLevel", valMap.get("passwordStrengthLevel"));
        saveMap.put("loginErrorCont", valMap.get("loginErrorCont"));
        saveMap.put("lockTime", valMap.get("lockTime"));
        saveMap.put("effectiveTime", valMap.get("effectiveTime"));
        saveMap.put("otherEffectiveTime", valMap.get("otherEffectiveTime"));
        saveMap.put("initPwd", valMap.get("initPwd"));
        this.authsecurityParamsService.saveParams(saveMap);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public Map<String, String> getParams() {
        return this.authsecurityParamsService.getParams();
    }

    public ZKResultMsg getIsNeedVerCodeParams() {
        ZKResultMsg resultMsg = ZKResultMsg.successMsg();
        HashMap<String, Boolean> resMap = new HashMap<String, Boolean>(1);
        boolean res = this.authsecurityParamsService.getIsNeedVerCodeParams(this.request.getSession().getId());
        resMap.put("needVerCode", res);
        resultMsg.setData(resMap);
        return resultMsg;
    }

    public Boolean checkStrength(String strength) {
        return this.authsecurityParamsService.checkStrength(strength);
    }

    private Boolean isInitPassword(String userName, String password, String code) {
        Map initPwdVal = this.authsecurityParamsService.getParams("initPwd");
        if (Objects.isNull(initPwdVal)) {
            return false;
        }
        String val = (String)initPwdVal.get("initPwd");
        if (StringUtils.isBlank((CharSequence)val) || "0".equals(val)) {
            return false;
        }
        return this.authsecurityParamsService.isInitPwd(userName);
    }

    private boolean checkUserAndPwd(String userName, String password, String code) {
        return this.checkLoginExtInfo(userName, password, code);
    }

    private boolean checkLoginExtInfo(String userName, String password, String code) {
        AuthUserItem authUserItem = this.authUserService.getItemByUsername(userName);
        if (Objects.isNull(authUserItem) || StringUtils.isBlank((CharSequence)password) || !this.authUserService.verifyUserNameAndPwd(userName, password).booleanValue()) {
            return false;
        }
        Boolean needValCode = this.authsecurityParamsService.getIsNeedVerCodeParams(this.request.getSession().getId());
        if (needValCode.booleanValue()) {
            String codeValue = this.authsecurityParamsService.getVerCodeValue(this.request.getSession().getId(), false);
            if (StringUtils.isBlank((CharSequence)code) || !StrUtil.toUpperCase((String)code).equals(codeValue)) {
                return false;
            }
        }
        return true;
    }

    private Boolean isNeedChangePwd(String userName, String password, @RequestParam(value="code", required=false) String code) {
        if (!this.checkLoginExtInfo(userName, password, code)) {
            return false;
        }
        Boolean exist = this.authsecurityParamsService.isUserPwdTimeOut(userName);
        if (exist == null || exist.booleanValue()) {
            return true;
        }
        return false;
    }

    public ZKResultMsg needChangePwd(String userName, String password, String code) {
        ZKResultMsg zkResultMsg = ZKResultMsg.successMsg();
        HashMap<String, Boolean> Data = new HashMap<String, Boolean>(2);
        Data.put("init", this.isInitPassword(userName, password, code));
        Data.put("timeOut", this.isNeedChangePwd(userName, password, code));
        Data.put("checkPwd", this.checkUserAndPwd(userName, password, code));
        zkResultMsg.setData(Data);
        return zkResultMsg;
    }

    public ModelAndView initPassword(String userName) {
        String index = (String)this.authsecurityParamsService.getParams("passwordStrengthLevel").get("passwordStrengthLevel");
        if ("admin".equals(userName)) {
            this.request.setAttribute("message0", (Object)I18nUtil.i18nCode((String)"auth_security_initAdminPwdInfo0", (Object[])new Object[0]));
            this.request.setAttribute("message1", (Object)I18nUtil.i18nCode((String)"auth_security_initAdminPwdInfo1", (Object[])new Object[0]));
            this.request.setAttribute("message2", (Object)I18nUtil.i18nCode((String)"auth_security_initAdminPwdInfo2", (Object[])new Object[0]));
            if (!index.equals("3")) {
                this.request.setAttribute("message2Leave", (Object)I18nUtil.i18nCode((String)("auth_security_strengthLevel" + index), (Object[])new Object[0]));
            }
            this.request.setAttribute("message3Leave", (Object)I18nUtil.i18nCode((String)"auth_security_strengthLevel2", (Object[])new Object[0]));
            this.request.setAttribute("info1", (Object)"1");
            this.request.setAttribute("info2", (Object)"2");
            this.request.setAttribute("userName", (Object)"admin");
        } else {
            this.request.setAttribute("message0", (Object)I18nUtil.i18nCode((String)"auth_authSecurity_initUserPwd", (Object[])new Object[0]));
            this.request.setAttribute("message1", (Object)I18nUtil.i18nCode((String)"auth_security_initAdminPwdInfo1", (Object[])new Object[0]));
            if (!index.equals("3")) {
                this.request.setAttribute("message2Leave", (Object)I18nUtil.i18nCode((String)("auth_security_strengthLevel" + index), (Object[])new Object[0]));
                this.request.setAttribute("info1", (Object)index);
            }
            this.request.setAttribute("userName", this.request.getSession().getAttribute("loginUserName"));
            this.request.setAttribute("userName", (Object)userName);
        }
        Map initPwdMap = this.authsecurityParamsService.getParams("initPwd");
        if (StringUtils.isBlank((CharSequence)((CharSequence)initPwdMap.get("initPwd"))) || ((String)initPwdMap.get("initPwd")).equals("1")) {
            this.request.setAttribute("noInitValidate", (Object)"true");
        }
        return new ModelAndView("auth/password/initAdminPassword");
    }

    public ModelAndView expiredChangeUserPwd(String userName) {
        this.request.setAttribute("message0", (Object)I18nUtil.i18nCode((String)"auth_authSecurity_passwordExpired", (Object[])new Object[0]));
        this.request.setAttribute("message1", (Object)I18nUtil.i18nCode((String)"auth_security_initAdminPwdInfo1", (Object[])new Object[0]));
        String index = (String)this.authsecurityParamsService.getParams("passwordStrengthLevel").get("passwordStrengthLevel");
        if (StringUtils.equals((CharSequence)index, (CharSequence)"3")) {
            this.request.setAttribute("message2Leave", (Object)I18nUtil.i18nCode((String)"common_none", (Object[])new Object[0]));
        } else {
            this.request.setAttribute("message2Leave", (Object)I18nUtil.i18nCode((String)("auth_security_strengthLevel" + index), (Object[])new Object[0]));
        }
        this.request.setAttribute("info1", (Object)index);
        this.request.setAttribute("userName", this.request.getSession().getAttribute("loginUserName"));
        this.request.setAttribute("userName", (Object)userName);
        this.request.setAttribute("changePwd", (Object)"true");
        return new ModelAndView("auth/password/initAdminPassword");
    }

    public ModelAndView strengthChangeUserPwd(String userName) {
        this.request.setAttribute("message0", (Object)I18nUtil.i18nCode((String)"auth_authSecurity_passwordInsufficientStrength", (Object[])new Object[0]));
        this.request.setAttribute("message1", (Object)I18nUtil.i18nCode((String)"auth_security_initAdminPwdInfo1", (Object[])new Object[0]));
        String index = (String)this.authsecurityParamsService.getParams("passwordStrengthLevel").get("passwordStrengthLevel");
        this.request.setAttribute("message2Leave", (Object)I18nUtil.i18nCode((String)("auth_security_strengthLevel" + index), (Object[])new Object[0]));
        this.request.setAttribute("info1", (Object)index);
        this.request.setAttribute("userName", this.request.getSession().getAttribute("loginUserName"));
        this.request.setAttribute("userName", (Object)userName);
        this.request.setAttribute("changePwd", (Object)"true");
        return new ModelAndView("auth/password/initAdminPassword");
    }

    @LogRequest(module="auth_module", object="auth_leftMenu_userManage", opType="common_op_edit", requestParams={"userName"}, opContent="auth_user_password")
    public ZKResultMsg submitPwdInit(String userName, String password, String oldPassword) {
        AuthUserItem authUserItem = this.authUserService.getItemByUsername(userName);
        if (Objects.isNull(authUserItem)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_login_userOrPwdError", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if (!this.authUserService.verifyUserNameAndPwd(userName, oldPassword).booleanValue()) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_login_userOrPwdError", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        Boolean res = this.authsecurityParamsService.setUserPwd(userName, password);
        if (Objects.isNull(res) || !res.booleanValue()) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_security_passwordNotEmpty", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        return ZKResultMsg.successMsg();
    }

    @LogRequest(module="auth_module", object="auth_leftMenu_userManage", opType="common_op_edit", requestParams={"userName"}, opContent="auth_user_password")
    public ZKResultMsg submitPwdChange(String userName, String password, String oldPassword) {
        if (StringUtils.isBlank((CharSequence)userName)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_mail_inputUser", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if (StringUtils.isBlank((CharSequence)password) || StringUtils.isBlank((CharSequence)oldPassword)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_mail_inputPwd", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if (password.equals(oldPassword)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_authSecurity_canNotEqualsOldPwd", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        AuthUserItem authUserItem = this.authUserService.getItemByUsername(userName);
        if (Objects.isNull(authUserItem)) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_login_userOrPwdError", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        if (!this.authUserService.verifyUserNameAndPwd(userName, oldPassword).booleanValue()) {
            return ZKResultMsg.failMsg((String)I18nUtil.i18nCode((String)"auth_login_userOrPwdError", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        authUserItem.setLoginPwd(password);
        authUserItem.setPwdCreateTime(new Date());
        authUserItem.setPwdInitFlag("1");
        this.authUserService.saveItem(authUserItem);
        return ZKResultMsg.successMsg();
    }

    public ZKResultMsg pwdEffectiveCheck(String content) {
        String serKey = SEC_KEY;
        try {
            content = content.replace(".", "%");
            content = URLDecoder.decode(content, "UTF-8");
            SecretKeySpec skeySpec = new SecretKeySpec(serKey.getBytes(StandardCharsets.UTF_8), "AES");
            Cipher cipher = Cipher.getInstance("AES/ECB/PKCS5Padding");
            cipher.init(2, skeySpec);
            String deResultStr = new String(cipher.doFinal(Base64.decodeBase64((String)content)), "GBK");
            deResultStr = URLDecoder.decode(deResultStr, "UTF-8");
            JSONObject json = JSON.parseObject((String)deResultStr);
            return this.needChangePwd(json.getString("userName"), json.getString("password"), json.getString("code"));
        }
        catch (Exception e) {
            this.log.error(String.format("Decoding error:\uff0ccontent\uff1a%s, key: %s    --->", content, serKey), (Throwable)e);
            return ZKResultMsg.successMsg();
        }
    }
}

