/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.guard.license.bean;

import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import com.google.common.collect.Maps;
import com.zkteco.zkbiosecurity.guard.LicenseCheckUtil;
import com.zkteco.zkbiosecurity.guard.LicenseUtil;
import com.zkteco.zkbiosecurity.guard.license.bean.LangPack;
import com.zkteco.zkbiosecurity.guard.license.bean.Module;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleBean;
import com.zkteco.zkbiosecurity.guard.license.bean.ModuleCode;
import com.zkteco.zkbiosecurity.guard.license.bean.SystemModule;
import com.zkteco.zkbiosecurity.license.vo.bean.ResultCode;
import java.text.ParseException;
import java.util.Collection;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.time.DateUtils;

public final class LicenseContext {
    private final int languagePack;
    private final Date trialFinishDate;
    private final Map<Integer, ModuleBean> moduleMap;
    private final Map<String, String> licenseDataMap;
    private final boolean TRIAL_SUPPORT_C3_LOCAL = false;
    private final boolean TRIAL_SUPPORT_C3_OVERSEA = false;

    public LicenseContext(Date trialFinishDate, Map<Integer, ModuleBean> moduleMap, Map<String, String> licenseDataMap) {
        HashBiMap biMapModule = HashBiMap.create(moduleMap);
        this.moduleMap = Maps.unmodifiableBiMap((BiMap)biMapModule);
        this.trialFinishDate = trialFinishDate;
        this.licenseDataMap = Maps.unmodifiableBiMap((BiMap)HashBiMap.create(licenseDataMap));
        int lan = LangPack.UNFOUND.getLang();
        Iterator iterator = biMapModule.values().iterator();
        if (iterator.hasNext()) {
            ModuleBean moduleBean = (ModuleBean)iterator.next();
            lan = moduleBean.getLanguagePack();
        }
        this.languagePack = lan;
    }

    public boolean containModule(String moduleCode) {
        ModuleBean moduleBean = this.getLicenseModule(moduleCode);
        return moduleBean != null;
    }

    public ModuleBean getModuleBean(String moduleCode) {
        Collection<ModuleBean> modules = this.moduleMap.values();
        if (modules != null) {
            for (ModuleBean module : modules) {
                if (!module.getCode().equalsIgnoreCase(moduleCode)) continue;
                return module;
            }
        }
        return null;
    }

    public boolean maxLicenseAvailable() {
        return this.getMaxLicenseDate() >= LicenseUtil.getNow();
    }

    public int getMaxLicenseDate() {
        Collection<ModuleBean> ms = this.getLicenseModules();
        int limitNumberOfDays = 0;
        for (ModuleBean module : ms) {
            if (module.getLimitNumberOfDays() <= limitNumberOfDays) continue;
            limitNumberOfDays = module.getLimitNumberOfDays();
        }
        return limitNumberOfDays;
    }

    public int getMinLicenseDate() {
        Collection<ModuleBean> ms = this.getLicenseModules();
        int limitNumberOfDays = this.getMaxLicenseDate();
        for (ModuleBean module : ms) {
            if (0 >= module.getLimitNumberOfDays() || module.getLimitNumberOfDays() >= limitNumberOfDays) continue;
            limitNumberOfDays = module.getLimitNumberOfDays();
        }
        return limitNumberOfDays;
    }

    public int getMaxLicenseLeft() {
        int maxLicenseDate = this.getMaxLicenseDate();
        if (maxLicenseDate > 0) {
            try {
                Date licenseDate = DateUtils.parseDate((String)(maxLicenseDate + ""), (String[])new String[]{"yyyyMMdd"});
                int left = LicenseUtil.getDaysBetween(new Date(), licenseDate);
                return left;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return -1;
    }

    public int getMinLicenseLeft() {
        int maxLicenseDate = this.getMinLicenseDate();
        if (maxLicenseDate > 0) {
            try {
                Date licenseDate = DateUtils.parseDate((String)(maxLicenseDate + ""), (String[])new String[]{"yyyyMMdd"});
                int left = LicenseUtil.getDaysBetween(new Date(), licenseDate);
                return left;
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
        }
        return -1;
    }

    public int getTrialLeft() {
        Date now = new Date();
        if (this.trialFinishDate == null) {
            return LicenseUtil.getDaysBetween(now, now);
        }
        return LicenseUtil.getDaysBetween(now, this.trialFinishDate);
    }

    public boolean trialAvailable() {
        return this.getTrialLeft() > 0;
    }

    public boolean getCanLogin() {
        return this.trialAvailable() || this.maxLicenseAvailable();
    }

    public int getControlCount(Module module) {
        return this.getControlCount(module.getCode());
    }

    public int getControlCount(String moduleCode) {
        ModuleBean module = this.moduleMap.get(Module.getByCode(moduleCode).getId());
        if ("ele".equals(moduleCode)) {
            if (module != null) {
                return module.getControlCount();
            }
            if (this.trialAvailable()) {
                return LicenseUtil.getTrialControlCount(moduleCode);
            }
            return 0;
        }
        if (this.isSupportFunction(Module.MODULE_ACC_C3) == ResultCode.SUCCESS && moduleCode.equals(Module.MODULE_ACC_PULL.getCode())) {
            module = this.moduleMap.get(Module.MODULE_ACC_C3.getId());
        }
        if (module != null) {
            if (!module.isTrial()) {
                if ("systempers".equals(moduleCode)) {
                    return module.getControlCount() * 1000;
                }
                if ("systemdepartment".equals(moduleCode) || "systemarea".equals(moduleCode)) {
                    return module.getControlCount() * 100;
                }
            }
            return module.getControlCount();
        }
        if (this.trialAvailable()) {
            return LicenseUtil.getTrialControlCount(moduleCode);
        }
        return 0;
    }

    public int getControlOfflineEleCount(String moduleCode) {
        ModuleBean module = this.moduleMap.get(Module.getByCode(moduleCode).getId());
        if ("ele".equals(moduleCode)) {
            if (module != null && module.getMajor() == 0 && module.licenseAvaiable()) {
                return module.getControlCount();
            }
            return 0;
        }
        if (this.isSupportFunction(Module.MODULE_ACC_C3) == ResultCode.SUCCESS && moduleCode.equals(Module.MODULE_ACC_PULL.getCode())) {
            module = this.moduleMap.get(Module.MODULE_ACC_C3.getId());
        }
        if (module != null) {
            return module.getControlCount();
        }
        if (this.trialAvailable()) {
            return LicenseUtil.getTrialControlCount(moduleCode);
        }
        return 0;
    }

    String intToBinaryString(int count) {
        String temp;
        String result = temp = Integer.toBinaryString(count);
        if (temp.length() < 4) {
            for (int i = 0; i < 4 - temp.length(); ++i) {
                result = "0" + result;
            }
        }
        return result;
    }

    public int getVisPlaceControlCount() {
        ModuleBean visModule = LicenseUtil.getLicenseContext().getLicenseModule(LicenseCheckUtil.LicenseModule.VIS.getCode());
        int licenseCount = 0;
        if (visModule != null && !visModule.isTrial()) {
            licenseCount = visModule.getMajor();
            String minor = this.intToBinaryString(visModule.getMinor());
            if ('1' == minor.charAt(0)) {
                minor = minor.replaceFirst("1", "0");
                String major = this.intToBinaryString(licenseCount);
                licenseCount = Integer.parseInt(minor + major, 2);
            }
        } else if (visModule != null && visModule.isTrial()) {
            licenseCount = LicenseUtil.getTrialControlCount(LicenseCheckUtil.LicenseModule.VIS.getCode());
        }
        return this.detemineVisPlaceCount(licenseCount);
    }

    public String getVisPlaceControlCountDisplayStr() {
        int ct = this.getVisPlaceControlCount();
        return ct + "";
    }

    private int detemineVisPlaceCount(int oriCount) {
        if (oriCount >= 1 && oriCount <= 5 || oriCount >= 11 && oriCount <= 19 || oriCount >= 21 && oriCount <= 49) {
            return oriCount;
        }
        if (oriCount == 6) {
            return 10;
        }
        if (oriCount == 7) {
            return 20;
        }
        if (oriCount == 8) {
            return 50;
        }
        if (oriCount == 9) {
            return 100;
        }
        if (oriCount == 10) {
            return 1000000;
        }
        return 0;
    }

    public boolean isUseful(String moduleCode) {
        if (this.trialAvailable() && !this.licenseAvailable(moduleCode)) {
            if ("api".equalsIgnoreCase(moduleCode)) {
                return false;
            }
            if ("ad".equalsIgnoreCase(moduleCode)) {
                return false;
            }
            if ("printcard".equalsIgnoreCase(moduleCode)) {
                return false;
            }
        }
        return this.licenseAvailable(moduleCode) || this.trialAvailable();
    }

    public boolean licenseAvailable(String moduleCode) {
        ModuleBean moduleBean;
        Module module = Module.getByCode(moduleCode);
        if (module != null && (moduleBean = this.getLicenseModule(moduleCode)) != null) {
            return moduleBean.licenseAvaiable();
        }
        return false;
    }

    public ResultCode isSupportFunction(Module functionModule) {
        ModuleBean module = this.getLicenseModule(functionModule.getCode());
        if (module != null) {
            if (module.trialAvaiable()) {
                return ResultCode.SUCCESS;
            }
            if (module.licenseAvaiable()) {
                return ResultCode.SUCCESS;
            }
            if (module.isTrial()) {
                return ResultCode.TRIALEXPIRED;
            }
            return ResultCode.EXPIRED;
        }
        if (!functionModule.canTrial()) {
            return ResultCode.UNSUPPORT;
        }
        if (LicenseUtil.getLeftTrialDay(functionModule.getCode()) > 0) {
            return ResultCode.SUCCESS;
        }
        return ResultCode.UNAUTH;
    }

    public ResultCode supportModule(Module module) {
        ModuleBean moduleBean = this.getLicenseModule(module.getCode());
        if (moduleBean != null) {
            if (moduleBean.trialAvaiable()) {
                return ResultCode.SUCCESS;
            }
            if (moduleBean.licenseAvaiable()) {
                return ResultCode.SUCCESS;
            }
            if (moduleBean.isTrial()) {
                return ResultCode.TRIALEXPIRED;
            }
            return ResultCode.EXPIRED;
        }
        return ResultCode.UNAUTH;
    }

    public Collection<ModuleBean> getLicenseModules() {
        Map<Integer, ModuleBean> mp = this.getModuleMap();
        return mp.values();
    }

    public ModuleBean getLicenseModule(String moduleCode) {
        return LicenseContext.getLicenseModule(moduleCode, this.moduleMap);
    }

    public boolean isModuleLicensed(String moduleCode) {
        ModuleCode module = ModuleCode.getByCode(moduleCode);
        if (module != null) {
            boolean useful = this.isUseful(moduleCode);
            if (useful) {
                return true;
            }
            SystemModule systemModule = SystemModule.getByCode(moduleCode);
            if (systemModule != null) {
                if (systemModule.isLeaf()) {
                    return this.isUseful(moduleCode);
                }
                List<Module> modules = systemModule.getModules();
                for (Module subModule : modules) {
                    if (!this.isUseful(subModule.getCode())) continue;
                    useful = true;
                }
                return useful;
            }
            return false;
        }
        return true;
    }

    public int getLanguagePack() {
        return this.languagePack;
    }

    public Date getTrialFinishDate() {
        return this.trialFinishDate;
    }

    public Map<Integer, ModuleBean> getModuleMap() {
        return this.moduleMap;
    }

    public Map<String, String> getLicenseDataMap() {
        return this.licenseDataMap;
    }

    public static boolean containModule(String moduleCode, Map<Integer, ModuleBean> moduleBeanMap) {
        ModuleBean moduleBean = LicenseContext.getLicenseModule(moduleCode, moduleBeanMap);
        return moduleBean != null;
    }

    public static ModuleBean getLicenseModule(String moduleCode, Map<Integer, ModuleBean> moduleBeanMap) {
        Collection<ModuleBean> modules = moduleBeanMap.values();
        for (ModuleBean module : modules) {
            if (module.getCode().equalsIgnoreCase(moduleCode)) {
                return module;
            }
            if (!Module.MODULE_ACC_PULL.getCode().equalsIgnoreCase(moduleCode) || !module.getCode().equals(Module.MODULE_ACC_C3.getCode())) continue;
            return module;
        }
        return null;
    }

    public static void putModule(ModuleBean moduleBean, Map<Integer, ModuleBean> moduleBeanMap) {
        if (moduleBean != null) {
            moduleBeanMap.put(moduleBean.getModule(), moduleBean);
        }
    }
}

