/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.pos.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="POS_HANDCONSUME t left join POS_MEAL pm on t.MEAL_ID = pm.ID")
@OrderBy(after="t.CREATE_TIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600)
public class PosHandConsumeItem
extends BaseItem {
    @Column(name="t.ID")
    @GridColumn(checkbox=true, width="40", sort="na", show=false)
    private String id;
    @Column(name="t.PERSON_ID")
    @GridColumn(label="pos_handConsume_personId", show=false)
    private String personId;
    @Column(name="t.PERSON_PIN")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="t.PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="t.PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="80", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.DEPT_ID")
    @GridColumn(label="pos_handConsume_deptId", show=false)
    private String deptId;
    @Column(name="t.DEPT_CODE")
    @GridColumn(label="pos_handConsume_deptCode", show=false)
    private String deptCode;
    @Column(name="t.DEPT_NAME")
    @GridColumn(label="pos_handConsume_deptName", show=false)
    private String deptName;
    @Column(name="t.CARD_SYS_NO")
    @GridColumn(label="pos_card_accountNum", width="100")
    private String cardSysNo;
    @Column(name="t.CARD_SERIAL_NO")
    @GridColumn(label="pos_card_cardSerial", width="120")
    private String cardSerialNo;
    @Column(name="t.CARD_NO")
    @GridColumn(label="pos_card_card", width="120")
    private String cardNo;
    @Column(name="t.MONEY")
    @GridColumn(label="pos_cus_money", width="150", format="0=0.0")
    private Double money;
    @Column(name="t.BALANCE")
    @GridColumn(label="pos_card_blance", width="90", format="0=0.0")
    private Double balance;
    @Column(name="pm.NAME")
    @GridColumn(label="pos_cus_meal")
    private String mealName;
    @Column(name="t.MEAL_ID")
    @GridColumn(label="pos_transaction_posMeal", show=false)
    private String mealId;
    @Column(name="t.DEVICE_SN")
    @GridColumn(label="common_dev_sn", width="150")
    private String deviceSn;
    @Column(name="t.DATE_TIME")
    @GridColumn(label="pos_cus_time", width="130")
    private Date dateTime;
    @Column(name="t.CREATE_TIME")
    @GridColumn(label="pos_cus_creatTime", width="130")
    private Date createTime;
    @Column(name="t.CREATER_NAME")
    @GridColumn(label="pos_card_creatOperator", width="110")
    private String createrName;
    @Column(name="t.DEVICE_ID")
    @GridColumn(label="pos_handConsume_posDevice", show=false)
    private String posDeviceId;
    @Column(name="t.STATUS")
    @GridColumn(label="pos_handConsume_status", show=false)
    private Short status;
    @Condition(value="t.DATE_TIME", equalTag=">=", toDate=true)
    private String startDatetimeBegin;
    @Condition(value="t.DATE_TIME", equalTag="<=", toDate=true)
    private String startDatetimeEnd;
    @Condition(value="t.DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="(lower(t.PERSON_NAME) LIKE ''%{0}%'' OR lower(t.PERSON_LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;

    public PosHandConsumeItem() {
    }

    public PosHandConsumeItem(Boolean equals) {
        super(equals);
    }

    public PosHandConsumeItem(String id) {
        super(Boolean.valueOf(true));
        this.id = id;
    }

    public PosHandConsumeItem(String id, String personId, String personPin, String personName, String personLastName, String deptId, String deptCode, String deptName, String cardSysNo, String cardNo, String cardSerialNo, Double money, Double balance, Date dateTime, String deviceSn, Short status) {
        this.id = id;
        this.personId = personId;
        this.personPin = personPin;
        this.personName = personName;
        this.personLastName = personLastName;
        this.deptId = deptId;
        this.deptCode = deptCode;
        this.deptName = deptName;
        this.cardSysNo = cardSysNo;
        this.cardNo = cardNo;
        this.cardSerialNo = cardSerialNo;
        this.money = money;
        this.balance = balance;
        this.dateTime = dateTime;
        this.deviceSn = deviceSn;
        this.status = status;
    }

    public String getId() {
        return this.id;
    }

    public String getPersonId() {
        return this.personId;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getCardSysNo() {
        return this.cardSysNo;
    }

    public String getCardSerialNo() {
        return this.cardSerialNo;
    }

    public String getCardNo() {
        return this.cardNo;
    }

    public Double getMoney() {
        return this.money;
    }

    public Double getBalance() {
        return this.balance;
    }

    public String getMealName() {
        return this.mealName;
    }

    public String getMealId() {
        return this.mealId;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public Date getDateTime() {
        return this.dateTime;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getCreaterName() {
        return this.createrName;
    }

    public String getPosDeviceId() {
        return this.posDeviceId;
    }

    public Short getStatus() {
        return this.status;
    }

    public String getStartDatetimeBegin() {
        return this.startDatetimeBegin;
    }

    public String getStartDatetimeEnd() {
        return this.startDatetimeEnd;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getLikeName() {
        return this.likeName;
    }

    public PosHandConsumeItem setId(String id) {
        this.id = id;
        return this;
    }

    public PosHandConsumeItem setPersonId(String personId) {
        this.personId = personId;
        return this;
    }

    public PosHandConsumeItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public PosHandConsumeItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public PosHandConsumeItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public PosHandConsumeItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public PosHandConsumeItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public PosHandConsumeItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public PosHandConsumeItem setCardSysNo(String cardSysNo) {
        this.cardSysNo = cardSysNo;
        return this;
    }

    public PosHandConsumeItem setCardSerialNo(String cardSerialNo) {
        this.cardSerialNo = cardSerialNo;
        return this;
    }

    public PosHandConsumeItem setCardNo(String cardNo) {
        this.cardNo = cardNo;
        return this;
    }

    public PosHandConsumeItem setMoney(Double money) {
        this.money = money;
        return this;
    }

    public PosHandConsumeItem setBalance(Double balance) {
        this.balance = balance;
        return this;
    }

    public PosHandConsumeItem setMealName(String mealName) {
        this.mealName = mealName;
        return this;
    }

    public PosHandConsumeItem setMealId(String mealId) {
        this.mealId = mealId;
        return this;
    }

    public PosHandConsumeItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public PosHandConsumeItem setDateTime(Date dateTime) {
        this.dateTime = dateTime;
        return this;
    }

    public PosHandConsumeItem setCreateTime(Date createTime) {
        this.createTime = createTime;
        return this;
    }

    public PosHandConsumeItem setCreaterName(String createrName) {
        this.createrName = createrName;
        return this;
    }

    public PosHandConsumeItem setPosDeviceId(String posDeviceId) {
        this.posDeviceId = posDeviceId;
        return this;
    }

    public PosHandConsumeItem setStatus(Short status) {
        this.status = status;
        return this;
    }

    public PosHandConsumeItem setStartDatetimeBegin(String startDatetimeBegin) {
        this.startDatetimeBegin = startDatetimeBegin;
        return this;
    }

    public PosHandConsumeItem setStartDatetimeEnd(String startDatetimeEnd) {
        this.startDatetimeEnd = startDatetimeEnd;
        return this;
    }

    public PosHandConsumeItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public PosHandConsumeItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String toString() {
        return "PosHandConsumeItem(id=" + this.getId() + ", personId=" + this.getPersonId() + ", personPin=" + this.getPersonPin() + ", personName=" + this.getPersonName() + ", personLastName=" + this.getPersonLastName() + ", deptId=" + this.getDeptId() + ", deptCode=" + this.getDeptCode() + ", deptName=" + this.getDeptName() + ", cardSysNo=" + this.getCardSysNo() + ", cardSerialNo=" + this.getCardSerialNo() + ", cardNo=" + this.getCardNo() + ", money=" + this.getMoney() + ", balance=" + this.getBalance() + ", mealName=" + this.getMealName() + ", mealId=" + this.getMealId() + ", deviceSn=" + this.getDeviceSn() + ", dateTime=" + this.getDateTime() + ", createTime=" + this.getCreateTime() + ", createrName=" + this.getCreaterName() + ", posDeviceId=" + this.getPosDeviceId() + ", status=" + this.getStatus() + ", startDatetimeBegin=" + this.getStartDatetimeBegin() + ", startDatetimeEnd=" + this.getStartDatetimeEnd() + ", inDeptId=" + this.getInDeptId() + ", likeName=" + this.getLikeName() + ")";
    }
}

