/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttYearStatisticalReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttRecordService;
import com.zkteco.zkbiosecurity.att.service.AttYearStatisticalReportService;
import com.zkteco.zkbiosecurity.att.vo.AttYearStatisticalReportItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttYearStatisticalReportController
extends ExportController
implements AttYearStatisticalReportRemote {
    @Autowired
    private AttYearStatisticalReportService attYearStatisticalReportService;
    @Autowired(required=false)
    private AuthDepartmentService authDepartmentService;
    @Autowired
    private AttRecordService attRecordService;

    @RequiresPermissions(value={"att:yearStatistiCalReport"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/report/attYearStatistical");
    }

    @RequiresPermissions(value={"att:yearStatistiCalReport:refresh"})
    public DxGrid list(AttYearStatisticalReportItem condition) {
        Pager pager = this.attYearStatisticalReportService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:yearStatistiCalReport:export"})
    @LogRequest(module="att_module", object="att_leftMenu_yearStatisticalReport", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttYearStatisticalReportItem attYearStatisticalReportItem = new AttYearStatisticalReportItem();
        this.setConditionValue((BaseItem)attYearStatisticalReportItem);
        List itemList = this.attRecordService.getYearStatisticalReportItemData(request.getSession().getId(), AttYearStatisticalReportItem.class, (BaseItem)attYearStatisticalReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(itemList, AttYearStatisticalReportItem.class);
    }
}

