/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttSignAddressRemote;
import com.zkteco.zkbiosecurity.att.service.AttParamService;
import com.zkteco.zkbiosecurity.att.service.AttSignAddressService;
import com.zkteco.zkbiosecurity.att.vo.AttSignAddressItem;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttSignAddressController
extends ExportController
implements AttSignAddressRemote {
    @Autowired
    private AttSignAddressService attSignAddressService;
    @Autowired
    private AttParamService attParamService;

    @RequiresPermissions(value={"att:signAddress"})
    public ModelAndView index() {
        return new ModelAndView("/att/signAddress/attSignAddress");
    }

    @RequiresPermissions(value={"att:signAddress:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            AttSignAddressItem item = this.attSignAddressService.getAttSignAddressItemById(id);
            this.request.setAttribute("item", (Object)item);
        }
        Map attParams = this.attParamService.getAttParams();
        this.request.setAttribute("attParams", (Object)attParams);
        return new ModelAndView("/att/signAddress/editAttSignAddress");
    }

    @RequiresPermissions(value={"att:signAddress:edit"})
    public ZKResultMsg save(AttSignAddressItem item) {
        ZKResultMsg zkResultMsg = new ZKResultMsg();
        AttSignAddressItem attSignAddressItem = this.attSignAddressService.saveItem(item);
        if (attSignAddressItem == null) {
            zkResultMsg.setMsg("att_self_attSignAddressAreaIsExist");
            return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequiresPermissions(value={"att:signAddress:refresh"})
    public DxGrid list(AttSignAddressItem condition) {
        Pager pager = this.attSignAddressService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:signAddress:del"})
    public ZKResultMsg delete(String ids) {
        this.attSignAddressService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

