/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttLeaveSummaryReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttLeaveSummaryReportService;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveSummaryReportItem;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.auth.service.AuthDepartmentService;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttLeaveSummaryReportController
extends ExportController
implements AttLeaveSummaryReportRemote {
    @Autowired
    private AttLeaveSummaryReportService attLeaveSummaryReportService;
    @Autowired(required=false)
    private AuthDepartmentService authDepartmentService;
    @Autowired
    private AttPersonService attPersonService;

    @RequiresPermissions(value={"att:leaveSummaryReport"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        AttPersonItem attPersonItem = this.attPersonService.getItemByPersonPin(securitySubject.getUserCode());
        if (Objects.nonNull(attPersonItem)) {
            staff = true;
        }
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/report/attLeaveSummary");
    }

    @RequiresPermissions(value={"att:leaveSummaryReport:refresh"})
    public DxGrid list(AttLeaveSummaryReportItem condition) {
        Pager pager = this.attLeaveSummaryReportService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:leaveSummaryReport:export"})
    @LogRequest(module="att_module", object="att_leftMenu_leaveSummaryReport", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttLeaveSummaryReportItem attLeaveSummaryReportItem = new AttLeaveSummaryReportItem();
        this.setConditionValue((BaseItem)attLeaveSummaryReportItem);
        List intemList = (List)this.attLeaveSummaryReportService.getItemData(request.getSession().getId(), AttLeaveSummaryReportItem.class, attLeaveSummaryReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttLeaveSummaryReportItem.class);
    }

    public ZKResultMsg getLeaveDetail(String personPin, String leaveTypeId, Date startTime, Date endTime) {
        return this.attLeaveSummaryReportService.getLeaveDetail(personPin, leaveTypeId, startTime, endTime);
    }
}

