/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttDeviceOptionRemote;
import com.zkteco.zkbiosecurity.att.service.AttDeviceOptionService;
import com.zkteco.zkbiosecurity.att.vo.AttDeviceOptionItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttDeviceOptionController
extends BaseController
implements AttDeviceOptionRemote {
    @Autowired
    private AttDeviceOptionService attDeviceOptionService;

    @RequiresPermissions(value={"att:deviceOption"})
    public ModelAndView index() {
        return new ModelAndView("att/deviceOption/attDeviceOption");
    }

    @RequiresPermissions(value={"acc:deviceOption:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attDeviceOptionService.getItemById(id));
        }
        return new ModelAndView("att/deviceOption/editAttDeviceOption");
    }

    @RequiresPermissions(value={"att:deviceOption:edit"})
    @LogRequest(module="att_module", object="att_deviceOption", opType="att_deviceOption_edit", requestParams={"deviceId"}, opContent="att_deviceOption_device")
    public ZKResultMsg save(AttDeviceOptionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attDeviceOptionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:deviceOption:refresh"})
    public DxGrid list(AttDeviceOptionItem codition) {
        Pager pager = this.attDeviceOptionService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:deviceOption:del"})
    @LogRequest(module="att_module", object="att_deviceOption", opType="att_deviceOption_del", requestParams={"id"}, opContent="att_common_id")
    public ZKResultMsg del(String ids) {
        this.attDeviceOptionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

