/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.h5.controller;

import com.zkteco.zkbiosecurity.att.h5.service.AttApiH5PersonSchService;
import com.zkteco.zkbiosecurity.att.util.ValidatorsUtils;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/att"})
public class AttApiH5PersonSchController {
    @Autowired
    private AttApiH5PersonSchService attApiPersonSchH5Service;

    @RequestMapping(path={"/getWorkTime"}, method={RequestMethod.GET}, produces={"application/json"})
    public ZKResultMsg getWorkTime(@RequestParam(name="customerId") String customerId, @RequestParam(name="schDate") String schDate) {
        if (StringUtils.isBlank((CharSequence)customerId)) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!(ValidatorsUtils.isDate(schDate) || ValidatorsUtils.isMonth(schDate) || ValidatorsUtils.isDateTime(schDate))) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        return I18nUtil.i18nMsg((ZKResultMsg)this.attApiPersonSchH5Service.getWorkTime(customerId, schDate));
    }
}

