/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.utils;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufInputStream;
import io.netty.handler.codec.http.HttpContent;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.apache.log4j.Logger;

public class HttpObjectUtil {
    public static final Logger logger = Logger.getLogger((String)HttpObjectUtil.class.getName());

    public static String getContentByHttpContent(HttpContent httpContent, String encoding) {
        ByteBuf bytebuf = httpContent.content();
        return HttpObjectUtil.getHttpContentAsString(bytebuf, encoding);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getHttpContentAsString(ByteBuf bytebuf, String encoding) {
        StringBuffer result = new StringBuffer();
        InputStreamReader inputStreamReader = null;
        BufferedReader bufferedReader = null;
        String line = "";
        try {
            bytebuf.readerIndex(0);
            inputStreamReader = new InputStreamReader((InputStream)new ByteBufInputStream(bytebuf), encoding);
            bufferedReader = new BufferedReader(inputStreamReader);
            while ((line = bufferedReader.readLine()) != null) {
                result.append(line + "\r\n");
            }
        }
        catch (IOException e) {
            logger.error((Object)"Get Http Content Failed!", (Throwable)e);
        }
        finally {
            try {
                if (inputStreamReader != null) {
                    inputStreamReader.close();
                }
                if (bufferedReader != null) {
                    bufferedReader.close();
                }
            }
            catch (IOException e) {
                logger.error((Object)"System.IOException", (Throwable)e);
            }
        }
        return result.toString().trim();
    }
}

