/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.init;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.service.AttLeaveTypeService;
import com.zkteco.zkbiosecurity.att.service.AttTimingService;
import com.zkteco.zkbiosecurity.att.vo.AttLeaveTypeItem;
import com.zkteco.zkbiosecurity.auth.service.AuthPermissionService;
import com.zkteco.zkbiosecurity.auth.vo.AuthPermissionItem;
import com.zkteco.zkbiosecurity.base.utils.VersionUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.constants.BaseDataConstants;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.service.BaseSysParamService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryItem;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import com.zkteco.zkbiosecurity.system.vo.BaseSysParamItem;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=40)
public class AttInit
implements CommandLineRunner {
    @Autowired
    private AuthPermissionService authPermissionService;
    @Autowired
    private BaseSysParamService baseSysParamService;
    @Autowired
    private BaseDictionaryService baseDictionaryService;
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private AttLeaveTypeService attLeaveTypeService;
    @Autowired
    private AttTimingService attTimingService;
    @Value(value="${system.productCode}")
    private String productCode;

    public void run(String ... args) throws Exception {
        boolean alreadyInit = this.baseSysParamService.getAlreadyInitModule("AttInit");
        if (!alreadyInit) {
            this.initAuthPermission();
            this.initAttParams();
            this.initAttLeaveType();
            this.initAttDictionary();
            this.initUpgradeVersion();
            this.baseSysParamService.setAlreadyInitModule("AttInit");
        }
    }

    private void initAuthPermission() {
        AuthPermissionItem systemMenuItem = null;
        AuthPermissionItem parentMenuItem = null;
        AuthPermissionItem childMenuItem = null;
        AuthPermissionItem buttonMenuItem = null;
        systemMenuItem = new AuthPermissionItem("Att", "att_module", "att", "system", "true", Integer.valueOf(4));
        systemMenuItem = this.authPermissionService.saveItem(systemMenuItem);
        parentMenuItem = new AuthPermissionItem("AttAttendanceDevice", "att_leftMenu_attendanceDevice", "att:attendance:device", "menu", "true", Integer.valueOf(1));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attDevice.do");
        parentMenuItem.setImg("att_device.png");
        parentMenuItem.setImgHover("att_device_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttAreaPerson", "common_setByArea", "att:areaPerson", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attAreaPerson.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonRefresh", "common_op_refresh", "att:areaPerson:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonDel", "common_op_del", "att:areaPerson:del", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonAddPerson", "att_op_forZoneAddPers", "att:areaPerson:addPerson", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonSetUserSms", "att_op_dataUserSms", "att:areaPerson:setUserSms", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAreaPersonSyncDev", "att_op_syncPers", "att:areaPerson:syncPerToDev", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttPersonArea", "common_setByPerson", "att:personArea", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attAreaPerson.do?personArea");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonAreaRefresh", "common_op_refresh", "att:personArea:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonAreaAddArea", "att_areaPerson_addArea", "att:personArea:addArea", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonAreaDelArea", "att_areaPerson_delArea", "att:personArea:delArea", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDevice", "att_leftMenu_device", "att:device", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDevice.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceRefresh", "common_op_refresh", "att:device:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceEdit", "common_op_edit", "att:device:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSearch", "common_dev_searchDev", "att:device:search", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceDel", "common_op_del", "att:device:del", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceEnable", "common_enable", "att:device:enable", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceDisable", "common_disable", "att:device:disable", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSyncDev", "att_op_syncDev", "att:device:syncdev", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSetTime", "att_op_account", "att:device:settime", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceFillPin", "att_device_getPin", "att:device:fillpin", "button", "true", Integer.valueOf(9));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSetStamp", "att_op_check", "att:device:setstamp", "button", "true", Integer.valueOf(10));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceDeleteCmd", "att_op_deleteCmd", "att:device:deletecmd", "button", "true", Integer.valueOf(11));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceSetSms", "att_op_dataSms", "att:device:setsms", "button", "true", Integer.valueOf(12));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceClearAttPic", "att_op_clearAttPic", "att:device:clearattpic", "button", "true", Integer.valueOf(13));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceClearAttLog", "att_op_clearAttLog", "att:device:clearattlog", "button", "true", Integer.valueOf(14));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceReboot", "common_dev_reboot", "att:device:reboot", "button", "true", Integer.valueOf(15));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceGetDevOpt", "common_dev_getDevOpt", "att:device:getdevopt", "button", "true", Integer.valueOf(16));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceQueryOption", "att_deviceOption_query", "att:device:queryOption", "button", "true", Integer.valueOf(18));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttPoint", "att_leftMenu_point", "att:point", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attPoint.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPointRefresh", "common_op_refresh", "att:point:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPointAdd", "common_op_new", "att:point:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPointDel", "common_op_del", "att:point:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPointEdit", "common_op_edit", "att:point:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = this.authPermissionService.getItemByCode("PersPerson");
        if (null != childMenuItem) {
            buttonMenuItem = new AuthPermissionItem("PersPersonAttEdit", "pers_person_attSet", "pers:person:attEdit", "button", "true", Integer.valueOf(101));
            buttonMenuItem.setParentId(childMenuItem.getId());
            buttonMenuItem = this.authPermissionService.initData(buttonMenuItem);
        }
        childMenuItem = new AuthPermissionItem("AttDeviceOpLog", "att_leftMenu_device_op_log", "att:deviceoplog", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDeviceOpLog.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeviceOpLogRefresh", "common_op_refresh", "att:deviceoplog:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttBasicInformation", "att_leftMenu_basicInformation", "att:basic:information", "menu", "true", Integer.valueOf(2));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attRule.do");
        parentMenuItem.setImg("att_basic.png");
        parentMenuItem.setImgHover("att_basic_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttRule", "att_leftMenu_base_rule", "att:rule", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attRule.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttRuleEdit", "common_op_edit", "att:rule:edit", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttCustomRule", "att_leftMenu_custom_rule", "att:customRule", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attCustomRule.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttCustomRuleRefresh", "common_op_refresh", "att:customRule:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttCustomRuleAdd", "common_op_new", "att:customRule:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttCustomRuleDel", "common_op_del", "att:customRule:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttCustomRuleEdit", "common_op_edit", "att:customRule:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttHoliday", "att_leftMenu_holiday", "att:holiday", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attHoliday.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttHolidayRefresh", "common_op_refresh", "att:holiday:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttHolidayAdd", "common_op_new", "att:holiday:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttHolidayDel", "common_op_del", "att:holiday:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttHolidayEdit", "common_op_edit", "att:holiday:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttLeaveType", "att_leftMenu_leaveType", "att:leaveType", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attLeaveType.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveTypeRefresh", "common_op_refresh", "att:leaveType:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveTypeAdd", "common_op_new", "att:leaveType:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveTypeDel", "common_op_del", "att:leaveType:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveTypeEdit", "common_op_edit", "att:leaveType:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttTiming", "att_leftMenu_timingCalculation", "att:timing", "menu", "false", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attTiming.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimingRefresh", "common_op_refresh", "att:timing:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimingAdd", "common_op_new", "att:timing:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimingDel", "common_op_del", "att:timing:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimingEnable", "common_enable", "att:timing:enable", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimingDisable", "common_disable", "att:timing:disable", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimingEdit", "common_op_edit", "att:timing:edit", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttAutoExport", "att_leftMenu_autoExport", "att:autoExport", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attAutoExport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportRefresh", "common_op_refresh", "att:autoExport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportAdd", "common_op_new", "att:autoExport:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportDel", "common_op_del", "att:autoExport:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportEnable", "common_enable", "att:autoExport:enable", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportDisable", "common_disable", "att:autoExport:disable", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAutoExportEdit", "common_op_edit", "att:autoExport:edit", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttParam", "att_leftMenu_param", "att:param", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attParam.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttParamEdit", "common_op_edit", "att:param:edit", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttShiftManagement", "att_leftMenu_shiftManagement", "att:shift:management", "menu", "true", Integer.valueOf(3));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attShift.do");
        parentMenuItem.setImg("att_shift.png");
        parentMenuItem.setImgHover("att_shift_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttBreakTime", "att_leftMenu_breakTime", "att:breakTime", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attBreakTime.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttBreakTimeRefresh", "common_op_refresh", "att:breakTime:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttBreakTimeAdd", "common_op_new", "att:breakTime:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttBreakTimeDel", "common_op_del", "att:breakTime:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttBreakTimeEdit", "common_op_edit", "att:breakTime:edit", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttTimeSlot", "att_leftMenu_timeSlot", "att:timeSlot", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attTimeSlot.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimeSlotRefresh", "common_op_refresh", "att:timeSlot:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimeSlotAdd", "common_op_new", "att:timeSlot:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimeSlotDel", "common_op_del", "att:timeSlot:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTimeSlotEdit", "common_op_edit", "att:timeSlot:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttShift", "att_leftMenu_shift", "att:shift", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attShift.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftRefresh", "common_op_refresh", "att:shift:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftAdd", "common_op_new", "att:shift:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftDel", "common_op_del", "att:shift:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftEdit", "common_op_edit", "att:shift:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttShiftClearTimeSlot", "att_shift_cleanTimeSlot", "att:shift:clearTimeSlot", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttScheduleManagement", "att_leftMenu_scheduleManagement", "att:schedule:management", "menu", "true", Integer.valueOf(4));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attGroup.do");
        parentMenuItem.setImg("att_schedule.png");
        parentMenuItem.setImgHover("att_schedule_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttGroup", "att_leftMenu_group", "att:group", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attGroup.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupRefresh", "common_op_refresh", "att:group:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupAdd", "common_op_new", "att:group:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupDel", "common_op_del", "att:group:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupDelPerson", "pers_common_delPerson", "att:group:delperson", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupEdit", "common_op_edit", "att:group:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupAddPerson", "common_op_addPerson", "att:group:addPerson", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupPersonRefresh", "common_op_refresh", "att:groupPerson:refresh", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupPersonDel", "common_op_del", "att:groupPerson:del", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttGroupSch", "att_leftMenu_groupSch", "att:groupsch", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attGroupSch.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupSchRefresh", "common_op_refresh", "att:groupsch:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupSchAdd", "common_op_new", "att:groupsch:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupSchDel", "common_op_del", "att:groupsch:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupSchAddTempSch", "att_schedult_opAddTempSch", "att:groupsch:addtempsch", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttGroupSchEdit", "common_op_edit", "att:groupsch:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDeptSch", "att_leftMenu_deptSch", "att:deptsch", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDeptSch.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptSchRefresh", "common_op_refresh", "att:deptsch:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptSchAdd", "common_op_new", "att:deptsch:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptSchDel", "common_op_del", "att:deptsch:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptSchAddTempSch", "att_schedult_opAddTempSch", "att:deptsch:addtempsch", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptSchEdit", "common_op_edit", "att:deptsch:edit", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttPersonSch", "att_leftMenu_personSch", "att:personsch", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attPersonSch.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttPersonSchAddTempSch", "att_schedult_opAddTempSch", "att:personsch:addtempsch", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttTempSch", "att_leftMenu_tempSch", "att:tempsch", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attTempSch.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTempSchRefresh", "common_op_refresh", "att:tempsch:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTempSchDel", "common_op_del", "att:tempsch:del", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTempSchEdit", "common_op_edit", "att:tempsch:edit", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttNonSch", "att_leftMenu_nonSch", "att:nonSch", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attNonSch.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttNonSchRefresh", "common_op_refresh", "att:nonSch:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttNonSchAddTempSch", "att_schedult_opAddTempSch", "att:nonSch:addtempsch", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttExceptionManagement", "att_leftMenu_exceptionManagement", "att:exception:management", "menu", "true", Integer.valueOf(5));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attSign.do");
        parentMenuItem.setImg("att_exception.png");
        parentMenuItem.setImgHover("att_exception_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttSign", "att_leftMenu_sign", "att:sign", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attSign.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignRefresh", "common_op_refresh", "att:sign:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignAdd", "common_op_new", "att:sign:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignDel", "common_op_del", "att:sign:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttSignExport", "common_op_export", "att:sign:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttLeave", "att_leftMenu_leave", "att:leave", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attLeave.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveRefresh", "common_op_refresh", "att:leave:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveAdd", "common_op_new", "att:leave:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveDel", "common_op_del", "att:leave:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveExport", "common_op_export", "att:leave:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveImage", "att_leave_image", "att:leave:image", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttTrip", "att_leftMenu_trip", "att:trip", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attTrip.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTripRefresh", "common_op_refresh", "att:trip:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTripAdd", "common_op_new", "att:trip:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTripDel", "common_op_del", "att:trip:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTripExport", "common_op_export", "att:trip:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttOut", "att_leftMenu_out", "att:out", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attOut.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOutRefresh", "common_op_refresh", "att:out:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOutAdd", "common_op_new", "att:out:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOutDel", "common_op_del", "att:out:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOutExport", "common_op_export", "att:out:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttOvertime", "att_leftMenu_overtime", "att:overtime", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attOvertime.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeRefresh", "common_op_refresh", "att:overtime:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeAdd", "common_op_new", "att:overtime:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeDel", "common_op_del", "att:overtime:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttOvertimeExport", "common_op_export", "att:overtime:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttAdjust", "att_leftMenu_adjust", "att:adjust", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attAdjust.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustRefresh", "common_op_refresh", "att:adjust:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustAdd", "common_op_new", "att:adjust:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustDel", "common_op_del", "att:adjust:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttAdjustExport", "common_op_export", "att:adjust:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttClass", "att_leftMenu_class", "att:class", "menu", "true", Integer.valueOf(7));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attClass.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassRefresh", "common_op_refresh", "att:class:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassAdd", "common_op_new", "att:class:add", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassDel", "common_op_del", "att:class:del", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttClassExport", "common_op_export", "att:class:export", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        parentMenuItem = new AuthPermissionItem("AttStatisticalReport", "att_leftMenu_statisticalReport", "att:statistical:report", "menu", "true", Integer.valueOf(7));
        parentMenuItem.setParentId(systemMenuItem.getId());
        parentMenuItem.setActionLink("attManualCalculation.do");
        parentMenuItem.setImg("att_report.png");
        parentMenuItem.setImgHover("att_report_over.png");
        parentMenuItem = this.authPermissionService.saveItem(parentMenuItem);
        childMenuItem = new AuthPermissionItem("AttManualCalculation", "att_leftMenu_manualCalculation", "att:manualCalculation", "menu", "true", Integer.valueOf(1));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attManualCalculation.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttManualCalculationRefresh", "common_op_refresh", "att:manualCalculation:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttManualCalculationCalculate", "att_op_calculation", "att:manualCalculation:calculate", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttTransaction", "att_leftMenu_transaction", "att:transaction", "menu", "true", Integer.valueOf(2));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attTransaction.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionRefresh", "common_op_refresh", "att:transaction:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionExport", "common_op_export", "att:transaction:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionImportAccRecord", "att_op_importAccRecord", "att:transaction:importAccRecord", "button", "true", Integer.valueOf(3));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionParkRecord", "att_op_importParkRecord", "att:transaction:importParkRecord", "button", "true", Integer.valueOf(4));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionImportInsRecord", "att_op_importInsRecord", "att:transaction:importInsRecord", "button", "true", Integer.valueOf(5));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionImportPidRecord", "att_op_importPidRecord", "att:transaction:importPidRecord", "button", "true", Integer.valueOf(6));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionImportVmsRecord", "att_op_importVmsRecord", "att:transaction:importVmsRecord", "button", "true", Integer.valueOf(7));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionImportUSBRecord", "att_op_importUSBRecord", "att:transaction:importUSBRecord", "button", "true", Integer.valueOf(8));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttTransactionExportAttPhoto", "att_transaction_exportAttPhoto", "att:transaction:exportAttPhoto", "button", "true", Integer.valueOf(9));
        buttonMenuItem.setParentId(childMenuItem.getId());
        this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDayCardDetailReport", "att_leftMenu_dayCardDetailReport", "att:dayCardDetailReport", "menu", "true", Integer.valueOf(3));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayCardDetailReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDayCardDetailReportRefresh", "common_op_refresh", "att:dayCardDetailReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDayCardDetailReportExport", "common_op_export", "att:dayCardDetailReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttLeaveSummaryReport", "att_leftMenu_leaveSummaryReport", "att:leaveSummaryReport", "menu", "true", Integer.valueOf(4));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attLeaveSummaryReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveSummaryReportRefresh", "common_op_refresh", "att:leaveSummaryReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttLeaveSummaryReportExport", "common_op_export", "att:leaveSummaryReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDayDetailReport", "att_leftMenu_dayDetailReport", "att:dayDetailReport", "menu", "true", Integer.valueOf(5));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDayDetailReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDayDetailReportRefresh", "common_op_refresh", "att:dayDetailReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDayDetailReportExport", "common_op_export", "att:dayDetailReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttMonthDetailReport", "att_leftMenu_monthDetailReport", "att:monthDetailReport", "menu", "true", Integer.valueOf(6));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attMonthDetailReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthDetailReportRefresh", "common_op_refresh", "att:monthDetailReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthDetailReportExport", "common_op_export", "att:monthDetailReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttMonthStatisticalReport", "att_leftMenu_monthStatisticalReport", "att:monthStatisticalReport", "menu", "true", Integer.valueOf(7));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attMonthStatisticalReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthStatisticalReportRefresh", "common_op_refresh", "att:monthStatisticalReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttMonthStatisticalReportExport", "common_op_export", "att:monthStatisticalReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttDeptStatisticalReport", "att_leftMenu_deptStatisticalReport", "att:deptStatistiCalReport", "menu", "true", Integer.valueOf(8));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attDeptStatisticalReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptStatisticalReportRefresh", "common_op_refresh", "att:deptStatistiCalReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttDeptStatisticalReportExport", "common_op_export", "att:deptStatistiCalReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttYearStatisticalReport", "att_leftMenu_yearStatisticalReport", "att:yearStatistiCalReport", "menu", "true", Integer.valueOf(9));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attYearStatisticalReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttYearStatisticalReportRefresh", "common_op_refresh", "att:yearStatistiCalReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttYearStatisticalReportExport", "common_op_export", "att:yearStatistiCalReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttWorkAbnormalReport", "att_leftMenu_workAbnormalReport", "att:workAbnormalReport", "menu", "true", Integer.valueOf(10));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attWorkAbnormalReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttWorkAbnormalReportRefresh", "common_op_refresh", "att:workAbnormalReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttWorkAbnormalReportExport", "common_op_export", "att:workAbnormalReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        childMenuItem = new AuthPermissionItem("AttWorkTimeReport", "att_leftMenu_workTimeReport", "att:workTimeReport", "menu", "true", Integer.valueOf(11));
        childMenuItem.setParentId(parentMenuItem.getId());
        childMenuItem.setActionLink("attWorkTimeReport.do");
        childMenuItem = this.authPermissionService.saveItem(childMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttWorkTimeReportRefresh", "common_op_refresh", "att:workTimeReport:refresh", "button", "true", Integer.valueOf(1));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
        buttonMenuItem = new AuthPermissionItem("AttWorkTimeReportExport", "common_op_export", "att:workTimeReport:export", "button", "true", Integer.valueOf(2));
        buttonMenuItem.setParentId(childMenuItem.getId());
        buttonMenuItem = this.authPermissionService.saveItem(buttonMenuItem);
    }

    public void initAttParams() {
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.signIn", "0", I18nUtil.i18nCode((String)"att_rule_baseRuleSignIn", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.signOut", "0", I18nUtil.i18nCode((String)"att_rule_baseRuleSignOut", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.shortestMinutes", "120", I18nUtil.i18nCode((String)"att_rule_baseRuleShortestMinutes", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.longestMinutes", "600", I18nUtil.i18nCode((String)"att_rule_baseRuleLongestMinutes", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.shortestOvertimeMinutes", "5", I18nUtil.i18nCode((String)"att_rule_baseRuleShortestOvertimeMinutes", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.maxOvertimeType", "notLimited", "Maximum overtime type (this week/this month)"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.maxOvertimeMinutes", "0", I18nUtil.i18nCode((String)"att_rule_baseRuleMaxOvertimeMinutes", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.elasticCal", "0", I18nUtil.i18nCode((String)"att_rule_baseRuleElasticCal", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.lateAndEarly", "false", I18nUtil.i18nCode((String)"att_rule_baseRuleLateAndEarly", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.countOvertime", "true", I18nUtil.i18nCode((String)"att_rule_baseRuleCountOvertime", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.findSchSort", "1", I18nUtil.i18nCode((String)"att_rule_baseRuleFindSchSort", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.smartFindClass", "1", I18nUtil.i18nCode((String)"att_rule_baseRuleSmartFindClass", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.crossDay", "0", I18nUtil.i18nCode((String)"att_rule_baseRuleCrossDay", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.signBreakTime", "true", I18nUtil.i18nCode((String)"att_rule_baseRuleSignBreakTime", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.noSignInCountType", "absent", I18nUtil.i18nCode((String)"att_rule_noSignInCountType", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.noSignInCountLateMinute", "30", I18nUtil.i18nCode((String)"att_rule_noSignInCountLateMinute", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.noSignOffCountType", "absent", I18nUtil.i18nCode((String)"att_rule_noSignOffCountType", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.baseRule.noSignOffCountEarlyMinute", "60", I18nUtil.i18nCode((String)"att_rule_noSignOffCountEarlyMinute", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.countConvert.hour", "0", I18nUtil.i18nCode((String)"att_rule_countConvertHour", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.countConvert.oneHour", "55", I18nUtil.i18nCode((String)"att_rule_oneHour", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.countConvert.halfAnHour", "25", I18nUtil.i18nCode((String)"att_rule_halfAnHour", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.countConvert.day", "0", I18nUtil.i18nCode((String)"att_rule_countConvertDay", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.countConvert.oneDay", "80", I18nUtil.i18nCode((String)"att_rule_oneDay", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.countConvert.halfAnDay", "20", I18nUtil.i18nCode((String)"att_rule_halfAnDay", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.countConvert.absentDay", "0", I18nUtil.i18nCode((String)"att_rule_countConvertAbsentDay", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.countConvert.decimal", "1", I18nUtil.i18nCode((String)"att_rule_countConvertDecimal", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.symbols", "\u221a,L,E,\u25a1,[,],\u2206,+,\u25cb,\u25cf,T,G", I18nUtil.i18nCode((String)"att_rule_otherSymbol", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.arrive", "\u221a", I18nUtil.i18nCode((String)"att_rule_arrive", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.late", "L", I18nUtil.i18nCode((String)"att_common_late", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.early", "E", I18nUtil.i18nCode((String)"att_common_early", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.absent", "\u25a1", I18nUtil.i18nCode((String)"att_common_absent", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.noSignIn", "[", I18nUtil.i18nCode((String)"att_rule_noSignIn", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.noSignOff", "]", I18nUtil.i18nCode((String)"att_rule_noSignOff", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.leave", "\u2206", I18nUtil.i18nCode((String)"att_common_leave", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.overtime", "+", I18nUtil.i18nCode((String)"att_common_overtime", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.off", "\u25cb", I18nUtil.i18nCode((String)"att_rule_off", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.classes", "\u25cf", I18nUtil.i18nCode((String)"att_rule_class", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.trip", "T", I18nUtil.i18nCode((String)"att_common_trip", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.out", "G", I18nUtil.i18nCode((String)"att_common_out", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.noCheckInIncomplete", "\u251c", I18nUtil.i18nCode((String)"att_rule_noCheckInIncomplete", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.other.noCheckOutIncomplete", "\u2524", I18nUtil.i18nCode((String)"att_rule_noCheckOutIncomplete", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.sms.uid", "0", "sms uid"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.reportSetting.shortDateFormat", "yyyy/MM/DD", "\u65e5\u671f\u683c\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.reportSetting.shortTimeFormat", "HH:mm", "\u65f6\u95f4\u683c\u5f0f"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.mapName", "gaodeMap", I18nUtil.i18nCode((String)"att_h5_defaultMap", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.distanceMatrixApi", "https://restapi.amap.com/v3/distance?origins=%s&destination=%s&type=0&key=", "\u6839\u636e\u7ecf\u7eac\u5ea6\u7b97\u8ddd\u79bb"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.placeApi", "https://restapi.amap.com/v3/geocode/regeo?output=json&location=%s&key=", "\u6839\u636e\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5730\u5740"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.mapKey", "4aeb1569617bc236f832a9ed0d6c3398", "\u4e91\u5e73\u53f0KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.googleMap", "googleMap", I18nUtil.i18nCode((String)"att_h5_googleMap", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.google.distanceMatrixApi", "https://maps.google.cn/maps/api/distancematrix/json?origins=%s&destinations=%s&key=", "\u8c37\u6b4capi\u6839\u636e\u7ecf\u7eac\u5ea6\u7b97\u8ddd\u79bb"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.google.placeApi", "https://maps.google.cn/maps/api/geocode/json?latlng=%s&key=", "\u8c37\u6b4capi\u6839\u636e\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5730\u5740"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.google.mapKey", "AIzaSyBOP5cLG70Jd0tC0j4sxCwCB3JaBGlsq40", "\u8c37\u6b4c\u4e91\u5e73\u53f0KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaodeMap", "gaodeMap", I18nUtil.i18nCode((String)"att_h5_gaodeMap", (Object[])new Object[0])));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaode.distanceMatrixApi", "https://restapi.amap.com/v3/distance?origins=%s&destination=%s&type=0&key=", "\u9ad8\u5fb7api\u6839\u636e\u7ecf\u7eac\u5ea6\u7b97\u8ddd\u79bb"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaode.placeApi", "https://restapi.amap.com/v3/geocode/regeo?output=json&location=%s&key=", "\u9ad8\u5fb7api\u6839\u636e\u7ecf\u7eac\u5ea6\u83b7\u53d6\u5730\u5740"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaode.mapKey", "4aeb1569617bc236f832a9ed0d6c3398", "\u9ad8\u5fb7\u4e91\u5e73\u53f0JAVA-KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.map.gaode.mapJsKey", "042328d3d9dace44bbf87030e4cd9ccc", "\u9ad8\u5fb7\u4e91\u5e73\u53f0JS-KEY"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.url.qrcodeUrl", "", "\u4e8c\u7ef4\u7801url"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.timing.unit", "hour", "\u5b9a\u65f6\u5355\u4f4d"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.timing.frequency", "1", "\u5b9a\u65f6\u9891\u7387"));
        String enableEmpLogin = "0";
        if ("ZKBioAccess".equals(this.productCode)) {
            enableEmpLogin = "1";
        }
        this.baseSysParamService.initData(new BaseSysParamItem("att.self.loginEntrance", enableEmpLogin, "\u5458\u5de5\u81ea\u52a9\u767b\u5f55\u5165\u53e3"));
        JSONObject values = new JSONObject();
        values.put("keptMonth", (Object)"15");
        values.put("runtime", (Object)"02:30:00");
        values.put("keptType", (Object)BaseDataConstants.DATA_CLEAN_KEPTMONTH);
        BaseSysParamItem item = new BaseSysParamItem("attReportDataClean", values.toString(), "base_dataClean_attTrans");
        this.baseSysParamService.initData(item);
        this.baseSysParamService.initData(new BaseSysParamItem("att.realTime.calculate", "0 0/2 * * * ?", "\u8003\u52e4\u5b9e\u65f6\u8ba1\u7b97\u9891\u7387"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.realTime.updateSchInfo", "0 0 1 * * ?", "\u6bcf\u5929\u5b9a\u65f6\u66f4\u65b0\u6392\u73ed\u4fe1\u606f"));
        this.baseSysParamService.initData(new BaseSysParamItem("att.point.pullTransaction", "0 0/5 * * * ?", "\u8003\u52e4\u70b9\u5b9a\u65f6\u83b7\u53d6\u8bb0\u5f55\u9891\u7387"));
    }

    private void initAttLeaveType() {
        AttLeaveTypeItem attLeaveTypeItem_1 = new AttLeaveTypeItem("L1", I18nUtil.i18nCode((String)"att_leaveType_leaveThing", (Object[])new Object[0]), Boolean.valueOf(true), Boolean.valueOf(true));
        AttLeaveTypeItem attLeaveTypeItem_2 = new AttLeaveTypeItem("L2", I18nUtil.i18nCode((String)"att_leaveType_leaveMarriage", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true));
        AttLeaveTypeItem attLeaveTypeItem_3 = new AttLeaveTypeItem("L3", I18nUtil.i18nCode((String)"att_leaveType_leaveBirth", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true));
        AttLeaveTypeItem attLeaveTypeItem_4 = new AttLeaveTypeItem("L4", I18nUtil.i18nCode((String)"att_leaveType_leaveSick", (Object[])new Object[0]), Boolean.valueOf(true), Boolean.valueOf(true));
        AttLeaveTypeItem attLeaveTypeItem_5 = new AttLeaveTypeItem("L5", I18nUtil.i18nCode((String)"att_leaveType_leaveAnnual", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true));
        AttLeaveTypeItem attLeaveTypeItem_6 = new AttLeaveTypeItem("L6", I18nUtil.i18nCode((String)"att_leaveType_leaveFuneral", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true));
        AttLeaveTypeItem attLeaveTypeItem_7 = new AttLeaveTypeItem("L7", I18nUtil.i18nCode((String)"att_leaveType_leaveHome", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true));
        AttLeaveTypeItem attLeaveTypeItem_8 = new AttLeaveTypeItem("L8", I18nUtil.i18nCode((String)"att_leaveType_leaveNursing", (Object[])new Object[0]), Boolean.valueOf(false), Boolean.valueOf(true));
        this.attLeaveTypeService.initData(attLeaveTypeItem_1);
        this.attLeaveTypeService.initData(attLeaveTypeItem_2);
        this.attLeaveTypeService.initData(attLeaveTypeItem_3);
        this.attLeaveTypeService.initData(attLeaveTypeItem_4);
        this.attLeaveTypeService.initData(attLeaveTypeItem_5);
        this.attLeaveTypeService.initData(attLeaveTypeItem_6);
        this.attLeaveTypeService.initData(attLeaveTypeItem_7);
        this.attLeaveTypeService.initData(attLeaveTypeItem_8);
    }

    private void initAttDictionary() {
        BaseDictionaryItem baseDictionaryItem = new BaseDictionaryItem("AttShiftWorkType", "att_shift_workType", Boolean.valueOf(false), "att_module");
        baseDictionaryItem = this.baseDictionaryService.initData(baseDictionaryItem);
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("normalWork", "att_shift_normalWork", Integer.valueOf(0), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("weekendOt", "att_overtime_rest", Integer.valueOf(1), baseDictionaryItem.getId()));
        this.baseDictionaryValueService.initData(new BaseDictionaryValueItem("holidayOt", "att_shift_holidayOt", Integer.valueOf(2), baseDictionaryItem.getId()));
    }

    private void initUpgradeVersion() {
        BaseSysParamItem baseSysParamItem;
        String curVersion = VersionUtil.getReleaseGitTags((String)"att");
        if (StringUtils.isNotBlank((CharSequence)curVersion) && StringUtils.isBlank((CharSequence)(baseSysParamItem = this.baseSysParamService.findByParamName("AttUpgradeVersion")).getId())) {
            baseSysParamItem = new BaseSysParamItem("AttUpgradeVersion", curVersion, "Att Upgrade Version", Boolean.valueOf(true));
            this.baseSysParamService.saveItem(baseSysParamItem);
        }
    }
}

