/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccPersonLimitZoneRemote;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLimitService;
import com.zkteco.zkbiosecurity.acc.service.AccPersonLimitZoneService;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLimitItem;
import com.zkteco.zkbiosecurity.acc.vo.AccPersonLimitZoneItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.text.SimpleDateFormat;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccPersonLimitZoneController
extends BaseController
implements AccPersonLimitZoneRemote {
    @Autowired
    private AccPersonLimitZoneService accPersonLimitZoneService;
    @Autowired
    private AccPersonLimitService accPersonLimitService;

    @RequiresPermissions(value={"acc:personLimitZone"})
    public ModelAndView index() {
        return new ModelAndView("acc/personLimitZone/accPersonLimitZone");
    }

    @RequiresPermissions(value={"acc:personLimitZone:add", "acc:personLimitZone:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accPersonLimitZoneService.getItemById(id));
        }
        return new ModelAndView("acc/personLimitZone/editAccPersonLimitZone");
    }

    @RequiresPermissions(value={"acc:personLimitZone:add", "acc:personLimitZone:edit"})
    @LogRequest(module="acc_module", object="acc_leftMenu_personLimit", opType="common_op_edit", requestParams={"name"}, opContent="acc_personLimit_availabilityName")
    public ZKResultMsg save(AccPersonLimitZoneItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accPersonLimitZoneService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:personLimitZone:refresh"})
    public DxGrid list(AccPersonLimitZoneItem codition) {
        Pager pager = this.accPersonLimitZoneService.getItemsByPage((BaseItem)codition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, codition.getClass());
    }

    @RequiresPermissions(value={"acc:personLimitZone:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_personLimit", opType="common_op_del", requestParams={"names"}, opContent="acc_personLimit_availabilityName")
    public ZKResultMsg del(String ids) {
        this.accPersonLimitZoneService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public String valid(String name) {
        AccPersonLimitZoneItem item = this.accPersonLimitZoneService.getItemByName(name);
        boolean rs = item == null;
        return rs + "";
    }

    public ZKResultMsg getPersonLimitZoneDetail(String id) {
        AccPersonLimitItem accPersonLimitItem;
        String ret = "";
        AccPersonLimitZoneItem accPersonLimitZoneItem = this.accPersonLimitZoneService.getItemById(id);
        if (accPersonLimitZoneItem != null && (accPersonLimitItem = this.accPersonLimitService.getItemById(accPersonLimitZoneItem.getPersonLimitId())) != null) {
            if (accPersonLimitItem.getValidType().toString().equals("3")) {
                ret = accPersonLimitItem.getValidTimes() + " " + I18nUtil.i18nCode((String)"common_times", (Object[])new Object[0]);
            } else if (accPersonLimitItem.getValidType().toString().equals("2")) {
                ret = accPersonLimitItem.getValidDays() + " " + I18nUtil.i18nCode((String)"common_days", (Object[])new Object[0]);
            } else if (accPersonLimitItem.getValidType().toString().equals("1")) {
                SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                ret = I18nUtil.i18nCode((String)"acc_personLimit_userDateTo", (Object[])new Object[0]) + " " + dateFormat.format(accPersonLimitItem.getValidDate());
            }
        }
        return new ZKResultMsg((Object)ret);
    }
}

