/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.acc.controller;

import com.zkteco.zkbiosecurity.acc.remote.AccOccupancyRemote;
import com.zkteco.zkbiosecurity.acc.service.AccOccupancyService;
import com.zkteco.zkbiosecurity.acc.vo.AccOccupancyItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AccOccupancyController
extends BaseController
implements AccOccupancyRemote {
    @Autowired
    private AccOccupancyService accOccupancyService;

    @RequiresPermissions(value={"acc:occupancy"})
    public ModelAndView index() {
        return new ModelAndView("acc/occupancy/accOccupancy");
    }

    @RequiresPermissions(value={"acc:occupancy:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.accOccupancyService.getItemById(id));
        }
        return new ModelAndView("acc/occupancy/editAccOccupancy");
    }

    @RequiresPermissions(value={"acc:occupancy:edit", "acc:occupancy:add"})
    @LogRequest(module="acc_module", object="acc_leftMenu_occupancy", opType="common_op_edit", requestParams={"name"}, opContent="common_name")
    public ZKResultMsg save(AccOccupancyItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.accOccupancyService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"acc:occupancy:refresh"})
    public DxGrid list(AccOccupancyItem condition) {
        Pager pager = this.accOccupancyService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"acc:occupancy:del"})
    @LogRequest(module="acc_module", object="acc_leftMenu_occupancy", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg del(String ids) {
        this.accOccupancyService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public Boolean isExist(String name) {
        return this.accOccupancyService.isExist(name);
    }
}

