/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.utils;

import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLDecoder;
import java.text.DecimalFormat;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.springframework.web.multipart.MultipartFile;

public class BaseMediaFileUtil {
    public static String HTTPMARK = "http://";
    public static String SOUNDPREPATH = "/upload/audio";
    public static long MAXFILESIZE = 0xA00000L;

    public static String getLocalUrl() throws Exception {
        String projectPath = BaseMediaFileUtil.class.getClassLoader().getResource("").getPath();
        projectPath = projectPath + "../../";
        projectPath = projectPath.replace("/", "\\");
        String realpath = URLDecoder.decode(projectPath, "UTF-8");
        return realpath;
    }

    public static void deleteFile(String filePath) throws Exception {
        File existFile = new File(filePath);
        existFile.delete();
    }

    public static void saveFile(String fileName, MultipartFile uploadFile, String systemFilePath) throws Exception {
        File eventSoundFile;
        String realSoundPath = systemFilePath + SOUNDPREPATH;
        File eventSoundFilePath = new File(realSoundPath);
        if (!eventSoundFilePath.isAbsolute()) {
            realSoundPath = ClassUtil.getRootPath() + "/" + realSoundPath;
            eventSoundFilePath = new File(realSoundPath);
        }
        if (!eventSoundFilePath.exists()) {
            eventSoundFilePath.mkdirs();
        }
        if ((eventSoundFile = new File(realSoundPath + "/" + fileName)).exists()) {
            eventSoundFile.delete();
        }
        uploadFile.transferTo(eventSoundFile);
    }

    public static String saveFileToServer(String fileType, MultipartFile file, String systemFilePath) throws Exception {
        String fileName = "";
        if (fileType.toLowerCase().contains("mp3") || fileType.toLowerCase().contains("mpeg")) {
            fileName = new Date().getTime() + ".mp3";
        } else if (fileType.toLowerCase().contains("wav")) {
            fileName = new Date().getTime() + ".wav";
        }
        if (StringUtils.isNotBlank((CharSequence)fileName)) {
            BaseMediaFileUtil.saveFile(fileName, file, systemFilePath);
            fileName = SOUNDPREPATH + "/" + fileName;
        }
        return fileName;
    }

    public static String getNewFileName(String fileName) {
        int lastIndex = fileName.lastIndexOf(".");
        fileName = fileName.substring(0, lastIndex) + "-" + System.currentTimeMillis() + fileName.substring(lastIndex);
        return fileName;
    }

    public static String getFileSize(MultipartFile file) throws Exception {
        DecimalFormat df = new DecimalFormat("#.##");
        String fileSiz = file.getSize() / 1024L > 1000L ? df.format((double)file.getSize() / 1024.0 / 1024.0) + "MB" : df.format(file.getSize() / 1024L) + "KB";
        return fileSiz;
    }

    public static boolean validatorFileSize(MultipartFile file) {
        boolean flag = true;
        if (file.getSize() > 0L && file.getSize() < MAXFILESIZE) {
            flag = false;
        }
        return flag;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeStringToFile(File file, String data, String encoding) throws IOException {
        try (FileOutputStream out = null;){
            out = BaseMediaFileUtil.openOutputStream(file, false);
            ((OutputStream)out).write(data.getBytes(encoding));
        }
    }

    private static FileOutputStream openOutputStream(File file, boolean append) throws IOException {
        if (file.exists()) {
            if (file.isDirectory()) {
                throw new IOException("File '" + file + "' exists but is a directory");
            }
            if (!file.canWrite()) {
                throw new IOException("File '" + file + "' cannot be written to");
            }
        } else {
            File parent = file.getParentFile();
            if (parent != null && !parent.mkdirs() && !parent.isDirectory()) {
                throw new IOException("Directory '" + parent + "' could not be created");
            }
        }
        return new FileOutputStream(file, append);
    }
}

