/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.annotation.DataMigration;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.system.remote.SystemDataMigrationRemote;
import com.zkteco.zkbiosecurity.system.service.DataMoveManager;
import com.zkteco.zkbiosecurity.system.service.SystemDataMigrationService;
import com.zkteco.zkbiosecurity.system.vo.DataSourceItem;
import com.zkteco.zkbiosecurity.system.vo.SystemDataTransferProcess;
import com.zkteco.zkbiosecurity.system.vo.SystemDataUpgradeProcess;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.CommandLineRunner;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class SystemDataMigrationController
extends BaseController
implements SystemDataMigrationRemote {
    @Autowired
    private SystemDataMigrationService systemDataMigrationService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired(required=false)
    @Qualifier(value="systemDataMoveManagement")
    private DataMoveManager systemDataMoveManagement;
    @Autowired(required=false)
    @Qualifier(value="persDataMoveManagement")
    private DataMoveManager persDataMoveManagement;
    @Autowired(required=false)
    @Qualifier(value="accDataMoveManagement")
    private DataMoveManager accDataMoveManagement;
    @Value(value="${system.productCode:ZKBioSecurity}")
    private String productCode;
    @Value(value="${system.version:}")
    private String systemVersion;

    public ModelAndView index() {
        this.request.setAttribute("systemVersion", (Object)this.systemVersion);
        return new ModelAndView("system/dataMigration/systemDataMigration");
    }

    public ZKResultMsg configDataSource(DataSourceItem dataSourceItem) {
        boolean rs = this.systemDataMigrationService.configDataSource(dataSourceItem);
        return I18nUtil.i18nMsg((ZKResultMsg)(rs ? ZKResultMsg.successMsg() : ZKResultMsg.failMsg((String)"system_dataMigration_database_connection_failed", (Object[])new Object[0])));
    }

    public ZKResultMsg handlerDataMigration() {
        try {
            String dataMigrationModule = this.request.getParameter("dataMigrationModule");
            String isMigrate = this.request.getParameter("isMigrateTrans");
            String sourceSoftwareVersion = this.request.getParameter("sourceSoftwareVersion");
            Boolean isMigrateTrans = "true".equals(isMigrate);
            List<Object> dataMigrationModules = new ArrayList();
            if (StringUtils.isNotBlank((CharSequence)dataMigrationModule)) {
                dataMigrationModules = Arrays.asList(dataMigrationModule.split(","));
            }
            this.progressCache.beginProcess(ProcessBean.createNormalContent((String)I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])));
            boolean rs = true;
            SystemDataTransferProcess process = new SystemDataTransferProcess();
            process.setProductCode(this.productCode);
            if (dataMigrationModules != null && dataMigrationModules.size() > 0) {
                Map mapBeans = SpringContextUtil.getBeansOfType(DataMoveManager.class);
                int moduleSize = mapBeans.size();
                int moduelProcess = 100 / moduleSize;
                int processIndex = 0;
                TreeMap map = new TreeMap();
                for (String beanName : mapBeans.keySet()) {
                    DataMigration dataMigration = ((DataMoveManager)mapBeans.get(beanName)).getClass().getAnnotation(DataMigration.class);
                    if (dataMigration == null || !dataMigrationModules.contains(beanName)) continue;
                    map.put(dataMigration.order(), mapBeans.get(beanName));
                }
                for (Integer order : map.keySet()) {
                    process.setBeginProgress(processIndex * moduelProcess).setEndProgress((processIndex + 1) * moduelProcess);
                    process.setIsMigrateTrans(isMigrateTrans);
                    process.setSourceSoftwareVersion(sourceSoftwareVersion);
                    rs = ((DataMoveManager)map.get(order)).handlerTransfer(process);
                    ++processIndex;
                }
            }
            this.progressCache.finishProcess(ProcessBean.createNormalContent((String)I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0])));
            return rs ? ZKResultMsg.successMsg() : ZKResultMsg.failMsg();
        }
        catch (ZKBusinessException e) {
            this.log.error("handlerDataMigration error", (Throwable)e);
            this.progressCache.finishProcess(ProcessBean.createErrorContent((String)I18nUtil.i18nCode((String)e.getMessage(), (Object[])new Object[0])));
            return ZKResultMsg.failMsg();
        }
        catch (Exception e) {
            this.log.error("handlerDataMigration error", (Throwable)e);
            this.progressCache.finishProcess(ProcessBean.createErrorContent((String)I18nUtil.i18nCode((String)"common_op_failed", (Object[])new Object[0])));
            return ZKResultMsg.failMsg();
        }
    }

    public ZKResultMsg handlerUpgrade() {
        String oldVersion = this.request.getParameter("oldVersion");
        SystemDataUpgradeProcess systemDataUpgradeProcess = new SystemDataUpgradeProcess();
        systemDataUpgradeProcess.setCurrentVersion(oldVersion).setProductCode(this.productCode).setTargetVersion(this.systemVersion);
        try {
            Map dataMoveManagerMap = SpringContextUtil.getBeansOfType(DataMoveManager.class);
            for (DataMoveManager dm : dataMoveManagerMap.values()) {
                dm.handlerUpgrade(systemDataUpgradeProcess);
            }
        }
        catch (Exception e) {
            this.log.error("upgrade data error", (Throwable)e);
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public ZKResultMsg reInit() {
        Map mapBeans = SpringContextUtil.getBeansOfType(CommandLineRunner.class);
        try {
            ArrayList<String> excludeBeans = new ArrayList<String>();
            excludeBeans.add("licenseInit");
            excludeBeans.add("engineInit");
            excludeBeans.add("admsDeviceCacheInit");
            excludeBeans.add("attQuartzInit");
            for (String beanName : mapBeans.keySet()) {
                if (!beanName.endsWith("Init") || excludeBeans.contains(beanName)) continue;
                this.log.info(beanName);
                ((CommandLineRunner)mapBeans.get(beanName)).run(new String[0]);
            }
            return ZKResultMsg.successMsg();
        }
        catch (Exception e) {
            this.log.error("ReInit error", (Throwable)e);
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
        }
    }
}

