/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.utils.Base64Util;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.system.remote.BaseMailRemote;
import com.zkteco.zkbiosecurity.system.service.BaseMailService;
import com.zkteco.zkbiosecurity.system.vo.BaseMailItem;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.ModelAndView;

@Controller
@RequestMapping(value={"/baseMail.do"})
public class BaseMailController
extends ExportController
implements BaseMailRemote {
    @Autowired
    private BaseMailService baseMailService;

    @RequiresPermissions(value={"system:mail"})
    public ModelAndView index() {
        return new ModelAndView("system/mail/baseMail");
    }

    @RequiresPermissions(value={"system:mail:refresh"})
    public DxGrid list(BaseMailItem condition) {
        Pager pager = this.baseMailService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"system:mail:del"})
    @LogRequest(module="system_module", object="base_leftMenu_emailManagement", opType="common_op_del", requestParams={"sendTimes"}, opContent="bsse_media_sendTime")
    public ZKResultMsg del(String ids) {
        this.baseMailService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"system:mail:getMailParam"})
    public ModelAndView getMailParam() {
        Map baseMailParams = this.baseMailService.getBaseMailParams();
        this.request.setAttribute("baseMailParams", (Object)baseMailParams);
        this.request.setAttribute("editPage", (Object)true);
        return new ModelAndView("system/mail/editBaseMailParam");
    }

    @RequiresPermissions(value={"system:mail:getMailParam"})
    @LogRequest(module="system_module", object="base_leftMenu_emailManagement", opType="base_mail_paramSetting", requestParams={"base.mailUserName"}, opContent="base_mail_paramSetting")
    public ZKResultMsg saveMailParam(@RequestParam Map<String, String> params) {
        String SSLSelect = this.request.getParameter("base.mailSSLSelect") == null ? "0" : this.request.getParameter("base.mailSSLSelect");
        String TLSSelect = this.request.getParameter("base.mailTLSSelect") == null ? "0" : this.request.getParameter("base.mailTLSSelect");
        String fromAddress = this.request.getParameter("base.mailUserName");
        params.put("base.mailSSLSelect", SSLSelect);
        params.put("base.mailTLSSelect", TLSSelect);
        params.put("base.mailFromAddress", fromAddress);
        String mailPwd = this.request.getParameter("base.mailPassword");
        if (StringUtils.isNotBlank((CharSequence)mailPwd)) {
            mailPwd = new String(Base64Util.decode((String)mailPwd));
        }
        params.put("base.mailPassword", mailPwd);
        this.baseMailService.saveBaseMailParams(params);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"system:mail:getMailParam"})
    public ZKResultMsg testSendMail(@RequestParam Map<String, String> params) {
        ZKResultMsg res = new ZKResultMsg();
        String serverHost = params.get("base.mailServerHost");
        String serverPort = params.get("base.mailServerPort");
        String userName = params.get("base.mailUserName");
        String password = new String(Base64Util.decode((String)params.get("base.mailPassword")));
        String mailName = params.get("base.mailShowMailName");
        String SSLSelect = params.get("base.mailSSLSelect");
        String TLSSelect = params.get("base.mailTLSSelect");
        boolean isSsl = StringUtils.defaultString((String)SSLSelect).equals("1");
        boolean isTls = StringUtils.defaultString((String)TLSSelect).equals("1");
        this.baseMailService.testSend(serverHost, userName, password, Integer.valueOf(Integer.parseInt(serverPort)), isSsl, userName, mailName, isTls);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"system:mail:export"})
    public void export(HttpServletRequest request, HttpServletResponse response) {
        String exportType = request.getParameter("exportType");
        String recordStart = request.getParameter("recordstart");
        String recordCount = request.getParameter("recordcount");
        BaseMailItem baseMailItem = new BaseMailItem();
        this.setConditionValue((BaseItem)baseMailItem);
        int beginIndex = 0;
        int endIndex = 30000;
        if (exportType.equals("3") && StringUtils.isNotBlank((CharSequence)recordStart) && StringUtils.isNotBlank((CharSequence)recordCount)) {
            beginIndex = Integer.valueOf(recordStart);
            beginIndex = beginIndex > 0 ? beginIndex - 1 : beginIndex;
            int maxCount = Integer.valueOf(recordCount) > 30000 ? 30000 : Integer.valueOf(recordCount);
            endIndex = beginIndex + maxCount - 1;
        }
        HashMap<String, String> retMap = new HashMap<String, String>();
        retMap.put("0", I18nUtil.i18nCode((String)"base_media_success", (Object[])new Object[0]));
        retMap.put("1", I18nUtil.i18nCode((String)"base_media_waitSend", (Object[])new Object[0]));
        retMap.put("-1", I18nUtil.i18nCode((String)"base_media_failure", (Object[])new Object[0]));
        retMap.put("-2", I18nUtil.i18nCode((String)"base_media_continueSend", (Object[])new Object[0]));
        List baseMailItemList = this.baseMailService.getExportItemList(baseMailItem, beginIndex, endIndex);
        baseMailItemList.forEach(baseMailItemNew -> {
            if (StringUtils.isNotBlank((CharSequence)baseMailItemNew.getRet())) {
                baseMailItemNew.setRet((String)retMap.get(baseMailItemNew.getRet()));
            }
        });
        this.excelExport(baseMailItemList, BaseMailItem.class);
    }
}

