/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.controller;

import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SelectItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.system.remote.BaseDictionaryValueRemote;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryService;
import com.zkteco.zkbiosecurity.system.service.BaseDictionaryValueService;
import com.zkteco.zkbiosecurity.system.vo.BaseDictionaryValueItem;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;

@Controller
public class BaseDictionaryValueController
extends BaseController
implements BaseDictionaryValueRemote {
    @Autowired
    private BaseDictionaryValueService baseDictionaryValueService;
    @Autowired
    private BaseDictionaryService baseDictionaryService;

    public DxGrid list(BaseDictionaryValueItem condition) {
        Pager pager = this.baseDictionaryValueService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg selectList(String key) {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        List valueItems = this.baseDictionaryValueService.getDictionaryValues(key);
        for (BaseDictionaryValueItem v : valueItems) {
            items.add(new SelectItem((Object)I18nUtil.i18nCode((String)v.getDictValue(), (Object[])new Object[0]), v.getCode()));
        }
        return new ZKResultMsg(items);
    }

    public ZKResultMsg getModuleNameList() {
        ArrayList<SelectItem> items = new ArrayList<SelectItem>();
        List moduleNames = this.baseDictionaryService.getAllModuleName();
        for (String moduleName : moduleNames) {
            items.add(new SelectItem((Object)I18nUtil.i18nCode((String)moduleName, (Object[])new Object[0]), moduleName));
        }
        return new ZKResultMsg(items);
    }

    public ZKResultMsg getNameList() {
        String moduleName = this.request.getParameter("moduleName");
        if (StringUtils.isNotBlank((CharSequence)moduleName)) {
            ArrayList<SelectItem> items = new ArrayList<SelectItem>();
            List dictNames = this.baseDictionaryService.getNameByModuleName(moduleName);
            for (String dictName : dictNames) {
                items.add(new SelectItem((Object)I18nUtil.i18nCode((String)dictName, (Object[])new Object[0]), dictName));
            }
            return new ZKResultMsg(items);
        }
        return new ZKResultMsg();
    }
}

