/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.vis.controller;

import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import com.zkteco.zkbiosecurity.vis.remote.VisVisitorLevelRemote;
import com.zkteco.zkbiosecurity.vis.service.VisVisitorLevelService;
import com.zkteco.zkbiosecurity.vis.vo.VisVisitorLevelItem;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class VisVisitorLevelController
extends BaseController
implements VisVisitorLevelRemote {
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private VisVisitorLevelService visVisitorLevelService;
    private Logger logger = LoggerFactory.getLogger(VisVisitorLevelController.class);

    @RequiresPermissions(value={"vis:visitorLevel:refresh"})
    public DxGrid list(VisVisitorLevelItem condition) {
        Pager pager = this.visVisitorLevelService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"vis:level:selectVisitor"})
    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="vis_level_addVisitor", requestParams={"levelName", "pin"}, opContent="vis_emp_pin")
    public ZKResultMsg addVisitor(@RequestParam(value="ids") String ids) {
        if (StringUtils.isNotBlank((CharSequence)ids)) {
            String levelId = ids.split(",")[0];
            ArrayList<String> selectVisitorIdList = new ArrayList<String>(Arrays.asList(ids.split(",")));
            selectVisitorIdList.remove(levelId);
            if (selectVisitorIdList.size() > 0) {
                this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0]) + "<br/>");
                try {
                    List visTranArrayIds = this.visVisitorLevelService.cutVisIdsToArray(selectVisitorIdList, 200);
                    int total = visTranArrayIds.size();
                    for (int i = 0; i < total; ++i) {
                        this.visVisitorLevelService.UpdateVisiotrLevel(levelId, (String)visTranArrayIds.get(i));
                        visTranArrayIds.set(i, null);
                        System.gc();
                        Thread.sleep(1000L);
                        this.progressCache.setProcess(new ProcessBean(0, (int)((double)(i + 1) * 1.0 / (double)total * 100.0)));
                    }
                }
                catch (Exception e) {
                    this.logger.error("addVisitor with level error", (Throwable)e);
                }
                this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_progress_finish", (Object[])new Object[0]));
            }
        }
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"vis:visitorLevel:del"})
    @LogRequest(module="vis_module", object="vis_leftMenu_level", opType="vis_level_delVisitor", requestParams={"levelName", "pins"}, opContent="vis_emp_pin")
    public ZKResultMsg del(@RequestParam(value="ids") String ids) {
        this.visVisitorLevelService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }
}

