/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.bean.AttUsbTransactionBean;
import com.zkteco.zkbiosecurity.att.remote.AttTransactionRemote;
import com.zkteco.zkbiosecurity.att.service.AttTransactionService;
import com.zkteco.zkbiosecurity.att.util.AttImportUtil;
import com.zkteco.zkbiosecurity.att.vo.AttPhotoExportQueryItem;
import com.zkteco.zkbiosecurity.att.vo.AttTransactionItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.ClassUtil;
import com.zkteco.zkbiosecurity.core.utils.DateUtil;
import com.zkteco.zkbiosecurity.core.utils.FileUtils;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttTransactionController
extends ExportController
implements AttTransactionRemote {
    @Autowired
    private AttTransactionService attTransactionService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private StringRedisTemplate stringRedisTemplate;
    @Value(value="${security.session.timeout:1800}")
    private Long sessionTimeout;

    @RequiresPermissions(value={"att:transaction"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/transaction/attTransaction");
    }

    @RequiresPermissions(value={"att:transaction:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attTransactionService.getItemById(id));
        }
        return new ModelAndView("att/transaction/editAttTransaction");
    }

    @RequiresPermissions(value={"att:transaction:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_transaction", opType="common_op_new", requestParams={"personPin"}, opContent="att_person_pin")
    public ZKResultMsg save(AttTransactionItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attTransactionService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:transaction:refresh"})
    public DxGrid list(AttTransactionItem condition) {
        Pager pager = this.attTransactionService.loadPagerByAuthUserFilter(this.request.getSession().getId(), (BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:transaction:del"})
    @LogRequest(module="att_module", object="att_leftMenu_transaction", opType="common_op_del", requestParams={"ids"}, opContent="att_common_id")
    public ZKResultMsg delete(String ids) {
        this.attTransactionService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:transaction:export"})
    @LogRequest(module="att_module", object="att_leftMenu_transaction", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttTransactionItem attTransactionItem = new AttTransactionItem();
        this.setConditionValue((BaseItem)attTransactionItem);
        List intemList = this.attTransactionService.exportItemListByAuthFilter(request.getSession().getId(), AttTransactionItem.class, attTransactionItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttTransactionItem.class);
    }

    public ZKResultMsg getPhoto(@RequestParam(value="pin") String pin, @RequestParam(value="sn") String sn, @RequestParam(value="attDate") String attDate) {
        ZKResultMsg res = new ZKResultMsg();
        String photoDate = attDate.replaceAll("-", "").replaceAll(" ", "").replaceAll(":", "");
        String photoName = photoDate + "-" + pin + ".jpg";
        String src = "/upload/att/transactionPhoto/" + sn + "/" + attDate.split(" ")[0] + "/" + photoName;
        res.setData((Object)src);
        return res;
    }

    public ZKResultMsg importAccRecord(String attPointIds, Date startDatetime, Date endDatetime) {
        ZKResultMsg res = this.attTransactionService.importAccRecord(attPointIds, startDatetime, endDatetime);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg importParkRecord(String attPointIds, Date startDatetime, Date endDatetime) {
        ZKResultMsg res = this.attTransactionService.importParkRecord(attPointIds, startDatetime, endDatetime);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg importInsRecord(String attPointIds, Date startDatetime, Date endDatetime) {
        ZKResultMsg res = this.attTransactionService.importInsRecord(attPointIds, startDatetime, endDatetime);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    public ZKResultMsg importPidRecord(String attPointIds, Date startDatetime, Date endDatetime) {
        ZKResultMsg res = this.attTransactionService.importPidRecord(attPointIds, startDatetime, endDatetime);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"att:transaction:importUSBRecord"})
    @LogRequest(module="att_module", object="att_leftMenu_transaction", opType="att_op_importUSBRecord", requestParams={}, opContent="att_op_importUSBRecord")
    public ZKResultMsg importUSBRecord(MultipartFile upload) {
        int progress = 5;
        try {
            this.progressCache.beginProcess(I18nUtil.i18nCode((String)"common_op_processing", (Object[])new Object[0]) + "...<br/>");
            this.progressCache.setProcess(new ProcessBean(progress, progress, I18nUtil.i18nCode((String)"att_import_uploadFileSuccess", (Object[])new Object[0]) + "<br/>"));
            String sn = "";
            if (upload.getOriginalFilename().contains("_")) {
                sn = upload.getOriginalFilename().split("_")[0].toString();
            }
            List<AttUsbTransactionBean> itemList = AttImportUtil.usbImport(upload.getInputStream());
            this.progressCache.setProcess(new ProcessBean(progress += 10, progress, I18nUtil.i18nCode((String)"att_import_resolutionComplete", (Object[])new Object[0]) + "<br/>"));
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)this.attTransactionService.importData(itemList, sn));
            return zKResultMsg;
        }
        catch (Exception e) {
            progress = 99;
            this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)"common_prompt_dataError", (Object[])new Object[0]) + "</font><br/>"));
            if (e instanceof ZKBusinessException) {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + I18nUtil.i18nCode((String)e.getMessage(), (Object[])((ZKBusinessException)((Object)e)).objects) + "</font><br/>"));
            } else {
                this.progressCache.setProcess(new ProcessBean(progress, progress, "<font color='red'>" + e.getMessage() + "</font><br/>"));
            }
            this.log.error("Import Person Info Exception", (Throwable)e);
            ZKResultMsg zKResultMsg = I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg());
            return zKResultMsg;
        }
        finally {
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"common_dev_opComplish", (Object[])new Object[0]));
        }
    }

    public Boolean isAccShow() {
        return this.attTransactionService.isExistAcc();
    }

    public Boolean isInsShow() {
        return this.attTransactionService.isExistIns();
    }

    public Boolean isPidShow() {
        return this.attTransactionService.isExistPid();
    }

    public Boolean isParkShow() {
        return this.attTransactionService.isExistPark();
    }

    public Boolean isVmsShow() {
        return this.attTransactionService.isExistVms();
    }

    public Boolean isValidFileName(String fileName) {
        Boolean isDev = false;
        File file = new File(fileName);
        if (file.getName().contains("_")) {
            String sn = file.getName().split("_")[0].toString();
            isDev = this.attTransactionService.validSn(sn);
        }
        return isDev;
    }

    public ZKResultMsg importVmsRecord(String attPointIds, Date startDatetime, Date endDatetime) {
        ZKResultMsg res = this.attTransactionService.importVmsRecord(attPointIds, startDatetime, endDatetime);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresPermissions(value={"att:transaction:exportAttPhoto"})
    public void exportAttPhoto() throws Exception {
        String tempPath;
        File zipTempFile;
        boolean isMSIE;
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"start");
        this.stringRedisTemplate.expire((Object)("export-result:" + this.request.getSession().getId()), this.sessionTimeout.longValue(), TimeUnit.SECONDS);
        String startDate = this.request.getParameter("startDate");
        String endDate = this.request.getParameter("endDate");
        String deviceIds = this.request.getParameter("deviceIds");
        AttPhotoExportQueryItem condition = new AttPhotoExportQueryItem();
        condition.setBeginDate(DateUtil.stringToDate((String)startDate));
        condition.setEndDate(DateUtil.stringToDate((String)endDate));
        condition.setInDeviceId(deviceIds);
        List attPhotoItems = this.attTransactionService.getAllAttPhotoListByAuthUserFilter(this.request.getSession().getId(), condition);
        ArrayList<AttPhotoExportQueryItem> exportFileList = new ArrayList<AttPhotoExportQueryItem>();
        Long fileSizeTotal = 0L;
        for (AttPhotoExportQueryItem item : attPhotoItems) {
            File file = new File(FileUtils.getLocalFullPath((String)item.getFilePath()));
            if (!file.exists()) continue;
            item.setFilePath(file.getAbsolutePath());
            exportFileList.add(item);
            fileSizeTotal = fileSizeTotal + file.length();
        }
        if (exportFileList.size() == 0) {
            throw ZKBusinessException.warnException((String)"common_report_dataSourceNull", (Object[])new Object[0]);
        }
        if (fileSizeTotal > 0x40000000L) {
            throw ZKBusinessException.warnException((String)I18nUtil.i18nCode((String)"att_transaction_fileIsTooLarge", (Object[])new Object[0]), (Object[])new Object[0]);
        }
        String fileNamePrefix = I18nUtil.i18nCode((String)"att_statistical_attPhoto", (Object[])new Object[0]);
        String agent = this.request.getHeader("User-Agent");
        boolean bl = isMSIE = agent != null && (agent.indexOf("MSIE") != -1 || agent.indexOf("Trident") != -1);
        if (isMSIE) {
            fileNamePrefix = URLEncoder.encode(fileNamePrefix, "UTF-8");
            fileNamePrefix = fileNamePrefix.replaceAll("\\+", " ");
        } else {
            fileNamePrefix = new String(fileNamePrefix.getBytes("UTF-8"), "ISO-8859-1");
        }
        if (this.request.getHeader("User-Agent") != null && this.request.getHeader("User-Agent").indexOf("Edge") != -1) {
            fileNamePrefix = fileNamePrefix.replaceAll(" ", "%20");
            fileNamePrefix = URLEncoder.encode(fileNamePrefix, "ISO-8859-1");
            fileNamePrefix = fileNamePrefix.replace("%2520", " ");
        }
        if (!(zipTempFile = new File(tempPath = (ClassUtil.getRootPath() + File.separator + FileUtils.systemFilePath + File.separator + "upload" + File.separator + "att").replace("/", "\\") + File.separator + fileNamePrefix + "_" + DateUtil.dateToString((Date)condition.getBeginDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYYMMDDHHMMSS) + "_" + DateUtil.dateToString((Date)condition.getEndDate(), (DateUtil.DateStyle)DateUtil.DateStyle.YYYYMMDDHHMMSS) + ".zip")).exists()) {
            zipTempFile.createNewFile();
        }
        this.response.reset();
        FileOutputStream fileOutputStream = new FileOutputStream(zipTempFile);
        ZipOutputStream zipOutputStream = new ZipOutputStream(fileOutputStream);
        try {
            for (AttPhotoExportQueryItem item : exportFileList) {
                String compressDir = item.getCompressDirectory();
                File file = new File(item.getFilePath());
                String fileName = file.getName();
                ZipEntry zipEntry = new ZipEntry(compressDir + fileName);
                FileInputStream fileInputStream = new FileInputStream(file);
                BufferedInputStream bufferedInputStream = new BufferedInputStream(fileInputStream, 512);
                zipOutputStream.putNextEntry(zipEntry);
                try {
                    int index;
                    byte[] buffer = new byte[512];
                    while ((index = bufferedInputStream.read(buffer)) != -1) {
                        zipOutputStream.write(buffer, 0, index);
                    }
                }
                finally {
                    if (null != bufferedInputStream) {
                        bufferedInputStream.close();
                    }
                    if (null == fileInputStream) continue;
                    fileInputStream.close();
                }
            }
        }
        finally {
            if (null != zipOutputStream) {
                zipOutputStream.close();
            }
            if (null != fileOutputStream) {
                fileOutputStream.close();
            }
        }
        try {
            FileUtils.downloadZip((File)zipTempFile, (HttpServletResponse)this.response);
            this.response.flushBuffer();
        }
        finally {
            if (zipTempFile.exists()) {
                zipTempFile.delete();
            }
        }
        this.stringRedisTemplate.opsForValue().set((Object)("export-result:" + this.request.getSession().getId()), (Object)"end");
    }
}

