/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.dto.AttShiftTempSchResultDTO;
import com.zkteco.zkbiosecurity.att.remote.AttTempSchRemote;
import com.zkteco.zkbiosecurity.att.service.AttTempSchService;
import com.zkteco.zkbiosecurity.att.vo.AttTempSchItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttTempSchController
extends BaseController
implements AttTempSchRemote {
    @Autowired
    private AttTempSchService attTempSchService;

    @RequiresPermissions(value={"att:tempsch"})
    public ModelAndView index() {
        return new ModelAndView("att/tempSch/attTempSch");
    }

    @RequiresPermissions(value={"att:tempsch:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("shiftIds", (Object)this.attTempSchService.getShiftIds(id));
            this.request.setAttribute("item", (Object)this.attTempSchService.getItemById(id));
        }
        String pathStr = "att/tempSch/editAttTempSch";
        String tempType = this.request.getParameter("tempType");
        if (StringUtils.isNotBlank((CharSequence)tempType)) {
            if ("0".equals(tempType.trim())) {
                pathStr = "att/groupSch/editAttGroupSch";
            } else if ("1".equals(tempType.trim())) {
                pathStr = "att/deptSch/editAttDeptSch";
            } else if ("2".equals(tempType.trim())) {
                pathStr = "att/personSch/editAttPersonSch";
            } else if ("3".equals(tempType.trim())) {
                pathStr = "att/nonSch/editAttNonSch";
            }
            this.request.setAttribute("tempType", (Object)tempType);
        }
        return new ModelAndView(pathStr);
    }

    @RequiresPermissions(value={"att:tempsch:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_tempSch", opType="common_op_new", requestParams={"tempType"}, opContent="att_schedule_tempType")
    public ZKResultMsg save(AttTempSchItem item) {
        ZKResultMsg res = new ZKResultMsg();
        String shiftIds = this.request.getParameter("shiftIds");
        String groupIds = this.request.getParameter("groupIds");
        String deptIds = this.request.getParameter("deptIds");
        String personIds = this.request.getParameter("personIds");
        String isIncludeLower = this.request.getParameter("isIncludeLower");
        this.attTempSchService.saveItem(item, shiftIds, groupIds, deptIds, personIds, isIncludeLower);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:tempsch:refresh"})
    public DxGrid list(AttTempSchItem condition) {
        Pager pager = this.attTempSchService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:tempsch:del"})
    @LogRequest(module="att_module", object="att_leftMenu_tempSch", opType="common_op_del", requestParams={"tempType"}, opContent="att_schedule_tempType")
    public ZKResultMsg delete(String ids) {
        this.attTempSchService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    public AttShiftTempSchResultDTO getAttShiftSchJson() {
        return this.attTempSchService.getAttShiftSchJson(this.request.getParameter("id"));
    }
}

