/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.att.remote.AttManualCalculationRemote;
import com.zkteco.zkbiosecurity.att.service.Att4PersPersonService;
import com.zkteco.zkbiosecurity.att.service.AttBaseDataService;
import com.zkteco.zkbiosecurity.att.service.AttCalculateService;
import com.zkteco.zkbiosecurity.att.service.AttExceptionDataService;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.utils.AttDateUtils;
import com.zkteco.zkbiosecurity.att.vo.Att4PersPersonItem;
import com.zkteco.zkbiosecurity.att.vo.AttManualCalculationItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.ProcessBean;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.cache.ProgressCache;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttManualCalculationController
extends BaseController
implements AttManualCalculationRemote {
    @Autowired
    private AttPersonService attPersonService;
    @Autowired
    private AttCalculateService attCalculateService;
    @Autowired
    private Att4PersPersonService att4PersPersonService;
    @Autowired
    private ProgressCache progressCache;
    @Autowired
    private AttBaseDataService attBaseDataService;
    @Autowired
    private AttExceptionDataService attExceptionDataService;

    @RequiresPermissions(value={"att:manualCalculation"})
    public ModelAndView index() {
        return new ModelAndView("att/manualCalculation/attManualCalculation");
    }

    @RequiresPermissions(value={"att:manualCalculation:refresh"})
    public DxGrid list(AttManualCalculationItem condition) {
        Pager pager = this.attPersonService.getItemsByPageForAttCal(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    public ZKResultMsg calculating() {
        ZKResultMsg res = new ZKResultMsg();
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:manualCalculation:calculate"})
    @LogRequest(module="att_module", object="att_op_calculation", opType="att_op_calculation", requestParams={"pins"}, opContent="att_person_pin")
    public void calculate(String personIds, String deptIds, String startDateStr, String endDateStr, String pins, String totalLeaver, String isIncludeLower) {
        try {
            boolean attendanceLeaver;
            ZKResultMsg msg = this.attCalculateService.calculateRepeatFlag();
            if (!"ok".equals(msg.getRet())) {
                return;
            }
            this.attCalculateService.setCalculateRepeatFlag();
            this.progressCache.beginProcess(ProcessBean.createNormalContent((String)I18nUtil.i18nCode((String)"common_op_startProcessing", (Object[])new Object[0])));
            Date startDate = AttDateUtils.getMinOfDay((String)startDateStr);
            Date endDate = AttDateUtils.getMaxOfDay((String)endDateStr);
            int searchDays = (int)((endDate.getTime() - startDate.getTime()) / 86400000L) + 1;
            boolean bl = attendanceLeaver = "true".equals(totalLeaver);
            if ("true".equals(isIncludeLower) && !StringUtils.isBlank((CharSequence)deptIds)) {
                List authDeptIdAry = this.attPersonService.getAllChildDeptById(deptIds);
                deptIds = StringUtils.join((Object[])authDeptIdAry.toArray(), (String)",");
            }
            int personTotal = this.attCalculateService.countAttPersonNumber(personIds, deptIds, startDate, attendanceLeaver);
            this.progressCache.setProcess(new ProcessBean(10, 1, I18nUtil.i18nCode((String)"att_statistical_filter", (Object[])new Object[0]) + "<br/>"));
            ArrayList filterPinList = new ArrayList(personTotal);
            HashMap attBaseDataMap = new HashMap(10);
            this.attBaseDataService.initAttBaseDataMap(personTotal, personIds, deptIds, startDate, endDate, filterPinList, attBaseDataMap, attendanceLeaver);
            this.progressCache.setProcess(new ProcessBean(70, 5, I18nUtil.i18nCode((String)"att_statistical_initData", (Object[])new Object[0]) + "<br/>"));
            HashMap attExceptionDataMap = new HashMap(12);
            this.attExceptionDataService.initAttExceptionDataMap(null, startDate, endDate, attExceptionDataMap, attBaseDataMap);
            this.progressCache.setProcess(new ProcessBean(100, 10, I18nUtil.i18nCode((String)"att_statistical_exception", (Object[])new Object[0]) + "<br/>"));
            int currentProgress = 10;
            int totalProgress = 10;
            personTotal = personTotal > filterPinList.size() ? filterPinList.size() : personTotal;
            int toIndex = personTotal < 500 ? personTotal : 500;
            int cpuCount = Runtime.getRuntime().availableProcessors();
            int threadCount = cpuCount > 4 ? 3 : 2;
            ArrayList<CompletableFuture> completableFutureList = new ArrayList<CompletableFuture>();
            int batchNum = personTotal % 500 == 0 ? personTotal / 500 : personTotal / 500 + 1;
            int progress = 0;
            this.log.info("====================personTotal:{}, batchNum:{}", (Object)personTotal, (Object)batchNum);
            for (int fromIndex = 0; fromIndex < personTotal; fromIndex += 500) {
                this.log.info(fromIndex + "==Attendance calculation cycle personnel==" + toIndex);
                CompletableFuture completableFuture = this.attCalculateService.progressForeachPersonExt(fromIndex, toIndex, startDate, endDate, searchDays, filterPinList, attBaseDataMap, attExceptionDataMap);
                completableFutureList.add(completableFuture);
                if (completableFutureList.size() >= threadCount) {
                    CompletableFuture[] futures = completableFutureList.toArray(new CompletableFuture[completableFutureList.size()]);
                    CompletableFuture.anyOf(futures).join();
                    Iterator iterator = completableFutureList.iterator();
                    while (iterator.hasNext()) {
                        CompletableFuture next = (CompletableFuture)iterator.next();
                        if (!next.isDone()) continue;
                        iterator.remove();
                        totalProgress = Math.round(++progress * 90 / batchNum) + currentProgress;
                        this.progressCache.setProcess(new ProcessBean(currentProgress, totalProgress, I18nUtil.i18nCode((String)"att_op_calculation", (Object[])new Object[0]) + totalProgress + "%...<br/>"));
                        this.log.info("====================progress:{}, totalProgress:{}", (Object)progress, (Object)totalProgress);
                    }
                }
                toIndex = toIndex + 500 < personTotal ? toIndex + 500 : personTotal;
            }
            while (!completableFutureList.isEmpty()) {
                Iterator iterator = completableFutureList.iterator();
                while (iterator.hasNext()) {
                    CompletableFuture next = (CompletableFuture)iterator.next();
                    if (!next.isDone()) continue;
                    iterator.remove();
                    totalProgress = Math.round(++progress * 90 / batchNum) + currentProgress;
                    this.progressCache.setProcess(new ProcessBean(currentProgress, totalProgress, I18nUtil.i18nCode((String)"att_op_calculation", (Object[])new Object[0]) + totalProgress + "%...<br/>"));
                    this.log.info("====================progress:{}, totalProgress:{}", (Object)progress, (Object)totalProgress);
                }
                try {
                    Thread.sleep(500L);
                }
                catch (InterruptedException interruptedException) {}
            }
            this.attCalculateService.deleteAttCalculateRepeatFlag();
            this.progressCache.finishProcess(ProcessBean.createNormalContent((String)I18nUtil.i18nCode((String)"common_op_succeed", (Object[])new Object[0])));
        }
        catch (Exception e) {
            this.log.error("handlerDataMigration error {}", (Throwable)e);
            this.attCalculateService.deleteAttCalculateRepeatFlag();
            this.progressCache.setProcess(new ProcessBean(100, 100, "<span style='color:red;'>" + I18nUtil.i18nCode((String)"att_statistical_error", (Object[])new Object[0]) + "<span><br/>"));
            this.progressCache.finishProcess(I18nUtil.i18nCode((String)"att_statistical_end", (Object[])new Object[0]));
        }
    }

    public ZKResultMsg calculateRepeatFlag() {
        return this.attCalculateService.calculateRepeatFlag();
    }

    public String getDeptPins(String deptIds) {
        JSONObject jsonObject = new JSONObject();
        List<String> dptIds = Arrays.asList(deptIds.split(","));
        List persPersonItems = this.att4PersPersonService.getPersPersonByDeptIds(dptIds);
        StringBuilder pins = new StringBuilder();
        StringBuilder persIds = new StringBuilder();
        int index = 1;
        for (Att4PersPersonItem persPersonItem : persPersonItems) {
            if (index != persPersonItems.size()) {
                pins.append(persPersonItem.getPersonPin() + ",");
                persIds.append(persPersonItem.getPersonId() + ",");
            } else {
                pins.append(persPersonItem.getPersonPin());
                persIds.append(persPersonItem.getPersonId());
            }
            ++index;
        }
        jsonObject.put("pins", (Object)pins);
        jsonObject.put("persIds", (Object)persIds);
        return jsonObject.toJSONString();
    }
}

