/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttGroupRemote;
import com.zkteco.zkbiosecurity.att.service.AttGroupService;
import com.zkteco.zkbiosecurity.att.vo.AttGroupItem;
import com.zkteco.zkbiosecurity.att.vo.AttGroupPersonSelectItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.TreeItem;
import com.zkteco.zkbiosecurity.base.controller.BaseController;
import com.zkteco.zkbiosecurity.base.format.TreeBuilder;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttGroupController
extends BaseController
implements AttGroupRemote {
    @Autowired
    private AttGroupService attGroupService;

    @RequiresPermissions(value={"att:group"})
    public ModelAndView index() {
        return new ModelAndView("att/group/attGroup");
    }

    @RequiresPermissions(value={"att:group:edit"})
    public ModelAndView edit(String id) {
        if (StringUtils.isNotBlank((CharSequence)id)) {
            this.request.setAttribute("item", (Object)this.attGroupService.getItemById(id));
        }
        return new ModelAndView("att/group/editAttGroup");
    }

    @RequiresPermissions(value={"att:group:edit"})
    @LogRequest(module="att_module", object="att_leftMenu_group", opType="common_op_edit", requestParams={"groupName"}, opContent="common_name")
    public ZKResultMsg save(AttGroupItem item) {
        ZKResultMsg res = new ZKResultMsg();
        this.attGroupService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:group:refresh"})
    public DxGrid list(AttGroupItem condition) {
        Pager pager = this.attGroupService.getItemsByPage((BaseItem)condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:group:del"})
    @LogRequest(module="att_module", object="att_leftMenu_group", opType="common_op_del", requestParams={"names"}, opContent="common_name")
    public ZKResultMsg delete(String ids) {
        if (this.attGroupService.isExistFkData(ids)) {
            return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.failMsg((String)"att_common_relationDataCanNotDel", (Object[])new Object[0]));
        }
        this.attGroupService.deleteByGroup(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)ZKResultMsg.successMsg());
    }

    public TreeItem tree() {
        List BaseDepartmentItems = this.attGroupService.getByCondition(new AttGroupItem());
        ArrayList<TreeItem> items = new ArrayList<TreeItem>();
        TreeItem item = null;
        TreeItem pItem = null;
        for (AttGroupItem attGroupItem : BaseDepartmentItems) {
            item = new TreeItem();
            item.setId(attGroupItem.getId());
            item.setText(attGroupItem.getGroupName());
            pItem = new TreeItem("0");
            item.setParent(pItem);
            items.add(item);
        }
        List treeItems = TreeBuilder.newTreeBuilder(TreeItem.class, String.class).buildToTreeList(items);
        return new TreeItem("0", treeItems);
    }

    public String validName(String groupName) {
        boolean existsGroupName = this.attGroupService.existsByGroupName(groupName);
        return String.valueOf(!existsGroupName);
    }

    public DxGrid selectList(AttGroupPersonSelectItem condition) {
        Pager pager = null;
        if ("noSelected".equals(condition.getType())) {
            pager = this.attGroupService.getNoExistPerson(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        } else {
            pager = new Pager(this.getPageNo(), this.getPageSize());
            pager.setData(new ArrayList());
        }
        return GridUtil.convert((Pager)pager, condition.getClass());
    }
}

