/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttDayCardDetailReportRemote;
import com.zkteco.zkbiosecurity.att.service.AttPersonService;
import com.zkteco.zkbiosecurity.att.service.AttTransactionService;
import com.zkteco.zkbiosecurity.att.vo.AttDayCardDetailReportItem;
import com.zkteco.zkbiosecurity.att.vo.AttPersonItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import java.util.Objects;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttDayCardDetailReportController
extends ExportController
implements AttDayCardDetailReportRemote {
    @Autowired
    private AttTransactionService attTransactionService;
    @Autowired
    private AttPersonService attPersonService;

    @RequiresPermissions(value={"att:dayCardDetailReport"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        AttPersonItem attPersonItem = this.attPersonService.getItemByPersonPin(securitySubject.getUserCode());
        if (Objects.nonNull(attPersonItem)) {
            staff = true;
        }
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/report/attDayCardDetail");
    }

    @RequiresPermissions(value={"att:dayCardDetailReport:refresh"})
    public DxGrid list(AttDayCardDetailReportItem condition) {
        Pager pager = this.attTransactionService.getItemsByDetailReportPage(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:dayCardDetailReport:export"})
    @LogRequest(module="att_module", object="att_leftMenu_dayCardDetailReport", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttDayCardDetailReportItem attDayCardDetailReportItem = new AttDayCardDetailReportItem();
        this.setConditionValue((BaseItem)attDayCardDetailReportItem);
        String sessionId = request.getSession().getId();
        List intemList = this.attTransactionService.exportItemListByAuthFilter(sessionId, AttDayCardDetailReportItem.class, attDayCardDetailReportItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttDayCardDetailReportItem.class);
    }
}

