/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttClassRemote;
import com.zkteco.zkbiosecurity.att.service.AttClassService;
import com.zkteco.zkbiosecurity.att.vo.AttClassItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttClassController
extends ExportController
implements AttClassRemote {
    @Autowired
    private AttClassService attClassService;

    @RequiresPermissions(value={"att:class"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/class/attClass");
    }

    @RequiresPermissions(value={"att:class:add"})
    public ModelAndView edit(String id) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        AttClassItem item = new AttClassItem();
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.attClassService.getItemById(id);
        } else if (staff == null || !staff.booleanValue()) {
            item.setFlowStatus("2");
        }
        this.request.setAttribute("item", (Object)item);
        return new ModelAndView("att/class/editAttClass");
    }

    @RequiresPermissions(value={"att:class:add"})
    @LogRequest(module="att_module", object="att_leftMenu_class", opType="common_op_new", requestParams={"adjustPersonName"}, opContent="att_person_name")
    public ZKResultMsg save(AttClassItem item) {
        ZKResultMsg res = this.attClassService.saveItem(item);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:class:refresh"})
    public DxGrid list(AttClassItem condition) {
        condition.setFlowStatus("2");
        String sessionId = this.request.getSession().getId();
        Pager pager = this.attClassService.loadPagerByAuthUserFilter(sessionId, condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:class:del"})
    @LogRequest(module="att_module", object="att_leftMenu_class", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attClassService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:class:export"})
    @LogRequest(module="att_module", object="att_leftMenu_class", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttClassItem attClassItem = new AttClassItem();
        this.setConditionValue((BaseItem)attClassItem);
        List intemList = this.attClassService.getItemData(request.getSession().getId(), attClassItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttClassItem.class);
    }
}

