/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.controller;

import com.zkteco.zkbiosecurity.att.remote.AttAdjustRemote;
import com.zkteco.zkbiosecurity.att.service.AttAdjustService;
import com.zkteco.zkbiosecurity.att.service.AttShiftService;
import com.zkteco.zkbiosecurity.att.vo.AttAdjustItem;
import com.zkteco.zkbiosecurity.att.vo.AttShiftItem;
import com.zkteco.zkbiosecurity.base.annotation.LogRequest;
import com.zkteco.zkbiosecurity.base.bean.DxGrid;
import com.zkteco.zkbiosecurity.base.bean.Pager;
import com.zkteco.zkbiosecurity.base.bean.SecuritySubject;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.GridUtil;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.web.ExportController;
import com.zkteco.zkbiosecurity.security.annotation.RequiresPermissions;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.servlet.ModelAndView;

@Controller
public class AttAdjustController
extends ExportController
implements AttAdjustRemote {
    @Autowired
    private AttAdjustService attAdjustService;
    @Autowired
    private AttShiftService attShiftService;

    @RequiresPermissions(value={"att:adjust"})
    public ModelAndView index() {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        return new ModelAndView("att/adjust/attAdjust");
    }

    @RequiresPermissions(value={"att:adjust:add"})
    public ModelAndView edit(String id) {
        SecuritySubject securitySubject = this.getCurrentSubject();
        Boolean staff = securitySubject.getStaff();
        this.request.setAttribute("staff", (Object)staff);
        AttAdjustItem item = null;
        if (StringUtils.isNotBlank((CharSequence)id)) {
            item = this.attAdjustService.getItemById(id);
        } else if (null != staff && staff.booleanValue()) {
            item = new AttAdjustItem();
            item.setPersonId(securitySubject.getUserId());
        }
        this.request.setAttribute("item", (Object)item);
        List shiftItemList = this.attShiftService.getByCondition(new AttShiftItem());
        if (shiftItemList != null && shiftItemList.size() > 0) {
            this.request.setAttribute("attShiftId", (Object)((AttShiftItem)shiftItemList.get(0)).getId());
        }
        return new ModelAndView("att/adjust/editAttAdjust");
    }

    @RequiresPermissions(value={"att:adjust:add"})
    @LogRequest(module="att_module", object="att_leftMenu_adjust", opType="common_op_new", requestParams={"personPin"}, opContent="att_person_pin")
    public ZKResultMsg save(AttAdjustItem item) {
        String personIds = this.request.getParameter("personIds");
        if (StringUtils.isBlank((CharSequence)personIds)) {
            throw new ZKBusinessException("EXCEPTIONLEVEL_WARN", "common_prompt_selectObj");
        }
        ZKResultMsg res = this.attAdjustService.saveItem(item, personIds);
        return I18nUtil.i18nMsg((ZKResultMsg)res);
    }

    @RequiresPermissions(value={"att:adjust:refresh"})
    public DxGrid list(AttAdjustItem condition) {
        condition.setFlowStatus("2");
        Pager pager = this.attAdjustService.loadPagerByAuthUserFilter(this.request.getSession().getId(), condition, this.getPageNo(), this.getPageSize());
        return GridUtil.convert((Pager)pager, condition.getClass());
    }

    @RequiresPermissions(value={"att:adjust:del"})
    @LogRequest(module="att_module", object="att_leftMenu_adjust", opType="common_op_del", requestParams={"pins"}, opContent="att_person_pin")
    public ZKResultMsg delete(String ids) {
        this.attAdjustService.deleteByIds(ids);
        return I18nUtil.i18nMsg((ZKResultMsg)new ZKResultMsg());
    }

    @RequiresPermissions(value={"att:adjust:export"})
    @LogRequest(module="att_module", object="att_leftMenu_adjust", opType="common_op_export", requestParams={"exportType"}, opContent="common_report_fileType")
    public void export(HttpServletRequest request, HttpServletResponse response) {
        AttAdjustItem attAdjustItem = new AttAdjustItem();
        this.setConditionValue((BaseItem)attAdjustItem);
        List intemList = this.attAdjustService.getItemData(request.getSession().getId(), AttAdjustItem.class, attAdjustItem, this.getBeginIndex(), this.getEndIndex());
        this.excelExport(intemList, AttAdjustItem.class);
    }
}

