/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.att.api.h5.controller;

import com.zkteco.zkbiosecurity.att.api.vo.AppAttQueryTeamAttItem;
import com.zkteco.zkbiosecurity.att.h5.service.AttApiH5TeamService;
import com.zkteco.zkbiosecurity.att.util.I18nMsgUtil;
import com.zkteco.zkbiosecurity.att.util.ValidatorsUtils;
import com.zkteco.zkbiosecurity.base.vo.ZKPageResultMsg;
import com.zkteco.zkbiosecurity.base.vo.ZKResultMsg;
import com.zkteco.zkbiosecurity.core.exception.ZKBusinessException;
import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v1/att"})
public class AttApiH5TeamController {
    @Autowired
    private AttApiH5TeamService attApiH5TeamService;

    @RequestMapping(path={"/getTeamAttByStatus"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getTeamAttByStatus(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        ZKResultMsg zkResultMsg = this.attApiH5TeamService.getTeamAttByStatus(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getDeptCode(), appAttQueryTeamAttItem.getAttDate());
        return I18nUtil.i18nMsg((ZKResultMsg)zkResultMsg);
    }

    @RequestMapping(path={"/getTeamAttByPers"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getTeamAttByPers(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        ZKPageResultMsg zkResultMsg = this.attApiH5TeamService.getTeamAttByPers(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getDeptCode(), appAttQueryTeamAttItem.getAttDate(), appAttQueryTeamAttItem.getPageNo(), appAttQueryTeamAttItem.getPageSize());
        return I18nMsgUtil.i18nMsg(zkResultMsg);
    }

    @RequestMapping(path={"/getOvertimeExceptionCount"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getOvertimeExceptionCount(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        ZKResultMsg resultMsg = this.attApiH5TeamService.getExceptionCount(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), "overtime");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/getTeamOvertimePage"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getTeamOvertimePage(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTeamAttItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttQueryTeamAttItem.getPageNo() == null || appAttQueryTeamAttItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5TeamService.getTeamOvertimePage(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), appAttQueryTeamAttItem.getPageNo(), appAttQueryTeamAttItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getTeamOvertimeHours"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getTeamOvertimeHours(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTeamAttItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttQueryTeamAttItem.getPageNo() == null || appAttQueryTeamAttItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5TeamService.getTeamOvertimeHours(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), appAttQueryTeamAttItem.getPageNo(), appAttQueryTeamAttItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getLeaveExceptionCount"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getLeaveExceptionCount(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        ZKResultMsg resultMsg = this.attApiH5TeamService.getExceptionCount(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), "leave");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/getTeamLeavePage"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getTeamLeavePage(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTeamAttItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttQueryTeamAttItem.getPageNo() == null || appAttQueryTeamAttItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5TeamService.getTeamLeavePage(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), appAttQueryTeamAttItem.getPageNo(), appAttQueryTeamAttItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getTripExceptionCount"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getTripExceptionCount(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        ZKResultMsg resultMsg = this.attApiH5TeamService.getExceptionCount(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), "trip");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/getOutExceptionCount"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getOutExceptionCount(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        ZKResultMsg resultMsg = this.attApiH5TeamService.getExceptionCount(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), "out");
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/getTeamSignPage"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getTeamSignPage(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTeamAttItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttQueryTeamAttItem.getPageNo() == null || appAttQueryTeamAttItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5TeamService.getTeamSignPage(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), appAttQueryTeamAttItem.getPageNo(), appAttQueryTeamAttItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getTeamSignTimes"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getTeamSignTimes(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTeamAttItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (!ValidatorsUtils.isMonth(appAttQueryTeamAttItem.getAttDate())) {
            throw ZKBusinessException.errorException((String)"base_db_backupDateError", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = this.attApiH5TeamService.getTeamSignTimes(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/getTeamPersonSignTimes"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKResultMsg getTeamPersonSignTimes(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTeamAttItem.getPersonPin())) {
            throw ZKBusinessException.errorException((String)"app_pers_personPinNull", (Object[])new Object[0]);
        }
        ZKResultMsg resultMsg = this.attApiH5TeamService.getTeamPersonSignTimes(appAttQueryTeamAttItem.getPersonPin(), appAttQueryTeamAttItem.getAttDate());
        return I18nUtil.i18nMsg((ZKResultMsg)resultMsg);
    }

    @RequestMapping(path={"/getTeamTripPage"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getTeamTripPage(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTeamAttItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttQueryTeamAttItem.getPageNo() == null || appAttQueryTeamAttItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5TeamService.getTeamTripPage(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), appAttQueryTeamAttItem.getPageNo(), appAttQueryTeamAttItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }

    @RequestMapping(path={"/getTeamOutPage"}, method={RequestMethod.POST}, produces={"application/json"})
    public ZKPageResultMsg getTeamOutPage(@RequestBody AppAttQueryTeamAttItem appAttQueryTeamAttItem) {
        if (StringUtils.isBlank((CharSequence)appAttQueryTeamAttItem.getCustomerId())) {
            throw ZKBusinessException.errorException((String)"att_h5_pers_personIdNull", (Object[])new Object[0]);
        }
        if (appAttQueryTeamAttItem.getPageNo() == null || appAttQueryTeamAttItem.getPageSize() == null) {
            throw ZKBusinessException.errorException((String)"att_h5_common_pageNull", (Object[])new Object[0]);
        }
        ZKPageResultMsg resultMsg = this.attApiH5TeamService.getTeamOutPage(appAttQueryTeamAttItem.getCustomerId(), appAttQueryTeamAttItem.getAttDate(), appAttQueryTeamAttItem.getPageNo(), appAttQueryTeamAttItem.getPageSize());
        return I18nMsgUtil.i18nMsg(resultMsg);
    }
}

