/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker;

import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKDirective;
import freemarker.template.Configuration;
import freemarker.template.TemplateModel;
import freemarker.template.TemplateModelException;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class FreemarkerConfig {
    @Autowired
    private Configuration configuration;
    @Autowired
    private TemplateModel[] templates;

    @PostConstruct
    public void setSharedVariable() throws TemplateModelException {
        if (this.templates != null && this.templates.length > 0) {
            for (TemplateModel temp : this.templates) {
                ZKDirective directive = temp.getClass().getAnnotation(ZKDirective.class);
                if (directive == null) continue;
                String name = directive.value();
                if ("".equals(name)) {
                    name = temp.getClass().getSimpleName();
                }
                this.configuration.setSharedVariable(name, temp);
            }
        }
        this.configuration.addAutoInclude("public/template/i18n.html");
        this.configuration.setNumberFormat("#");
    }
}

