/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.system.service.impl;

import com.sun.jna.Native;
import com.zkteco.zkbiosecurity.base.utils.SystemOsUtil;
import com.zkteco.zkbiosecurity.dll.LibraryService;
import com.zkteco.zkbiosecurity.system.sdk.service.BaseFingerSdkService;
import com.zkteco.zkbiosecurity.system.service.BaseFingerComparisonService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.CommandLineRunner;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;

@Component
@Order(value=11)
public class BaseFingerComparisonServiceImpl
implements BaseFingerComparisonService,
CommandLineRunner {
    private static Logger logger = LoggerFactory.getLogger(BaseFingerComparisonServiceImpl.class);
    @Autowired
    private LibraryService libraryService;
    private BaseFingerSdkService baseFingerSdkService;

    public void run(String ... strings) throws Exception {
        if (SystemOsUtil.isWindow()) {
            logger.info("----------  start init zkfinger10 -----------");
            this.libraryService.loadLibrary("match/zkfinger10-" + System.getProperty("sun.arch.data.model"));
            this.libraryService.loadLibrary("match/matchdll");
            this.baseFingerSdkService = (BaseFingerSdkService)Native.loadLibrary((String)"match/matchdll", BaseFingerSdkService.class);
            logger.info("----------  end init matchdll -----------");
        }
    }

    public void NativeToSetThreshold(int threshold, int oneToOneThreshold) {
        this.baseFingerSdkService.SetThreshold(threshold, oneToOneThreshold);
    }

    public boolean NativeToProcess(String regTemplate, String verTemplate) {
        return this.baseFingerSdkService.process(regTemplate, verTemplate) == 1;
    }
}

