/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.zkteco.zkbiosecurity.core.utils.I18nUtil;
import com.zkteco.zkbiosecurity.core.utils.ResourceUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKDirective;
import freemarker.template.TemplateMethodModelEx;
import freemarker.template.TemplateModelException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.Resource;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@Component
@ZKDirective(value="getLanguageList")
public class LanguageList
implements TemplateMethodModelEx {
    @Value(value="${spring.defined.messages.basename:local/*.properties}")
    private String localPattern;
    private static Map<String, String> langMap = new HashMap<String, String>();

    private List<String> getLanguages() {
        Resource[] res;
        ArrayList<String> langs = new ArrayList<String>();
        for (Resource r : res = ResourceUtil.loadResources((String)this.localPattern)) {
            String lang;
            int i = r.getFilename().indexOf("_");
            if (i == -1 || langs.indexOf(lang = r.getFilename().substring(i + 1, r.getFilename().length() - ".properties".length())) != -1) continue;
            langs.add(lang);
        }
        return langs;
    }

    private Map<String, Map<String, String>> getLocaleNames(String name) {
        HashMap<String, Map<String, String>> names = new HashMap<String, Map<String, String>>();
        Locale[] locales = Locale.getAvailableLocales();
        Locale defaultLocale = this.getLocaleByName(name);
        for (Locale locale : locales) {
            String code = (locale + "").split("#")[0];
            if (!StringUtils.isNotBlank((CharSequence)code) || names.containsKey(code)) continue;
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("code", code);
            if (langMap.containsKey(code)) {
                map.put("name1", this.resolveLanguageName(I18nUtil.i18nCode((String)("common_lang_" + code), (Object[])new Object[0]), code));
                map.put("name2", this.resolveLanguageName(langMap.get(code), code));
            } else {
                map.put("name1", this.resolveLanguageName(locale.getDisplayName(defaultLocale), code));
                map.put("name2", this.resolveLanguageName(locale.getDisplayName(locale), code));
            }
            names.put(code, map);
        }
        return names;
    }

    private String resolveLanguageName(String name, String code) {
        int index;
        if (StringUtils.isNotBlank((CharSequence)name) && !"zh_CN".equals(code) && !"zh_TW".equals(code) && !"pt_BR".equals(code) && (index = name.indexOf("(")) != -1) {
            return name.substring(0, index);
        }
        return name;
    }

    private Locale getLocaleByName(String name) {
        Locale[] locales;
        for (Locale l : locales = Locale.getAvailableLocales()) {
            if (!(l + "").equals(name)) continue;
            return l;
        }
        return Locale.getDefault();
    }

    public Map<String, Map<String, String>> getLanguageList(String loca) {
        HashMap<String, Map<String, String>> ret = new HashMap<String, Map<String, String>>();
        Map<String, Map<String, String>> langMap = this.getLocaleNames(loca);
        List<String> langs = this.getLanguages();
        for (String lang : langs) {
            if (!langMap.containsKey(lang)) continue;
            ret.put(lang, langMap.get(lang));
        }
        return ret;
    }

    public Object exec(List arguments) throws TemplateModelException {
        if (!arguments.isEmpty()) {
            HttpServletRequest req = ((ServletRequestAttributes)RequestContextHolder.getRequestAttributes()).getRequest();
            String lang = req.getParameter("lang");
            if (StringUtils.isBlank((CharSequence)lang)) {
                lang = arguments.get(0).toString();
            }
            return this.getLanguageList(lang);
        }
        return null;
    }

    static {
        langMap.put("zh_CN", "\u4e2d\u6587(\u7b80\u4f53)");
        langMap.put("en_US", "English");
        langMap.put("es", "Espa\u00f1ol");
        langMap.put("th", "\u0e44\u0e17\u0e22");
        langMap.put("in_ID", "Bahasa Indonesia");
        langMap.put("vi", "Ti\u1ebfng Vi\u1ec7t");
        langMap.put("zh_TW", "\u4e2d\u6587(\u7e41\u9ad4)");
        langMap.put("ru_RU", "P\u0443\u0441\u0441\u043a\u0438\u0439");
        langMap.put("ar", "\u0639\u0631\u0628\u0649");
        langMap.put("pt_BR", "Portugu\u00eas (Brasil)");
        langMap.put("fr", "Fran\u00e7ais");
    }
}

