/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.core.utils.SpringContextUtil;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import org.apache.commons.beanutils.MethodUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKEchart.js")
public class Echart
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        JSONObject options = new JSONObject();
        BeanUtil.setParamsToJson(options, params);
        String id = BeanUtil.getParam(params, "id", "echart" + BeanUtil.getUUID());
        options.put("id", (Object)id);
        if (body != null) {
            StringWriter sout = new StringWriter();
            body.render((Writer)sout);
            if (StringUtils.isNotBlank((CharSequence)sout.toString())) {
                try {
                    JSONObject bodyContent = JSONObject.parseObject((String)sout.toString().trim());
                    options.put("body", (Object)bodyContent);
                }
                catch (Exception e) {
                    options.put("body", (Object)sout.toString().trim());
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)options.getString("optionClass"))) {
            try {
                String classMethodName = options.getString("optionClass");
                int len = classMethodName.lastIndexOf(".");
                String className = classMethodName.substring(0, len);
                String methodName = classMethodName.substring(len + 1);
                Object obj = null;
                try {
                    obj = SpringContextUtil.getBean((String)className);
                }
                catch (Exception ex) {
                    obj = ClassUtils.getClass((String)className).newInstance();
                }
                JSONObject opt = (JSONObject)MethodUtils.invokeMethod((Object)obj, (String)methodName, null);
                options.put("optionEX", (Object)opt);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        HTMLElement doc = Document.createElement();
        doc.div().addAttributesOnly(params).id(id).addClass("echart_box");
        doc.script().appendContent("new ZKUI.Echart(" + options.toJSONString() + ");");
        Writer out = env.getOut();
        out.write(doc.toString());
    }
}

