/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.freemarker.directives;

import com.alibaba.fastjson.JSONObject;
import com.zkteco.zkbiosecurity.ui.web.freemarker.annotation.ZKUIDirective;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.Document;
import com.zkteco.zkbiosecurity.ui.web.freemarker.tags.HTMLElement;
import com.zkteco.zkbiosecurity.ui.web.freemarker.util.BeanUtil;
import freemarker.core.Environment;
import freemarker.template.TemplateDirectiveBody;
import freemarker.template.TemplateDirectiveModel;
import freemarker.template.TemplateException;
import freemarker.template.TemplateModel;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;
import org.springframework.stereotype.Component;

@Component
@ZKUIDirective(script="ui/js/ZKDGrid.js")
public class DGrid
implements TemplateDirectiveModel {
    public void execute(Environment env, Map params, TemplateModel[] loopVars, TemplateDirectiveBody body) throws TemplateException, IOException {
        boolean enableRTL = BeanUtil.enableRTL();
        Writer out = env.getOut();
        JSONObject options = new JSONObject();
        BeanUtil.setParamsToJson(options, params);
        String gridName = options.getString("gridName");
        if (gridName == null || "".equals(gridName)) {
            gridName = "gridbox" + BeanUtil.getUUID();
            options.put("gridName", (Object)gridName);
        }
        JSONObject ops = (JSONObject)env.getCurrentNamespace().toMap().get("options");
        env.getCurrentNamespace().put("options", (Object)options);
        if (body != null) {
            body.render(out);
        }
        env.getCurrentNamespace().put("options", (Object)ops);
        HTMLElement doc = Document.createElement();
        doc.div().id("layoutBox" + gridName).addClass("layout_dgrid_box").addAttributesOnly(params);
        doc.div().id("leftLayoutBox" + gridName).addClass("layout_leftgrid_box").addAttributesOnly((Map)options.get((Object)"leftParams")).removeAttr("title");
        doc.div().id("rightLayoutBox" + gridName).addClass("layout_rightgrid_box").addAttributesOnly((Map)options.get((Object)"rightParams")).removeAttr("title");
        options.remove((Object)"leftParams");
        options.remove((Object)"rightParams");
        if (enableRTL) {
            options.put("enableRTL", (Object)true);
        }
        doc.script().appendContent("new ZKUI.DGrid(" + options.toJSONString() + ");");
        out.write(doc.toString());
    }
}

