/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ui.web.config;

import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.stereotype.Component;

@Component
public class DynamicEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(DynamicEnvironmentPostProcessor.class);
    private int order = -2147483618;

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        InputStream is;
        String skin = environment.getProperty("system.skin");
        if (StringUtils.isNotBlank((CharSequence)skin) && (is = this.getClass().getResourceAsStream("/static/public/skins/" + skin + "/skin.properties")) != null) {
            try {
                Properties properties = new Properties();
                properties.load(is);
                PropertiesPropertySource propertySource = new PropertiesPropertySource("dynamic", properties);
                environment.getPropertySources().addAfter("applicationConfigurationProperties", (PropertySource)propertySource);
            }
            catch (Exception e) {
                log.error("load dynamic failed", (Throwable)e);
            }
        }
    }

    public int getOrder() {
        return this.order;
    }
}

