/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.ins.vo;

import com.zkteco.zkbiosecurity.base.annotation.Column;
import com.zkteco.zkbiosecurity.base.annotation.Condition;
import com.zkteco.zkbiosecurity.base.annotation.From;
import com.zkteco.zkbiosecurity.base.annotation.GridColumn;
import com.zkteco.zkbiosecurity.base.annotation.GridConfig;
import com.zkteco.zkbiosecurity.base.annotation.OrderBy;
import com.zkteco.zkbiosecurity.base.vo.BaseItem;
import java.util.Date;

@From(after="INS_TRANSACTION t ")
@OrderBy(after="t.ATT_DATETIME DESC")
@GridConfig(operate=true, idField="id", winHeight=400, winWidth=600, operates={})
public class InsTransactionItem
extends BaseItem {
    private static final long serialVersionUID = 1L;
    @Column(name="t.ID")
    @GridColumn(show=false)
    private String id;
    @Column(name="t.AUTH_DEPT_ID", equalTag="=")
    private String deptId;
    @Column(name="t.AUTH_DEPT_CODE", equalTag="=")
    @GridColumn(label="pers_dept_deptNo", width="130")
    private String deptCode;
    @Column(name="t.AUTH_DEPT_NAME")
    @GridColumn(label="pers_dept_deptName", width="120")
    private String deptName;
    @Column(name="t.PERS_PERSON_PIN", equalTag="=")
    @GridColumn(label="pers_person_pin", width="100")
    private String personPin;
    @Column(name="t.PERS_PERSON_NAME")
    @GridColumn(label="pers_person_name", width="100")
    private String personName;
    @Column(name="t.PERS_PERSON_LAST_NAME")
    @GridColumn(label="pers_person_lastName", width="100", showExpression="#language!='zh_CN'")
    private String personLastName;
    @Column(name="t.AUTH_AREA_ID", equalTag="=")
    @GridColumn(show=false)
    private String areaId;
    @Column(name="t.AUTH_AREA_NO")
    @GridColumn(show=false)
    private String areaNo;
    @Column(name="t.AUTH_AREA_NAME")
    @GridColumn(label="base_area_name", sort="na", width="120")
    private String areaName;
    @Column(name="t.DEVICE_ID", equalTag="=")
    @GridColumn(show=false)
    private String deviceId;
    @Column(name="t.DEVICE_SN")
    @GridColumn(label="ins_device_sn", width="150")
    private String deviceSn;
    @Column(name="t.DOOR_NO")
    @GridColumn(show=false)
    private Short doorNo;
    @Column(name="t.ATT_DATETIME")
    @GridColumn(label="ins_transaction_time", width="150")
    private Date attDatetime;
    @Column(name="t.ATT_DATE")
    @GridColumn(show=false)
    private String attDate;
    @Column(name="t.ATT_TIME")
    @GridColumn(show=false)
    private String attTime;
    @Column(name="t.ATT_STATE")
    @GridColumn(show=false)
    private String attState;
    @Column(name="t.ATT_VERIFY")
    @GridColumn(show=false)
    private String attVerify;
    @Column(name="t.MARK")
    @GridColumn(label="ins_statistical_dataSources", format="ins=ins_statistical_ins")
    private String mark;
    @Condition(value="t.ATT_DATETIME", equalTag=">=")
    private Date beginDate;
    @Condition(value="t.ATT_DATETIME", equalTag="<=")
    private Date endDate;
    @Condition(value="t.AUTH_DEPT_ID", equalTag="in")
    private String inDeptId;
    @Condition(value="t.DEVICE_ID", equalTag="in")
    private String inDeviceId;
    @Condition(value="(lower(t.PERS_PERSON_NAME) LIKE ''%{0}%'' OR lower(t.PERS_PERSON_LAST_NAME) LIKE ''%{0}%'')")
    private String likeName;

    public InsTransactionItem setId(String id) {
        this.id = id;
        return this;
    }

    public InsTransactionItem setDeptId(String deptId) {
        this.deptId = deptId;
        return this;
    }

    public InsTransactionItem setDeptCode(String deptCode) {
        this.deptCode = deptCode;
        return this;
    }

    public InsTransactionItem setDeptName(String deptName) {
        this.deptName = deptName;
        return this;
    }

    public InsTransactionItem setPersonPin(String personPin) {
        this.personPin = personPin;
        return this;
    }

    public InsTransactionItem setPersonName(String personName) {
        this.personName = personName;
        return this;
    }

    public InsTransactionItem setPersonLastName(String personLastName) {
        this.personLastName = personLastName;
        return this;
    }

    public InsTransactionItem setAreaId(String areaId) {
        this.areaId = areaId;
        return this;
    }

    public InsTransactionItem setAreaNo(String areaNo) {
        this.areaNo = areaNo;
        return this;
    }

    public InsTransactionItem setAreaName(String areaName) {
        this.areaName = areaName;
        return this;
    }

    public InsTransactionItem setDeviceId(String deviceId) {
        this.deviceId = deviceId;
        return this;
    }

    public InsTransactionItem setDeviceSn(String deviceSn) {
        this.deviceSn = deviceSn;
        return this;
    }

    public InsTransactionItem setDoorNo(Short doorNo) {
        this.doorNo = doorNo;
        return this;
    }

    public InsTransactionItem setAttDatetime(Date attDatetime) {
        this.attDatetime = attDatetime;
        return this;
    }

    public InsTransactionItem setAttDate(String attDate) {
        this.attDate = attDate;
        return this;
    }

    public InsTransactionItem setAttTime(String attTime) {
        this.attTime = attTime;
        return this;
    }

    public InsTransactionItem setAttState(String attState) {
        this.attState = attState;
        return this;
    }

    public InsTransactionItem setAttVerify(String attVerify) {
        this.attVerify = attVerify;
        return this;
    }

    public InsTransactionItem setMark(String mark) {
        this.mark = mark;
        return this;
    }

    public InsTransactionItem setBeginDate(Date beginDate) {
        this.beginDate = beginDate;
        return this;
    }

    public InsTransactionItem setEndDate(Date endDate) {
        this.endDate = endDate;
        return this;
    }

    public InsTransactionItem setInDeptId(String inDeptId) {
        this.inDeptId = inDeptId;
        return this;
    }

    public InsTransactionItem setInDeviceId(String inDeviceId) {
        this.inDeviceId = inDeviceId;
        return this;
    }

    public InsTransactionItem setLikeName(String likeName) {
        this.likeName = likeName;
        return this;
    }

    public String getId() {
        return this.id;
    }

    public String getDeptId() {
        return this.deptId;
    }

    public String getDeptCode() {
        return this.deptCode;
    }

    public String getDeptName() {
        return this.deptName;
    }

    public String getPersonPin() {
        return this.personPin;
    }

    public String getPersonName() {
        return this.personName;
    }

    public String getPersonLastName() {
        return this.personLastName;
    }

    public String getAreaId() {
        return this.areaId;
    }

    public String getAreaNo() {
        return this.areaNo;
    }

    public String getAreaName() {
        return this.areaName;
    }

    public String getDeviceId() {
        return this.deviceId;
    }

    public String getDeviceSn() {
        return this.deviceSn;
    }

    public Short getDoorNo() {
        return this.doorNo;
    }

    public Date getAttDatetime() {
        return this.attDatetime;
    }

    public String getAttDate() {
        return this.attDate;
    }

    public String getAttTime() {
        return this.attTime;
    }

    public String getAttState() {
        return this.attState;
    }

    public String getAttVerify() {
        return this.attVerify;
    }

    public String getMark() {
        return this.mark;
    }

    public Date getBeginDate() {
        return this.beginDate;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public String getInDeptId() {
        return this.inDeptId;
    }

    public String getInDeviceId() {
        return this.inDeviceId;
    }

    public String getLikeName() {
        return this.likeName;
    }
}

