/*
 * Decompiled with CFR 0.152.
 */
package com.zkteco.zkbiosecurity.adms.distributor.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.util.Assert;

public class DataReadUtil {
    private static final String TAB_STR = "\t";
    private static final String NEW_LINE_STR = "\n";
    private static final String SPACE_STR = " ";
    private static final String DEFAULT_EMPTY_STR = "";
    private static final String DEFAULT_KEY_PREFIX = "key";
    public static final byte LF = 10;

    private static String[] splitCell(String str) {
        return str.split(TAB_STR);
    }

    private static String[] splitLine(String str) {
        return StringUtils.split((String)StringUtils.defaultString((String)str), (String)NEW_LINE_STR);
    }

    private static Map<String, String> readLineToDynamicNamedValue(String line) {
        HashMap<String, String> namedValues = new HashMap<String, String>();
        Object[] arr = DataReadUtil.splitCell(line);
        Assert.notEmpty((Object[])arr, (String)"split arr is empty");
        for (int i = 0; i < arr.length; ++i) {
            String name = DEFAULT_KEY_PREFIX + i;
            Object value = arr[i];
            namedValues.put(name, (String)value);
        }
        return namedValues;
    }

    public static List<Map<String, String>> readToNamedValue(String content) {
        String[] lineArr;
        ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
        for (String line : lineArr = DataReadUtil.splitLine(content)) {
            l.add(DataReadUtil.readLineToDynamicNamedValue(line));
        }
        return l;
    }

    private static NamedValue readIntoNamedValue(String namedValueStr) {
        Assert.hasText((String)namedValueStr, (String)"namedValue string is empty");
        String[] arr = StringUtils.split((String)namedValueStr, (String)"=", (int)2);
        if (arr.length == 1) {
            return new NamedValue(StringUtils.trimToEmpty((String)arr[0]).toLowerCase(), DEFAULT_EMPTY_STR);
        }
        if (arr.length == 2) {
            return new NamedValue(StringUtils.trimToEmpty((String)arr[0]).toLowerCase(), StringUtils.trimToEmpty((String)arr[1]));
        }
        return null;
    }

    private static String readLineTitle(String content) {
        Assert.hasText((String)content, (String)"line data is empty");
        return content.substring(0, StringUtils.indexOf((CharSequence)content, (CharSequence)SPACE_STR)).toLowerCase();
    }

    private static String readLineValue(String content) {
        Assert.hasText((String)content, (String)"line data is empty");
        int index = StringUtils.indexOf((CharSequence)content, (CharSequence)SPACE_STR);
        return StringUtils.trimToEmpty((String)content.substring(index));
    }

    private static Map<String, String> readLineNamedValue(String[] cells) {
        Assert.notEmpty((Object[])cells);
        HashMap<String, String> re = new HashMap<String, String>();
        for (int i = 0; i < cells.length; ++i) {
            NamedValue namedValue = DataReadUtil.readIntoNamedValue(cells[i]);
            if (namedValue == null) continue;
            re.put(namedValue.getName(), namedValue.getValue());
        }
        return re;
    }

    public static Map<String, List<Map<String, String>>> readTitleNamedValue(String content) {
        String[] lines;
        HashMap<String, List<Map<String, String>>> re = new HashMap<String, List<Map<String, String>>>();
        for (String line : lines = DataReadUtil.splitLine(content)) {
            String title = DataReadUtil.readLineTitle(line);
            String lineVaue = DataReadUtil.readLineValue(line);
            Map<String, String> namedValues = null;
            namedValues = OperlogType.OPLOG.name().equalsIgnoreCase(title) ? DataReadUtil.readLineToDynamicNamedValue(lineVaue) : DataReadUtil.readLineNamedValue(DataReadUtil.splitCell(lineVaue));
            if (re.containsKey(title)) {
                ((List)re.get(title)).add(namedValues);
                continue;
            }
            ArrayList<Map<String, String>> l = new ArrayList<Map<String, String>>();
            l.add(namedValues);
            re.put(title, l);
        }
        return re;
    }

    public static Map<String, String> readQueryString(String content) {
        String[] pairs;
        HashMap<String, String> re = new HashMap<String, String>();
        for (String pair : pairs = StringUtils.split((String)StringUtils.trimToEmpty((String)content), (String)"&")) {
            NamedValue namedValue = DataReadUtil.readIntoNamedValue(pair);
            re.put(namedValue.getName(), namedValue.getValue());
        }
        return re;
    }

    public static Map<String, String> readEachLineNamedValue(String content) {
        String[] lines;
        HashMap<String, String> re = new HashMap<String, String>();
        for (String line : lines = DataReadUtil.splitLine(content)) {
            NamedValue namedValue = DataReadUtil.readIntoNamedValue(line);
            re.put(namedValue.getName(), namedValue.getValue());
        }
        return re;
    }

    public static Map<String, String> readLineNamedValue(String content) {
        String[] arrs;
        HashMap<String, String> re = new HashMap<String, String>();
        for (String cell : arrs = DataReadUtil.splitCell(content)) {
            NamedValue namedValue = DataReadUtil.readIntoNamedValue(cell);
            re.put(namedValue.getName(), namedValue.getValue());
        }
        return re;
    }

    static enum OperlogType {
        OPLOG,
        USER,
        FP,
        FACE,
        USERPIC;

    }

    static class NamedValue {
        private String name;
        private String value;

        NamedValue(String name, String value) {
            this.name = name;
            this.value = value;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getValue() {
            return this.value;
        }

        public void setValue(String value) {
            this.value = value;
        }
    }
}

