/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.runtime;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.SocketPermission;
import java.net.URL;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Permissions;
import java.security.PrivilegedAction;
import java.security.ProtectionDomain;
import java.util.PropertyPermission;
import net.sourceforge.jnlp.runtime.PacEvaluator;
import net.sourceforge.jnlp.util.TimedHashMap;
import net.sourceforge.jnlp.util.logging.OutputController;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class RhinoBasedPacEvaluator
implements PacEvaluator {
    private final String pacHelperFunctionContents;
    private final String pacContents;
    private final URL pacUrl;
    private final TimedHashMap<String, String> cache;

    public RhinoBasedPacEvaluator(URL pacUrl) {
        OutputController.getLogger().log(OutputController.Level.ERROR_DEBUG, "Using the Rhino based PAC evaluator for url " + pacUrl);
        this.pacHelperFunctionContents = this.getHelperFunctionContents();
        this.pacUrl = pacUrl;
        this.pacContents = this.getPacContents(pacUrl);
        this.cache = new TimedHashMap();
    }

    @Override
    public String getProxies(URL url) {
        String cachedResult = this.getFromCache(url);
        if (cachedResult != null) {
            return cachedResult;
        }
        String result = this.getProxiesWithoutCaching(url);
        this.addToCache(url, result);
        return result;
    }

    private String getProxiesWithoutCaching(URL url) {
        if (this.pacHelperFunctionContents == null) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "Error loading pac functions");
            return "DIRECT";
        }
        EvaluatePacAction evaluatePacAction = new EvaluatePacAction(this.pacContents, this.pacUrl.toString(), this.pacHelperFunctionContents, url);
        Permissions p = new Permissions();
        p.add(new RuntimePermission("accessClassInPackage.org.mozilla.javascript"));
        p.add(new SocketPermission("*", "resolve"));
        p.add(new PropertyPermission("java.vm.name", "read"));
        ProtectionDomain pd = new ProtectionDomain(null, p);
        AccessControlContext context = new AccessControlContext(new ProtectionDomain[]{pd});
        return AccessController.doPrivileged(evaluatePacAction, context);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getPacContents(URL pacUrl) {
        StringBuilder contents = null;
        try {
            String line = null;
            contents = new StringBuilder();
            try (BufferedReader pacReader = new BufferedReader(new InputStreamReader(pacUrl.openStream()));){
                while ((line = pacReader.readLine()) != null) {
                    contents = contents.append(line).append("\n");
                }
            }
        }
        catch (IOException e) {
            contents = null;
        }
        return contents != null ? contents.toString() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getHelperFunctionContents() {
        StringBuilder contents = null;
        try {
            ClassLoader cl = this.getClass().getClassLoader();
            if (cl == null) {
                cl = ClassLoader.getSystemClassLoader();
            }
            InputStream in = cl.getResourceAsStream("net/sourceforge/jnlp/runtime/pac-funcs.js");
            try (BufferedReader pacFuncsReader = new BufferedReader(new InputStreamReader(in));){
                String line;
                contents = new StringBuilder();
                while ((line = pacFuncsReader.readLine()) != null) {
                    contents = contents.append(line).append("\n");
                }
            }
        }
        catch (IOException e) {
            OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
            contents = null;
        }
        return contents != null ? contents.toString() : null;
    }

    private String getFromCache(URL url) {
        String lookupString = url.getProtocol() + "://" + url.getHost();
        String result = this.cache.get(lookupString);
        return result;
    }

    private void addToCache(URL url, String proxyResult) {
        String lookupString = url.getAuthority() + "://" + url.getHost();
        this.cache.put(lookupString, proxyResult);
    }

    private static class EvaluatePacAction
    implements PrivilegedAction<String> {
        private String pacContents;
        private String pacUrl;
        private String pacFuncsContents;
        private URL url;

        public EvaluatePacAction(String pacContents, String pacUrl, String pacFuncsContents, URL url) {
            this.pacContents = pacContents;
            this.pacUrl = pacUrl;
            this.pacFuncsContents = pacFuncsContents;
            this.url = url;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public String run() {
            Context cx = Context.enter();
            try {
                ScriptableObject scope = cx.initStandardObjects();
                cx.setOptimizationLevel(-1);
                Object result = null;
                result = cx.evaluateString(scope, this.pacFuncsContents, "internal", 1, null);
                result = cx.evaluateString(scope, this.pacContents, this.pacUrl, 1, null);
                Object functionObj = scope.get("FindProxyForURL", (Scriptable)scope);
                if (!(functionObj instanceof Function)) {
                    OutputController.getLogger().log(OutputController.Level.ERROR_ALL, "FindProxyForURL not found");
                    String string = null;
                    return string;
                }
                Function findProxyFunction = (Function)functionObj;
                Object[] args = new Object[]{this.url.toString(), this.url.getHost()};
                result = findProxyFunction.call(cx, scope, scope, args);
                String string = (String)result;
                return string;
            }
            catch (Exception e) {
                OutputController.getLogger().log(OutputController.Level.ERROR_ALL, e);
                String string = "DIRECT";
                return string;
            }
            finally {
                Context.exit();
            }
        }
    }
}

