/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.jnlp.config;

import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.jnlp.config.InfrastructureFileDescriptor;
import net.sourceforge.jnlp.runtime.JNLPRuntime;
import net.sourceforge.jnlp.runtime.Translator;
import net.sourceforge.jnlp.util.logging.OutputController;

public class PathsAndFiles {
    public static final String DEPLOYMENT_SUBDIR_DIR = "icedtea-web";
    private static final String CONFIG_HOME;
    private static final String CACHE_HOME;
    private static final String DATA_HOME;
    private static final String RUNTIME_HOME;
    public static final String USER_CONFIG_HOME;
    public static final String USER_CACHE_HOME;
    public static final String USER_DEFAULT_SECURITY_DIR;
    public static final String XDG_CONFIG_HOME_VAR = "XDG_CONFIG_HOME";
    public static final String XDG_CACHE_HOME_VAR = "XDG_CACHE_HOME";
    public static final String XDG_RUNTIME_DIR_VAR = "XDG_RUNTIME_DIR";
    private static final String XDG_DATA_HOME = "XDG_DATA_HOME";
    private static final String WINDIR = "WINDIR";
    private static final String TMP_PROP = "java.io.tmpdir";
    private static final String HOME_PROP = "user.home";
    private static final String ITW_USERDATA_PROP = "itw.userdata";
    private static final String JAVA_PROP = "java.home";
    private static final String USER_PROP = "user.name";
    private static final String VARIABLE;
    private static final String securityWord = "security";
    public static final String ICEDTEA_SO = "IcedTeaPlugin.so";
    public static final String CACHE_INDEX_FILE_NAME = "recently_used";
    public static final InfrastructureFileDescriptor PIPES_DIR;
    public static final InfrastructureFileDescriptor MOZILA_USER;
    public static final InfrastructureFileDescriptor MOZILA_GLOBAL_64;
    public static final InfrastructureFileDescriptor MOZILA_GLOBAL_32;
    public static final InfrastructureFileDescriptor OPERA_64;
    public static final InfrastructureFileDescriptor OPERA_32;
    public static final InfrastructureFileDescriptor CACHE_DIR;
    public static final InfrastructureFileDescriptor PCACHE_DIR;
    public static final InfrastructureFileDescriptor LOG_DIR;
    public static final InfrastructureFileDescriptor ICONS_DIR;
    public static final InfrastructureFileDescriptor GEN_JNLPS_DIR;
    public static final InfrastructureFileDescriptor MENUS_DIR;
    public static final InfrastructureFileDescriptor APPLET_TRUST_SETTINGS_USER;
    public static final InfrastructureFileDescriptor APPLET_TRUST_SETTINGS_SYS;
    public static final InfrastructureFileDescriptor ETC_DEPLOYMENT_CFG;
    public static final InfrastructureFileDescriptor TMP_DIR;
    public static final InfrastructureFileDescriptor LOCKS_DIR;
    public static final InfrastructureFileDescriptor MAIN_LOCK;
    public static final InfrastructureFileDescriptor JAVA_POLICY;
    public static final InfrastructureFileDescriptor USER_CACERTS;
    public static final InfrastructureFileDescriptor USER_JSSECAC;
    public static final InfrastructureFileDescriptor USER_CERTS;
    public static final InfrastructureFileDescriptor USER_JSSECER;
    public static final InfrastructureFileDescriptor USER_CLIENTCERT;
    public static final InfrastructureFileDescriptor SYS_CACERT;
    public static final InfrastructureFileDescriptor SYS_JSSECAC;
    public static final InfrastructureFileDescriptor SYS_CERT;
    public static final InfrastructureFileDescriptor SYS_JSSECERT;
    public static final InfrastructureFileDescriptor SYS_CLIENTCERT;
    public static final InfrastructureFileDescriptor JAVA_DEPLOYMENT_PROP_FILE;
    public static final InfrastructureFileDescriptor USER_DEPLOYMENT_FILE;

    public static InfrastructureFileDescriptor getRecentlyUsedFile() {
        return RECENTLY_USED_FILE_HOLDER.RECENTLY_USED_FILE;
    }

    public static List<InfrastructureFileDescriptor> getAllFiles() {
        return PathsAndFiles.getAllFiles(null);
    }

    public static List<InfrastructureFileDescriptor> getAllSecurityFiles() {
        return PathsAndFiles.getAllFiles(null, UserSecurityConfigFileDescriptor.class);
    }

    private static List<InfrastructureFileDescriptor> getAllFiles(Target desired) {
        return PathsAndFiles.getAllFiles(desired, InfrastructureFileDescriptor.class);
    }

    private static List<InfrastructureFileDescriptor> getAllFiles(Target desired, Class c) {
        Field[] all;
        ArrayList<InfrastructureFileDescriptor> r = new ArrayList<InfrastructureFileDescriptor>();
        block2: for (Field field : all = PathsAndFiles.class.getDeclaredFields()) {
            try {
                Object o = field.get(null);
                if (!c.isInstance(o)) continue;
                InfrastructureFileDescriptor i = (InfrastructureFileDescriptor)o;
                for (Target targe : i.target) {
                    if (desired != null && targe != desired) continue;
                    r.add(i);
                    continue block2;
                }
            }
            catch (IllegalAccessException | IllegalArgumentException ex) {
                OutputController.getLogger().log(ex);
            }
        }
        r.add(PathsAndFiles.getRecentlyUsedFile());
        return r;
    }

    public static List<InfrastructureFileDescriptor> getAllJavaWsFiles() {
        return PathsAndFiles.getAllFiles(Target.JAVAWS);
    }

    public static List<InfrastructureFileDescriptor> getAllItWebSettingsFiles() {
        return PathsAndFiles.getAllFiles(Target.ITWEB_SETTINGS);
    }

    public static List<InfrastructureFileDescriptor> getAllPEFiles() {
        return PathsAndFiles.getAllFiles(Target.POLICY_EDITOR);
    }

    public static List<InfrastructureFileDescriptor> getAllPluginFiles() {
        return PathsAndFiles.getAllFiles(Target.PLUGIN);
    }

    static {
        VARIABLE = JNLPRuntime.isWindows() ? "%" : "$";
        String itwDataRootProp = System.getProperty(ITW_USERDATA_PROP);
        String itwDataRootBadslash = null != itwDataRootProp ? itwDataRootProp : System.getProperty(HOME_PROP);
        String itwDataRoot = itwDataRootBadslash.replace("/", "\\");
        String configHome = itwDataRoot + File.separator + ".config";
        String cacheHome = itwDataRoot + File.separator + ".cache";
        String dataHome = itwDataRoot + File.separator + ".local" + File.separator + "share";
        String runtimeHome = System.getProperty(TMP_PROP);
        String xdg_config_home = System.getenv(XDG_CONFIG_HOME_VAR);
        String xdg_cache_home = System.getenv(XDG_CACHE_HOME_VAR);
        String xdg_runtime_home = System.getenv(XDG_RUNTIME_DIR_VAR);
        String xdg_data_home = System.getenv(XDG_DATA_HOME);
        CONFIG_HOME = xdg_config_home != null ? xdg_config_home : configHome;
        CACHE_HOME = xdg_cache_home != null ? xdg_cache_home : cacheHome;
        RUNTIME_HOME = xdg_runtime_home != null ? xdg_runtime_home : runtimeHome;
        DATA_HOME = xdg_data_home != null ? xdg_data_home : dataHome;
        USER_CONFIG_HOME = CONFIG_HOME + File.separator + DEPLOYMENT_SUBDIR_DIR;
        USER_CACHE_HOME = CACHE_HOME + File.separator + DEPLOYMENT_SUBDIR_DIR;
        USER_DEFAULT_SECURITY_DIR = USER_CONFIG_HOME + File.separator + securityWord;
        PIPES_DIR = new RuntimeFileDescriptor("icedteaplugin-user-*", "FILEpipe", new Target[]{Target.PLUGIN});
        MOZILA_USER = new HomeFileDescriptor(ICEDTEA_SO, ".mozilla/plugins", "FILEmozillauser", new Target[]{Target.PLUGIN});
        MOZILA_GLOBAL_64 = new InfrastructureFileDescriptor(ICEDTEA_SO, "/usr/lib64/mozilla/plugins/", "", "FILEmozillaglobal64", Target.PLUGIN);
        MOZILA_GLOBAL_32 = new InfrastructureFileDescriptor(ICEDTEA_SO, "/usr/lib/mozilla/plugins/", "", "FILEmozillaglobal32", Target.PLUGIN);
        OPERA_64 = new InfrastructureFileDescriptor(ICEDTEA_SO, "/usr/lib64/opera/plugins/", "", "FILEopera64", Target.PLUGIN);
        OPERA_32 = new InfrastructureFileDescriptor(ICEDTEA_SO, "/usr/lib/opera/plugins/", "", "FILEopera32", Target.PLUGIN);
        CACHE_DIR = new ItwCacheFileDescriptor("cache", "FILEcache", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS}){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.cachedir";
            }
        };
        PCACHE_DIR = new ItwCacheFileDescriptor("pcache", "FILEappdata", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS}){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.pcachedir";
            }
        };
        LOG_DIR = new ItwConfigFileDescriptor("log", "FILElogs", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS}){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.logdir";
            }
        };
        ICONS_DIR = new ItwConfigFileDescriptor("icons", "FILEicons", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS});
        GEN_JNLPS_DIR = new ItwConfigFileDescriptor("generated_jnlps", "FILEjnlps", new Target[]{Target.PLUGIN, Target.ITWEB_SETTINGS});
        MENUS_DIR = new MenuFileDescriptor("javaws", "FILEmenus", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS});
        APPLET_TRUST_SETTINGS_USER = new ItwConfigFileDescriptor(".appletTrustSettings", "FILEextasuser", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS});
        APPLET_TRUST_SETTINGS_SYS = new SystemDeploymentCofigFileDescriptor(".appletTrustSettings", "FILEextasadmin", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS});
        ETC_DEPLOYMENT_CFG = new SystemDeploymentCofigFileDescriptor("deployment.config", "FILEglobaldp", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS});
        TMP_DIR = new ItwCacheFileDescriptor("tmp", "FILEtmpappdata", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS}){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.tmp";
            }
        };
        LOCKS_DIR = new TmpUsrFileDescriptor("locks", "netx", "FILElocksdir", new Target[]{Target.JAVAWS}){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.locksdir";
            }
        };
        MAIN_LOCK = new TmpUsrFileDescriptor("netx_running", "netx" + File.separator + "locks", "FILEmainlock", new Target[]{Target.JAVAWS}){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.runningfile";
            }
        };
        JAVA_POLICY = new UserSecurityConfigFileDescriptor("java.policy", "FILEpolicy", new Target[]{Target.JAVAWS, Target.POLICY_EDITOR}){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.security.policy";
            }

            @Override
            public File getFile() {
                throw new IllegalStateException("Only getFullPath should be used. This is returning URL String.");
            }

            @Override
            public File getDefaultFile() {
                throw new IllegalStateException("Only getDefaultFullPath should be used. This is returning URL String.");
            }
        };
        USER_CACERTS = new UserCacertsFileDescriptor("trusted.cacerts"){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.security.trusted.cacerts";
            }
        };
        USER_JSSECAC = new UserCacertsFileDescriptor("trusted.jssecacerts"){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.security.trusted.jssecacerts";
            }
        };
        USER_CERTS = new UserCacertsFileDescriptor("trusted.certs"){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.security.trusted.certs";
            }
        };
        USER_JSSECER = new UserCacertsFileDescriptor("trusted.jssecerts"){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.security.trusted.jssecerts";
            }
        };
        USER_CLIENTCERT = new UserCacertsFileDescriptor("trusted.clientcerts"){

            @Override
            public String getPropertiesKey() {
                return "deployment.user.security.trusted.clientauthcerts";
            }
        };
        SYS_CACERT = new SystemJavaSecurityFileDescriptor("cacerts"){

            @Override
            public String getPropertiesKey() {
                return "deployment.system.security.cacerts";
            }
        };
        SYS_JSSECAC = new SystemJavaSecurityFileDescriptor("jssecacerts"){

            @Override
            public String getPropertiesKey() {
                return "deployment.system.security.jssecacerts";
            }
        };
        SYS_CERT = new SystemJavaSecurityFileDescriptor("trusted.certs"){

            @Override
            public String getPropertiesKey() {
                return "deployment.system.security.trusted.certs";
            }
        };
        SYS_JSSECERT = new SystemJavaSecurityFileDescriptor("trusted.jssecerts"){

            @Override
            public String getPropertiesKey() {
                return "deployment.system.security.trusted.jssecerts";
            }
        };
        SYS_CLIENTCERT = new SystemJavaSecurityFileDescriptor("trusted.clientcerts"){

            @Override
            public String getPropertiesKey() {
                return "deployment.system.security.trusted.clientautcerts";
            }
        };
        JAVA_DEPLOYMENT_PROP_FILE = new SystemJavaLibFileDescriptor("deployment.config", "FILEjavadp", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS}){

            @Override
            public String getDescription() {
                return Translator.R(this.getDescriptionKey(), "deployment.jre.dir");
            }
        };
        USER_DEPLOYMENT_FILE = new ItwConfigFileDescriptor("deployment.properties", "FILEuserdp", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS});
    }

    private static class TmpUsrFileDescriptor
    extends InfrastructureFileDescriptor {
        private TmpUsrFileDescriptor(String fileName, String pathStub, String description, Target ... target) {
            super(fileName, pathStub, System.getProperty(PathsAndFiles.TMP_PROP) + File.separator + System.getProperty(PathsAndFiles.USER_PROP), description, target);
        }

        @Override
        public String getSystemPathStubAcronym() {
            return VARIABLE + "TMP" + File.separator + VARIABLE + "USER";
        }
    }

    private static class ItwCacheFileDescriptor
    extends CacheFileDescriptor {
        private ItwCacheFileDescriptor(String fileName, String description, Target ... target) {
            super(fileName, PathsAndFiles.DEPLOYMENT_SUBDIR_DIR, description, target);
        }

        private ItwCacheFileDescriptor(String fileName, String folowingPath, String description, Target ... target) {
            super(fileName, PathsAndFiles.DEPLOYMENT_SUBDIR_DIR + File.separator + folowingPath, description, target);
        }
    }

    private static class UserCacertsFileDescriptor
    extends UserSecurityConfigFileDescriptor {
        private UserCacertsFileDescriptor(String fileName) {
            super(fileName, "FILEusercerts", new Target[]{Target.JAVAWS});
        }
    }

    private static class UserSecurityConfigFileDescriptor
    extends ItwConfigFileDescriptor {
        private UserSecurityConfigFileDescriptor(String fileName, String description, Target ... target) {
            super(fileName, PathsAndFiles.securityWord, description, target);
        }
    }

    private static class ItwConfigFileDescriptor
    extends ConfigFileDescriptor {
        private ItwConfigFileDescriptor(String fileName, String description, Target ... target) {
            super(fileName, PathsAndFiles.DEPLOYMENT_SUBDIR_DIR, description, target);
        }

        private ItwConfigFileDescriptor(String fileName, String folowingPath, String description, Target ... target) {
            super(fileName, PathsAndFiles.DEPLOYMENT_SUBDIR_DIR + File.separator + folowingPath, description, target);
        }
    }

    private static class CacheFileDescriptor
    extends InfrastructureFileDescriptor {
        private CacheFileDescriptor(String fileName, String pathStub, String description, Target ... target) {
            super(fileName, pathStub, CACHE_HOME, description, target);
        }

        @Override
        public String getSystemPathStubAcronym() {
            return VARIABLE + "" + PathsAndFiles.XDG_CACHE_HOME_VAR;
        }
    }

    private static class ConfigFileDescriptor
    extends InfrastructureFileDescriptor {
        private ConfigFileDescriptor(String fileName, String pathStub, String description, Target ... target) {
            super(fileName, pathStub, CONFIG_HOME, description, target);
        }

        @Override
        public String getSystemPathStubAcronym() {
            return VARIABLE + "" + PathsAndFiles.XDG_CONFIG_HOME_VAR;
        }
    }

    private static class RuntimeFileDescriptor
    extends InfrastructureFileDescriptor {
        private RuntimeFileDescriptor(String fileName, String description, Target ... target) {
            super(fileName, RUNTIME_HOME, "", description, target);
        }

        @Override
        public String getSystemPathStubAcronym() {
            return VARIABLE + "" + PathsAndFiles.XDG_RUNTIME_DIR_VAR;
        }
    }

    private static class MenuFileDescriptor
    extends DataFileDescriptor {
        private MenuFileDescriptor(String fileName, String description, Target ... target) {
            super(fileName, "applications", description, target);
        }
    }

    private static class DataFileDescriptor
    extends InfrastructureFileDescriptor {
        private DataFileDescriptor(String fileName, String sp, String description, Target ... target) {
            super(fileName, sp, DATA_HOME, description, target);
        }

        @Override
        public String getSystemPathStubAcronym() {
            return VARIABLE + "" + PathsAndFiles.XDG_DATA_HOME;
        }
    }

    private static class SystemJavaSecurityFileDescriptor
    extends SystemJavaLibFileDescriptor {
        private SystemJavaSecurityFileDescriptor(String fileName) {
            super(fileName, PathsAndFiles.securityWord, "FILEjavacerts", new Target[]{Target.JAVAWS});
        }
    }

    private static class SystemJavaLibFileDescriptor
    extends SystemJavaFileDescriptor {
        private SystemJavaLibFileDescriptor(String fileName, String desc, Target ... target) {
            super(fileName, "lib", desc, target);
        }

        private SystemJavaLibFileDescriptor(String fileName, String subpath, String description, Target ... target) {
            super(fileName, "lib" + File.separator + subpath, description, target);
        }
    }

    private static class SystemJavaFileDescriptor
    extends InfrastructureFileDescriptor {
        private SystemJavaFileDescriptor(String fileName, String pathSub, String description, Target ... target) {
            super(fileName, pathSub, System.getProperty(PathsAndFiles.JAVA_PROP), description, target);
        }

        @Override
        public String getSystemPathStubAcronym() {
            return VARIABLE + "JAVA_HOME";
        }
    }

    private static class SystemDeploymentCofigFileDescriptor
    extends SystemCofigFileDescriptor {
        private SystemDeploymentCofigFileDescriptor(String fileName, String description, Target ... target) {
            super(fileName, "deployment", description, target);
        }
    }

    private static class SystemCofigFileDescriptor
    extends InfrastructureFileDescriptor {
        private static final String windowsPathSuffix = File.separator + "Sun" + File.separator + "Java";
        private static final String unixPathSuffix = File.separator + "etc" + File.separator + ".java";

        private static String getSystemConfigDir() {
            if (JNLPRuntime.isWindows()) {
                return System.getenv(PathsAndFiles.WINDIR) + windowsPathSuffix;
            }
            return unixPathSuffix;
        }

        @Override
        public String getSystemPathStubAcronym() {
            return "{%WINDIR" + windowsPathSuffix + " or " + unixPathSuffix + "}";
        }

        private SystemCofigFileDescriptor(String fileName, String pathSub, String description, Target ... target) {
            super(fileName, pathSub, SystemCofigFileDescriptor.getSystemConfigDir(), description, target);
        }
    }

    private static class HomeFileDescriptor
    extends InfrastructureFileDescriptor {
        private HomeFileDescriptor(String fileName, String pathSub, String description, Target ... target) {
            super(fileName, pathSub, System.getProperty(PathsAndFiles.HOME_PROP), description, target);
        }

        @Override
        public String getSystemPathStubAcronym() {
            return VARIABLE + "HOME";
        }
    }

    static enum Target {
        JAVAWS,
        PLUGIN,
        ITWEB_SETTINGS,
        POLICY_EDITOR;

    }

    private static class RECENTLY_USED_FILE_HOLDER {
        static final InfrastructureFileDescriptor RECENTLY_USED_FILE = new ItwCacheFileDescriptor("recently_used", CACHE_DIR.getFile().getName(), "FILErecentlyUsed", new Target[]{Target.JAVAWS, Target.ITWEB_SETTINGS}){

            @Override
            public String getFullPath() {
                return this.clean(CACHE_DIR.getFullPath() + File.separator + this.getFileName());
            }
        };

        private RECENTLY_USED_FILE_HOLDER() {
        }
    }
}

